package errors

import (
	"fmt"
	"io"
)

func ExampleES() {
	// Create a Kusto error holding an error string.
	err := ES(OpQuery, KInternal, "some type of client error")
	fmt.Println(err)

	// Output: Op(OpQuery): Kind(KInternal): some type of client error
}

func ExampleE() {
	// Wrap a non-*Error type generated from other code. There should only ever be a single
	// non-typed error, as all errors in Kusto should be of type *Error. That underlying error
	// could be a wrapped error.
	err := E(OpQuery, KInternal, io.EOF)
	fmt.Println(err)

	// Output: Op(OpQuery): Kind(KInternal): EOF
}

func ExampleW() {
	// Our inner *Error.
	err := E(OpQuery, KInternal, io.EOF)
	// Wrap an *Error in a *Error. Can only use an error type has a concrete type of *Error.
	// This wraps err inside the error generated by E().
	err = W(err, ES(OpQuery, KTimeout, "database db does not exist"))
	fmt.Println(err)

	/* Output: Op(OpQuery): Kind(KTimeout): database db does not exist:
	EOF*/
}
