// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package apihub provides access to the API hub API.
//
// For product documentation, see: https://cloud.google.com/apigee/docs/api-hub/what-is-api-hub
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/apihub/v1"
//	...
//	ctx := context.Background()
//	apihubService, err := apihub.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	apihubService, err := apihub.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	apihubService, err := apihub.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package apihub // import "google.golang.org/api/apihub/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "apihub:v1"
const apiName = "apihub"
const apiVersion = "v1"
const basePath = "https://apihub.googleapis.com/"
const basePathTemplate = "https://apihub.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://apihub.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.ApiHubInstances = NewProjectsLocationsApiHubInstancesService(s)
	rs.Apis = NewProjectsLocationsApisService(s)
	rs.Attributes = NewProjectsLocationsAttributesService(s)
	rs.Curations = NewProjectsLocationsCurationsService(s)
	rs.Dependencies = NewProjectsLocationsDependenciesService(s)
	rs.Deployments = NewProjectsLocationsDeploymentsService(s)
	rs.ExternalApis = NewProjectsLocationsExternalApisService(s)
	rs.HostProjectRegistrations = NewProjectsLocationsHostProjectRegistrationsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.Plugins = NewProjectsLocationsPluginsService(s)
	rs.RuntimeProjectAttachments = NewProjectsLocationsRuntimeProjectAttachmentsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	ApiHubInstances *ProjectsLocationsApiHubInstancesService

	Apis *ProjectsLocationsApisService

	Attributes *ProjectsLocationsAttributesService

	Curations *ProjectsLocationsCurationsService

	Dependencies *ProjectsLocationsDependenciesService

	Deployments *ProjectsLocationsDeploymentsService

	ExternalApis *ProjectsLocationsExternalApisService

	HostProjectRegistrations *ProjectsLocationsHostProjectRegistrationsService

	Operations *ProjectsLocationsOperationsService

	Plugins *ProjectsLocationsPluginsService

	RuntimeProjectAttachments *ProjectsLocationsRuntimeProjectAttachmentsService
}

func NewProjectsLocationsApiHubInstancesService(s *Service) *ProjectsLocationsApiHubInstancesService {
	rs := &ProjectsLocationsApiHubInstancesService{s: s}
	return rs
}

type ProjectsLocationsApiHubInstancesService struct {
	s *Service
}

func NewProjectsLocationsApisService(s *Service) *ProjectsLocationsApisService {
	rs := &ProjectsLocationsApisService{s: s}
	rs.Versions = NewProjectsLocationsApisVersionsService(s)
	return rs
}

type ProjectsLocationsApisService struct {
	s *Service

	Versions *ProjectsLocationsApisVersionsService
}

func NewProjectsLocationsApisVersionsService(s *Service) *ProjectsLocationsApisVersionsService {
	rs := &ProjectsLocationsApisVersionsService{s: s}
	rs.Definitions = NewProjectsLocationsApisVersionsDefinitionsService(s)
	rs.Operations = NewProjectsLocationsApisVersionsOperationsService(s)
	rs.Specs = NewProjectsLocationsApisVersionsSpecsService(s)
	return rs
}

type ProjectsLocationsApisVersionsService struct {
	s *Service

	Definitions *ProjectsLocationsApisVersionsDefinitionsService

	Operations *ProjectsLocationsApisVersionsOperationsService

	Specs *ProjectsLocationsApisVersionsSpecsService
}

func NewProjectsLocationsApisVersionsDefinitionsService(s *Service) *ProjectsLocationsApisVersionsDefinitionsService {
	rs := &ProjectsLocationsApisVersionsDefinitionsService{s: s}
	return rs
}

type ProjectsLocationsApisVersionsDefinitionsService struct {
	s *Service
}

func NewProjectsLocationsApisVersionsOperationsService(s *Service) *ProjectsLocationsApisVersionsOperationsService {
	rs := &ProjectsLocationsApisVersionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsApisVersionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsApisVersionsSpecsService(s *Service) *ProjectsLocationsApisVersionsSpecsService {
	rs := &ProjectsLocationsApisVersionsSpecsService{s: s}
	return rs
}

type ProjectsLocationsApisVersionsSpecsService struct {
	s *Service
}

func NewProjectsLocationsAttributesService(s *Service) *ProjectsLocationsAttributesService {
	rs := &ProjectsLocationsAttributesService{s: s}
	return rs
}

type ProjectsLocationsAttributesService struct {
	s *Service
}

func NewProjectsLocationsCurationsService(s *Service) *ProjectsLocationsCurationsService {
	rs := &ProjectsLocationsCurationsService{s: s}
	return rs
}

type ProjectsLocationsCurationsService struct {
	s *Service
}

func NewProjectsLocationsDependenciesService(s *Service) *ProjectsLocationsDependenciesService {
	rs := &ProjectsLocationsDependenciesService{s: s}
	return rs
}

type ProjectsLocationsDependenciesService struct {
	s *Service
}

func NewProjectsLocationsDeploymentsService(s *Service) *ProjectsLocationsDeploymentsService {
	rs := &ProjectsLocationsDeploymentsService{s: s}
	return rs
}

type ProjectsLocationsDeploymentsService struct {
	s *Service
}

func NewProjectsLocationsExternalApisService(s *Service) *ProjectsLocationsExternalApisService {
	rs := &ProjectsLocationsExternalApisService{s: s}
	return rs
}

type ProjectsLocationsExternalApisService struct {
	s *Service
}

func NewProjectsLocationsHostProjectRegistrationsService(s *Service) *ProjectsLocationsHostProjectRegistrationsService {
	rs := &ProjectsLocationsHostProjectRegistrationsService{s: s}
	return rs
}

type ProjectsLocationsHostProjectRegistrationsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPluginsService(s *Service) *ProjectsLocationsPluginsService {
	rs := &ProjectsLocationsPluginsService{s: s}
	rs.Instances = NewProjectsLocationsPluginsInstancesService(s)
	rs.StyleGuide = NewProjectsLocationsPluginsStyleGuideService(s)
	return rs
}

type ProjectsLocationsPluginsService struct {
	s *Service

	Instances *ProjectsLocationsPluginsInstancesService

	StyleGuide *ProjectsLocationsPluginsStyleGuideService
}

func NewProjectsLocationsPluginsInstancesService(s *Service) *ProjectsLocationsPluginsInstancesService {
	rs := &ProjectsLocationsPluginsInstancesService{s: s}
	return rs
}

type ProjectsLocationsPluginsInstancesService struct {
	s *Service
}

func NewProjectsLocationsPluginsStyleGuideService(s *Service) *ProjectsLocationsPluginsStyleGuideService {
	rs := &ProjectsLocationsPluginsStyleGuideService{s: s}
	return rs
}

type ProjectsLocationsPluginsStyleGuideService struct {
	s *Service
}

func NewProjectsLocationsRuntimeProjectAttachmentsService(s *Service) *ProjectsLocationsRuntimeProjectAttachmentsService {
	rs := &ProjectsLocationsRuntimeProjectAttachmentsService{s: s}
	return rs
}

type ProjectsLocationsRuntimeProjectAttachmentsService struct {
	s *Service
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudApihubV1APIMetadata: The API metadata.
type GoogleCloudApihubV1APIMetadata struct {
	// Api: Required. The API resource to be pushed to Hub's collect layer. The ID
	// of the API resource will be generated by Hub to ensure uniqueness across all
	// APIs across systems.
	Api *GoogleCloudApihubV1Api `json:"api,omitempty"`
	// OriginalCreateTime: Optional. Timestamp indicating when the API was created
	// at the source.
	OriginalCreateTime string `json:"originalCreateTime,omitempty"`
	// OriginalId: Optional. The unique identifier of the API in the system where
	// it was originally created.
	OriginalId string `json:"originalId,omitempty"`
	// OriginalUpdateTime: Required. Timestamp indicating when the API was last
	// updated at the source.
	OriginalUpdateTime string `json:"originalUpdateTime,omitempty"`
	// Versions: Optional. The list of versions present in an API resource.
	Versions []*GoogleCloudApihubV1VersionMetadata `json:"versions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Api") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Api") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1APIMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1APIMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ActionExecutionDetail: The details for the action to
// execute.
type GoogleCloudApihubV1ActionExecutionDetail struct {
	// ActionId: Required. The action id of the plugin to execute.
	ActionId string `json:"actionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ActionExecutionDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ActionExecutionDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1AllowedValue: The value that can be assigned to the
// attribute when the data type is enum.
type GoogleCloudApihubV1AllowedValue struct {
	// Description: Optional. The detailed description of the allowed value.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the allowed value.
	DisplayName string `json:"displayName,omitempty"`
	// Id: Required. The ID of the allowed value. * If provided, the same will be
	// used. The service will throw an error if the specified id is already used by
	// another allowed value in the same attribute resource. * If not provided, a
	// system generated id derived from the display name will be used. In this
	// case, the service will handle conflict resolution by adding a system
	// generated suffix in case of duplicates. This value should be 4-63
	// characters, and valid characters are /a-z-/.
	Id string `json:"id,omitempty"`
	// Immutable: Optional. When set to true, the allowed value cannot be updated
	// or deleted by the user. It can only be true for System defined attributes.
	Immutable bool `json:"immutable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1AllowedValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1AllowedValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Api: An API resource in the API Hub.
type GoogleCloudApihubV1Api struct {
	// ApiFunctionalRequirements: Optional. The api functional requirements
	// associated with the API resource. Carinality is 1 for this attribute. This
	// maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-api-functional-req
	// uirements` attribute. The value of the attribute should be a proper URI, and
	// in case of Cloud Storage URI, it should point to a Cloud Storage object, not
	// a directory.
	ApiFunctionalRequirements *GoogleCloudApihubV1AttributeValues `json:"apiFunctionalRequirements,omitempty"`
	// ApiRequirements: Optional. The api requirement doc associated with the API
	// resource. Carinality is 1 for this attribute. This maps to the following
	// system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-api-requirements`
	// attribute. The value of the attribute should be a proper URI, and in case of
	// Cloud Storage URI, it should point to a Cloud Storage object, not a
	// directory.
	ApiRequirements *GoogleCloudApihubV1AttributeValues `json:"apiRequirements,omitempty"`
	// ApiStyle: Optional. The style of the API. This maps to the following system
	// defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-api-style`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	ApiStyle *GoogleCloudApihubV1AttributeValues `json:"apiStyle,omitempty"`
	// ApiTechnicalRequirements: Optional. The api technical requirements
	// associated with the API resource. Carinality is 1 for this attribute. This
	// maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-api-technical-requ
	// irements` attribute. The value of the attribute should be a proper URI, and
	// in case of Cloud Storage URI, it should point to a Cloud Storage object, not
	// a directory.
	ApiTechnicalRequirements *GoogleCloudApihubV1AttributeValues `json:"apiTechnicalRequirements,omitempty"`
	// Attributes: Optional. The list of user defined attributes associated with
	// the API resource. The key is the attribute name. It will be of the format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`. The value
	// is the attribute values associated with the resource.
	Attributes map[string]GoogleCloudApihubV1AttributeValues `json:"attributes,omitempty"`
	// BusinessUnit: Optional. The business unit owning the API. This maps to the
	// following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-business-unit`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	BusinessUnit *GoogleCloudApihubV1AttributeValues `json:"businessUnit,omitempty"`
	// CreateTime: Output only. The time at which the API resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. The description of the API resource.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the API resource.
	DisplayName string `json:"displayName,omitempty"`
	// Documentation: Optional. The documentation for the API resource.
	Documentation *GoogleCloudApihubV1Documentation `json:"documentation,omitempty"`
	// Fingerprint: Optional. Fingerprint of the API resource.
	Fingerprint string `json:"fingerprint,omitempty"`
	// MaturityLevel: Optional. The maturity level of the API. This maps to the
	// following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-maturity-level`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	MaturityLevel *GoogleCloudApihubV1AttributeValues `json:"maturityLevel,omitempty"`
	// Name: Identifier. The name of the API resource in the API Hub. Format:
	// `projects/{project}/locations/{location}/apis/{api}`
	Name string `json:"name,omitempty"`
	// Owner: Optional. Owner details for the API resource.
	Owner *GoogleCloudApihubV1Owner `json:"owner,omitempty"`
	// SelectedVersion: Optional. The selected version for an API resource. This
	// can be used when special handling is needed on client side for particular
	// version of the API. Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	SelectedVersion string `json:"selectedVersion,omitempty"`
	// SourceMetadata: Output only. The list of sources and metadata from the
	// sources of the API resource.
	SourceMetadata []*GoogleCloudApihubV1SourceMetadata `json:"sourceMetadata,omitempty"`
	// TargetUser: Optional. The target users for the API. This maps to the
	// following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-target-user`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	TargetUser *GoogleCloudApihubV1AttributeValues `json:"targetUser,omitempty"`
	// Team: Optional. The team owning the API. This maps to the following system
	// defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-team` attribute.
	// The number of values for this attribute will be based on the cardinality of
	// the attribute. The same can be retrieved via GetAttribute API. All values
	// should be from the list of allowed values defined for the attribute.
	Team *GoogleCloudApihubV1AttributeValues `json:"team,omitempty"`
	// UpdateTime: Output only. The time at which the API resource was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Versions: Output only. The list of versions present in an API resource.
	// Note: An API resource can be associated with more than 1 version. Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Versions []string `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiFunctionalRequirements")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiFunctionalRequirements") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Api) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Api
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ApiData: The API data to be collected.
type GoogleCloudApihubV1ApiData struct {
	// ApiMetadataList: Optional. The list of API metadata.
	ApiMetadataList *GoogleCloudApihubV1ApiMetadataList `json:"apiMetadataList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiMetadataList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiMetadataList") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ApiData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ApiData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ApiHubInstance: An ApiHubInstance represents the instance
// resources of the API Hub. Currently, only one ApiHub instance is allowed for
// each project.
type GoogleCloudApihubV1ApiHubInstance struct {
	// Config: Required. Config of the ApiHub instance.
	Config *GoogleCloudApihubV1Config `json:"config,omitempty"`
	// CreateTime: Output only. Creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the ApiHub instance.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Instance labels to represent user-provided metadata. Refer
	// to cloud documentation on labels for more details.
	// https://cloud.google.com/compute/docs/labeling-resources
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Format:
	// `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
	Name string `json:"name,omitempty"`
	// State: Output only. The current state of the ApiHub instance.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "INACTIVE" - The ApiHub instance has not been initialized or has been
	// deleted.
	//   "CREATING" - The ApiHub instance is being created.
	//   "ACTIVE" - The ApiHub instance has been created and is ready for use.
	//   "UPDATING" - The ApiHub instance is being updated.
	//   "DELETING" - The ApiHub instance is being deleted.
	//   "FAILED" - The ApiHub instance encountered an error during a state change.
	State string `json:"state,omitempty"`
	// StateMessage: Output only. Extra information about ApiHub instance state.
	// Currently the message would be populated when state is `FAILED`.
	StateMessage string `json:"stateMessage,omitempty"`
	// UpdateTime: Output only. Last update timestamp.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ApiHubInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ApiHubInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ApiHubResource: ApiHubResource is one of the resources
// such as Api, Operation, Deployment, Definition, Spec and Version resources
// stored in API-Hub.
type GoogleCloudApihubV1ApiHubResource struct {
	// Api: This represents Api resource in search results. Only name,
	// display_name, description and owner fields are populated in search results.
	Api *GoogleCloudApihubV1Api `json:"api,omitempty"`
	// Definition: This represents Definition resource in search results. Only name
	// field is populated in search results.
	Definition *GoogleCloudApihubV1Definition `json:"definition,omitempty"`
	// Deployment: This represents Deployment resource in search results. Only
	// name, display_name, description, deployment_type and api_versions fields are
	// populated in search results.
	Deployment *GoogleCloudApihubV1Deployment `json:"deployment,omitempty"`
	// Operation: This represents ApiOperation resource in search results. Only
	// name, description, spec and details fields are populated in search results.
	Operation *GoogleCloudApihubV1ApiOperation `json:"operation,omitempty"`
	// Spec: This represents Spec resource in search results. Only name,
	// display_name, description, spec_type and documentation fields are populated
	// in search results.
	Spec *GoogleCloudApihubV1Spec `json:"spec,omitempty"`
	// Version: This represents Version resource in search results. Only name,
	// display_name, description, lifecycle, compliance and accreditation fields
	// are populated in search results.
	Version *GoogleCloudApihubV1Version `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Api") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Api") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ApiHubResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ApiHubResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ApiKeyConfig: Config for authentication with API key.
type GoogleCloudApihubV1ApiKeyConfig struct {
	// ApiKey: Required. The name of the SecretManager secret version resource
	// storing the API key. Format:
	// `projects/{project}/secrets/{secrete}/versions/{version}`. The
	// `secretmanager.versions.access` permission should be granted to the service
	// account accessing the secret.
	ApiKey *GoogleCloudApihubV1Secret `json:"apiKey,omitempty"`
	// HttpElementLocation: Required. The location of the API key. The default
	// value is QUERY.
	//
	// Possible values:
	//   "HTTP_ELEMENT_LOCATION_UNSPECIFIED" - HTTP element location not specified.
	//   "QUERY" - Element is in the HTTP request query.
	//   "HEADER" - Element is in the HTTP request header.
	//   "PATH" - Element is in the HTTP request path.
	//   "BODY" - Element is in the HTTP request body.
	//   "COOKIE" - Element is in the HTTP request cookie.
	HttpElementLocation string `json:"httpElementLocation,omitempty"`
	// Name: Required. The parameter name of the API key. E.g. If the API request
	// is "https://example.com/act?api_key=", "api_key" would be the parameter
	// name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ApiMetadataList: The message to hold repeated API
// metadata.
type GoogleCloudApihubV1ApiMetadataList struct {
	// ApiMetadata: Required. The list of API metadata.
	ApiMetadata []*GoogleCloudApihubV1APIMetadata `json:"apiMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiMetadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ApiMetadataList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ApiMetadataList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ApiOperation: Represents an operation contained in an API
// version in the API Hub. An operation is added/updated/deleted in an API
// version when a new spec is added or an existing spec is updated/deleted in a
// version. Currently, an operation will be created only corresponding to
// OpenAPI spec as parsing is supported for OpenAPI spec. Alternatively
// operations can be managed via create,update and delete APIs, creation of
// apiOperation can be possible only for version with no parsed operations and
// update/delete can be possible only for operations created via create API.
type GoogleCloudApihubV1ApiOperation struct {
	// Attributes: Optional. The list of user defined attributes associated with
	// the API operation resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]GoogleCloudApihubV1AttributeValues `json:"attributes,omitempty"`
	// CreateTime: Output only. The time at which the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// Details: Optional. Operation details. Note: Even though this field is
	// optional, it is required for CreateApiOperation API and we will fail the
	// request if not provided.
	Details *GoogleCloudApihubV1OperationDetails `json:"details,omitempty"`
	// Name: Identifier. The name of the operation. Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operat
	// ions/{operation}`
	Name string `json:"name,omitempty"`
	// SourceMetadata: Output only. The list of sources and metadata from the
	// sources of the API operation.
	SourceMetadata []*GoogleCloudApihubV1SourceMetadata `json:"sourceMetadata,omitempty"`
	// Spec: Output only. The name of the spec will be of the format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/
	// {spec}` Note:The name of the spec will be empty if the operation is created
	// via CreateApiOperation API.
	Spec string `json:"spec,omitempty"`
	// UpdateTime: Output only. The time at which the operation was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ApiOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ApiOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ApplicationIntegrationEndpointDetails: The details of the
// Application Integration endpoint to be triggered for curation.
type GoogleCloudApihubV1ApplicationIntegrationEndpointDetails struct {
	// TriggerId: Required. The API trigger ID of the Application Integration
	// workflow.
	TriggerId string `json:"triggerId,omitempty"`
	// Uri: Required. The endpoint URI should be a valid REST URI for triggering an
	// Application Integration. Format:
	// `https://integrations.googleapis.com/v1/{name=projects/*/locations/*/integrat
	// ions/*}:execute` or
	// `https://{location}-integrations.googleapis.com/v1/{name=projects/*/locations
	// /*/integrations/*}:execute`
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TriggerId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TriggerId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ApplicationIntegrationEndpointDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ApplicationIntegrationEndpointDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Attribute: An attribute in the API Hub. An attribute is a
// name value pair which can be attached to different resources in the API hub
// based on the scope of the attribute. Attributes can either be pre-defined by
// the API Hub or created by users.
type GoogleCloudApihubV1Attribute struct {
	// AllowedValues: Optional. The list of allowed values when the attribute value
	// is of type enum. This is required when the data_type of the attribute is
	// ENUM. The maximum number of allowed values of an attribute will be 1000.
	AllowedValues []*GoogleCloudApihubV1AllowedValue `json:"allowedValues,omitempty"`
	// Cardinality: Optional. The maximum number of values that the attribute can
	// have when associated with an API Hub resource. Cardinality 1 would represent
	// a single-valued attribute. It must not be less than 1 or greater than 20. If
	// not specified, the cardinality would be set to 1 by default and represent a
	// single-valued attribute.
	Cardinality int64 `json:"cardinality,omitempty"`
	// CreateTime: Output only. The time at which the attribute was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataType: Required. The type of the data of the attribute.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Attribute data type unspecified.
	//   "ENUM" - Attribute's value is of type enum.
	//   "JSON" - Attribute's value is of type json.
	//   "STRING" - Attribute's value is of type string.
	//   "URI" - Attribute's value is of type uri.
	DataType string `json:"dataType,omitempty"`
	// DefinitionType: Output only. The definition type of the attribute.
	//
	// Possible values:
	//   "DEFINITION_TYPE_UNSPECIFIED" - Attribute definition type unspecified.
	//   "SYSTEM_DEFINED" - The attribute is predefined by the API Hub. Note that
	// only the list of allowed values can be updated in this case via
	// UpdateAttribute method.
	//   "USER_DEFINED" - The attribute is defined by the user.
	DefinitionType string `json:"definitionType,omitempty"`
	// Description: Optional. The description of the attribute.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the attribute.
	DisplayName string `json:"displayName,omitempty"`
	// Mandatory: Output only. When mandatory is true, the attribute is mandatory
	// for the resource specified in the scope. Only System defined attributes can
	// be mandatory.
	Mandatory bool `json:"mandatory,omitempty"`
	// Name: Identifier. The name of the attribute in the API Hub. Format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`
	Name string `json:"name,omitempty"`
	// Scope: Required. The scope of the attribute. It represents the resource in
	// the API Hub to which the attribute can be linked.
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - Scope Unspecified.
	//   "API" - Attribute can be linked to an API.
	//   "VERSION" - Attribute can be linked to an API version.
	//   "SPEC" - Attribute can be linked to a Spec.
	//   "API_OPERATION" - Attribute can be linked to an API Operation.
	//   "DEPLOYMENT" - Attribute can be linked to a Deployment.
	//   "DEPENDENCY" - Attribute can be linked to a Dependency.
	//   "DEFINITION" - Attribute can be linked to a definition.
	//   "EXTERNAL_API" - Attribute can be linked to a ExternalAPI.
	//   "PLUGIN" - Attribute can be linked to a Plugin.
	Scope string `json:"scope,omitempty"`
	// UpdateTime: Output only. The time at which the attribute was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowedValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Attribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Attribute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1AttributeValues: The attribute values associated with
// resource.
type GoogleCloudApihubV1AttributeValues struct {
	// Attribute: Output only. The name of the attribute. Format:
	// projects/{project}/locations/{location}/attributes/{attribute}
	Attribute string `json:"attribute,omitempty"`
	// EnumValues: The attribute values associated with a resource in case
	// attribute data type is enum.
	EnumValues *GoogleCloudApihubV1EnumAttributeValues `json:"enumValues,omitempty"`
	// JsonValues: The attribute values associated with a resource in case
	// attribute data type is JSON.
	JsonValues *GoogleCloudApihubV1StringAttributeValues `json:"jsonValues,omitempty"`
	// StringValues: The attribute values associated with a resource in case
	// attribute data type is string.
	StringValues *GoogleCloudApihubV1StringAttributeValues `json:"stringValues,omitempty"`
	// UriValues: The attribute values associated with a resource in case attribute
	// data type is URL, URI or IP, like gs://bucket-name/object-name.
	UriValues *GoogleCloudApihubV1StringAttributeValues `json:"uriValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attribute") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attribute") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1AttributeValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1AttributeValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1AuthConfig: AuthConfig represents the authentication
// information.
type GoogleCloudApihubV1AuthConfig struct {
	// ApiKeyConfig: Api Key Config.
	ApiKeyConfig *GoogleCloudApihubV1ApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// AuthType: Required. The authentication type.
	//
	// Possible values:
	//   "AUTH_TYPE_UNSPECIFIED" - Authentication type not specified.
	//   "NO_AUTH" - No authentication.
	//   "GOOGLE_SERVICE_ACCOUNT" - Google service account authentication.
	//   "USER_PASSWORD" - Username and password authentication.
	//   "API_KEY" - API Key authentication.
	//   "OAUTH2_CLIENT_CREDENTIALS" - Oauth 2.0 client credentials grant
	// authentication.
	AuthType string `json:"authType,omitempty"`
	// GoogleServiceAccountConfig: Google Service Account.
	GoogleServiceAccountConfig *GoogleCloudApihubV1GoogleServiceAccountConfig `json:"googleServiceAccountConfig,omitempty"`
	// Oauth2ClientCredentialsConfig: Oauth2.0 Client Credentials.
	Oauth2ClientCredentialsConfig *GoogleCloudApihubV1Oauth2ClientCredentialsConfig `json:"oauth2ClientCredentialsConfig,omitempty"`
	// UserPasswordConfig: User Password.
	UserPasswordConfig *GoogleCloudApihubV1UserPasswordConfig `json:"userPasswordConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1AuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1AuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1AuthConfigTemplate: AuthConfigTemplate represents the
// authentication template for a plugin.
type GoogleCloudApihubV1AuthConfigTemplate struct {
	// ServiceAccount: Optional. The service account of the plugin hosting service.
	// This service account should be granted the required permissions on the Auth
	// Config parameters provided while creating the plugin instances corresponding
	// to this plugin. For example, if the plugin instance auth config requires a
	// secret manager secret, the service account should be granted the
	// secretmanager.versions.access permission on the corresponding secret, if the
	// plugin instance auth config contains a service account, the service account
	// should be granted the iam.serviceAccounts.getAccessToken permission on the
	// corresponding service account.
	ServiceAccount *GoogleCloudApihubV1GoogleServiceAccountConfig `json:"serviceAccount,omitempty"`
	// SupportedAuthTypes: Required. The list of authentication types supported by
	// the plugin.
	//
	// Possible values:
	//   "AUTH_TYPE_UNSPECIFIED" - Authentication type not specified.
	//   "NO_AUTH" - No authentication.
	//   "GOOGLE_SERVICE_ACCOUNT" - Google service account authentication.
	//   "USER_PASSWORD" - Username and password authentication.
	//   "API_KEY" - API Key authentication.
	//   "OAUTH2_CLIENT_CREDENTIALS" - Oauth 2.0 client credentials grant
	// authentication.
	SupportedAuthTypes []string `json:"supportedAuthTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1AuthConfigTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1AuthConfigTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1CollectApiDataRequest: The CollectApiData method's
// request.
type GoogleCloudApihubV1CollectApiDataRequest struct {
	// ActionId: Required. The action ID to be used for collecting the API data.
	// This should map to one of the action IDs specified in action configs in the
	// plugin.
	ActionId string `json:"actionId,omitempty"`
	// ApiData: Required. The API data to be collected.
	ApiData *GoogleCloudApihubV1ApiData `json:"apiData,omitempty"`
	// CollectionType: Required. The type of collection. Applies to all entries in
	// api_data.
	//
	// Possible values:
	//   "COLLECTION_TYPE_UNSPECIFIED" - The default value. This value is used if
	// the collection type is omitted.
	//   "COLLECTION_TYPE_UPSERT" - The collection type is upsert. This should be
	// used when an API is created or updated at the source.
	//   "COLLECTION_TYPE_DELETE" - The collection type is delete. This should be
	// used when an API is deleted at the source.
	CollectionType string `json:"collectionType,omitempty"`
	// PluginInstance: Required. The plugin instance collecting the API data.
	// Format:
	// `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance
	// }`.
	PluginInstance string `json:"pluginInstance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1CollectApiDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1CollectApiDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Config: Available configurations to provision an ApiHub
// Instance.
type GoogleCloudApihubV1Config struct {
	// CmekKeyName: Optional. The Customer Managed Encryption Key (CMEK) used for
	// data encryption. The CMEK name should follow the format of
	// `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`,
	// where the location must match the instance location. If the CMEK is not
	// provided, a GMEK will be created for the instance.
	CmekKeyName string `json:"cmekKeyName,omitempty"`
	// DisableSearch: Optional. If true, the search will be disabled for the
	// instance. The default value is false.
	DisableSearch bool `json:"disableSearch,omitempty"`
	// EncryptionType: Optional. Encryption type for the region. If the encryption
	// type is CMEK, the cmek_key_name must be provided. If no encryption type is
	// provided, GMEK will be used.
	//
	// Possible values:
	//   "ENCRYPTION_TYPE_UNSPECIFIED" - Encryption type unspecified.
	//   "GMEK" - Default encryption using Google managed encryption key.
	//   "CMEK" - Encryption using customer managed encryption key.
	EncryptionType string `json:"encryptionType,omitempty"`
	// VertexLocation: Optional. The name of the Vertex AI location where the data
	// store is stored.
	VertexLocation string `json:"vertexLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CmekKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CmekKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Config) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Config
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ConfigTemplate: ConfigTemplate represents the
// configuration template for a plugin.
type GoogleCloudApihubV1ConfigTemplate struct {
	// AdditionalConfigTemplate: Optional. The list of additional configuration
	// variables for the plugin's configuration.
	AdditionalConfigTemplate []*GoogleCloudApihubV1ConfigVariableTemplate `json:"additionalConfigTemplate,omitempty"`
	// AuthConfigTemplate: Optional. The authentication template for the plugin.
	AuthConfigTemplate *GoogleCloudApihubV1AuthConfigTemplate `json:"authConfigTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalConfigTemplate")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalConfigTemplate") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ConfigTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ConfigTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ConfigValueOption: ConfigValueOption represents an option
// for a config variable of type enum or multi select.
type GoogleCloudApihubV1ConfigValueOption struct {
	// Description: Optional. Description of the option.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name of the option.
	DisplayName string `json:"displayName,omitempty"`
	// Id: Required. Id of the option.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ConfigValueOption) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ConfigValueOption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ConfigVariable: ConfigVariable represents a additional
// configuration variable present in a PluginInstance Config or AuthConfig,
// based on a ConfigVariableTemplate.
type GoogleCloudApihubV1ConfigVariable struct {
	// BoolValue: Optional. The config variable value in case of config variable of
	// type boolean.
	BoolValue bool `json:"boolValue,omitempty"`
	// EnumValue: Optional. The config variable value in case of config variable of
	// type enum.
	EnumValue *GoogleCloudApihubV1ConfigValueOption `json:"enumValue,omitempty"`
	// IntValue: Optional. The config variable value in case of config variable of
	// type integer.
	IntValue int64 `json:"intValue,omitempty,string"`
	// Key: Output only. Key will be the id to uniquely identify the config
	// variable.
	Key string `json:"key,omitempty"`
	// MultiIntValues: Optional. The config variable value in case of config
	// variable of type multi integer.
	MultiIntValues *GoogleCloudApihubV1MultiIntValues `json:"multiIntValues,omitempty"`
	// MultiSelectValues: Optional. The config variable value in case of config
	// variable of type multi select.
	MultiSelectValues *GoogleCloudApihubV1MultiSelectValues `json:"multiSelectValues,omitempty"`
	// MultiStringValues: Optional. The config variable value in case of config
	// variable of type multi string.
	MultiStringValues *GoogleCloudApihubV1MultiStringValues `json:"multiStringValues,omitempty"`
	// SecretValue: Optional. The config variable value in case of config variable
	// of type secret.
	SecretValue *GoogleCloudApihubV1Secret `json:"secretValue,omitempty"`
	// StringValue: Optional. The config variable value in case of config variable
	// of type string.
	StringValue string `json:"stringValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ConfigVariable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ConfigVariable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ConfigVariableTemplate: ConfigVariableTemplate represents
// a configuration variable template present in a Plugin Config.
type GoogleCloudApihubV1ConfigVariableTemplate struct {
	// Description: Optional. Description.
	Description string `json:"description,omitempty"`
	// EnumOptions: Optional. Enum options. To be populated if `ValueType` is
	// `ENUM`.
	EnumOptions []*GoogleCloudApihubV1ConfigValueOption `json:"enumOptions,omitempty"`
	// Id: Required. ID of the config variable. Must be unique within the
	// configuration.
	Id string `json:"id,omitempty"`
	// MultiSelectOptions: Optional. Multi select options. To be populated if
	// `ValueType` is `MULTI_SELECT`.
	MultiSelectOptions []*GoogleCloudApihubV1ConfigValueOption `json:"multiSelectOptions,omitempty"`
	// Required: Optional. Flag represents that this `ConfigVariable` must be
	// provided for a PluginInstance.
	Required bool `json:"required,omitempty"`
	// ValidationRegex: Optional. Regular expression in RE2 syntax used for
	// validating the `value` of a `ConfigVariable`.
	ValidationRegex string `json:"validationRegex,omitempty"`
	// ValueType: Required. Type of the parameter: string, int, bool etc.
	//
	// Possible values:
	//   "VALUE_TYPE_UNSPECIFIED" - Value type is not specified.
	//   "STRING" - Value type is string.
	//   "INT" - Value type is integer.
	//   "BOOL" - Value type is boolean.
	//   "SECRET" - Value type is secret.
	//   "ENUM" - Value type is enum.
	//   "MULTI_SELECT" - Value type is multi select.
	//   "MULTI_STRING" - Value type is multi string.
	//   "MULTI_INT" - Value type is multi int.
	ValueType string `json:"valueType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ConfigVariableTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ConfigVariableTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Curation: A curation resource in the API Hub.
type GoogleCloudApihubV1Curation struct {
	// CreateTime: Output only. The time at which the curation was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. The description of the curation.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the curation.
	DisplayName string `json:"displayName,omitempty"`
	// Endpoint: Required. The endpoint to be triggered for curation.
	Endpoint *GoogleCloudApihubV1Endpoint `json:"endpoint,omitempty"`
	// LastExecutionErrorCode: Output only. The error code of the last execution of
	// the curation. The error code is populated only when the last execution state
	// is failed.
	//
	// Possible values:
	//   "ERROR_CODE_UNSPECIFIED" - Default unspecified error code.
	//   "INTERNAL_ERROR" - The execution failed due to an internal error.
	//   "UNAUTHORIZED" - The curation is not authorized to trigger the endpoint
	// uri.
	LastExecutionErrorCode string `json:"lastExecutionErrorCode,omitempty"`
	// LastExecutionErrorMessage: Output only. Error message describing the
	// failure, if any, during the last execution of the curation.
	LastExecutionErrorMessage string `json:"lastExecutionErrorMessage,omitempty"`
	// LastExecutionState: Output only. The last execution state of the curation.
	//
	// Possible values:
	//   "LAST_EXECUTION_STATE_UNSPECIFIED" - Default unspecified state.
	//   "SUCCEEDED" - The last curation execution was successful.
	//   "FAILED" - The last curation execution failed.
	LastExecutionState string `json:"lastExecutionState,omitempty"`
	// Name: Identifier. The name of the curation. Format:
	// `projects/{project}/locations/{location}/curations/{curation}`
	Name string `json:"name,omitempty"`
	// PluginInstanceActions: Output only. The plugin instances and associated
	// actions that are using the curation. Note: A particular curation could be
	// used by multiple plugin instances or multiple actions in a plugin instance.
	PluginInstanceActions []*GoogleCloudApihubV1PluginInstanceActionID `json:"pluginInstanceActions,omitempty"`
	// UpdateTime: Output only. The time at which the curation was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Curation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Curation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1CurationConfig: The curation information for this plugin
// instance.
type GoogleCloudApihubV1CurationConfig struct {
	// CurationType: Required. The curation type for this plugin instance.
	//
	// Possible values:
	//   "CURATION_TYPE_UNSPECIFIED" - Default unspecified curation type.
	//   "DEFAULT_CURATION_FOR_API_METADATA" - Default curation for API metadata
	// will be used.
	//   "CUSTOM_CURATION_FOR_API_METADATA" - Custom curation for API metadata will
	// be used.
	CurationType string `json:"curationType,omitempty"`
	// CustomCuration: Optional. Custom curation information for this plugin
	// instance.
	CustomCuration *GoogleCloudApihubV1CustomCuration `json:"customCuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurationType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1CurationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1CurationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1CustomCuration: Custom curation information for this
// plugin instance.
type GoogleCloudApihubV1CustomCuration struct {
	// Curation: Required. The unique name of the curation resource. This will be
	// the name of the curation resource in the format:
	// `projects/{project}/locations/{location}/curations/{curation}`
	Curation string `json:"curation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Curation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Curation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1CustomCuration) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1CustomCuration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Definition: Represents a definition for example schema,
// request, response definitions contained in an API version. A definition is
// added/updated/deleted in an API version when a new spec is added or an
// existing spec is updated/deleted in a version. Currently, definition will be
// created only corresponding to OpenAPI spec as parsing is supported for
// OpenAPI spec. Also, within OpenAPI spec, only `schema` object is supported.
type GoogleCloudApihubV1Definition struct {
	// Attributes: Optional. The list of user defined attributes associated with
	// the definition resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]GoogleCloudApihubV1AttributeValues `json:"attributes,omitempty"`
	// CreateTime: Output only. The time at which the definition was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the definition. Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/defini
	// tions/{definition}`
	Name string `json:"name,omitempty"`
	// Schema: Output only. The value of a schema definition.
	Schema *GoogleCloudApihubV1Schema `json:"schema,omitempty"`
	// Spec: Output only. The name of the spec from where the definition was
	// parsed. Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/
	// {spec}`
	Spec string `json:"spec,omitempty"`
	// Type: Output only. The type of the definition.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Definition type unspecified.
	//   "SCHEMA" - Definition type schema.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The time at which the definition was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Definition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Definition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Dependency: A dependency resource defined in the API hub
// describes a dependency directed from a consumer to a supplier entity. A
// dependency can be defined between two Operations or between an Operation and
// External API.
type GoogleCloudApihubV1Dependency struct {
	// Attributes: Optional. The list of user defined attributes associated with
	// the dependency resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]GoogleCloudApihubV1AttributeValues `json:"attributes,omitempty"`
	// Consumer: Required. Immutable. The entity acting as the consumer in the
	// dependency.
	Consumer *GoogleCloudApihubV1DependencyEntityReference `json:"consumer,omitempty"`
	// CreateTime: Output only. The time at which the dependency was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Human readable description corresponding of the
	// dependency.
	Description string `json:"description,omitempty"`
	// DiscoveryMode: Output only. Discovery mode of the dependency.
	//
	// Possible values:
	//   "DISCOVERY_MODE_UNSPECIFIED" - Default value. This value is unused.
	//   "MANUAL" - Manual mode of discovery when the dependency is defined by the
	// user.
	DiscoveryMode string `json:"discoveryMode,omitempty"`
	// ErrorDetail: Output only. Error details of a dependency if the system has
	// detected it internally.
	ErrorDetail *GoogleCloudApihubV1DependencyErrorDetail `json:"errorDetail,omitempty"`
	// Name: Identifier. The name of the dependency in the API Hub. Format:
	// `projects/{project}/locations/{location}/dependencies/{dependency}`
	Name string `json:"name,omitempty"`
	// State: Output only. State of the dependency.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "PROPOSED" - Dependency will be in a proposed state when it is newly
	// identified by the API hub on its own.
	//   "VALIDATED" - Dependency will be in a validated state when it is validated
	// by the admin or manually created in the API hub.
	State string `json:"state,omitempty"`
	// Supplier: Required. Immutable. The entity acting as the supplier in the
	// dependency.
	Supplier *GoogleCloudApihubV1DependencyEntityReference `json:"supplier,omitempty"`
	// UpdateTime: Output only. The time at which the dependency was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Dependency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Dependency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1DependencyEntityReference: Reference to an entity
// participating in a dependency.
type GoogleCloudApihubV1DependencyEntityReference struct {
	// DisplayName: Output only. Display name of the entity.
	DisplayName string `json:"displayName,omitempty"`
	// ExternalApiResourceName: The resource name of an external API in the API
	// Hub. Format:
	// `projects/{project}/locations/{location}/externalApis/{external_api}`
	ExternalApiResourceName string `json:"externalApiResourceName,omitempty"`
	// OperationResourceName: The resource name of an operation in the API Hub.
	// Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operat
	// ions/{operation}`
	OperationResourceName string `json:"operationResourceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1DependencyEntityReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1DependencyEntityReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1DependencyErrorDetail: Details describing error condition
// of a dependency.
type GoogleCloudApihubV1DependencyErrorDetail struct {
	// Error: Optional. Error in the dependency.
	//
	// Possible values:
	//   "ERROR_UNSPECIFIED" - Default value used for no error in the dependency.
	//   "SUPPLIER_NOT_FOUND" - Supplier entity has been deleted.
	//   "SUPPLIER_RECREATED" - Supplier entity has been recreated.
	Error string `json:"error,omitempty"`
	// ErrorTime: Optional. Timestamp at which the error was found.
	ErrorTime string `json:"errorTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1DependencyErrorDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1DependencyErrorDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Deployment: Details of the deployment where APIs are
// hosted. A deployment could represent an Apigee proxy, API gateway, other
// Google Cloud services or non-Google Cloud services as well. A deployment
// entity is a root level entity in the API hub and exists independent of any
// API.
type GoogleCloudApihubV1Deployment struct {
	// ApiVersions: Output only. The API versions linked to this deployment. Note:
	// A particular deployment could be linked to multiple different API versions
	// (of same or different APIs).
	ApiVersions []string `json:"apiVersions,omitempty"`
	// Attributes: Optional. The list of user defined attributes associated with
	// the deployment resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]GoogleCloudApihubV1AttributeValues `json:"attributes,omitempty"`
	// CreateTime: Output only. The time at which the deployment was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeploymentType: Required. The type of deployment. This maps to the following
	// system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-deployment-type`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	DeploymentType *GoogleCloudApihubV1AttributeValues `json:"deploymentType,omitempty"`
	// Description: Optional. The description of the deployment.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the deployment.
	DisplayName string `json:"displayName,omitempty"`
	// Documentation: Optional. The documentation of the deployment.
	Documentation *GoogleCloudApihubV1Documentation `json:"documentation,omitempty"`
	// Endpoints: Required. The endpoints at which this deployment resource is
	// listening for API requests. This could be a list of complete URIs, hostnames
	// or an IP addresses.
	Endpoints []string `json:"endpoints,omitempty"`
	// Environment: Optional. The environment mapping to this deployment. This maps
	// to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-environment`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Environment *GoogleCloudApihubV1AttributeValues `json:"environment,omitempty"`
	// ManagementUrl: Optional. The uri where users can navigate to for the
	// management of the deployment. This maps to the following system defined
	// attribute:
	// `projects/{project}/locations/{location}/attributes/system-management-url`
	// The number of values for this attribute will be based on the cardinality of
	// the attribute. The same can be retrieved via GetAttribute API.
	ManagementUrl *GoogleCloudApihubV1AttributeValues `json:"managementUrl,omitempty"`
	// Name: Identifier. The name of the deployment. Format:
	// `projects/{project}/locations/{location}/deployments/{deployment}`
	Name string `json:"name,omitempty"`
	// ResourceUri: Required. A uri that uniquely identfies the deployment within a
	// particular gateway. For example, if the runtime resource is of type
	// APIGEE_PROXY, then this field will be a combination of org, proxy name and
	// environment.
	ResourceUri string `json:"resourceUri,omitempty"`
	// Slo: Optional. The SLO for this deployment. This maps to the following
	// system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-slo` attribute.
	// The number of values for this attribute will be based on the cardinality of
	// the attribute. The same can be retrieved via GetAttribute API. All values
	// should be from the list of allowed values defined for the attribute.
	Slo *GoogleCloudApihubV1AttributeValues `json:"slo,omitempty"`
	// SourceEnvironment: Optional. The environment at source for the deployment.
	// For example: prod, dev, staging, etc.
	SourceEnvironment string `json:"sourceEnvironment,omitempty"`
	// SourceMetadata: Output only. The list of sources and metadata from the
	// sources of the deployment.
	SourceMetadata []*GoogleCloudApihubV1SourceMetadata `json:"sourceMetadata,omitempty"`
	// SourceProject: Optional. The project to which the deployment belongs. For
	// GCP gateways, this will refer to the project identifier. For others like
	// Edge/OPDK, this will refer to the org identifier.
	SourceProject string `json:"sourceProject,omitempty"`
	// SourceUri: Optional. The uri where additional source specific information
	// for this deployment can be found. This maps to the following system defined
	// attribute:
	// `projects/{project}/locations/{location}/attributes/system-source-uri` The
	// number of values for this attribute will be based on the cardinality of the
	// attribute. The same can be retrieved via GetAttribute API.
	SourceUri *GoogleCloudApihubV1AttributeValues `json:"sourceUri,omitempty"`
	// UpdateTime: Output only. The time at which the deployment was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Deployment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Deployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1DeploymentMetadata: The metadata associated with a
// deployment.
type GoogleCloudApihubV1DeploymentMetadata struct {
	// Deployment: Required. The deployment resource to be pushed to Hub's collect
	// layer. The ID of the deployment will be generated by Hub.
	Deployment *GoogleCloudApihubV1Deployment `json:"deployment,omitempty"`
	// OriginalCreateTime: Optional. Timestamp indicating when the deployment was
	// created at the source.
	OriginalCreateTime string `json:"originalCreateTime,omitempty"`
	// OriginalId: Optional. The unique identifier of the deployment in the system
	// where it was originally created.
	OriginalId string `json:"originalId,omitempty"`
	// OriginalUpdateTime: Required. Timestamp indicating when the deployment was
	// last updated at the source.
	OriginalUpdateTime string `json:"originalUpdateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1DeploymentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1DeploymentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1DisablePluginInstanceActionRequest: The
// DisablePluginInstanceAction method's request.
type GoogleCloudApihubV1DisablePluginInstanceActionRequest struct {
	// ActionId: Required. The action id to disable.
	ActionId string `json:"actionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1DisablePluginInstanceActionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1DisablePluginInstanceActionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1DisablePluginRequest: The DisablePlugin method's request.
type GoogleCloudApihubV1DisablePluginRequest struct {
}

// GoogleCloudApihubV1Documentation: Documentation details.
type GoogleCloudApihubV1Documentation struct {
	// ExternalUri: Optional. The uri of the externally hosted documentation.
	ExternalUri string `json:"externalUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExternalUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Documentation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Documentation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1EnablePluginInstanceActionRequest: The
// EnablePluginInstanceAction method's request.
type GoogleCloudApihubV1EnablePluginInstanceActionRequest struct {
	// ActionId: Required. The action id to enable.
	ActionId string `json:"actionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1EnablePluginInstanceActionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1EnablePluginInstanceActionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1EnablePluginRequest: The EnablePlugin method's request.
type GoogleCloudApihubV1EnablePluginRequest struct {
}

// GoogleCloudApihubV1Endpoint: The endpoint to be triggered for curation. The
// endpoint will be invoked with a request payload containing ApiMetadata.
// Response should contain curated data in the form of ApiMetadata.
type GoogleCloudApihubV1Endpoint struct {
	// ApplicationIntegrationEndpointDetails: Required. The details of the
	// Application Integration endpoint to be triggered for curation.
	ApplicationIntegrationEndpointDetails *GoogleCloudApihubV1ApplicationIntegrationEndpointDetails `json:"applicationIntegrationEndpointDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ApplicationIntegrationEndpointDetails") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ApplicationIntegrationEndpointDetails") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Endpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Endpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1EnumAttributeValues: The attribute values of data type
// enum.
type GoogleCloudApihubV1EnumAttributeValues struct {
	// Values: Required. The attribute values in case attribute data type is enum.
	Values []*GoogleCloudApihubV1AllowedValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1EnumAttributeValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1EnumAttributeValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ExecutePluginInstanceActionRequest: The
// ExecutePluginInstanceAction method's request.
type GoogleCloudApihubV1ExecutePluginInstanceActionRequest struct {
	// ActionExecutionDetail: Required. The execution details for the action to
	// execute.
	ActionExecutionDetail *GoogleCloudApihubV1ActionExecutionDetail `json:"actionExecutionDetail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionExecutionDetail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionExecutionDetail") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ExecutePluginInstanceActionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ExecutePluginInstanceActionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ExecutionStatus: The execution status for the plugin
// instance.
type GoogleCloudApihubV1ExecutionStatus struct {
	// CurrentExecutionState: Output only. The current state of the execution.
	//
	// Possible values:
	//   "CURRENT_EXECUTION_STATE_UNSPECIFIED" - Default unspecified execution
	// state.
	//   "RUNNING" - The plugin instance is executing.
	//   "NOT_RUNNING" - The plugin instance is not running an execution.
	CurrentExecutionState string `json:"currentExecutionState,omitempty"`
	// LastExecution: Output only. The last execution of the plugin instance.
	LastExecution *GoogleCloudApihubV1LastExecution `json:"lastExecution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentExecutionState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentExecutionState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ExecutionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ExecutionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ExternalApi: An external API represents an API being
// provided by external sources. This can be used to model third-party APIs and
// can be used to define dependencies.
type GoogleCloudApihubV1ExternalApi struct {
	// Attributes: Optional. The list of user defined attributes associated with
	// the Version resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]GoogleCloudApihubV1AttributeValues `json:"attributes,omitempty"`
	// CreateTime: Output only. Creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the external API. Max length is 2000
	// characters (Unicode Code Points).
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name of the external API. Max length is 63
	// characters (Unicode Code Points).
	DisplayName string `json:"displayName,omitempty"`
	// Documentation: Optional. Documentation of the external API.
	Documentation *GoogleCloudApihubV1Documentation `json:"documentation,omitempty"`
	// Endpoints: Optional. List of endpoints on which this API is accessible.
	Endpoints []string `json:"endpoints,omitempty"`
	// Name: Identifier. Format:
	// `projects/{project}/locations/{location}/externalApi/{externalApi}`.
	Name string `json:"name,omitempty"`
	// Paths: Optional. List of paths served by this API.
	Paths []string `json:"paths,omitempty"`
	// UpdateTime: Output only. Last update timestamp.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ExternalApi) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ExternalApi
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1GoogleServiceAccountConfig: Config for Google service
// account authentication.
type GoogleCloudApihubV1GoogleServiceAccountConfig struct {
	// ServiceAccount: Required. The service account to be used for authenticating
	// request. The `iam.serviceAccounts.getAccessToken` permission should be
	// granted on this service account to the impersonator service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1GoogleServiceAccountConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1GoogleServiceAccountConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1HostProjectRegistration: Host project registration refers
// to the registration of a Google cloud project with Api Hub as a host
// project. This is the project where Api Hub is provisioned. It acts as the
// consumer project for the Api Hub instance provisioned. Multiple runtime
// projects can be attached to the host project and these attachments define
// the scope of Api Hub.
type GoogleCloudApihubV1HostProjectRegistration struct {
	// CreateTime: Output only. The time at which the host project registration was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// GcpProject: Required. Immutable. Google cloud project name in the format:
	// "projects/abc" or "projects/123". As input, project name with either project
	// id or number are accepted. As output, this field will contain project
	// number.
	GcpProject string `json:"gcpProject,omitempty"`
	// Name: Identifier. The name of the host project registration. Format:
	// "projects/{project}/locations/{location}/hostProjectRegistrations/{host_proje
	// ct_registration}".
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1HostProjectRegistration) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1HostProjectRegistration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1HostingService: The information related to the service
// implemented by the plugin developer, used to invoke the plugin's
// functionality.
type GoogleCloudApihubV1HostingService struct {
	// ServiceUri: Optional. The URI of the service implemented by the plugin
	// developer, used to invoke the plugin's functionality. This information is
	// only required for user defined plugins.
	ServiceUri string `json:"serviceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1HostingService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1HostingService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1HttpOperation: The HTTP Operation.
type GoogleCloudApihubV1HttpOperation struct {
	// Method: Optional. Operation method Note: Even though this field is optional,
	// it is required for CreateApiOperation API and we will fail the request if
	// not provided.
	//
	// Possible values:
	//   "METHOD_UNSPECIFIED" - Method unspecified.
	//   "GET" - Get Operation type.
	//   "PUT" - Put Operation type.
	//   "POST" - Post Operation type.
	//   "DELETE" - Delete Operation type.
	//   "OPTIONS" - Options Operation type.
	//   "HEAD" - Head Operation type.
	//   "PATCH" - Patch Operation type.
	//   "TRACE" - Trace Operation type.
	Method string `json:"method,omitempty"`
	// Path: Optional. The path details for the Operation. Note: Even though this
	// field is optional, it is required for CreateApiOperation API and we will
	// fail the request if not provided.
	Path *GoogleCloudApihubV1Path `json:"path,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Method") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Method") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1HttpOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1HttpOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Issue: Issue contains the details of a single issue found
// by the linter.
type GoogleCloudApihubV1Issue struct {
	// Code: Required. Rule code unique to each rule defined in linter.
	Code string `json:"code,omitempty"`
	// Message: Required. Human-readable message describing the issue found by the
	// linter.
	Message string `json:"message,omitempty"`
	// Path: Required. An array of strings indicating the location in the analyzed
	// document where the rule was triggered.
	Path []string `json:"path,omitempty"`
	// Range: Required. Object describing where in the file the issue was found.
	Range *GoogleCloudApihubV1Range `json:"range,omitempty"`
	// Severity: Required. Severity level of the rule violation.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Severity unspecified.
	//   "SEVERITY_ERROR" - Severity error.
	//   "SEVERITY_WARNING" - Severity warning.
	//   "SEVERITY_INFO" - Severity info.
	//   "SEVERITY_HINT" - Severity hint.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Issue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Issue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1LastExecution: The result of the last execution of the
// plugin instance.
type GoogleCloudApihubV1LastExecution struct {
	// EndTime: Output only. The last execution end time of the plugin instance.
	EndTime string `json:"endTime,omitempty"`
	// ErrorMessage: Output only. Error message describing the failure, if any,
	// during the last execution.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// Result: Output only. The result of the last execution of the plugin
	// instance.
	//
	// Possible values:
	//   "RESULT_UNSPECIFIED" - Default unspecified execution result.
	//   "SUCCEEDED" - The plugin instance executed successfully.
	//   "FAILED" - The plugin instance execution failed.
	Result string `json:"result,omitempty"`
	// StartTime: Output only. The last execution start time of the plugin
	// instance.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1LastExecution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1LastExecution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1LintResponse: LintResponse contains the response from the
// linter.
type GoogleCloudApihubV1LintResponse struct {
	// CreateTime: Required. Timestamp when the linting response was generated.
	CreateTime string `json:"createTime,omitempty"`
	// Issues: Optional. Array of issues found in the analyzed document.
	Issues []*GoogleCloudApihubV1Issue `json:"issues,omitempty"`
	// Linter: Required. Name of the linter used.
	//
	// Possible values:
	//   "LINTER_UNSPECIFIED" - Linter type unspecified.
	//   "SPECTRAL" - Linter type spectral.
	//   "OTHER" - Linter type other.
	Linter string `json:"linter,omitempty"`
	// Source: Required. Name of the linting application.
	Source string `json:"source,omitempty"`
	// State: Required. Lint state represents success or failure for linting.
	//
	// Possible values:
	//   "LINT_STATE_UNSPECIFIED" - Lint state unspecified.
	//   "LINT_STATE_SUCCESS" - Linting was completed successfully.
	//   "LINT_STATE_ERROR" - Linting encountered errors.
	State string `json:"state,omitempty"`
	// Summary: Optional. Summary of all issue types and counts for each severity
	// level.
	Summary []*GoogleCloudApihubV1SummaryEntry `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1LintResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1LintResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1LintSpecRequest: The LintSpec method's request.
type GoogleCloudApihubV1LintSpecRequest struct {
}

// GoogleCloudApihubV1ListApiOperationsResponse: The ListApiOperations method's
// response.
type GoogleCloudApihubV1ListApiOperationsResponse struct {
	// ApiOperations: The operations corresponding to an API version.
	ApiOperations []*GoogleCloudApihubV1ApiOperation `json:"apiOperations,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiOperations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiOperations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListApiOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListApiOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListApisResponse: The ListApis method's response.
type GoogleCloudApihubV1ListApisResponse struct {
	// Apis: The API resources present in the API hub.
	Apis []*GoogleCloudApihubV1Api `json:"apis,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Apis") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apis") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListApisResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListApisResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListAttributesResponse: The ListAttributes method's
// response.
type GoogleCloudApihubV1ListAttributesResponse struct {
	// Attributes: The list of all attributes.
	Attributes []*GoogleCloudApihubV1Attribute `json:"attributes,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListAttributesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListAttributesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListCurationsResponse: The ListCurations method's
// response.
type GoogleCloudApihubV1ListCurationsResponse struct {
	// Curations: The curation resources present in the API hub.
	Curations []*GoogleCloudApihubV1Curation `json:"curations,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Curations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Curations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListCurationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListCurationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListDependenciesResponse: The ListDependencies method's
// response.
type GoogleCloudApihubV1ListDependenciesResponse struct {
	// Dependencies: The dependency resources present in the API hub.
	Dependencies []*GoogleCloudApihubV1Dependency `json:"dependencies,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Dependencies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dependencies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListDependenciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListDependenciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListDeploymentsResponse: The ListDeployments method's
// response.
type GoogleCloudApihubV1ListDeploymentsResponse struct {
	// Deployments: The deployment resources present in the API hub.
	Deployments []*GoogleCloudApihubV1Deployment `json:"deployments,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Deployments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListDeploymentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListExternalApisResponse: The ListExternalApis method's
// response.
type GoogleCloudApihubV1ListExternalApisResponse struct {
	// ExternalApis: The External API resources present in the API hub.
	ExternalApis []*GoogleCloudApihubV1ExternalApi `json:"externalApis,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExternalApis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExternalApis") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListExternalApisResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListExternalApisResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListHostProjectRegistrationsResponse: The
// ListHostProjectRegistrations method's response.
type GoogleCloudApihubV1ListHostProjectRegistrationsResponse struct {
	// HostProjectRegistrations: The list of host project registrations.
	HostProjectRegistrations []*GoogleCloudApihubV1HostProjectRegistration `json:"hostProjectRegistrations,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "HostProjectRegistrations")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HostProjectRegistrations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListHostProjectRegistrationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListHostProjectRegistrationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListPluginInstancesResponse: The ListPluginInstances
// method's response.
type GoogleCloudApihubV1ListPluginInstancesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PluginInstances: The plugin instances from the specified parent resource.
	PluginInstances []*GoogleCloudApihubV1PluginInstance `json:"pluginInstances,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListPluginInstancesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListPluginInstancesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListPluginsResponse: The ListPlugins method's response.
type GoogleCloudApihubV1ListPluginsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Plugins: The plugins from the specified parent resource.
	Plugins []*GoogleCloudApihubV1Plugin `json:"plugins,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListPluginsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListPluginsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListRuntimeProjectAttachmentsResponse: The
// ListRuntimeProjectAttachments method's response.
type GoogleCloudApihubV1ListRuntimeProjectAttachmentsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RuntimeProjectAttachments: List of runtime project attachments.
	RuntimeProjectAttachments []*GoogleCloudApihubV1RuntimeProjectAttachment `json:"runtimeProjectAttachments,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListRuntimeProjectAttachmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListRuntimeProjectAttachmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListSpecsResponse: The ListSpecs method's response.
type GoogleCloudApihubV1ListSpecsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Specs: The specs corresponding to an API Version.
	Specs []*GoogleCloudApihubV1Spec `json:"specs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListSpecsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListSpecsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ListVersionsResponse: The ListVersions method's response.
type GoogleCloudApihubV1ListVersionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Versions: The versions corresponding to an API.
	Versions []*GoogleCloudApihubV1Version `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ListVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ListVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1LookupApiHubInstanceResponse: The LookupApiHubInstance
// method's response.`
type GoogleCloudApihubV1LookupApiHubInstanceResponse struct {
	// ApiHubInstance: API Hub instance for a project if it exists, empty
	// otherwise.
	ApiHubInstance *GoogleCloudApihubV1ApiHubInstance `json:"apiHubInstance,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiHubInstance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiHubInstance") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1LookupApiHubInstanceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1LookupApiHubInstanceResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1LookupRuntimeProjectAttachmentResponse: The
// ListRuntimeProjectAttachments method's response.
type GoogleCloudApihubV1LookupRuntimeProjectAttachmentResponse struct {
	// RuntimeProjectAttachment: Runtime project attachment for a project if
	// exists, empty otherwise.
	RuntimeProjectAttachment *GoogleCloudApihubV1RuntimeProjectAttachment `json:"runtimeProjectAttachment,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "RuntimeProjectAttachment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RuntimeProjectAttachment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1LookupRuntimeProjectAttachmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1LookupRuntimeProjectAttachmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1MultiIntValues: The config variable value of data type
// multi int.
type GoogleCloudApihubV1MultiIntValues struct {
	// Values: Optional. The config variable value of data type multi int.
	Values []int64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1MultiIntValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1MultiIntValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1MultiSelectValues: The config variable value of data type
// multi select.
type GoogleCloudApihubV1MultiSelectValues struct {
	// Values: Optional. The config variable value of data type multi select.
	Values []*GoogleCloudApihubV1ConfigValueOption `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1MultiSelectValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1MultiSelectValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1MultiStringValues: The config variable value of data type
// multi string.
type GoogleCloudApihubV1MultiStringValues struct {
	// Values: Optional. The config variable value of data type multi string.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1MultiStringValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1MultiStringValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Oauth2ClientCredentialsConfig: Parameters to support
// Oauth 2.0 client credentials grant authentication. See
// https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
type GoogleCloudApihubV1Oauth2ClientCredentialsConfig struct {
	// ClientId: Required. The client identifier.
	ClientId string `json:"clientId,omitempty"`
	// ClientSecret: Required. Secret version reference containing the client
	// secret. The `secretmanager.versions.access` permission should be granted to
	// the service account accessing the secret.
	ClientSecret *GoogleCloudApihubV1Secret `json:"clientSecret,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Oauth2ClientCredentialsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Oauth2ClientCredentialsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1OpenApiSpecDetails: OpenApiSpecDetails contains the
// details parsed from an OpenAPI spec in addition to the fields mentioned in
// SpecDetails.
type GoogleCloudApihubV1OpenApiSpecDetails struct {
	// Format: Output only. The format of the spec.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - SpecFile type unspecified.
	//   "OPEN_API_SPEC_2_0" - OpenAPI Spec v2.0.
	//   "OPEN_API_SPEC_3_0" - OpenAPI Spec v3.0.
	//   "OPEN_API_SPEC_3_1" - OpenAPI Spec v3.1.
	Format string `json:"format,omitempty"`
	// Owner: Output only. Owner details for the spec. This maps to `info.contact`
	// in OpenAPI spec.
	Owner *GoogleCloudApihubV1Owner `json:"owner,omitempty"`
	// Version: Output only. The version in the spec. This maps to `info.version`
	// in OpenAPI spec.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Format") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1OpenApiSpecDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1OpenApiSpecDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1OperationDetails: The operation details parsed from the
// spec.
type GoogleCloudApihubV1OperationDetails struct {
	// Deprecated -- Optional. For OpenAPI spec, this will be set if
	// `operation.deprecated`is marked as `true` in the spec.
	Deprecated bool `json:"deprecated,omitempty"`
	// Description: Optional. Description of the operation behavior. For OpenAPI
	// spec, this will map to `operation.description` in the spec, in case
	// description is empty, `operation.summary` will be used.
	Description string `json:"description,omitempty"`
	// Documentation: Optional. Additional external documentation for this
	// operation. For OpenAPI spec, this will map to `operation.documentation` in
	// the spec.
	Documentation *GoogleCloudApihubV1Documentation `json:"documentation,omitempty"`
	// HttpOperation: The HTTP Operation.
	HttpOperation *GoogleCloudApihubV1HttpOperation `json:"httpOperation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deprecated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deprecated") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1OperationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1OperationDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1OperationMetadata: Represents the metadata of the
// long-running operation.
type GoogleCloudApihubV1OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have Operation.error value with a google.rpc.Status.code of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Owner: Owner details.
type GoogleCloudApihubV1Owner struct {
	// DisplayName: Optional. The name of the owner.
	DisplayName string `json:"displayName,omitempty"`
	// Email: Required. The email of the owner.
	Email string `json:"email,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Owner) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Owner
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Path: The path details derived from the spec.
type GoogleCloudApihubV1Path struct {
	// Description: Optional. A short description for the path applicable to all
	// operations.
	Description string `json:"description,omitempty"`
	// Path: Optional. Complete path relative to server endpoint. Note: Even though
	// this field is optional, it is required for CreateApiOperation API and we
	// will fail the request if not provided.
	Path string `json:"path,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Path) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Path
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Plugin: A plugin resource in the API Hub.
type GoogleCloudApihubV1Plugin struct {
	// ActionsConfig: Optional. The configuration of actions supported by the
	// plugin.
	ActionsConfig []*GoogleCloudApihubV1PluginActionConfig `json:"actionsConfig,omitempty"`
	// ConfigTemplate: Optional. The configuration template for the plugin.
	ConfigTemplate *GoogleCloudApihubV1ConfigTemplate `json:"configTemplate,omitempty"`
	// CreateTime: Output only. Timestamp indicating when the plugin was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. The plugin description. Max length is 2000 characters
	// (Unicode code points).
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the plugin. Max length is 50
	// characters (Unicode code points).
	DisplayName string `json:"displayName,omitempty"`
	// Documentation: Optional. The documentation of the plugin, that explains how
	// to set up and use the plugin.
	Documentation *GoogleCloudApihubV1Documentation `json:"documentation,omitempty"`
	// GatewayType: Optional. The type of the gateway.
	//
	// Possible values:
	//   "GATEWAY_TYPE_UNSPECIFIED" - The gateway type is not specified.
	//   "APIGEE_X_AND_HYBRID" - The gateway type is Apigee X and Hybrid.
	//   "APIGEE_EDGE_PUBLIC_CLOUD" - The gateway type is Apigee Edge Public Cloud.
	//   "APIGEE_EDGE_PRIVATE_CLOUD" - The gateway type is Apigee Edge Private
	// Cloud.
	//   "CLOUD_API_GATEWAY" - The gateway type is Cloud API Gateway.
	//   "CLOUD_ENDPOINTS" - The gateway type is Cloud Endpoints.
	//   "API_DISCOVERY" - The gateway type is API Discovery.
	//   "OTHERS" - The gateway type for any other types of gateways.
	GatewayType string `json:"gatewayType,omitempty"`
	// HostingService: Optional. This field is optional. It is used to notify the
	// plugin hosting service for any lifecycle changes of the plugin instance and
	// trigger execution of plugin instance actions in case of API hub managed
	// actions. This field should be provided if the plugin instance lifecycle of
	// the developed plugin needs to be managed from API hub. Also, in this case
	// the plugin hosting service interface needs to be implemented. This field
	// should not be provided if the plugin wants to manage plugin instance
	// lifecycle events outside of hub interface and use plugin framework for only
	// registering of plugin and plugin instances to capture the source of data
	// into hub. Note, in this case the plugin hosting service interface is not
	// required to be implemented. Also, the plugin instance lifecycle actions will
	// be disabled from API hub's UI.
	HostingService *GoogleCloudApihubV1HostingService `json:"hostingService,omitempty"`
	// Name: Identifier. The name of the plugin. Format:
	// `projects/{project}/locations/{location}/plugins/{plugin}`
	Name string `json:"name,omitempty"`
	// OwnershipType: Output only. The type of the plugin, indicating whether it is
	// 'SYSTEM_OWNED' or 'USER_OWNED'.
	//
	// Possible values:
	//   "OWNERSHIP_TYPE_UNSPECIFIED" - Default unspecified type.
	//   "SYSTEM_OWNED" - System owned plugins are defined by API hub and are
	// available out of the box in API hub.
	//   "USER_OWNED" - User owned plugins are defined by the user and need to be
	// explicitly added to API hub via CreatePlugin method.
	OwnershipType string `json:"ownershipType,omitempty"`
	// PluginCategory: Optional. The category of the plugin, identifying its
	// primary category or purpose. This field is required for all plugins.
	//
	// Possible values:
	//   "PLUGIN_CATEGORY_UNSPECIFIED" - Default unspecified plugin type.
	//   "API_GATEWAY" - API_GATEWAY plugins represent plugins built for API
	// Gateways like Apigee.
	//   "API_PRODUCER" - API_PRODUCER plugins represent plugins built for API
	// Producers like Cloud Run, Application Integration etc.
	PluginCategory string `json:"pluginCategory,omitempty"`
	// State: Output only. Represents the state of the plugin. Note this field will
	// not be set for plugins developed via plugin framework as the state will be
	// managed at plugin instance level.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "ENABLED" - The plugin is enabled.
	//   "DISABLED" - The plugin is disabled.
	State string `json:"state,omitempty"`
	// Type: Optional. The type of the API. This maps to the following system
	// defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-plugin-type`
	// attribute. The number of allowed values for this attribute will be based on
	// the cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute. Note this field is not required for plugins developed via plugin
	// framework.
	Type *GoogleCloudApihubV1AttributeValues `json:"type,omitempty"`
	// UpdateTime: Output only. Timestamp indicating when the plugin was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActionsConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionsConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Plugin) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Plugin
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1PluginActionConfig: PluginActionConfig represents the
// configuration of an action supported by a plugin.
type GoogleCloudApihubV1PluginActionConfig struct {
	// Description: Required. The description of the operation performed by the
	// action.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the action.
	DisplayName string `json:"displayName,omitempty"`
	// Id: Required. The id of the action.
	Id string `json:"id,omitempty"`
	// TriggerMode: Required. The trigger mode supported by the action.
	//
	// Possible values:
	//   "TRIGGER_MODE_UNSPECIFIED" - Default unspecified mode.
	//   "API_HUB_ON_DEMAND_TRIGGER" - This action can be executed by invoking
	// ExecutePluginInstanceAction API with the given action id. To support this,
	// the plugin hosting service should handle this action id as part of execute
	// call.
	//   "API_HUB_SCHEDULE_TRIGGER" - This action will be executed on schedule by
	// invoking ExecutePluginInstanceAction API with the given action id. To set
	// the schedule, the user can provide the cron expression in the PluginAction
	// field for a given plugin instance. To support this, the plugin hosting
	// service should handle this action id as part of execute call. Note, on
	// demand execution will be supported by default in this trigger mode.
	//   "NON_API_HUB_MANAGED" - The execution of this plugin is not handled by API
	// hub. In this case, the plugin hosting service need not handle this action id
	// as part of the execute call.
	TriggerMode string `json:"triggerMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1PluginActionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1PluginActionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1PluginInstance: Represents a plugin instance resource in
// the API Hub. A PluginInstance is a specific instance of a hub plugin with
// its own configuration, state, and execution details.
type GoogleCloudApihubV1PluginInstance struct {
	// Actions: Required. The action status for the plugin instance.
	Actions []*GoogleCloudApihubV1PluginInstanceAction `json:"actions,omitempty"`
	// AdditionalConfig: Optional. The additional information for this plugin
	// instance corresponding to the additional config template of the plugin. This
	// information will be sent to plugin hosting service on each call to plugin
	// hosted service. The key will be the config_variable_template.display_name to
	// uniquely identify the config variable.
	AdditionalConfig map[string]GoogleCloudApihubV1ConfigVariable `json:"additionalConfig,omitempty"`
	// AuthConfig: Optional. The authentication information for this plugin
	// instance.
	AuthConfig *GoogleCloudApihubV1AuthConfig `json:"authConfig,omitempty"`
	// CreateTime: Output only. Timestamp indicating when the plugin instance was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name for this plugin instance. Max length
	// is 255 characters.
	DisplayName string `json:"displayName,omitempty"`
	// ErrorMessage: Output only. Error message describing the failure, if any,
	// during Create, Delete or ApplyConfig operation corresponding to the plugin
	// instance.This field will only be populated if the plugin instance is in the
	// ERROR or FAILED state.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// Name: Identifier. The unique name of the plugin instance resource. Format:
	// `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance
	// }`
	Name string `json:"name,omitempty"`
	// SourceProjectId: Optional. The source project id of the plugin instance.
	// This will be the id of runtime project in case of gcp based plugins and org
	// id in case of non gcp based plugins. This is a required field.
	SourceProjectId string `json:"sourceProjectId,omitempty"`
	// State: Output only. The current state of the plugin instance (e.g., enabled,
	// disabled, provisioning).
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified state.
	//   "CREATING" - The plugin instance is being created.
	//   "ACTIVE" - The plugin instance is active and ready for executions. This is
	// the only state where executions can run on the plugin instance.
	//   "APPLYING_CONFIG" - The updated config that contains additional_config and
	// auth_config is being applied.
	//   "ERROR" - The ERROR state can come while applying config. Users can
	// retrigger ApplyPluginInstanceConfig to restore the plugin instance back to
	// active state. Note, In case the ERROR state happens while applying config
	// (auth_config, additional_config), the plugin instance will reflect the
	// config which was trying to be applied while error happened. In order to
	// overwrite, trigger ApplyConfig with a new config.
	//   "FAILED" - The plugin instance is in a failed state. This indicates that
	// an unrecoverable error occurred during a previous operation (Create,
	// Delete).
	//   "DELETING" - The plugin instance is being deleted. Delete is only possible
	// if there is no other operation running on the plugin instance and plugin
	// instance action.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp indicating when the plugin instance was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1PluginInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1PluginInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1PluginInstanceAction: PluginInstanceAction represents an
// action which can be executed in the plugin instance.
type GoogleCloudApihubV1PluginInstanceAction struct {
	// ActionId: Required. This should map to one of the action id specified in
	// actions_config in the plugin.
	ActionId string `json:"actionId,omitempty"`
	// CurationConfig: Optional. This configuration should be provided if the
	// plugin action is publishing data to API hub curate layer.
	CurationConfig *GoogleCloudApihubV1CurationConfig `json:"curationConfig,omitempty"`
	// HubInstanceAction: Optional. The execution information for the plugin
	// instance action done corresponding to an API hub instance.
	HubInstanceAction *GoogleCloudApihubV1ExecutionStatus `json:"hubInstanceAction,omitempty"`
	// ResourceConfig: Output only. The configuration of resources created for a
	// given plugin instance action. Note these will be returned only in case of
	// Non-GCP plugins like OPDK.
	ResourceConfig *GoogleCloudApihubV1ResourceConfig `json:"resourceConfig,omitempty"`
	// ScheduleCronExpression: Optional. The schedule for this plugin instance
	// action. This can only be set if the plugin supports API_HUB_SCHEDULE_TRIGGER
	// mode for this action.
	ScheduleCronExpression string `json:"scheduleCronExpression,omitempty"`
	// ScheduleTimeZone: Optional. The time zone for the schedule cron expression.
	// If not provided, UTC will be used.
	ScheduleTimeZone string `json:"scheduleTimeZone,omitempty"`
	// ServiceAccount: Optional. The service account used to publish data. Note,
	// the service account will only be accepted for non GCP plugins like OPDK.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// State: Output only. The current state of the plugin action in the plugin
	// instance.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default unspecified state.
	//   "ENABLED" - The action is enabled in the plugin instance i.e., executions
	// can be triggered for this action.
	//   "DISABLED" - The action is disabled in the plugin instance i.e., no
	// executions can be triggered for this action. This state indicates that the
	// user explicitly disabled the instance, and no further action is needed
	// unless the user wants to re-enable it.
	//   "ENABLING" - The action in the plugin instance is being enabled.
	//   "DISABLING" - The action in the plugin instance is being disabled.
	//   "ERROR" - The ERROR state can come while enabling/disabling plugin
	// instance action. Users can retrigger enable, disable via
	// EnablePluginInstanceAction and DisablePluginInstanceAction to restore the
	// action back to enabled/disabled state. Note enable/disable on actions can
	// only be triggered if plugin instance is in Active state.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1PluginInstanceAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1PluginInstanceAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1PluginInstanceActionID: The plugin instance and
// associated action that is using the curation.
type GoogleCloudApihubV1PluginInstanceActionID struct {
	// ActionId: Output only. The action ID that is using the curation. This should
	// map to one of the action IDs specified in action configs in the plugin.
	ActionId string `json:"actionId,omitempty"`
	// PluginInstance: Output only. Plugin instance that is using the curation.
	// Format is
	// `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance
	// }`
	PluginInstance string `json:"pluginInstance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1PluginInstanceActionID) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1PluginInstanceActionID
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1PluginInstanceActionSource: PluginInstanceActionSource
// represents the plugin instance action source.
type GoogleCloudApihubV1PluginInstanceActionSource struct {
	// ActionId: Output only. The id of the plugin instance action.
	ActionId string `json:"actionId,omitempty"`
	// PluginInstance: Output only. The resource name of the source plugin
	// instance. Format is
	// `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance
	// }`
	PluginInstance string `json:"pluginInstance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1PluginInstanceActionSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1PluginInstanceActionSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Point: Point within the file (line and character).
type GoogleCloudApihubV1Point struct {
	// Character: Required. Character position within the line (zero-indexed).
	Character int64 `json:"character,omitempty"`
	// Line: Required. Line number (zero-indexed).
	Line int64 `json:"line,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Character") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Character") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Point) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Point
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Range: Object describing where in the file the issue was
// found.
type GoogleCloudApihubV1Range struct {
	// End: Required. End of the issue.
	End *GoogleCloudApihubV1Point `json:"end,omitempty"`
	// Start: Required. Start of the issue.
	Start *GoogleCloudApihubV1Point `json:"start,omitempty"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Range) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Range
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1ResourceConfig: The configuration of resources created
// for a given plugin instance action.
type GoogleCloudApihubV1ResourceConfig struct {
	// ActionType: Output only. The type of the action.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Default unspecified action type.
	//   "SYNC_METADATA" - Action type for sync metadata.
	//   "SYNC_RUNTIME_DATA" - Action type for sync runtime data.
	ActionType string `json:"actionType,omitempty"`
	// PubsubTopic: Output only. The pubsub topic to publish the data to. Format is
	// projects/{project}/topics/{topic}
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1ResourceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1ResourceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1RuntimeProjectAttachment: Runtime project attachment
// represents an attachment from the runtime project to the host project. Api
// Hub looks for deployments in the attached runtime projects and creates
// corresponding resources in Api Hub for the discovered deployments.
type GoogleCloudApihubV1RuntimeProjectAttachment struct {
	// CreateTime: Output only. Create time.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The resource name of a runtime project attachment. Format:
	// "projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_p
	// roject_attachment}".
	Name string `json:"name,omitempty"`
	// RuntimeProject: Required. Immutable. Google cloud project name in the
	// format: "projects/abc" or "projects/123". As input, project name with either
	// project id or number are accepted. As output, this field will contain
	// project number.
	RuntimeProject string `json:"runtimeProject,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1RuntimeProjectAttachment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1RuntimeProjectAttachment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Schema: The schema details derived from the spec.
// Currently, this entity is supported for OpenAPI spec only. For OpenAPI spec,
// this maps to the schema defined in the `definitions` section for OpenAPI 2.0
// version and in `components.schemas` section for OpenAPI 3.0 and 3.1 version.
type GoogleCloudApihubV1Schema struct {
	// DisplayName: Output only. The display name of the schema. This will map to
	// the name of the schema in the spec.
	DisplayName string `json:"displayName,omitempty"`
	// RawValue: Output only. The raw value of the schema definition corresponding
	// to the schema name in the spec.
	RawValue string `json:"rawValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Schema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Schema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1SearchResourcesRequest: The SearchResources method's
// request.
type GoogleCloudApihubV1SearchResourcesRequest struct {
	// Filter: Optional. An expression that filters the list of search results. A
	// filter expression consists of a field name, a comparison operator, and a
	// value for filtering. The value must be a string, a number, or a boolean. The
	// comparison operator must be `=`. Filters are not case sensitive. The
	// following field names are eligible for filtering: * `resource_type` - The
	// type of resource in the search results. Must be one of the following: `Api`,
	// `ApiOperation`, `Deployment`, `Definition`, `Spec` or `Version`. This field
	// can only be specified once in the filter. Here are is an example: *
	// `resource_type = Api` - The resource_type is _Api_.
	Filter string `json:"filter,omitempty"`
	// PageSize: Optional. The maximum number of search results to return. The
	// service may return fewer than this value. If unspecified at most 10 search
	// results will be returned. If value is negative then `INVALID_ARGUMENT` error
	// is returned. The maximum value is 25; values above 25 will be coerced to 25.
	// While paginating, you can specify a new page size parameter for each page of
	// search results to be listed.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Optional. A page token, received from a previous SearchResources
	// call. Specify this parameter to retrieve the next page of transactions. When
	// paginating, you must specify the `page_token` parameter and all the other
	// parameters except page_size should be specified with the same value which
	// was used in the previous call. If the other fields are set with a different
	// value than the previous call then `INVALID_ARGUMENT` error is returned.
	PageToken string `json:"pageToken,omitempty"`
	// Query: Required. The free text search query. This query can contain keywords
	// which could be related to any detail of the API-Hub resources such display
	// names, descriptions, attributes etc.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1SearchResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1SearchResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1SearchResourcesResponse: Response for the SearchResources
// method.
type GoogleCloudApihubV1SearchResourcesResponse struct {
	// NextPageToken: Pass this token in the SearchResourcesRequest to continue to
	// list results. If all results have been returned, this field is an empty
	// string or not present in the response.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SearchResults: List of search results according to the filter and search
	// query specified. The order of search results represents the ranking.
	SearchResults []*GoogleCloudApihubV1SearchResult `json:"searchResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1SearchResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1SearchResourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1SearchResult: Represents the search results.
type GoogleCloudApihubV1SearchResult struct {
	// Resource: This represents the ApiHubResource. Note: Only selected fields of
	// the resources are populated in response.
	Resource *GoogleCloudApihubV1ApiHubResource `json:"resource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1SearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1SearchResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Secret: Secret provides a reference to entries in Secret
// Manager.
type GoogleCloudApihubV1Secret struct {
	// SecretVersion: Required. The resource name of the secret version in the
	// format, format as: `projects/*/secrets/*/versions/*`.
	SecretVersion string `json:"secretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Secret) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Secret
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1SourceMetadata: SourceMetadata represents the metadata
// for a resource at the source.
type GoogleCloudApihubV1SourceMetadata struct {
	// OriginalResourceCreateTime: Output only. The time at which the resource was
	// created at the source.
	OriginalResourceCreateTime string `json:"originalResourceCreateTime,omitempty"`
	// OriginalResourceId: Output only. The unique identifier of the resource at
	// the source.
	OriginalResourceId string `json:"originalResourceId,omitempty"`
	// OriginalResourceUpdateTime: Output only. The time at which the resource was
	// last updated at the source.
	OriginalResourceUpdateTime string `json:"originalResourceUpdateTime,omitempty"`
	// PluginInstanceActionSource: Output only. The source of the resource is a
	// plugin instance action.
	PluginInstanceActionSource *GoogleCloudApihubV1PluginInstanceActionSource `json:"pluginInstanceActionSource,omitempty"`
	// SourceType: Output only. The type of the source.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type not specified.
	//   "PLUGIN" - Source type plugin.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalResourceCreateTime")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalResourceCreateTime") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1SourceMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1SourceMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Spec: Represents a spec associated with an API version in
// the API Hub. Note that specs of various types can be uploaded, however
// parsing of details is supported for OpenAPI spec currently.
type GoogleCloudApihubV1Spec struct {
	// Attributes: Optional. The list of user defined attributes associated with
	// the spec. The key is the attribute name. It will be of the format:
	// `projects/{project}/locations/{location}/attributes/{attribute}`. The value
	// is the attribute values associated with the resource.
	Attributes map[string]GoogleCloudApihubV1AttributeValues `json:"attributes,omitempty"`
	// Contents: Optional. Input only. The contents of the uploaded spec.
	Contents *GoogleCloudApihubV1SpecContents `json:"contents,omitempty"`
	// CreateTime: Output only. The time at which the spec was created.
	CreateTime string `json:"createTime,omitempty"`
	// Details: Output only. Details parsed from the spec.
	Details *GoogleCloudApihubV1SpecDetails `json:"details,omitempty"`
	// DisplayName: Required. The display name of the spec. This can contain the
	// file name of the spec.
	DisplayName string `json:"displayName,omitempty"`
	// Documentation: Optional. The documentation of the spec. For OpenAPI spec,
	// this will be populated from `externalDocs` in OpenAPI spec.
	Documentation *GoogleCloudApihubV1Documentation `json:"documentation,omitempty"`
	// LintResponse: Optional. The lint response for the spec.
	LintResponse *GoogleCloudApihubV1LintResponse `json:"lintResponse,omitempty"`
	// Name: Identifier. The name of the spec. Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/
	// {spec}`
	Name string `json:"name,omitempty"`
	// ParsingMode: Optional. Input only. Enum specifying the parsing mode for
	// OpenAPI Specification (OAS) parsing.
	//
	// Possible values:
	//   "PARSING_MODE_UNSPECIFIED" - Defaults to `RELAXED`.
	//   "RELAXED" - Parsing of the Spec on create and update is relaxed, meaning
	// that parsing errors the spec contents will not fail the API call.
	//   "STRICT" - Parsing of the Spec on create and update is strict, meaning
	// that parsing errors in the spec contents will fail the API call.
	ParsingMode string `json:"parsingMode,omitempty"`
	// SourceMetadata: Output only. The list of sources and metadata from the
	// sources of the spec.
	SourceMetadata []*GoogleCloudApihubV1SourceMetadata `json:"sourceMetadata,omitempty"`
	// SourceUri: Optional. The URI of the spec source in case file is uploaded
	// from an external version control system.
	SourceUri string `json:"sourceUri,omitempty"`
	// SpecType: Required. The type of spec. The value should be one of the allowed
	// values defined for
	// `projects/{project}/locations/{location}/attributes/system-spec-type`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. Note, this field is mandatory if content is provided.
	SpecType *GoogleCloudApihubV1AttributeValues `json:"specType,omitempty"`
	// UpdateTime: Output only. The time at which the spec was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Spec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Spec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1SpecContents: The spec contents.
type GoogleCloudApihubV1SpecContents struct {
	// Contents: Required. The contents of the spec.
	Contents string `json:"contents,omitempty"`
	// MimeType: Required. The mime type of the content for example
	// application/json, application/yaml, application/wsdl etc.
	MimeType string `json:"mimeType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1SpecContents) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1SpecContents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1SpecDetails: SpecDetails contains the details parsed from
// supported spec types.
type GoogleCloudApihubV1SpecDetails struct {
	// Description: Output only. The description of the spec.
	Description string `json:"description,omitempty"`
	// OpenApiSpecDetails: Output only. Additional details apart from
	// `OperationDetails` parsed from an OpenAPI spec. The OperationDetails parsed
	// from the spec can be obtained by using ListAPIOperations method.
	OpenApiSpecDetails *GoogleCloudApihubV1OpenApiSpecDetails `json:"openApiSpecDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1SpecDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1SpecDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1SpecMetadata: The metadata associated with a spec of the
// API version.
type GoogleCloudApihubV1SpecMetadata struct {
	// OriginalCreateTime: Optional. Timestamp indicating when the spec was created
	// at the source.
	OriginalCreateTime string `json:"originalCreateTime,omitempty"`
	// OriginalId: Optional. The unique identifier of the spec in the system where
	// it was originally created.
	OriginalId string `json:"originalId,omitempty"`
	// OriginalUpdateTime: Required. Timestamp indicating when the spec was last
	// updated at the source.
	OriginalUpdateTime string `json:"originalUpdateTime,omitempty"`
	// Spec: Required. The spec resource to be pushed to Hub's collect layer. The
	// ID of the spec will be generated by Hub.
	Spec *GoogleCloudApihubV1Spec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalCreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalCreateTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1SpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1SpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1StringAttributeValues: The attribute values of data type
// string or JSON.
type GoogleCloudApihubV1StringAttributeValues struct {
	// Values: Required. The attribute values in case attribute data type is string
	// or JSON.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1StringAttributeValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1StringAttributeValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1StyleGuide: Represents a singleton style guide resource
// to be used for linting Open API specs.
type GoogleCloudApihubV1StyleGuide struct {
	// Contents: Required. Input only. The contents of the uploaded style guide.
	Contents *GoogleCloudApihubV1StyleGuideContents `json:"contents,omitempty"`
	// Linter: Required. Target linter for the style guide.
	//
	// Possible values:
	//   "LINTER_UNSPECIFIED" - Linter type unspecified.
	//   "SPECTRAL" - Linter type spectral.
	//   "OTHER" - Linter type other.
	Linter string `json:"linter,omitempty"`
	// Name: Identifier. The name of the style guide. Format:
	// `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1StyleGuide) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1StyleGuide
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1StyleGuideContents: The style guide contents.
type GoogleCloudApihubV1StyleGuideContents struct {
	// Contents: Required. The contents of the style guide.
	Contents string `json:"contents,omitempty"`
	// MimeType: Required. The mime type of the content.
	MimeType string `json:"mimeType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1StyleGuideContents) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1StyleGuideContents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1SummaryEntry: Count of issues with a given severity.
type GoogleCloudApihubV1SummaryEntry struct {
	// Count: Required. Count of issues with the given severity.
	Count int64 `json:"count,omitempty"`
	// Severity: Required. Severity of the issue.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Severity unspecified.
	//   "SEVERITY_ERROR" - Severity error.
	//   "SEVERITY_WARNING" - Severity warning.
	//   "SEVERITY_INFO" - Severity info.
	//   "SEVERITY_HINT" - Severity hint.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1SummaryEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1SummaryEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1UserPasswordConfig: Parameters to support Username and
// Password Authentication.
type GoogleCloudApihubV1UserPasswordConfig struct {
	// Password: Required. Secret version reference containing the password. The
	// `secretmanager.versions.access` permission should be granted to the service
	// account accessing the secret.
	Password *GoogleCloudApihubV1Secret `json:"password,omitempty"`
	// Username: Required. Username.
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Password") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Password") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1UserPasswordConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1UserPasswordConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1Version: Represents a version of the API resource in API
// hub. This is also referred to as the API version.
type GoogleCloudApihubV1Version struct {
	// Accreditation: Optional. The accreditations associated with the API version.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-accreditation`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Accreditation *GoogleCloudApihubV1AttributeValues `json:"accreditation,omitempty"`
	// ApiOperations: Output only. The operations contained in the API version.
	// These operations will be added to the version when a new spec is added or
	// when an existing spec is updated. Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operat
	// ions/{operation}`
	ApiOperations []string `json:"apiOperations,omitempty"`
	// Attributes: Optional. The list of user defined attributes associated with
	// the Version resource. The key is the attribute name. It will be of the
	// format: `projects/{project}/locations/{location}/attributes/{attribute}`.
	// The value is the attribute values associated with the resource.
	Attributes map[string]GoogleCloudApihubV1AttributeValues `json:"attributes,omitempty"`
	// Compliance: Optional. The compliance associated with the API version. This
	// maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-compliance`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Compliance *GoogleCloudApihubV1AttributeValues `json:"compliance,omitempty"`
	// CreateTime: Output only. The time at which the version was created.
	CreateTime string `json:"createTime,omitempty"`
	// Definitions: Output only. The definitions contained in the API version.
	// These definitions will be added to the version when a new spec is added or
	// when an existing spec is updated. Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/defini
	// tions/{definition}`
	Definitions []string `json:"definitions,omitempty"`
	// Deployments: Optional. The deployments linked to this API version. Note: A
	// particular API version could be deployed to multiple deployments (for dev
	// deployment, UAT deployment, etc) Format is
	// `projects/{project}/locations/{location}/deployments/{deployment}`
	Deployments []string `json:"deployments,omitempty"`
	// Description: Optional. The description of the version.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the version.
	DisplayName string `json:"displayName,omitempty"`
	// Documentation: Optional. The documentation of the version.
	Documentation *GoogleCloudApihubV1Documentation `json:"documentation,omitempty"`
	// Lifecycle: Optional. The lifecycle of the API version. This maps to the
	// following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-lifecycle`
	// attribute. The number of values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Lifecycle *GoogleCloudApihubV1AttributeValues `json:"lifecycle,omitempty"`
	// Name: Identifier. The name of the version. Format:
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
	Name string `json:"name,omitempty"`
	// SelectedDeployment: Optional. The selected deployment for a Version
	// resource. This can be used when special handling is needed on client side
	// for a particular deployment linked to the version. Format is
	// `projects/{project}/locations/{location}/deployments/{deployment}`
	SelectedDeployment string `json:"selectedDeployment,omitempty"`
	// SourceMetadata: Output only. The list of sources and metadata from the
	// sources of the version.
	SourceMetadata []*GoogleCloudApihubV1SourceMetadata `json:"sourceMetadata,omitempty"`
	// Specs: Output only. The specs associated with this version. Note that an API
	// version can be associated with multiple specs. Format is
	// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/
	// {spec}`
	Specs []string `json:"specs,omitempty"`
	// UpdateTime: Output only. The time at which the version was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Accreditation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accreditation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1Version) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1Version
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudApihubV1VersionMetadata: The metadata associated with a version
// of the API resource.
type GoogleCloudApihubV1VersionMetadata struct {
	// Deployments: Optional. The deployments linked to this API version. Note: A
	// particular API version could be deployed to multiple deployments (for dev
	// deployment, UAT deployment, etc.)
	Deployments []*GoogleCloudApihubV1DeploymentMetadata `json:"deployments,omitempty"`
	// OriginalCreateTime: Optional. Timestamp indicating when the version was
	// created at the source.
	OriginalCreateTime string `json:"originalCreateTime,omitempty"`
	// OriginalId: Optional. The unique identifier of the version in the system
	// where it was originally created.
	OriginalId string `json:"originalId,omitempty"`
	// OriginalUpdateTime: Required. Timestamp indicating when the version was last
	// updated at the source.
	OriginalUpdateTime string `json:"originalUpdateTime,omitempty"`
	// Specs: Optional. The specs associated with this version. Note that an API
	// version can be associated with multiple specs.
	Specs []*GoogleCloudApihubV1SpecMetadata `json:"specs,omitempty"`
	// Version: Required. Represents a version of the API resource in API hub. The
	// ID of the version will be generated by Hub.
	Version *GoogleCloudApihubV1Version `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudApihubV1VersionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApihubV1VersionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudCommonOperationMetadata: Represents the metadata of the
// long-running operation.
type GoogleCloudCommonOperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CancelRequested: Output only. Identifies whether the user has requested
	// cancellation of the operation. Operations that have been cancelled
	// successfully have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
	CancelRequested bool `json:"cancelRequested,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// StatusDetail: Output only. Human-readable status of the operation, if any.
	StatusDetail string `json:"statusDetail,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudCommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudCommonOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationListLocationsResponse: The response message for
// Locations.ListLocations.
type GoogleCloudLocationListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*GoogleCloudLocationLocation `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudLocationListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationLocation: A resource that represents a Google Cloud
// location.
type GoogleCloudLocationLocation struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudLocationLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningCancelOperationRequest: The request message for
// Operations.CancelOperation.
type GoogleLongrunningCancelOperationRequest struct {
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsCollectApiDataCall struct {
	s                                        *Service
	location                                 string
	googlecloudapihubv1collectapidatarequest *GoogleCloudApihubV1CollectApiDataRequest
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// CollectApiData: Collect API data from a source and push it to Hub's collect
// layer.
//
//   - location: The regional location of the API hub instance and its resources.
//     Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsService) CollectApiData(location string, googlecloudapihubv1collectapidatarequest *GoogleCloudApihubV1CollectApiDataRequest) *ProjectsLocationsCollectApiDataCall {
	c := &ProjectsLocationsCollectApiDataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googlecloudapihubv1collectapidatarequest = googlecloudapihubv1collectapidatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCollectApiDataCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectApiDataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCollectApiDataCall) Context(ctx context.Context) *ProjectsLocationsCollectApiDataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCollectApiDataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectApiDataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1collectapidatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}:collectApiData")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.collectApiData", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.collectApiData" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectApiDataCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.collectApiData", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationLocation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationLocation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationLocation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": A list
// of extra location types that should be used as conditions for controlling
// the visibility of the locations.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationListLocationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*GoogleCloudLocationListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsLookupRuntimeProjectAttachmentCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// LookupRuntimeProjectAttachment: Look up a runtime project attachment. This
// API can be called in the context of any project.
//
//   - name: Runtime project ID to look up runtime project attachment for. Lookup
//     happens across all regions. Expected format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsService) LookupRuntimeProjectAttachment(name string) *ProjectsLocationsLookupRuntimeProjectAttachmentCall {
	c := &ProjectsLocationsLookupRuntimeProjectAttachmentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsLookupRuntimeProjectAttachmentCall) Fields(s ...googleapi.Field) *ProjectsLocationsLookupRuntimeProjectAttachmentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsLookupRuntimeProjectAttachmentCall) IfNoneMatch(entityTag string) *ProjectsLocationsLookupRuntimeProjectAttachmentCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsLookupRuntimeProjectAttachmentCall) Context(ctx context.Context) *ProjectsLocationsLookupRuntimeProjectAttachmentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsLookupRuntimeProjectAttachmentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLookupRuntimeProjectAttachmentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:lookupRuntimeProjectAttachment")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.lookupRuntimeProjectAttachment", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.lookupRuntimeProjectAttachment" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1LookupRuntimeProjectAttachmentResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsLookupRuntimeProjectAttachmentCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1LookupRuntimeProjectAttachmentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1LookupRuntimeProjectAttachmentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.lookupRuntimeProjectAttachment", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSearchResourcesCall struct {
	s                                         *Service
	location                                  string
	googlecloudapihubv1searchresourcesrequest *GoogleCloudApihubV1SearchResourcesRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// SearchResources: Search across API-Hub resources.
//
//   - location: The resource name of the location which will be of the type
//     `projects/{project_id}/locations/{location_id}`. This field is used to
//     identify the instance of API-Hub in which resources should be searched.
func (r *ProjectsLocationsService) SearchResources(location string, googlecloudapihubv1searchresourcesrequest *GoogleCloudApihubV1SearchResourcesRequest) *ProjectsLocationsSearchResourcesCall {
	c := &ProjectsLocationsSearchResourcesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googlecloudapihubv1searchresourcesrequest = googlecloudapihubv1searchresourcesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSearchResourcesCall) Fields(s ...googleapi.Field) *ProjectsLocationsSearchResourcesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSearchResourcesCall) Context(ctx context.Context) *ProjectsLocationsSearchResourcesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSearchResourcesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSearchResourcesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1searchresourcesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}:searchResources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.searchResources", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.searchResources" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1SearchResourcesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSearchResourcesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1SearchResourcesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1SearchResourcesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.searchResources", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSearchResourcesCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1SearchResourcesResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googlecloudapihubv1searchresourcesrequest.PageToken = pt }(c.googlecloudapihubv1searchresourcesrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googlecloudapihubv1searchresourcesrequest.PageToken = x.NextPageToken
	}
}

type ProjectsLocationsApiHubInstancesCreateCall struct {
	s                                 *Service
	parent                            string
	googlecloudapihubv1apihubinstance *GoogleCloudApihubV1ApiHubInstance
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Create: Provisions instance resources for the API Hub.
//
//   - parent: The parent resource for the Api Hub instance resource. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsApiHubInstancesService) Create(parent string, googlecloudapihubv1apihubinstance *GoogleCloudApihubV1ApiHubInstance) *ProjectsLocationsApiHubInstancesCreateCall {
	c := &ProjectsLocationsApiHubInstancesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1apihubinstance = googlecloudapihubv1apihubinstance
	return c
}

// ApiHubInstanceId sets the optional parameter "apiHubInstanceId": Identifier
// to assign to the Api Hub instance. Must be unique within scope of the parent
// resource. If the field is not provided, system generated id will be used.
// This value should be 4-40 characters, and valid characters are
// `/a-z[0-9]-_/`.
func (c *ProjectsLocationsApiHubInstancesCreateCall) ApiHubInstanceId(apiHubInstanceId string) *ProjectsLocationsApiHubInstancesCreateCall {
	c.urlParams_.Set("apiHubInstanceId", apiHubInstanceId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApiHubInstancesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsApiHubInstancesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApiHubInstancesCreateCall) Context(ctx context.Context) *ProjectsLocationsApiHubInstancesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApiHubInstancesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApiHubInstancesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1apihubinstance)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apiHubInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apiHubInstances.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apiHubInstances.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApiHubInstancesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apiHubInstances.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApiHubInstancesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the API hub instance.
//
//   - name: The name of the Api Hub instance to delete. Format:
//     `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
func (r *ProjectsLocationsApiHubInstancesService) Delete(name string) *ProjectsLocationsApiHubInstancesDeleteCall {
	c := &ProjectsLocationsApiHubInstancesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApiHubInstancesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsApiHubInstancesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApiHubInstancesDeleteCall) Context(ctx context.Context) *ProjectsLocationsApiHubInstancesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApiHubInstancesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApiHubInstancesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apiHubInstances.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apiHubInstances.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApiHubInstancesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apiHubInstances.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApiHubInstancesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single API Hub instance.
//
//   - name: The name of the Api Hub instance to retrieve. Format:
//     `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
func (r *ProjectsLocationsApiHubInstancesService) Get(name string) *ProjectsLocationsApiHubInstancesGetCall {
	c := &ProjectsLocationsApiHubInstancesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApiHubInstancesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsApiHubInstancesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApiHubInstancesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsApiHubInstancesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApiHubInstancesGetCall) Context(ctx context.Context) *ProjectsLocationsApiHubInstancesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApiHubInstancesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApiHubInstancesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apiHubInstances.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apiHubInstances.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ApiHubInstance.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApiHubInstancesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ApiHubInstance, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ApiHubInstance{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apiHubInstances.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApiHubInstancesLookupCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Lookup: Looks up an Api Hub instance in a given GCP project. There will
// always be only one Api Hub instance for a GCP project across all locations.
//
//   - parent: There will always be only one Api Hub instance for a GCP project
//     across all locations. The parent resource for the Api Hub instance
//     resource. Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsApiHubInstancesService) Lookup(parent string) *ProjectsLocationsApiHubInstancesLookupCall {
	c := &ProjectsLocationsApiHubInstancesLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApiHubInstancesLookupCall) Fields(s ...googleapi.Field) *ProjectsLocationsApiHubInstancesLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApiHubInstancesLookupCall) IfNoneMatch(entityTag string) *ProjectsLocationsApiHubInstancesLookupCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApiHubInstancesLookupCall) Context(ctx context.Context) *ProjectsLocationsApiHubInstancesLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApiHubInstancesLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApiHubInstancesLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apiHubInstances:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apiHubInstances.lookup", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apiHubInstances.lookup" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1LookupApiHubInstanceResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApiHubInstancesLookupCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1LookupApiHubInstanceResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1LookupApiHubInstanceResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apiHubInstances.lookup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisCreateCall struct {
	s                      *Service
	parent                 string
	googlecloudapihubv1api *GoogleCloudApihubV1Api
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Create: Create an API resource in the API hub. Once an API resource is
// created, versions can be added to it.
//
//   - parent: The parent resource for the API resource. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsApisService) Create(parent string, googlecloudapihubv1api *GoogleCloudApihubV1Api) *ProjectsLocationsApisCreateCall {
	c := &ProjectsLocationsApisCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1api = googlecloudapihubv1api
	return c
}

// ApiId sets the optional parameter "apiId": The ID to use for the API
// resource, which will become the final component of the API's resource name.
// This field is optional. * If provided, the same will be used. The service
// will throw an error if the specified id is already used by another API
// resource in the API hub. * If not provided, a system generated id will be
// used. This value should be 4-500 characters, and valid characters are
// /a-z[0-9]-_/.
func (c *ProjectsLocationsApisCreateCall) ApiId(apiId string) *ProjectsLocationsApisCreateCall {
	c.urlParams_.Set("apiId", apiId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisCreateCall) Context(ctx context.Context) *ProjectsLocationsApisCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1api)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apis")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Api.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsApisCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Api, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Api{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an API resource in the API hub. API can only be deleted if
// all underlying versions are deleted.
//
//   - name: The name of the API resource to delete. Format:
//     `projects/{project}/locations/{location}/apis/{api}`.
func (r *ProjectsLocationsApisService) Delete(name string) *ProjectsLocationsApisDeleteCall {
	c := &ProjectsLocationsApisDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, any versions from
// this API will also be deleted. Otherwise, the request will only work if the
// API has no versions.
func (c *ProjectsLocationsApisDeleteCall) Force(force bool) *ProjectsLocationsApisDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisDeleteCall) Context(ctx context.Context) *ProjectsLocationsApisDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsApisDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get API resource details including the API versions contained in it.
//
//   - name: The name of the API resource to retrieve. Format:
//     `projects/{project}/locations/{location}/apis/{api}`.
func (r *ProjectsLocationsApisService) Get(name string) *ProjectsLocationsApisGetCall {
	c := &ProjectsLocationsApisGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisGetCall) Context(ctx context.Context) *ProjectsLocationsApisGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Api.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsApisGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Api, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Api{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List API resources in the API hub.
//
//   - parent: The parent, which owns this collection of API resources. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsApisService) List(parent string) *ProjectsLocationsApisListCall {
	c := &ProjectsLocationsApisListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of ApiResources. A filter expression consists of a field name, a
// comparison operator, and a value for filtering. The value must be a string.
// The comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are
// not case sensitive. The following fields in the `ApiResource` are eligible
// for filtering: * `owner.email` - The email of the team which owns the
// ApiResource. Allowed comparison operators: `=`. * `create_time` - The time
// at which the ApiResource was created. The value should be in the
// (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed comparison
// operators: `>` and `<`. * `display_name` - The display name of the
// ApiResource. Allowed comparison operators: `=`. *
// `target_user.enum_values.values.id` - The allowed value id of the target
// users attribute associated with the ApiResource. Allowed comparison operator
// is `:`. * `target_user.enum_values.values.display_name` - The allowed value
// display name of the target users attribute associated with the ApiResource.
// Allowed comparison operator is `:`. * `team.enum_values.values.id` - The
// allowed value id of the team attribute associated with the ApiResource.
// Allowed comparison operator is `:`. * `team.enum_values.values.display_name`
// - The allowed value display name of the team attribute associated with the
// ApiResource. Allowed comparison operator is `:`. *
// `business_unit.enum_values.values.id` - The allowed value id of the business
// unit attribute associated with the ApiResource. Allowed comparison operator
// is `:`. * `business_unit.enum_values.values.display_name` - The allowed
// value display name of the business unit attribute associated with the
// ApiResource. Allowed comparison operator is `:`. *
// `maturity_level.enum_values.values.id` - The allowed value id of the
// maturity level attribute associated with the ApiResource. Allowed comparison
// operator is `:`. * `maturity_level.enum_values.values.display_name` - The
// allowed value display name of the maturity level attribute associated with
// the ApiResource. Allowed comparison operator is `:`. *
// `api_style.enum_values.values.id` - The allowed value id of the api style
// attribute associated with the ApiResource. Allowed comparison operator is
// `:`. * `api_style.enum_values.values.display_name` - The allowed value
// display name of the api style attribute associated with the ApiResource.
// Allowed comparison operator is `:`. *
// `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.id` - The allowed
// value id of the user defined enum attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-enum-id is a
// placeholder that can be replaced with any user defined enum attribute name.
// * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.display_name` - The
// allowed value display name of the user defined enum attribute associated
// with the Resource. Allowed comparison operator is `:`. Here
// user-defined-attribute-enum-display-name is a placeholder that can be
// replaced with any user defined enum attribute enum name. *
// `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.string_values.values` - The allowed
// value of the user defined string attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-string is a
// placeholder that can be replaced with any user defined string attribute
// name. * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.json_values.values` - The allowed value
// of the user defined JSON attribute associated with the Resource. Allowed
// comparison operator is `:`. Here user-defined-attribute-json is a
// placeholder that can be replaced with any user defined JSON attribute name.
// A filter function is also supported in the filter string. The filter
// function is `id(name)`. The `id(name)` function returns the id of the
// resource name. For example, `id(name) = \"api-1\" is equivalent to `name =
// \"projects/test-project-id/locations/test-location-id/apis/api-1\" provided
// the parent is `projects/test-project-id/locations/test-location-id`.
// Expressions are combined with either `AND` logic operator or `OR` logical
// operator but not both of them together i.e. only one of the `AND` or `OR`
// operator can be used throughout the filter string and both the operators
// cannot be used together. No other logical operators are supported. At most
// three filter fields are allowed in the filter string and if provided more
// than that then `INVALID_ARGUMENT` error is returned by the API. Here are a
// few examples: * `owner.email = \"apihub@google.com\" - - The owner team
// email is _apihub@google.com_. * `owner.email = \"apihub@google.com\" AND
// create_time < \"2021-08-15T14:50:00Z\" AND create_time >
// \"2021-08-10T12:00:00Z\" - The owner team email is _apihub@google.com_ and
// the api was created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10
// 12:00:00 UTC_. * `owner.email = \"apihub@google.com\" OR
// team.enum_values.values.id: apihub-team-id` - The filter string specifies
// the APIs where the owner team email is _apihub@google.com_ or the id of the
// allowed value associated with the team attribute is _apihub-team-id_. *
// `owner.email = \"apihub@google.com\" OR
// team.enum_values.values.display_name: ApiHub Team` - The filter string
// specifies the APIs where the owner team email is _apihub@google.com_ or the
// display name of the allowed value associated with the team attribute is
// `ApiHub Team`. * `owner.email = \"apihub@google.com\" AND
// attributes.projects/test-project-id/locations/test-location-id/
// attributes/17650f90-4a29-4971-b3c0-d5532da3764b.enum_values.values.id:
// test_enum_id AND
// attributes.projects/test-project-id/locations/test-location-id/
// attributes/1765\0f90-4a29-5431-b3d0-d5532da3764c.string_values.values:
// test_string_value` - The filter string specifies the APIs where the owner
// team email is _apihub@google.com_ and the id of the allowed value associated
// with the user defined attribute of type enum is _test_enum_id_ and the value
// of the user defined attribute of type string is _test_..
func (c *ProjectsLocationsApisListCall) Filter(filter string) *ProjectsLocationsApisListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of API
// resources to return. The service may return fewer than this value. If
// unspecified, at most 50 Apis will be returned. The maximum value is 1000;
// values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsApisListCall) PageSize(pageSize int64) *ProjectsLocationsApisListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListApis` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters (except page_size) provided to
// `ListApis` must match the call that provided the page token.
func (c *ProjectsLocationsApisListCall) PageToken(pageToken string) *ProjectsLocationsApisListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisListCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisListCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisListCall) Context(ctx context.Context) *ProjectsLocationsApisListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apis")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListApisResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListApisResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListApisResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsApisListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListApisResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsApisPatchCall struct {
	s                      *Service
	name                   string
	googlecloudapihubv1api *GoogleCloudApihubV1Api
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Patch: Update an API resource in the API hub. The following fields in the
// API can be updated: * display_name * description * owner * documentation *
// target_user * team * business_unit * maturity_level * api_style * attributes
// The update_mask should be used to specify the fields being updated. Updating
// the owner field requires complete owner message and updates both owner and
// email fields.
//
//   - name: Identifier. The name of the API resource in the API Hub. Format:
//     `projects/{project}/locations/{location}/apis/{api}`.
func (r *ProjectsLocationsApisService) Patch(name string, googlecloudapihubv1api *GoogleCloudApihubV1Api) *ProjectsLocationsApisPatchCall {
	c := &ProjectsLocationsApisPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1api = googlecloudapihubv1api
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update.
func (c *ProjectsLocationsApisPatchCall) UpdateMask(updateMask string) *ProjectsLocationsApisPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisPatchCall) Context(ctx context.Context) *ProjectsLocationsApisPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1api)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Api.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsApisPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Api, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Api{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsCreateCall struct {
	s                          *Service
	parent                     string
	googlecloudapihubv1version *GoogleCloudApihubV1Version
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Create: Create an API version for an API resource in the API hub.
//
//   - parent: The parent resource for API version. Format:
//     `projects/{project}/locations/{location}/apis/{api}`.
func (r *ProjectsLocationsApisVersionsService) Create(parent string, googlecloudapihubv1version *GoogleCloudApihubV1Version) *ProjectsLocationsApisVersionsCreateCall {
	c := &ProjectsLocationsApisVersionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1version = googlecloudapihubv1version
	return c
}

// VersionId sets the optional parameter "versionId": The ID to use for the API
// version, which will become the final component of the version's resource
// name. This field is optional. * If provided, the same will be used. The
// service will throw an error if the specified id is already used by another
// version in the API resource. * If not provided, a system generated id will
// be used. This value should be 4-500 characters, overall resource name which
// will be of format
// `projects/{project}/locations/{location}/apis/{api}/versions/{version}`, its
// length is limited to 700 characters and valid characters are /a-z[0-9]-_/.
func (c *ProjectsLocationsApisVersionsCreateCall) VersionId(versionId string) *ProjectsLocationsApisVersionsCreateCall {
	c.urlParams_.Set("versionId", versionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsCreateCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1version)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/versions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Version.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Version, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Version{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an API version. Version can only be deleted if all underlying
// specs, operations, definitions and linked deployments are deleted.
//
//   - name: The name of the version to delete. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`.
func (r *ProjectsLocationsApisVersionsService) Delete(name string) *ProjectsLocationsApisVersionsDeleteCall {
	c := &ProjectsLocationsApisVersionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, any specs from
// this version will also be deleted. Otherwise, the request will only work if
// the version has no specs.
func (c *ProjectsLocationsApisVersionsDeleteCall) Force(force bool) *ProjectsLocationsApisVersionsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get details about the API version of an API resource. This will include
// information about the specs and operations present in the API version as
// well as the deployments linked to it.
//
//   - name: The name of the API version to retrieve. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`.
func (r *ProjectsLocationsApisVersionsService) Get(name string) *ProjectsLocationsApisVersionsGetCall {
	c := &ProjectsLocationsApisVersionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisVersionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisVersionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsGetCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Version.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Version, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Version{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List API versions of an API resource in the API hub.
//
//   - parent: The parent which owns this collection of API versions i.e., the
//     API resource Format: `projects/{project}/locations/{location}/apis/{api}`.
func (r *ProjectsLocationsApisVersionsService) List(parent string) *ProjectsLocationsApisVersionsListCall {
	c := &ProjectsLocationsApisVersionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of Versions. A filter expression consists of a field name, a comparison
// operator, and a value for filtering. The value must be a string, a number,
// or a boolean. The comparison operator must be one of: `<`, `>` or `=`.
// Filters are not case sensitive. The following fields in the `Version` are
// eligible for filtering: * `display_name` - The display name of the Version.
// Allowed comparison operators: `=`. * `create_time` - The time at which the
// Version was created. The value should be in the
// (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed comparison
// operators: `>` and `<`. * `lifecycle.enum_values.values.id` - The allowed
// value id of the lifecycle attribute associated with the Version. Allowed
// comparison operators: `:`. * `lifecycle.enum_values.values.display_name` -
// The allowed value display name of the lifecycle attribute associated with
// the Version. Allowed comparison operators: `:`. *
// `compliance.enum_values.values.id` - The allowed value id of the compliances
// attribute associated with the Version. Allowed comparison operators: `:`. *
// `compliance.enum_values.values.display_name` - The allowed value display
// name of the compliances attribute associated with the Version. Allowed
// comparison operators: `:`. * `accreditation.enum_values.values.id` - The
// allowed value id of the accreditations attribute associated with the
// Version. Allowed comparison operators: `:`. *
// `accreditation.enum_values.values.display_name` - The allowed value display
// name of the accreditations attribute associated with the Version. Allowed
// comparison operators: `:`. *
// `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.id` - The allowed
// value id of the user defined enum attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-enum-id is a
// placeholder that can be replaced with any user defined enum attribute name.
// * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.display_name` - The
// allowed value display name of the user defined enum attribute associated
// with the Resource. Allowed comparison operator is `:`. Here
// user-defined-attribute-enum-display-name is a placeholder that can be
// replaced with any user defined enum attribute enum name. *
// `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.string_values.values` - The allowed
// value of the user defined string attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-string is a
// placeholder that can be replaced with any user defined string attribute
// name. * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.json_values.values` - The allowed value
// of the user defined JSON attribute associated with the Resource. Allowed
// comparison operator is `:`. Here user-defined-attribute-json is a
// placeholder that can be replaced with any user defined JSON attribute name.
// Expressions are combined with either `AND` logic operator or `OR` logical
// operator but not both of them together i.e. only one of the `AND` or `OR`
// operator can be used throughout the filter string and both the operators
// cannot be used together. No other logical operators are supported. At most
// three filter fields are allowed in the filter string and if provided more
// than that then `INVALID_ARGUMENT` error is returned by the API. Here are a
// few examples: * `lifecycle.enum_values.values.id: preview-id` - The filter
// string specifies that the id of the allowed value associated with the
// lifecycle attribute of the Version is _preview-id_. *
// `lifecycle.enum_values.values.display_name: \"Preview Display Name\" - The
// filter string specifies that the display name of the allowed value
// associated with the lifecycle attribute of the Version is `Preview Display
// Name`. * `lifecycle.enum_values.values.id: preview-id AND create_time <
// \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\" - The
// id of the allowed value associated with the lifecycle attribute of the
// Version is _preview-id_ and it was created before _2021-08-15 14:50:00 UTC_
// and after _2021-08-10 12:00:00 UTC_. * `compliance.enum_values.values.id:
// gdpr-id OR compliance.enum_values.values.id: pci-dss-id` - The id of the
// allowed value associated with the compliance attribute is _gdpr-id_ or
// _pci-dss-id_. * `lifecycle.enum_values.values.id: preview-id AND
// attributes.projects/test-project-id/locations/test-location-id/
// attributes/17650f90-4a29-4971-b3c0-d5532da3764b.string_values.values: test`
// - The filter string specifies that the id of the allowed value associated
// with the lifecycle attribute of the Version is _preview-id_ and the value of
// the user defined attribute of type string is _test_.
func (c *ProjectsLocationsApisVersionsListCall) Filter(filter string) *ProjectsLocationsApisVersionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// versions to return. The service may return fewer than this value. If
// unspecified, at most 50 versions will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsApisVersionsListCall) PageSize(pageSize int64) *ProjectsLocationsApisVersionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListVersions` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters (except page_size) provided to
// `ListVersions` must match the call that provided the page token.
func (c *ProjectsLocationsApisVersionsListCall) PageToken(pageToken string) *ProjectsLocationsApisVersionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisVersionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisVersionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsListCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/versions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListVersionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsApisVersionsListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsApisVersionsPatchCall struct {
	s                          *Service
	name                       string
	googlecloudapihubv1version *GoogleCloudApihubV1Version
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Patch: Update API version. The following fields in the version can be
// updated currently: * display_name * description * documentation *
// deployments * lifecycle * compliance * accreditation * attributes The
// update_mask should be used to specify the fields being updated.
//
//   - name: Identifier. The name of the version. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`.
func (r *ProjectsLocationsApisVersionsService) Patch(name string, googlecloudapihubv1version *GoogleCloudApihubV1Version) *ProjectsLocationsApisVersionsPatchCall {
	c := &ProjectsLocationsApisVersionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1version = googlecloudapihubv1version
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update.
func (c *ProjectsLocationsApisVersionsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsApisVersionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsPatchCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1version)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Version.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Version, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Version{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsDefinitionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get details about a definition in an API version.
//
//   - name: The name of the definition to retrieve. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/defi
//     nitions/{definition}`.
func (r *ProjectsLocationsApisVersionsDefinitionsService) Get(name string) *ProjectsLocationsApisVersionsDefinitionsGetCall {
	c := &ProjectsLocationsApisVersionsDefinitionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsDefinitionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsDefinitionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisVersionsDefinitionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisVersionsDefinitionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsDefinitionsGetCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsDefinitionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsDefinitionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsDefinitionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.definitions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.definitions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Definition.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsDefinitionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Definition, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Definition{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.definitions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsOperationsCreateCall struct {
	s                               *Service
	parent                          string
	googlecloudapihubv1apioperation *GoogleCloudApihubV1ApiOperation
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Create: Create an apiOperation in an API version. An apiOperation can be
// created only if the version has no apiOperations which were created by
// parsing a spec.
//
//   - parent: The parent resource for the operation resource. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`.
func (r *ProjectsLocationsApisVersionsOperationsService) Create(parent string, googlecloudapihubv1apioperation *GoogleCloudApihubV1ApiOperation) *ProjectsLocationsApisVersionsOperationsCreateCall {
	c := &ProjectsLocationsApisVersionsOperationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1apioperation = googlecloudapihubv1apioperation
	return c
}

// ApiOperationId sets the optional parameter "apiOperationId": The ID to use
// for the operation resource, which will become the final component of the
// operation's resource name. This field is optional. * If provided, the same
// will be used. The service will throw an error if the specified id is already
// used by another operation resource in the API hub. * If not provided, a
// system generated id will be used. This value should be 4-500 characters,
// overall resource name which will be of format
// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operat
// ions/{operation}`, its length is limited to 700 characters, and valid
// characters are /a-z[0-9]-_/.
func (c *ProjectsLocationsApisVersionsOperationsCreateCall) ApiOperationId(apiOperationId string) *ProjectsLocationsApisVersionsOperationsCreateCall {
	c.urlParams_.Set("apiOperationId", apiOperationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsOperationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsOperationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsOperationsCreateCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsOperationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsOperationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsOperationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1apioperation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.operations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ApiOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsOperationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ApiOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ApiOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an operation in an API version and we can delete only the
// operations created via create API. If the operation was created by parsing
// the spec, then it can be deleted by editing or deleting the spec.
//
//   - name: The name of the operation resource to delete. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/oper
//     ations/{operation}`.
func (r *ProjectsLocationsApisVersionsOperationsService) Delete(name string) *ProjectsLocationsApisVersionsOperationsDeleteCall {
	c := &ProjectsLocationsApisVersionsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get details about a particular operation in API version.
//
//   - name: The name of the operation to retrieve. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/oper
//     ations/{operation}`.
func (r *ProjectsLocationsApisVersionsOperationsService) Get(name string) *ProjectsLocationsApisVersionsOperationsGetCall {
	c := &ProjectsLocationsApisVersionsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisVersionsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisVersionsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ApiOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ApiOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ApiOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsOperationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List operations in an API version.
//
//   - parent: The parent which owns this collection of operations i.e., the API
//     version. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`.
func (r *ProjectsLocationsApisVersionsOperationsService) List(parent string) *ProjectsLocationsApisVersionsOperationsListCall {
	c := &ProjectsLocationsApisVersionsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of ApiOperations. A filter expression consists of a field name, a
// comparison operator, and a value for filtering. The value must be a string
// or a boolean. The comparison operator must be one of: `<`, `>` or `=`.
// Filters are not case sensitive. The following fields in the `ApiOperation`
// are eligible for filtering: * `name` - The ApiOperation resource name.
// Allowed comparison operators: `=`. * `details.http_operation.path.path` -
// The http operation's complete path relative to server endpoint. Allowed
// comparison operators: `=`. * `details.http_operation.method` - The http
// operation method type. Allowed comparison operators: `=`. *
// `details.deprecated` - Indicates if the ApiOperation is deprecated. Allowed
// values are True / False indicating the deprycation status of the
// ApiOperation. Allowed comparison operators: `=`. * `create_time` - The time
// at which the ApiOperation was created. The value should be in the
// (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed comparison
// operators: `>` and `<`. *
// `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.id` - The allowed
// value id of the user defined enum attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-enum-id is a
// placeholder that can be replaced with any user defined enum attribute name.
// * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.display_name` - The
// allowed value display name of the user defined enum attribute associated
// with the Resource. Allowed comparison operator is `:`. Here
// user-defined-attribute-enum-display-name is a placeholder that can be
// replaced with any user defined enum attribute enum name. *
// `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.string_values.values` - The allowed
// value of the user defined string attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-string is a
// placeholder that can be replaced with any user defined string attribute
// name. * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.json_values.values` - The allowed value
// of the user defined JSON attribute associated with the Resource. Allowed
// comparison operator is `:`. Here user-defined-attribute-json is a
// placeholder that can be replaced with any user defined JSON attribute name.
// Expressions are combined with either `AND` logic operator or `OR` logical
// operator but not both of them together i.e. only one of the `AND` or `OR`
// operator can be used throughout the filter string and both the operators
// cannot be used together. No other logical operators are supported. At most
// three filter fields are allowed in the filter string and if provided more
// than that then `INVALID_ARGUMENT` error is returned by the API. Here are a
// few examples: * `details.deprecated = True` - The ApiOperation is
// deprecated. * `details.http_operation.method = GET AND create_time <
// \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\" - The
// method of the http operation of the ApiOperation is _GET_ and the spec was
// created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00
// UTC_. * `details.http_operation.method = GET OR
// details.http_operation.method = POST`. - The http operation of the method of
// ApiOperation is _GET_ or _POST_. * `details.deprecated = True AND
// attributes.projects/test-project-id/locations/test-location-id/
// attributes/17650f90-4a29-4971-b3c0-d5532da3764b.string_values.values: test`
// - The filter string specifies that the ApiOperation is deprecated and the
// value of the user defined attribute of type string is _test_.
func (c *ProjectsLocationsApisVersionsOperationsListCall) Filter(filter string) *ProjectsLocationsApisVersionsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// operations to return. The service may return fewer than this value. If
// unspecified, at most 50 operations will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsApisVersionsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsApisVersionsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListApiOperations` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters (except page_size)
// provided to `ListApiOperations` must match the call that provided the page
// token.
func (c *ProjectsLocationsApisVersionsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsApisVersionsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisVersionsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisVersionsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListApiOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListApiOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListApiOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsApisVersionsOperationsListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListApiOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsApisVersionsOperationsPatchCall struct {
	s                               *Service
	name                            string
	googlecloudapihubv1apioperation *GoogleCloudApihubV1ApiOperation
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Patch: Update an operation in an API version. The following fields in the
// ApiOperation resource can be updated: * details.description *
// details.documentation * details.http_operation.path *
// details.http_operation.method * details.deprecated * attributes The
// update_mask should be used to specify the fields being updated. An operation
// can be updated only if the operation was created via CreateApiOperation API.
// If the operation was created by parsing the spec, then it can be edited by
// updating the spec.
//
//   - name: Identifier. The name of the operation. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/oper
//     ations/{operation}`.
func (r *ProjectsLocationsApisVersionsOperationsService) Patch(name string, googlecloudapihubv1apioperation *GoogleCloudApihubV1ApiOperation) *ProjectsLocationsApisVersionsOperationsPatchCall {
	c := &ProjectsLocationsApisVersionsOperationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1apioperation = googlecloudapihubv1apioperation
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update.
func (c *ProjectsLocationsApisVersionsOperationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsApisVersionsOperationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsOperationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsOperationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsOperationsPatchCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsOperationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsOperationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsOperationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1apioperation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.operations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ApiOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsOperationsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ApiOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ApiOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.operations.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsSpecsCreateCall struct {
	s                       *Service
	parent                  string
	googlecloudapihubv1spec *GoogleCloudApihubV1Spec
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Create: Add a spec to an API version in the API hub. Multiple specs can be
// added to an API version. Note, while adding a spec, at least one of
// `contents` or `source_uri` must be provided. If `contents` is provided, then
// `spec_type` must also be provided. On adding a spec with contents to the
// version, the operations present in it will be added to the version.Note that
// the file contents in the spec should be of the same type as defined in the
// `projects/{project}/locations/{location}/attributes/system-spec-type`
// attribute associated with spec resource. Note that specs of various types
// can be uploaded, however parsing of details is supported for OpenAPI spec
// currently. In order to access the information parsed from the spec, use the
// GetSpec method. In order to access the raw contents for a particular spec,
// use the GetSpecContents method. In order to access the operations parsed
// from the spec, use the ListAPIOperations method.
//
//   - parent: The parent resource for Spec. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`.
func (r *ProjectsLocationsApisVersionsSpecsService) Create(parent string, googlecloudapihubv1spec *GoogleCloudApihubV1Spec) *ProjectsLocationsApisVersionsSpecsCreateCall {
	c := &ProjectsLocationsApisVersionsSpecsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1spec = googlecloudapihubv1spec
	return c
}

// SpecId sets the optional parameter "specId": The ID to use for the spec,
// which will become the final component of the spec's resource name. This
// field is optional. * If provided, the same will be used. The service will
// throw an error if the specified id is already used by another spec in the
// API resource. * If not provided, a system generated id will be used. This
// value should be 4-500 characters, overall resource name which will be of
// format
// `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/
// {spec}`, its length is limited to 1000 characters and valid characters are
// /a-z[0-9]-_/.
func (c *ProjectsLocationsApisVersionsSpecsCreateCall) SpecId(specId string) *ProjectsLocationsApisVersionsSpecsCreateCall {
	c.urlParams_.Set("specId", specId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsSpecsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsSpecsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsSpecsCreateCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsSpecsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsSpecsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsSpecsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1spec)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/specs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.specs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Spec.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsSpecsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Spec, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Spec{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsSpecsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a spec. Deleting a spec will also delete the associated
// operations from the version.
//
//   - name: The name of the spec to delete. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/spec
//     s/{spec}`.
func (r *ProjectsLocationsApisVersionsSpecsService) Delete(name string) *ProjectsLocationsApisVersionsSpecsDeleteCall {
	c := &ProjectsLocationsApisVersionsSpecsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsSpecsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsSpecsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsSpecsDeleteCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsSpecsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsSpecsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsSpecsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.specs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsSpecsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsSpecsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get details about the information parsed from a spec. Note that this
// method does not return the raw spec contents. Use GetSpecContents method to
// retrieve the same.
//
//   - name: The name of the spec to retrieve. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/spec
//     s/{spec}`.
func (r *ProjectsLocationsApisVersionsSpecsService) Get(name string) *ProjectsLocationsApisVersionsSpecsGetCall {
	c := &ProjectsLocationsApisVersionsSpecsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsSpecsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsSpecsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisVersionsSpecsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisVersionsSpecsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsSpecsGetCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsSpecsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsSpecsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsSpecsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.specs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Spec.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsSpecsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Spec, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Spec{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsSpecsGetContentsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetContents: Get spec contents.
//
//   - name: The name of the spec whose contents need to be retrieved. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/spec
//     s/{spec}`.
func (r *ProjectsLocationsApisVersionsSpecsService) GetContents(name string) *ProjectsLocationsApisVersionsSpecsGetContentsCall {
	c := &ProjectsLocationsApisVersionsSpecsGetContentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsSpecsGetContentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsSpecsGetContentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisVersionsSpecsGetContentsCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisVersionsSpecsGetContentsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsSpecsGetContentsCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsSpecsGetContentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsSpecsGetContentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsSpecsGetContentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:contents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.getContents", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.specs.getContents" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1SpecContents.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsSpecsGetContentsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1SpecContents, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1SpecContents{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.getContents", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsSpecsLintCall struct {
	s                                  *Service
	name                               string
	googlecloudapihubv1lintspecrequest *GoogleCloudApihubV1LintSpecRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Lint: Lints the requested spec and updates the corresponding API Spec with
// the lint response. This lint response will be available in all subsequent
// Get and List Spec calls to Core service.
//
//   - name: The name of the spec to be linted. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/spec
//     s/{spec}`.
func (r *ProjectsLocationsApisVersionsSpecsService) Lint(name string, googlecloudapihubv1lintspecrequest *GoogleCloudApihubV1LintSpecRequest) *ProjectsLocationsApisVersionsSpecsLintCall {
	c := &ProjectsLocationsApisVersionsSpecsLintCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1lintspecrequest = googlecloudapihubv1lintspecrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsSpecsLintCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsSpecsLintCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsSpecsLintCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsSpecsLintCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsSpecsLintCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsSpecsLintCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1lintspecrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:lint")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.lint", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.specs.lint" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsSpecsLintCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.lint", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsApisVersionsSpecsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List specs corresponding to a particular API resource.
//
//   - parent: The parent, which owns this collection of specs. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}`.
func (r *ProjectsLocationsApisVersionsSpecsService) List(parent string) *ProjectsLocationsApisVersionsSpecsListCall {
	c := &ProjectsLocationsApisVersionsSpecsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of Specs. A filter expression consists of a field name, a comparison
// operator, and a value for filtering. The value must be a string. The
// comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are not
// case sensitive. The following fields in the `Spec` are eligible for
// filtering: * `display_name` - The display name of the Spec. Allowed
// comparison operators: `=`. * `create_time` - The time at which the Spec was
// created. The value should be in the
// (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed comparison
// operators: `>` and `<`. * `spec_type.enum_values.values.id` - The allowed
// value id of the spec_type attribute associated with the Spec. Allowed
// comparison operators: `:`. * `spec_type.enum_values.values.display_name` -
// The allowed value display name of the spec_type attribute associated with
// the Spec. Allowed comparison operators: `:`. *
// `lint_response.json_values.values` - The json value of the lint_response
// attribute associated with the Spec. Allowed comparison operators: `:`. *
// `mime_type` - The MIME type of the Spec. Allowed comparison operators: `=`.
// * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.id` - The allowed
// value id of the user defined enum attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-enum-id is a
// placeholder that can be replaced with any user defined enum attribute name.
// * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.display_name` - The
// allowed value display name of the user defined enum attribute associated
// with the Resource. Allowed comparison operator is `:`. Here
// user-defined-attribute-enum-display-name is a placeholder that can be
// replaced with any user defined enum attribute enum name. *
// `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.string_values.values` - The allowed
// value of the user defined string attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-string is a
// placeholder that can be replaced with any user defined string attribute
// name. * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.json_values.values` - The allowed value
// of the user defined JSON attribute associated with the Resource. Allowed
// comparison operator is `:`. Here user-defined-attribute-json is a
// placeholder that can be replaced with any user defined JSON attribute name.
// Expressions are combined with either `AND` logic operator or `OR` logical
// operator but not both of them together i.e. only one of the `AND` or `OR`
// operator can be used throughout the filter string and both the operators
// cannot be used together. No other logical operators are supported. At most
// three filter fields are allowed in the filter string and if provided more
// than that then `INVALID_ARGUMENT` error is returned by the API. Here are a
// few examples: * `spec_type.enum_values.values.id: rest-id` - The filter
// string specifies that the id of the allowed value associated with the
// spec_type attribute is _rest-id_. *
// `spec_type.enum_values.values.display_name: \"Rest Display Name\" - The
// filter string specifies that the display name of the allowed value
// associated with the spec_type attribute is `Rest Display Name`. *
// `spec_type.enum_values.values.id: grpc-id AND create_time <
// \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\" - The
// id of the allowed value associated with the spec_type attribute is _grpc-id_
// and the spec was created before _2021-08-15 14:50:00 UTC_ and after
// _2021-08-10 12:00:00 UTC_. * `spec_type.enum_values.values.id: rest-id OR
// spec_type.enum_values.values.id: grpc-id` - The id of the allowed value
// associated with the spec_type attribute is _rest-id_ or _grpc-id_. *
// `spec_type.enum_values.values.id: rest-id AND
// attributes.projects/test-project-id/locations/test-location-id/
// attributes/17650f90-4a29-4971-b3c0-d5532da3764b.enum_values.values.id: test`
// - The filter string specifies that the id of the allowed value associated
// with the spec_type attribute is _rest-id_ and the id of the allowed value
// associated with the user defined attribute of type enum is _test_.
func (c *ProjectsLocationsApisVersionsSpecsListCall) Filter(filter string) *ProjectsLocationsApisVersionsSpecsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of specs
// to return. The service may return fewer than this value. If unspecified, at
// most 50 specs will be returned. The maximum value is 1000; values above 1000
// will be coerced to 1000.
func (c *ProjectsLocationsApisVersionsSpecsListCall) PageSize(pageSize int64) *ProjectsLocationsApisVersionsSpecsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListSpecs` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListSpecs` must
// match the call that provided the page token.
func (c *ProjectsLocationsApisVersionsSpecsListCall) PageToken(pageToken string) *ProjectsLocationsApisVersionsSpecsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsSpecsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsSpecsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsApisVersionsSpecsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsApisVersionsSpecsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsSpecsListCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsSpecsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsSpecsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsSpecsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/specs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.specs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListSpecsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsSpecsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListSpecsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListSpecsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsApisVersionsSpecsListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListSpecsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsApisVersionsSpecsPatchCall struct {
	s                       *Service
	name                    string
	googlecloudapihubv1spec *GoogleCloudApihubV1Spec
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Patch: Update spec. The following fields in the spec can be updated: *
// display_name * source_uri * lint_response * attributes * contents *
// spec_type In case of an OAS spec, updating spec contents can lead to: 1.
// Creation, deletion and update of operations. 2. Creation, deletion and
// update of definitions. 3. Update of other info parsed out from the new spec.
// In case of contents or source_uri being present in update mask, spec_type
// must also be present. Also, spec_type can not be present in update mask if
// contents or source_uri is not present. The update_mask should be used to
// specify the fields being updated.
//
//   - name: Identifier. The name of the spec. Format:
//     `projects/{project}/locations/{location}/apis/{api}/versions/{version}/spec
//     s/{spec}`.
func (r *ProjectsLocationsApisVersionsSpecsService) Patch(name string, googlecloudapihubv1spec *GoogleCloudApihubV1Spec) *ProjectsLocationsApisVersionsSpecsPatchCall {
	c := &ProjectsLocationsApisVersionsSpecsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1spec = googlecloudapihubv1spec
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update.
func (c *ProjectsLocationsApisVersionsSpecsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsApisVersionsSpecsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsApisVersionsSpecsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsApisVersionsSpecsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsApisVersionsSpecsPatchCall) Context(ctx context.Context) *ProjectsLocationsApisVersionsSpecsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsApisVersionsSpecsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsApisVersionsSpecsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1spec)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.apis.versions.specs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Spec.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsApisVersionsSpecsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Spec, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Spec{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.apis.versions.specs.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAttributesCreateCall struct {
	s                            *Service
	parent                       string
	googlecloudapihubv1attribute *GoogleCloudApihubV1Attribute
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Create: Create a user defined attribute. Certain pre defined attributes are
// already created by the API hub. These attributes will have type as
// `SYSTEM_DEFINED` and can be listed via ListAttributes method. Allowed values
// for the same can be updated via UpdateAttribute method.
//
//   - parent: The parent resource for Attribute. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsAttributesService) Create(parent string, googlecloudapihubv1attribute *GoogleCloudApihubV1Attribute) *ProjectsLocationsAttributesCreateCall {
	c := &ProjectsLocationsAttributesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1attribute = googlecloudapihubv1attribute
	return c
}

// AttributeId sets the optional parameter "attributeId": The ID to use for the
// attribute, which will become the final component of the attribute's resource
// name. This field is optional. * If provided, the same will be used. The
// service will throw an error if the specified id is already used by another
// attribute resource in the API hub. * If not provided, a system generated id
// will be used. This value should be 4-500 characters, and valid characters
// are /a-z[0-9]-_/.
func (c *ProjectsLocationsAttributesCreateCall) AttributeId(attributeId string) *ProjectsLocationsAttributesCreateCall {
	c.urlParams_.Set("attributeId", attributeId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAttributesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAttributesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAttributesCreateCall) Context(ctx context.Context) *ProjectsLocationsAttributesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAttributesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAttributesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1attribute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/attributes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.attributes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Attribute.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAttributesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Attribute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Attribute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAttributesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an attribute. Note: System defined attributes cannot be
// deleted. All associations of the attribute being deleted with any API hub
// resource will also get deleted.
//
//   - name: The name of the attribute to delete. Format:
//     `projects/{project}/locations/{location}/attributes/{attribute}`.
func (r *ProjectsLocationsAttributesService) Delete(name string) *ProjectsLocationsAttributesDeleteCall {
	c := &ProjectsLocationsAttributesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAttributesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAttributesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAttributesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAttributesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAttributesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAttributesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.attributes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAttributesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAttributesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get details about the attribute.
//
//   - name: The name of the attribute to retrieve. Format:
//     `projects/{project}/locations/{location}/attributes/{attribute}`.
func (r *ProjectsLocationsAttributesService) Get(name string) *ProjectsLocationsAttributesGetCall {
	c := &ProjectsLocationsAttributesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAttributesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAttributesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAttributesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAttributesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAttributesGetCall) Context(ctx context.Context) *ProjectsLocationsAttributesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAttributesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAttributesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.attributes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Attribute.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAttributesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Attribute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Attribute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAttributesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List all attributes.
//
//   - parent: The parent resource for Attribute. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsAttributesService) List(parent string) *ProjectsLocationsAttributesListCall {
	c := &ProjectsLocationsAttributesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of Attributes. A filter expression consists of a field name, a
// comparison operator, and a value for filtering. The value must be a string
// or a boolean. The comparison operator must be one of: `<`, `>` or `=`.
// Filters are not case sensitive. The following fields in the `Attribute` are
// eligible for filtering: * `display_name` - The display name of the
// Attribute. Allowed comparison operators: `=`. * `definition_type` - The
// definition type of the attribute. Allowed comparison operators: `=`. *
// `scope` - The scope of the attribute. Allowed comparison operators: `=`. *
// `data_type` - The type of the data of the attribute. Allowed comparison
// operators: `=`. * `mandatory` - Denotes whether the attribute is mandatory
// or not. Allowed comparison operators: `=`. * `create_time` - The time at
// which the Attribute was created. The value should be in the
// (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed comparison
// operators: `>` and `<`. Expressions are combined with either `AND` logic
// operator or `OR` logical operator but not both of them together i.e. only
// one of the `AND` or `OR` operator can be used throughout the filter string
// and both the operators cannot be used together. No other logical operators
// are supported. At most three filter fields are allowed in the filter string
// and if provided more than that then `INVALID_ARGUMENT` error is returned by
// the API. Here are a few examples: * `display_name = production` - - The
// display name of the attribute is _production_. * `(display_name =
// production) AND (create_time < \"2021-08-15T14:50:00Z\") AND (create_time >
// \"2021-08-10T12:00:00Z\")` - The display name of the attribute is
// _production_ and the attribute was created before _2021-08-15 14:50:00 UTC_
// and after _2021-08-10 12:00:00 UTC_. * `display_name = production OR scope =
// api` - The attribute where the display name is _production_ or the scope is
// _api_.
func (c *ProjectsLocationsAttributesListCall) Filter(filter string) *ProjectsLocationsAttributesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// attribute resources to return. The service may return fewer than this value.
// If unspecified, at most 50 attributes will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsAttributesListCall) PageSize(pageSize int64) *ProjectsLocationsAttributesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListAttributes` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListAttributes` must match the call that provided the page token.
func (c *ProjectsLocationsAttributesListCall) PageToken(pageToken string) *ProjectsLocationsAttributesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAttributesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAttributesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAttributesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAttributesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAttributesListCall) Context(ctx context.Context) *ProjectsLocationsAttributesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAttributesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAttributesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/attributes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.attributes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListAttributesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAttributesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListAttributesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListAttributesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAttributesListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListAttributesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAttributesPatchCall struct {
	s                            *Service
	name                         string
	googlecloudapihubv1attribute *GoogleCloudApihubV1Attribute
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Patch: Update the attribute. The following fields in the Attribute resource
// can be updated: * display_name The display name can be updated for user
// defined attributes only. * description The description can be updated for
// user defined attributes only. * allowed_values To update the list of allowed
// values, clients need to use the fetched list of allowed values and add or
// remove values to or from the same list. The mutable allowed values can be
// updated for both user defined and System defined attributes. The immutable
// allowed values cannot be updated or deleted. The updated list of allowed
// values cannot be empty. If an allowed value that is already used by some
// resource's attribute is deleted, then the association between the resource
// and the attribute value will also be deleted. * cardinality The cardinality
// can be updated for user defined attributes only. Cardinality can only be
// increased during an update. The update_mask should be used to specify the
// fields being updated.
//
//   - name: Identifier. The name of the attribute in the API Hub. Format:
//     `projects/{project}/locations/{location}/attributes/{attribute}`.
func (r *ProjectsLocationsAttributesService) Patch(name string, googlecloudapihubv1attribute *GoogleCloudApihubV1Attribute) *ProjectsLocationsAttributesPatchCall {
	c := &ProjectsLocationsAttributesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1attribute = googlecloudapihubv1attribute
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update.
func (c *ProjectsLocationsAttributesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAttributesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAttributesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAttributesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAttributesPatchCall) Context(ctx context.Context) *ProjectsLocationsAttributesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAttributesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAttributesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1attribute)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.attributes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Attribute.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAttributesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Attribute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Attribute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.attributes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCurationsCreateCall struct {
	s                           *Service
	parent                      string
	googlecloudapihubv1curation *GoogleCloudApihubV1Curation
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Create: Create a curation resource in the API hub. Once a curation resource
// is created, plugin instances can start using it.
//
//   - parent: The parent resource for the curation resource. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsCurationsService) Create(parent string, googlecloudapihubv1curation *GoogleCloudApihubV1Curation) *ProjectsLocationsCurationsCreateCall {
	c := &ProjectsLocationsCurationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1curation = googlecloudapihubv1curation
	return c
}

// CurationId sets the optional parameter "curationId": The ID to use for the
// curation resource, which will become the final component of the curations's
// resource name. This field is optional. * If provided, the same will be used.
// The service will throw an error if the specified ID is already used by
// another curation resource in the API hub. * If not provided, a system
// generated ID will be used. This value should be 4-500 characters, and valid
// characters are /a-z[0-9]-_/.
func (c *ProjectsLocationsCurationsCreateCall) CurationId(curationId string) *ProjectsLocationsCurationsCreateCall {
	c.urlParams_.Set("curationId", curationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCurationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCurationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCurationsCreateCall) Context(ctx context.Context) *ProjectsLocationsCurationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCurationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCurationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1curation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/curations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.curations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Curation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCurationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Curation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Curation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCurationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a curation resource in the API hub. A curation can only be
// deleted if it's not being used by any plugin instance.
//
//   - name: The name of the curation resource to delete. Format:
//     `projects/{project}/locations/{location}/curations/{curation}`.
func (r *ProjectsLocationsCurationsService) Delete(name string) *ProjectsLocationsCurationsDeleteCall {
	c := &ProjectsLocationsCurationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCurationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCurationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCurationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCurationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCurationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCurationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.curations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsCurationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCurationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get curation resource details.
//
//   - name: The name of the curation resource to retrieve. Format:
//     `projects/{project}/locations/{location}/curations/{curation}`.
func (r *ProjectsLocationsCurationsService) Get(name string) *ProjectsLocationsCurationsGetCall {
	c := &ProjectsLocationsCurationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCurationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCurationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCurationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCurationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCurationsGetCall) Context(ctx context.Context) *ProjectsLocationsCurationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCurationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCurationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.curations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Curation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCurationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Curation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Curation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsCurationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List curation resources in the API hub.
//
//   - parent: The parent, which owns this collection of curation resources.
//     Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsCurationsService) List(parent string) *ProjectsLocationsCurationsListCall {
	c := &ProjectsLocationsCurationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of curation resources. A filter expression consists of a field name, a
// comparison operator, and a value for filtering. The value must be a string.
// The comparison operator must be one of: `<`, `>`, `:` or `=`. Filters are
// case insensitive. The following fields in the `curation resource` are
// eligible for filtering: * `create_time` - The time at which the curation was
// created. The value should be in the
// (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed comparison
// operators: `>` and `<`. * `display_name` - The display name of the curation.
// Allowed comparison operators: `=`. * `state` - The state of the curation.
// Allowed comparison operators: `=`. Expressions are combined with either
// `AND` logic operator or `OR` logical operator but not both of them together
// i.e. only one of the `AND` or `OR` operator can be used throughout the
// filter string and both the operators cannot be used together. No other
// logical operators are supported. At most three filter fields are allowed in
// the filter string and if provided more than that then `INVALID_ARGUMENT`
// error is returned by the API. Here are a few examples: * `create_time <
// \"2021-08-15T14:50:00Z\" AND create_time > \"2021-08-10T12:00:00Z\" - The
// curation resource was created before _2021-08-15 14:50:00 UTC_ and after
// _2021-08-10 12:00:00 UTC_.
func (c *ProjectsLocationsCurationsListCall) Filter(filter string) *ProjectsLocationsCurationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// curation resources to return. The service may return fewer than this value.
// If unspecified, at most 50 curations will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsCurationsListCall) PageSize(pageSize int64) *ProjectsLocationsCurationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListCurations` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters (except page_size)
// provided to `ListCurations` must match the call that provided the page
// token.
func (c *ProjectsLocationsCurationsListCall) PageToken(pageToken string) *ProjectsLocationsCurationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCurationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCurationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsCurationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCurationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCurationsListCall) Context(ctx context.Context) *ProjectsLocationsCurationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCurationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCurationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/curations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.curations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListCurationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCurationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListCurationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListCurationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCurationsListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListCurationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsCurationsPatchCall struct {
	s                           *Service
	name                        string
	googlecloudapihubv1curation *GoogleCloudApihubV1Curation
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Patch: Update a curation resource in the API hub. The following fields in
// the curation can be updated: * display_name * description The update_mask
// should be used to specify the fields being updated.
//
//   - name: Identifier. The name of the curation. Format:
//     `projects/{project}/locations/{location}/curations/{curation}`.
func (r *ProjectsLocationsCurationsService) Patch(name string, googlecloudapihubv1curation *GoogleCloudApihubV1Curation) *ProjectsLocationsCurationsPatchCall {
	c := &ProjectsLocationsCurationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1curation = googlecloudapihubv1curation
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *ProjectsLocationsCurationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCurationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsCurationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCurationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsCurationsPatchCall) Context(ctx context.Context) *ProjectsLocationsCurationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsCurationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCurationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1curation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.curations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Curation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsCurationsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Curation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Curation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.curations.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDependenciesCreateCall struct {
	s                             *Service
	parent                        string
	googlecloudapihubv1dependency *GoogleCloudApihubV1Dependency
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Create: Create a dependency between two entities in the API hub.
//
//   - parent: The parent resource for the dependency resource. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsDependenciesService) Create(parent string, googlecloudapihubv1dependency *GoogleCloudApihubV1Dependency) *ProjectsLocationsDependenciesCreateCall {
	c := &ProjectsLocationsDependenciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1dependency = googlecloudapihubv1dependency
	return c
}

// DependencyId sets the optional parameter "dependencyId": The ID to use for
// the dependency resource, which will become the final component of the
// dependency's resource name. This field is optional. * If provided, the same
// will be used. The service will throw an error if duplicate id is provided by
// the client. * If not provided, a system generated id will be used. This
// value should be 4-500 characters, and valid characters are `a-z[0-9]-_`.
func (c *ProjectsLocationsDependenciesCreateCall) DependencyId(dependencyId string) *ProjectsLocationsDependenciesCreateCall {
	c.urlParams_.Set("dependencyId", dependencyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDependenciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDependenciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDependenciesCreateCall) Context(ctx context.Context) *ProjectsLocationsDependenciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDependenciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDependenciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1dependency)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dependencies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.dependencies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Dependency.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDependenciesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Dependency, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Dependency{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDependenciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete the dependency resource.
//
//   - name: The name of the dependency resource to delete. Format:
//     `projects/{project}/locations/{location}/dependencies/{dependency}`.
func (r *ProjectsLocationsDependenciesService) Delete(name string) *ProjectsLocationsDependenciesDeleteCall {
	c := &ProjectsLocationsDependenciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDependenciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDependenciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDependenciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDependenciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDependenciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDependenciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.dependencies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDependenciesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDependenciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get details about a dependency resource in the API hub.
//
//   - name: The name of the dependency resource to retrieve. Format:
//     `projects/{project}/locations/{location}/dependencies/{dependency}`.
func (r *ProjectsLocationsDependenciesService) Get(name string) *ProjectsLocationsDependenciesGetCall {
	c := &ProjectsLocationsDependenciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDependenciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDependenciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDependenciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDependenciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDependenciesGetCall) Context(ctx context.Context) *ProjectsLocationsDependenciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDependenciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDependenciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.dependencies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Dependency.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDependenciesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Dependency, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Dependency{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDependenciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List dependencies based on the provided filter and pagination
// parameters.
//
//   - parent: The parent which owns this collection of dependency resources.
//     Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsDependenciesService) List(parent string) *ProjectsLocationsDependenciesListCall {
	c := &ProjectsLocationsDependenciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of Dependencies. A filter expression consists of a field name, a
// comparison operator, and a value for filtering. The value must be a string.
// Allowed comparison operator is `=`. Filters are not case sensitive. The
// following fields in the `Dependency` are eligible for filtering: *
// `consumer.operation_resource_name` - The operation resource name for the
// consumer entity involved in a dependency. Allowed comparison operators: `=`.
// * `consumer.external_api_resource_name` - The external api resource name for
// the consumer entity involved in a dependency. Allowed comparison operators:
// `=`. * `supplier.operation_resource_name` - The operation resource name for
// the supplier entity involved in a dependency. Allowed comparison operators:
// `=`. * `supplier.external_api_resource_name` - The external api resource
// name for the supplier entity involved in a dependency. Allowed comparison
// operators: `=`. Expressions are combined with either `AND` logic operator or
// `OR` logical operator but not both of them together i.e. only one of the
// `AND` or `OR` operator can be used throughout the filter string and both the
// operators cannot be used together. No other logical operators are supported.
// At most three filter fields are allowed in the filter string and if provided
// more than that then `INVALID_ARGUMENT` error is returned by the API. For
// example, `consumer.operation_resource_name =
// \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\" OR
// supplier.operation_resource_name =
// \"projects/p1/locations/global/apis/a1/versions/v1/operations/o1\" - The
// dependencies with either consumer or supplier operation resource name as
// _projects/p1/locations/global/apis/a1/versions/v1/operations/o1_.
func (c *ProjectsLocationsDependenciesListCall) Filter(filter string) *ProjectsLocationsDependenciesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// dependency resources to return. The service may return fewer than this
// value. If unspecified, at most 50 dependencies will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsDependenciesListCall) PageSize(pageSize int64) *ProjectsLocationsDependenciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDependencies` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListDependencies` must match the call that provided the page token.
func (c *ProjectsLocationsDependenciesListCall) PageToken(pageToken string) *ProjectsLocationsDependenciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDependenciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDependenciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDependenciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDependenciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDependenciesListCall) Context(ctx context.Context) *ProjectsLocationsDependenciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDependenciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDependenciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dependencies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.dependencies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListDependenciesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDependenciesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListDependenciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListDependenciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDependenciesListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListDependenciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDependenciesPatchCall struct {
	s                             *Service
	name                          string
	googlecloudapihubv1dependency *GoogleCloudApihubV1Dependency
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Patch: Update a dependency based on the update_mask provided in the request.
// The following fields in the dependency can be updated: * description
//
//   - name: Identifier. The name of the dependency in the API Hub. Format:
//     `projects/{project}/locations/{location}/dependencies/{dependency}`.
func (r *ProjectsLocationsDependenciesService) Patch(name string, googlecloudapihubv1dependency *GoogleCloudApihubV1Dependency) *ProjectsLocationsDependenciesPatchCall {
	c := &ProjectsLocationsDependenciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1dependency = googlecloudapihubv1dependency
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update.
func (c *ProjectsLocationsDependenciesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDependenciesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDependenciesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDependenciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDependenciesPatchCall) Context(ctx context.Context) *ProjectsLocationsDependenciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDependenciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDependenciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1dependency)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.dependencies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Dependency.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDependenciesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Dependency, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Dependency{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.dependencies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDeploymentsCreateCall struct {
	s                             *Service
	parent                        string
	googlecloudapihubv1deployment *GoogleCloudApihubV1Deployment
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Create: Create a deployment resource in the API hub. Once a deployment
// resource is created, it can be associated with API versions.
//
//   - parent: The parent resource for the deployment resource. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsDeploymentsService) Create(parent string, googlecloudapihubv1deployment *GoogleCloudApihubV1Deployment) *ProjectsLocationsDeploymentsCreateCall {
	c := &ProjectsLocationsDeploymentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1deployment = googlecloudapihubv1deployment
	return c
}

// DeploymentId sets the optional parameter "deploymentId": The ID to use for
// the deployment resource, which will become the final component of the
// deployment's resource name. This field is optional. * If provided, the same
// will be used. The service will throw an error if the specified id is already
// used by another deployment resource in the API hub. * If not provided, a
// system generated id will be used. This value should be 4-500 characters, and
// valid characters are /a-z[0-9]-_/.
func (c *ProjectsLocationsDeploymentsCreateCall) DeploymentId(deploymentId string) *ProjectsLocationsDeploymentsCreateCall {
	c.urlParams_.Set("deploymentId", deploymentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDeploymentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDeploymentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDeploymentsCreateCall) Context(ctx context.Context) *ProjectsLocationsDeploymentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDeploymentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDeploymentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1deployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/deployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.deployments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Deployment.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDeploymentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Deployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Deployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDeploymentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a deployment resource in the API hub.
//
//   - name: The name of the deployment resource to delete. Format:
//     `projects/{project}/locations/{location}/deployments/{deployment}`.
func (r *ProjectsLocationsDeploymentsService) Delete(name string) *ProjectsLocationsDeploymentsDeleteCall {
	c := &ProjectsLocationsDeploymentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDeploymentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDeploymentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDeploymentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDeploymentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDeploymentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDeploymentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.deployments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDeploymentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDeploymentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get details about a deployment and the API versions linked to it.
//
//   - name: The name of the deployment resource to retrieve. Format:
//     `projects/{project}/locations/{location}/deployments/{deployment}`.
func (r *ProjectsLocationsDeploymentsService) Get(name string) *ProjectsLocationsDeploymentsGetCall {
	c := &ProjectsLocationsDeploymentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDeploymentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDeploymentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDeploymentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDeploymentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDeploymentsGetCall) Context(ctx context.Context) *ProjectsLocationsDeploymentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDeploymentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDeploymentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.deployments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Deployment.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDeploymentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Deployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Deployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDeploymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List deployment resources in the API hub.
//
//   - parent: The parent, which owns this collection of deployment resources.
//     Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsDeploymentsService) List(parent string) *ProjectsLocationsDeploymentsListCall {
	c := &ProjectsLocationsDeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of Deployments. A filter expression consists of a field name, a
// comparison operator, and a value for filtering. The value must be a string.
// The comparison operator must be one of: `<`, `>` or `=`. Filters are not
// case sensitive. The following fields in the `Deployments` are eligible for
// filtering: * `display_name` - The display name of the Deployment. Allowed
// comparison operators: `=`. * `create_time` - The time at which the
// Deployment was created. The value should be in the
// (RFC3339)[https://tools.ietf.org/html/rfc3339] format. Allowed comparison
// operators: `>` and `<`. * `resource_uri` - A URI to the deployment resource.
// Allowed comparison operators: `=`. * `api_versions` - The API versions
// linked to this deployment. Allowed comparison operators: `:`. *
// `deployment_type.enum_values.values.id` - The allowed value id of the
// deployment_type attribute associated with the Deployment. Allowed comparison
// operators: `:`. * `deployment_type.enum_values.values.display_name` - The
// allowed value display name of the deployment_type attribute associated with
// the Deployment. Allowed comparison operators: `:`. *
// `slo.string_values.values` -The allowed string value of the slo attribute
// associated with the deployment. Allowed comparison operators: `:`. *
// `environment.enum_values.values.id` - The allowed value id of the
// environment attribute associated with the deployment. Allowed comparison
// operators: `:`. * `environment.enum_values.values.display_name` - The
// allowed value display name of the environment attribute associated with the
// deployment. Allowed comparison operators: `:`. *
// `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.id` - The allowed
// value id of the user defined enum attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-enum-id is a
// placeholder that can be replaced with any user defined enum attribute name.
// * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.enum_values.values.display_name` - The
// allowed value display name of the user defined enum attribute associated
// with the Resource. Allowed comparison operator is `:`. Here
// user-defined-attribute-enum-display-name is a placeholder that can be
// replaced with any user defined enum attribute enum name. *
// `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.string_values.values` - The allowed
// value of the user defined string attribute associated with the Resource.
// Allowed comparison operator is `:`. Here user-defined-attribute-string is a
// placeholder that can be replaced with any user defined string attribute
// name. * `attributes.projects/test-project-id/locations/test-location-id/
// attributes/user-defined-attribute-id.json_values.values` - The allowed value
// of the user defined JSON attribute associated with the Resource. Allowed
// comparison operator is `:`. Here user-defined-attribute-json is a
// placeholder that can be replaced with any user defined JSON attribute name.
// A filter function is also supported in the filter string. The filter
// function is `id(name)`. The `id(name)` function returns the id of the
// resource name. For example, `id(name) = \"deployment-1\" is equivalent to
// `name =
// \"projects/test-project-id/locations/test-location-id/deployments/deployment-
// 1\" provided the parent is
// `projects/test-project-id/locations/test-location-id`. Expressions are
// combined with either `AND` logic operator or `OR` logical operator but not
// both of them together i.e. only one of the `AND` or `OR` operator can be
// used throughout the filter string and both the operators cannot be used
// together. No other logical operators are supported. At most three filter
// fields are allowed in the filter string and if provided more than that then
// `INVALID_ARGUMENT` error is returned by the API. Here are a few examples: *
// `environment.enum_values.values.id: staging-id` - The allowed value id of
// the environment attribute associated with the Deployment is _staging-id_. *
// `environment.enum_values.values.display_name: \"Staging Deployment\" - The
// allowed value display name of the environment attribute associated with the
// Deployment is `Staging Deployment`. * `environment.enum_values.values.id:
// production-id AND create_time < \"2021-08-15T14:50:00Z\" AND create_time >
// \"2021-08-10T12:00:00Z\" - The allowed value id of the environment
// attribute associated with the Deployment is _production-id_ and Deployment
// was created before _2021-08-15 14:50:00 UTC_ and after _2021-08-10 12:00:00
// UTC_. * `environment.enum_values.values.id: production-id OR
// slo.string_values.values: \"99.99%\" - The allowed value id of the
// environment attribute Deployment is _production-id_ or string value of the
// slo attribute is _99.99%_. * `environment.enum_values.values.id: staging-id
// AND attributes.projects/test-project-id/locations/test-location-id/
// attributes/17650f90-4a29-4971-b3c0-d5532da3764b.string_values.values: test`
// - The filter string specifies that the allowed value id of the environment
// attribute associated with the Deployment is _staging-id_ and the value of
// the user defined attribute of type string is _test_.
func (c *ProjectsLocationsDeploymentsListCall) Filter(filter string) *ProjectsLocationsDeploymentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// deployment resources to return. The service may return fewer than this
// value. If unspecified, at most 50 deployments will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsDeploymentsListCall) PageSize(pageSize int64) *ProjectsLocationsDeploymentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListDeployments` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters (except page_size)
// provided to `ListDeployments` must match the call that provided the page
// token.
func (c *ProjectsLocationsDeploymentsListCall) PageToken(pageToken string) *ProjectsLocationsDeploymentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDeploymentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDeploymentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDeploymentsListCall) Context(ctx context.Context) *ProjectsLocationsDeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/deployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.deployments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListDeploymentsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDeploymentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListDeploymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListDeploymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDeploymentsListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListDeploymentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDeploymentsPatchCall struct {
	s                             *Service
	name                          string
	googlecloudapihubv1deployment *GoogleCloudApihubV1Deployment
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Patch: Update a deployment resource in the API hub. The following fields in
// the deployment resource can be updated: * display_name * description *
// documentation * deployment_type * resource_uri * endpoints * slo *
// environment * attributes * source_project * source_environment *
// management_url * source_uri The update_mask should be used to specify the
// fields being updated.
//
//   - name: Identifier. The name of the deployment. Format:
//     `projects/{project}/locations/{location}/deployments/{deployment}`.
func (r *ProjectsLocationsDeploymentsService) Patch(name string, googlecloudapihubv1deployment *GoogleCloudApihubV1Deployment) *ProjectsLocationsDeploymentsPatchCall {
	c := &ProjectsLocationsDeploymentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1deployment = googlecloudapihubv1deployment
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update.
func (c *ProjectsLocationsDeploymentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDeploymentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDeploymentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDeploymentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDeploymentsPatchCall) Context(ctx context.Context) *ProjectsLocationsDeploymentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDeploymentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDeploymentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1deployment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.deployments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Deployment.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDeploymentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Deployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Deployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.deployments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExternalApisCreateCall struct {
	s                              *Service
	parent                         string
	googlecloudapihubv1externalapi *GoogleCloudApihubV1ExternalApi
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Create: Create an External API resource in the API hub.
//
//   - parent: The parent resource for the External API resource. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsExternalApisService) Create(parent string, googlecloudapihubv1externalapi *GoogleCloudApihubV1ExternalApi) *ProjectsLocationsExternalApisCreateCall {
	c := &ProjectsLocationsExternalApisCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1externalapi = googlecloudapihubv1externalapi
	return c
}

// ExternalApiId sets the optional parameter "externalApiId": The ID to use for
// the External API resource, which will become the final component of the
// External API's resource name. This field is optional. * If provided, the
// same will be used. The service will throw an error if the specified id is
// already used by another External API resource in the API hub. * If not
// provided, a system generated id will be used. This value should be 4-500
// characters, and valid characters are /a-z[0-9]-_/.
func (c *ProjectsLocationsExternalApisCreateCall) ExternalApiId(externalApiId string) *ProjectsLocationsExternalApisCreateCall {
	c.urlParams_.Set("externalApiId", externalApiId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExternalApisCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsExternalApisCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExternalApisCreateCall) Context(ctx context.Context) *ProjectsLocationsExternalApisCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExternalApisCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExternalApisCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1externalapi)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/externalApis")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.externalApis.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ExternalApi.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExternalApisCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ExternalApi, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ExternalApi{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExternalApisDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an External API resource in the API hub.
//
//   - name: The name of the External API resource to delete. Format:
//     `projects/{project}/locations/{location}/externalApis/{externalApi}`.
func (r *ProjectsLocationsExternalApisService) Delete(name string) *ProjectsLocationsExternalApisDeleteCall {
	c := &ProjectsLocationsExternalApisDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExternalApisDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsExternalApisDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExternalApisDeleteCall) Context(ctx context.Context) *ProjectsLocationsExternalApisDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExternalApisDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExternalApisDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.externalApis.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsExternalApisDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExternalApisGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get details about an External API resource in the API hub.
//
//   - name: The name of the External API resource to retrieve. Format:
//     `projects/{project}/locations/{location}/externalApis/{externalApi}`.
func (r *ProjectsLocationsExternalApisService) Get(name string) *ProjectsLocationsExternalApisGetCall {
	c := &ProjectsLocationsExternalApisGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExternalApisGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsExternalApisGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExternalApisGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsExternalApisGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExternalApisGetCall) Context(ctx context.Context) *ProjectsLocationsExternalApisGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExternalApisGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExternalApisGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.externalApis.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ExternalApi.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExternalApisGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ExternalApi, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ExternalApi{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExternalApisListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List External API resources in the API hub.
//
//   - parent: The parent, which owns this collection of External API resources.
//     Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsExternalApisService) List(parent string) *ProjectsLocationsExternalApisListCall {
	c := &ProjectsLocationsExternalApisListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// External API resources to return. The service may return fewer than this
// value. If unspecified, at most 50 ExternalApis will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsExternalApisListCall) PageSize(pageSize int64) *ProjectsLocationsExternalApisListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListExternalApis` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters (except page_size)
// provided to `ListExternalApis` must match the call that provided the page
// token.
func (c *ProjectsLocationsExternalApisListCall) PageToken(pageToken string) *ProjectsLocationsExternalApisListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExternalApisListCall) Fields(s ...googleapi.Field) *ProjectsLocationsExternalApisListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExternalApisListCall) IfNoneMatch(entityTag string) *ProjectsLocationsExternalApisListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExternalApisListCall) Context(ctx context.Context) *ProjectsLocationsExternalApisListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExternalApisListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExternalApisListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/externalApis")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.externalApis.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListExternalApisResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExternalApisListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListExternalApisResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListExternalApisResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsExternalApisListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListExternalApisResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsExternalApisPatchCall struct {
	s                              *Service
	name                           string
	googlecloudapihubv1externalapi *GoogleCloudApihubV1ExternalApi
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Patch: Update an External API resource in the API hub. The following fields
// can be updated: * display_name * description * documentation * endpoints *
// paths The update_mask should be used to specify the fields being updated.
//
//   - name: Identifier. Format:
//     `projects/{project}/locations/{location}/externalApi/{externalApi}`.
func (r *ProjectsLocationsExternalApisService) Patch(name string, googlecloudapihubv1externalapi *GoogleCloudApihubV1ExternalApi) *ProjectsLocationsExternalApisPatchCall {
	c := &ProjectsLocationsExternalApisPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1externalapi = googlecloudapihubv1externalapi
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to update.
func (c *ProjectsLocationsExternalApisPatchCall) UpdateMask(updateMask string) *ProjectsLocationsExternalApisPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExternalApisPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsExternalApisPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExternalApisPatchCall) Context(ctx context.Context) *ProjectsLocationsExternalApisPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExternalApisPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExternalApisPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1externalapi)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.externalApis.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ExternalApi.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExternalApisPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ExternalApi, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ExternalApi{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.externalApis.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsHostProjectRegistrationsCreateCall struct {
	s                                          *Service
	parent                                     string
	googlecloudapihubv1hostprojectregistration *GoogleCloudApihubV1HostProjectRegistration
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Create a host project registration. A Google cloud project can be
// registered as a host project if it is not attached as a runtime project to
// another host project. A project can be registered as a host project only
// once. Subsequent register calls for the same project will fail.
//
//   - parent: The parent resource for the host project. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsHostProjectRegistrationsService) Create(parent string, googlecloudapihubv1hostprojectregistration *GoogleCloudApihubV1HostProjectRegistration) *ProjectsLocationsHostProjectRegistrationsCreateCall {
	c := &ProjectsLocationsHostProjectRegistrationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1hostprojectregistration = googlecloudapihubv1hostprojectregistration
	return c
}

// HostProjectRegistrationId sets the optional parameter
// "hostProjectRegistrationId": Required. The ID to use for the Host Project
// Registration, which will become the final component of the host project
// registration's resource name. The ID must be the same as the Google cloud
// project specified in the host_project_registration.gcp_project field.
func (c *ProjectsLocationsHostProjectRegistrationsCreateCall) HostProjectRegistrationId(hostProjectRegistrationId string) *ProjectsLocationsHostProjectRegistrationsCreateCall {
	c.urlParams_.Set("hostProjectRegistrationId", hostProjectRegistrationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsHostProjectRegistrationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsHostProjectRegistrationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsHostProjectRegistrationsCreateCall) Context(ctx context.Context) *ProjectsLocationsHostProjectRegistrationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsHostProjectRegistrationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsHostProjectRegistrationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1hostprojectregistration)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/hostProjectRegistrations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.hostProjectRegistrations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.hostProjectRegistrations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1HostProjectRegistration.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsHostProjectRegistrationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1HostProjectRegistration, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1HostProjectRegistration{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.hostProjectRegistrations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsHostProjectRegistrationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a host project registration.
//
//   - name: Host project registration resource name.
//     projects/{project}/locations/{location}/hostProjectRegistrations/{host_proj
//     ect_registration_id}.
func (r *ProjectsLocationsHostProjectRegistrationsService) Get(name string) *ProjectsLocationsHostProjectRegistrationsGetCall {
	c := &ProjectsLocationsHostProjectRegistrationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsHostProjectRegistrationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsHostProjectRegistrationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsHostProjectRegistrationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsHostProjectRegistrationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsHostProjectRegistrationsGetCall) Context(ctx context.Context) *ProjectsLocationsHostProjectRegistrationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsHostProjectRegistrationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsHostProjectRegistrationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.hostProjectRegistrations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.hostProjectRegistrations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1HostProjectRegistration.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsHostProjectRegistrationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1HostProjectRegistration, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1HostProjectRegistration{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.hostProjectRegistrations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsHostProjectRegistrationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists host project registrations.
//
//   - parent: The parent, which owns this collection of host projects. Format:
//     `projects/*/locations/*`.
func (r *ProjectsLocationsHostProjectRegistrationsService) List(parent string) *ProjectsLocationsHostProjectRegistrationsListCall {
	c := &ProjectsLocationsHostProjectRegistrationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of HostProjectRegistrations. A filter expression consists of a field
// name, a comparison operator, and a value for filtering. The value must be a
// string. All standard operators as documented at https://google.aip.dev/160
// are supported. The following fields in the `HostProjectRegistration` are
// eligible for filtering: * `name` - The name of the HostProjectRegistration.
// * `create_time` - The time at which the HostProjectRegistration was created.
// The value should be in the (RFC3339)[https://tools.ietf.org/html/rfc3339]
// format. * `gcp_project` - The Google cloud project associated with the
// HostProjectRegistration.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) Filter(filter string) *ProjectsLocationsHostProjectRegistrationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) OrderBy(orderBy string) *ProjectsLocationsHostProjectRegistrationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of host
// project registrations to return. The service may return fewer than this
// value. If unspecified, at most 50 host project registrations will be
// returned. The maximum value is 1000; values above 1000 will be coerced to
// 1000.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) PageSize(pageSize int64) *ProjectsLocationsHostProjectRegistrationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListHostProjectRegistrations` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters (except
// page_size) provided to `ListHostProjectRegistrations` must match the call
// that provided the page token.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) PageToken(pageToken string) *ProjectsLocationsHostProjectRegistrationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsHostProjectRegistrationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsHostProjectRegistrationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) Context(ctx context.Context) *ProjectsLocationsHostProjectRegistrationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsHostProjectRegistrationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/hostProjectRegistrations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.hostProjectRegistrations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.hostProjectRegistrations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListHostProjectRegistrationsResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListHostProjectRegistrationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListHostProjectRegistrationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.hostProjectRegistrations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsHostProjectRegistrationsListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListHostProjectRegistrationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsCancelCall struct {
	s                                       *Service
	name                                    string
	googlelongrunningcanceloperationrequest *GoogleLongrunningCancelOperationRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, googlelongrunningcanceloperationrequest *GoogleLongrunningCancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlelongrunningcanceloperationrequest = googlelongrunningcanceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlelongrunningcanceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsPluginsCreateCall struct {
	s                         *Service
	parent                    string
	googlecloudapihubv1plugin *GoogleCloudApihubV1Plugin
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Create: Create an API Hub plugin resource in the API hub. Once a plugin is
// created, it can be used to create plugin instances.
//
//   - parent: The parent resource where this plugin will be created. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsPluginsService) Create(parent string, googlecloudapihubv1plugin *GoogleCloudApihubV1Plugin) *ProjectsLocationsPluginsCreateCall {
	c := &ProjectsLocationsPluginsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1plugin = googlecloudapihubv1plugin
	return c
}

// PluginId sets the optional parameter "pluginId": The ID to use for the
// Plugin resource, which will become the final component of the Plugin's
// resource name. This field is optional. * If provided, the same will be used.
// The service will throw an error if the specified id is already used by
// another Plugin resource in the API hub instance. * If not provided, a system
// generated id will be used. This value should be 4-63 characters, overall
// resource name which will be of format
// `projects/{project}/locations/{location}/plugins/{plugin}`, its length is
// limited to 1000 characters and valid characters are /a-z[0-9]-_/.
func (c *ProjectsLocationsPluginsCreateCall) PluginId(pluginId string) *ProjectsLocationsPluginsCreateCall {
	c.urlParams_.Set("pluginId", pluginId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsCreateCall) Context(ctx context.Context) *ProjectsLocationsPluginsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1plugin)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/plugins")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Plugin.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Plugin, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Plugin{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a Plugin in API hub. Note, only user owned plugins can be
// deleted via this method.
//
//   - name: The name of the Plugin resource to delete. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}`.
func (r *ProjectsLocationsPluginsService) Delete(name string) *ProjectsLocationsPluginsDeleteCall {
	c := &ProjectsLocationsPluginsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsDeleteCall) Context(ctx context.Context) *ProjectsLocationsPluginsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsDisableCall struct {
	s                                       *Service
	name                                    string
	googlecloudapihubv1disablepluginrequest *GoogleCloudApihubV1DisablePluginRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Disable: Disables a plugin. The `state` of the plugin after disabling is
// `DISABLED`
//
//   - name: The name of the plugin to disable. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}`.
func (r *ProjectsLocationsPluginsService) Disable(name string, googlecloudapihubv1disablepluginrequest *GoogleCloudApihubV1DisablePluginRequest) *ProjectsLocationsPluginsDisableCall {
	c := &ProjectsLocationsPluginsDisableCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1disablepluginrequest = googlecloudapihubv1disablepluginrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsDisableCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsDisableCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsDisableCall) Context(ctx context.Context) *ProjectsLocationsPluginsDisableCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsDisableCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsDisableCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1disablepluginrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:disable")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.disable", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.disable" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Plugin.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsDisableCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Plugin, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Plugin{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.disable", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsEnableCall struct {
	s                                      *Service
	name                                   string
	googlecloudapihubv1enablepluginrequest *GoogleCloudApihubV1EnablePluginRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Enable: Enables a plugin. The `state` of the plugin after enabling is
// `ENABLED`
//
//   - name: The name of the plugin to enable. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}`.
func (r *ProjectsLocationsPluginsService) Enable(name string, googlecloudapihubv1enablepluginrequest *GoogleCloudApihubV1EnablePluginRequest) *ProjectsLocationsPluginsEnableCall {
	c := &ProjectsLocationsPluginsEnableCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1enablepluginrequest = googlecloudapihubv1enablepluginrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsEnableCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsEnableCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsEnableCall) Context(ctx context.Context) *ProjectsLocationsPluginsEnableCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsEnableCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsEnableCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1enablepluginrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:enable")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.enable", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.enable" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Plugin.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsEnableCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Plugin, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Plugin{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.enable", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get an API Hub plugin.
//
//   - name: The name of the plugin to retrieve. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}`.
func (r *ProjectsLocationsPluginsService) Get(name string) *ProjectsLocationsPluginsGetCall {
	c := &ProjectsLocationsPluginsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPluginsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPluginsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsGetCall) Context(ctx context.Context) *ProjectsLocationsPluginsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1Plugin.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1Plugin, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1Plugin{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsGetStyleGuideCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetStyleGuide: Get the style guide being used for linting.
//
//   - name: The name of the spec to retrieve. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`.
func (r *ProjectsLocationsPluginsService) GetStyleGuide(name string) *ProjectsLocationsPluginsGetStyleGuideCall {
	c := &ProjectsLocationsPluginsGetStyleGuideCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsGetStyleGuideCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsGetStyleGuideCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPluginsGetStyleGuideCall) IfNoneMatch(entityTag string) *ProjectsLocationsPluginsGetStyleGuideCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsGetStyleGuideCall) Context(ctx context.Context) *ProjectsLocationsPluginsGetStyleGuideCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsGetStyleGuideCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsGetStyleGuideCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.getStyleGuide", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.getStyleGuide" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1StyleGuide.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsGetStyleGuideCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1StyleGuide, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1StyleGuide{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.getStyleGuide", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List all the plugins in a given project and location.
//
//   - parent: The parent resource where this plugin will be created. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsPluginsService) List(parent string) *ProjectsLocationsPluginsListCall {
	c := &ProjectsLocationsPluginsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of plugins. A filter expression consists of a field name, a comparison
// operator, and a value for filtering. The value must be a string. The
// comparison operator must be one of: `<`, `>` or `=`. Filters are not case
// sensitive. The following fields in the `Plugins` are eligible for filtering:
// * `plugin_category` - The category of the Plugin. Allowed comparison
// operators: `=`. Expressions are combined with either `AND` logic operator or
// `OR` logical operator but not both of them together i.e. only one of the
// `AND` or `OR` operator can be used throughout the filter string and both the
// operators cannot be used together. No other logical operators are supported.
// At most three filter fields are allowed in the filter string and if provided
// more than that then `INVALID_ARGUMENT` error is returned by the API. Here
// are a few examples: * `plugin_category = ON_RAMP` - The plugin is of
// category on ramp.
func (c *ProjectsLocationsPluginsListCall) Filter(filter string) *ProjectsLocationsPluginsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of hub
// plugins to return. The service may return fewer than this value. If
// unspecified, at most 50 hub plugins will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsPluginsListCall) PageSize(pageSize int64) *ProjectsLocationsPluginsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListPlugins` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters (except page_size) provided to
// `ListPlugins` must match the call that provided the page token.
func (c *ProjectsLocationsPluginsListCall) PageToken(pageToken string) *ProjectsLocationsPluginsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPluginsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPluginsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsListCall) Context(ctx context.Context) *ProjectsLocationsPluginsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/plugins")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListPluginsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListPluginsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListPluginsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPluginsListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListPluginsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsPluginsUpdateStyleGuideCall struct {
	s                             *Service
	name                          string
	googlecloudapihubv1styleguide *GoogleCloudApihubV1StyleGuide
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// UpdateStyleGuide: Update the styleGuide to be used for liniting in by API
// hub.
//
//   - name: Identifier. The name of the style guide. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`.
func (r *ProjectsLocationsPluginsService) UpdateStyleGuide(name string, googlecloudapihubv1styleguide *GoogleCloudApihubV1StyleGuide) *ProjectsLocationsPluginsUpdateStyleGuideCall {
	c := &ProjectsLocationsPluginsUpdateStyleGuideCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1styleguide = googlecloudapihubv1styleguide
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *ProjectsLocationsPluginsUpdateStyleGuideCall) UpdateMask(updateMask string) *ProjectsLocationsPluginsUpdateStyleGuideCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsUpdateStyleGuideCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsUpdateStyleGuideCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsUpdateStyleGuideCall) Context(ctx context.Context) *ProjectsLocationsPluginsUpdateStyleGuideCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsUpdateStyleGuideCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsUpdateStyleGuideCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1styleguide)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.updateStyleGuide", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.updateStyleGuide" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1StyleGuide.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsUpdateStyleGuideCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1StyleGuide, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1StyleGuide{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.updateStyleGuide", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsInstancesCreateCall struct {
	s                                 *Service
	parent                            string
	googlecloudapihubv1plugininstance *GoogleCloudApihubV1PluginInstance
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Create: Creates a Plugin instance in the API hub.
//
//   - parent: The parent of the plugin instance resource. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}`.
func (r *ProjectsLocationsPluginsInstancesService) Create(parent string, googlecloudapihubv1plugininstance *GoogleCloudApihubV1PluginInstance) *ProjectsLocationsPluginsInstancesCreateCall {
	c := &ProjectsLocationsPluginsInstancesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1plugininstance = googlecloudapihubv1plugininstance
	return c
}

// PluginInstanceId sets the optional parameter "pluginInstanceId": The ID to
// use for the plugin instance, which will become the final component of the
// plugin instance's resource name. This field is optional. * If provided, the
// same will be used. The service will throw an error if the specified id is
// already used by another plugin instance in the plugin resource. * If not
// provided, a system generated id will be used. This value should be 4-63
// characters, and valid characters are /a-z[0-9]-_/.
func (c *ProjectsLocationsPluginsInstancesCreateCall) PluginInstanceId(pluginInstanceId string) *ProjectsLocationsPluginsInstancesCreateCall {
	c.urlParams_.Set("pluginInstanceId", pluginInstanceId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsInstancesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsInstancesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsInstancesCreateCall) Context(ctx context.Context) *ProjectsLocationsPluginsInstancesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsInstancesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsInstancesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1plugininstance)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/instances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.instances.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsInstancesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsInstancesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a plugin instance in the API hub.
//
//   - name: The name of the plugin instance to delete. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instan
//     ce}`.
func (r *ProjectsLocationsPluginsInstancesService) Delete(name string) *ProjectsLocationsPluginsInstancesDeleteCall {
	c := &ProjectsLocationsPluginsInstancesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsInstancesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsInstancesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsInstancesDeleteCall) Context(ctx context.Context) *ProjectsLocationsPluginsInstancesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsInstancesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsInstancesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.instances.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsInstancesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsInstancesDisableActionCall struct {
	s                                                     *Service
	name                                                  string
	googlecloudapihubv1disableplugininstanceactionrequest *GoogleCloudApihubV1DisablePluginInstanceActionRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// DisableAction: Disables a plugin instance in the API hub.
//
//   - name: The name of the plugin instance to disable. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instan
//     ce}`.
func (r *ProjectsLocationsPluginsInstancesService) DisableAction(name string, googlecloudapihubv1disableplugininstanceactionrequest *GoogleCloudApihubV1DisablePluginInstanceActionRequest) *ProjectsLocationsPluginsInstancesDisableActionCall {
	c := &ProjectsLocationsPluginsInstancesDisableActionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1disableplugininstanceactionrequest = googlecloudapihubv1disableplugininstanceactionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsInstancesDisableActionCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsInstancesDisableActionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsInstancesDisableActionCall) Context(ctx context.Context) *ProjectsLocationsPluginsInstancesDisableActionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsInstancesDisableActionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsInstancesDisableActionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1disableplugininstanceactionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:disableAction")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.disableAction", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.instances.disableAction" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsInstancesDisableActionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.disableAction", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsInstancesEnableActionCall struct {
	s                                                    *Service
	name                                                 string
	googlecloudapihubv1enableplugininstanceactionrequest *GoogleCloudApihubV1EnablePluginInstanceActionRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// EnableAction: Enables a plugin instance in the API hub.
//
//   - name: The name of the plugin instance to enable. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instan
//     ce}`.
func (r *ProjectsLocationsPluginsInstancesService) EnableAction(name string, googlecloudapihubv1enableplugininstanceactionrequest *GoogleCloudApihubV1EnablePluginInstanceActionRequest) *ProjectsLocationsPluginsInstancesEnableActionCall {
	c := &ProjectsLocationsPluginsInstancesEnableActionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1enableplugininstanceactionrequest = googlecloudapihubv1enableplugininstanceactionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsInstancesEnableActionCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsInstancesEnableActionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsInstancesEnableActionCall) Context(ctx context.Context) *ProjectsLocationsPluginsInstancesEnableActionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsInstancesEnableActionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsInstancesEnableActionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1enableplugininstanceactionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:enableAction")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.enableAction", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.instances.enableAction" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsInstancesEnableActionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.enableAction", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsInstancesExecuteActionCall struct {
	s                                                     *Service
	name                                                  string
	googlecloudapihubv1executeplugininstanceactionrequest *GoogleCloudApihubV1ExecutePluginInstanceActionRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// ExecuteAction: Executes a plugin instance in the API hub.
//
//   - name: The name of the plugin instance to execute. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instan
//     ce}`.
func (r *ProjectsLocationsPluginsInstancesService) ExecuteAction(name string, googlecloudapihubv1executeplugininstanceactionrequest *GoogleCloudApihubV1ExecutePluginInstanceActionRequest) *ProjectsLocationsPluginsInstancesExecuteActionCall {
	c := &ProjectsLocationsPluginsInstancesExecuteActionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1executeplugininstanceactionrequest = googlecloudapihubv1executeplugininstanceactionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsInstancesExecuteActionCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsInstancesExecuteActionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsInstancesExecuteActionCall) Context(ctx context.Context) *ProjectsLocationsPluginsInstancesExecuteActionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsInstancesExecuteActionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsInstancesExecuteActionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1executeplugininstanceactionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:executeAction")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.executeAction", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.instances.executeAction" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsInstancesExecuteActionCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.executeAction", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsInstancesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get an API Hub plugin instance.
//
//   - name: The name of the plugin instance to retrieve. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instan
//     ce}`.
func (r *ProjectsLocationsPluginsInstancesService) Get(name string) *ProjectsLocationsPluginsInstancesGetCall {
	c := &ProjectsLocationsPluginsInstancesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsInstancesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsInstancesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPluginsInstancesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsPluginsInstancesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsInstancesGetCall) Context(ctx context.Context) *ProjectsLocationsPluginsInstancesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsInstancesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsInstancesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.instances.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1PluginInstance.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsInstancesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1PluginInstance, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1PluginInstance{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsInstancesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List all the plugins in a given project and location. `-` can be used
// as wildcard value for {plugin_id}
//
//   - parent: The parent resource where this plugin will be created. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}`. To list plugin
//     instances for multiple plugins, use the - character instead of the plugin
//     ID.
func (r *ProjectsLocationsPluginsInstancesService) List(parent string) *ProjectsLocationsPluginsInstancesListCall {
	c := &ProjectsLocationsPluginsInstancesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of plugin instances. A filter expression consists of a field name, a
// comparison operator, and a value for filtering. The value must be a string.
// The comparison operator must be one of: `<`, `>` or `=`. Filters are not
// case sensitive. The following fields in the `PluginInstances` are eligible
// for filtering: * `state` - The state of the Plugin Instance. Allowed
// comparison operators: `=`. A filter function is also supported in the filter
// string. The filter function is `id(name)`. The `id(name)` function returns
// the id of the resource name. For example, `id(name) = \"plugin-instance-1\"
// is equivalent to `name =
// \"projects/test-project-id/locations/test-location-id/plugins/plugin-1/instan
// ces/plugin-instance-1\" provided the parent is
// `projects/test-project-id/locations/test-location-id/plugins/plugin-1`.
// Expressions are combined with either `AND` logic operator or `OR` logical
// operator but not both of them together i.e. only one of the `AND` or `OR`
// operator can be used throughout the filter string and both the operators
// cannot be used together. No other logical operators are supported. At most
// three filter fields are allowed in the filter string and if provided more
// than that then `INVALID_ARGUMENT` error is returned by the API. Here are a
// few examples: * `state = ENABLED` - The plugin instance is in enabled state.
func (c *ProjectsLocationsPluginsInstancesListCall) Filter(filter string) *ProjectsLocationsPluginsInstancesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of hub
// plugins to return. The service may return fewer than this value. If
// unspecified, at most 50 hub plugins will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsPluginsInstancesListCall) PageSize(pageSize int64) *ProjectsLocationsPluginsInstancesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListPluginInstances` call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// `ListPluginInstances` must match the call that provided the page token.
func (c *ProjectsLocationsPluginsInstancesListCall) PageToken(pageToken string) *ProjectsLocationsPluginsInstancesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsInstancesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsInstancesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPluginsInstancesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsPluginsInstancesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsInstancesListCall) Context(ctx context.Context) *ProjectsLocationsPluginsInstancesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsInstancesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsInstancesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/instances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.instances.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListPluginInstancesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsInstancesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListPluginInstancesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListPluginInstancesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsPluginsInstancesListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListPluginInstancesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsPluginsInstancesPatchCall struct {
	s                                 *Service
	name                              string
	googlecloudapihubv1plugininstance *GoogleCloudApihubV1PluginInstance
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Patch: Updates a plugin instance in the API hub. The following fields in the
// plugin_instance can be updated currently: * display_name *
// schedule_cron_expression The update_mask should be used to specify the
// fields being updated. To update the auth_config and additional_config of the
// plugin instance, use the ApplyPluginInstanceConfig method.
//
//   - name: Identifier. The unique name of the plugin instance resource. Format:
//     `projects/{project}/locations/{location}/plugins/{plugin}/instances/{instan
//     ce}`.
func (r *ProjectsLocationsPluginsInstancesService) Patch(name string, googlecloudapihubv1plugininstance *GoogleCloudApihubV1PluginInstance) *ProjectsLocationsPluginsInstancesPatchCall {
	c := &ProjectsLocationsPluginsInstancesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapihubv1plugininstance = googlecloudapihubv1plugininstance
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *ProjectsLocationsPluginsInstancesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsPluginsInstancesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsInstancesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsInstancesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsInstancesPatchCall) Context(ctx context.Context) *ProjectsLocationsPluginsInstancesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsInstancesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsInstancesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1plugininstance)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.instances.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1PluginInstance.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsInstancesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1PluginInstance, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1PluginInstance{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.instances.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsPluginsStyleGuideGetContentsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetContents: Get the contents of the style guide.
//
//   - name: The name of the StyleGuide whose contents need to be retrieved.
//     There is exactly one style guide resource per project per location. The
//     expected format is
//     `projects/{project}/locations/{location}/plugins/{plugin}/styleGuide`.
func (r *ProjectsLocationsPluginsStyleGuideService) GetContents(name string) *ProjectsLocationsPluginsStyleGuideGetContentsCall {
	c := &ProjectsLocationsPluginsStyleGuideGetContentsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsPluginsStyleGuideGetContentsCall) Fields(s ...googleapi.Field) *ProjectsLocationsPluginsStyleGuideGetContentsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsPluginsStyleGuideGetContentsCall) IfNoneMatch(entityTag string) *ProjectsLocationsPluginsStyleGuideGetContentsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsPluginsStyleGuideGetContentsCall) Context(ctx context.Context) *ProjectsLocationsPluginsStyleGuideGetContentsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsPluginsStyleGuideGetContentsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsPluginsStyleGuideGetContentsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:contents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.styleGuide.getContents", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.plugins.styleGuide.getContents" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1StyleGuideContents.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsPluginsStyleGuideGetContentsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1StyleGuideContents, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1StyleGuideContents{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.plugins.styleGuide.getContents", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimeProjectAttachmentsCreateCall struct {
	s                                           *Service
	parent                                      string
	googlecloudapihubv1runtimeprojectattachment *GoogleCloudApihubV1RuntimeProjectAttachment
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Create: Attaches a runtime project to the host project.
//
//   - parent: The parent resource for the Runtime Project Attachment. Format:
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsRuntimeProjectAttachmentsService) Create(parent string, googlecloudapihubv1runtimeprojectattachment *GoogleCloudApihubV1RuntimeProjectAttachment) *ProjectsLocationsRuntimeProjectAttachmentsCreateCall {
	c := &ProjectsLocationsRuntimeProjectAttachmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapihubv1runtimeprojectattachment = googlecloudapihubv1runtimeprojectattachment
	return c
}

// RuntimeProjectAttachmentId sets the optional parameter
// "runtimeProjectAttachmentId": Required. The ID to use for the Runtime
// Project Attachment, which will become the final component of the Runtime
// Project Attachment's name. The ID must be the same as the project ID of the
// Google cloud project specified in the
// runtime_project_attachment.runtime_project field.
func (c *ProjectsLocationsRuntimeProjectAttachmentsCreateCall) RuntimeProjectAttachmentId(runtimeProjectAttachmentId string) *ProjectsLocationsRuntimeProjectAttachmentsCreateCall {
	c.urlParams_.Set("runtimeProjectAttachmentId", runtimeProjectAttachmentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimeProjectAttachmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimeProjectAttachmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimeProjectAttachmentsCreateCall) Context(ctx context.Context) *ProjectsLocationsRuntimeProjectAttachmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimeProjectAttachmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimeProjectAttachmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudapihubv1runtimeprojectattachment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/runtimeProjectAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.runtimeProjectAttachments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.runtimeProjectAttachments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1RuntimeProjectAttachment.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimeProjectAttachmentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1RuntimeProjectAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1RuntimeProjectAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.runtimeProjectAttachments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimeProjectAttachmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a runtime project attachment in the API Hub. This call will
// detach the runtime project from the host project.
//
//   - name: The name of the Runtime Project Attachment to delete. Format:
//     `projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime
//     _project_attachment}`.
func (r *ProjectsLocationsRuntimeProjectAttachmentsService) Delete(name string) *ProjectsLocationsRuntimeProjectAttachmentsDeleteCall {
	c := &ProjectsLocationsRuntimeProjectAttachmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimeProjectAttachmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimeProjectAttachmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimeProjectAttachmentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsRuntimeProjectAttachmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimeProjectAttachmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimeProjectAttachmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.runtimeProjectAttachments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.runtimeProjectAttachments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimeProjectAttachmentsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.runtimeProjectAttachments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimeProjectAttachmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a runtime project attachment.
//
//   - name: The name of the API resource to retrieve. Format:
//     `projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime
//     _project_attachment}`.
func (r *ProjectsLocationsRuntimeProjectAttachmentsService) Get(name string) *ProjectsLocationsRuntimeProjectAttachmentsGetCall {
	c := &ProjectsLocationsRuntimeProjectAttachmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimeProjectAttachmentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimeProjectAttachmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRuntimeProjectAttachmentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRuntimeProjectAttachmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimeProjectAttachmentsGetCall) Context(ctx context.Context) *ProjectsLocationsRuntimeProjectAttachmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimeProjectAttachmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimeProjectAttachmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.runtimeProjectAttachments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.runtimeProjectAttachments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1RuntimeProjectAttachment.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimeProjectAttachmentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1RuntimeProjectAttachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1RuntimeProjectAttachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.runtimeProjectAttachments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRuntimeProjectAttachmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List runtime projects attached to the host project.
//
//   - parent: The parent, which owns this collection of runtime project
//     attachments. Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsRuntimeProjectAttachmentsService) List(parent string) *ProjectsLocationsRuntimeProjectAttachmentsListCall {
	c := &ProjectsLocationsRuntimeProjectAttachmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression that filters the
// list of RuntimeProjectAttachments. A filter expression consists of a field
// name, a comparison operator, and a value for filtering. The value must be a
// string. All standard operators as documented at https://google.aip.dev/160
// are supported. The following fields in the `RuntimeProjectAttachment` are
// eligible for filtering: * `name` - The name of the RuntimeProjectAttachment.
// * `create_time` - The time at which the RuntimeProjectAttachment was
// created. The value should be in the
// (RFC3339)[https://tools.ietf.org/html/rfc3339] format. * `runtime_project` -
// The Google cloud project associated with the RuntimeProjectAttachment.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) Filter(filter string) *ProjectsLocationsRuntimeProjectAttachmentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) OrderBy(orderBy string) *ProjectsLocationsRuntimeProjectAttachmentsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// runtime project attachments to return. The service may return fewer than
// this value. If unspecified, at most 50 runtime project attachments will be
// returned. The maximum value is 1000; values above 1000 will be coerced to
// 1000.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) PageSize(pageSize int64) *ProjectsLocationsRuntimeProjectAttachmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListRuntimeProjectAttachments` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters (except
// page_size) provided to `ListRuntimeProjectAttachments` must match the call
// that provided the page token.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) PageToken(pageToken string) *ProjectsLocationsRuntimeProjectAttachmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRuntimeProjectAttachmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRuntimeProjectAttachmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) Context(ctx context.Context) *ProjectsLocationsRuntimeProjectAttachmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/runtimeProjectAttachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "apihub.projects.locations.runtimeProjectAttachments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apihub.projects.locations.runtimeProjectAttachments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApihubV1ListRuntimeProjectAttachmentsResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApihubV1ListRuntimeProjectAttachmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApihubV1ListRuntimeProjectAttachmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "apihub.projects.locations.runtimeProjectAttachments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsRuntimeProjectAttachmentsListCall) Pages(ctx context.Context, f func(*GoogleCloudApihubV1ListRuntimeProjectAttachmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
