// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/datacatalog/v1/datacatalog.proto

package datacatalogpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataCatalog_SearchCatalog_FullMethodName                   = "/google.cloud.datacatalog.v1.DataCatalog/SearchCatalog"
	DataCatalog_CreateEntryGroup_FullMethodName                = "/google.cloud.datacatalog.v1.DataCatalog/CreateEntryGroup"
	DataCatalog_GetEntryGroup_FullMethodName                   = "/google.cloud.datacatalog.v1.DataCatalog/GetEntryGroup"
	DataCatalog_UpdateEntryGroup_FullMethodName                = "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntryGroup"
	DataCatalog_DeleteEntryGroup_FullMethodName                = "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntryGroup"
	DataCatalog_ListEntryGroups_FullMethodName                 = "/google.cloud.datacatalog.v1.DataCatalog/ListEntryGroups"
	DataCatalog_CreateEntry_FullMethodName                     = "/google.cloud.datacatalog.v1.DataCatalog/CreateEntry"
	DataCatalog_UpdateEntry_FullMethodName                     = "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntry"
	DataCatalog_DeleteEntry_FullMethodName                     = "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntry"
	DataCatalog_GetEntry_FullMethodName                        = "/google.cloud.datacatalog.v1.DataCatalog/GetEntry"
	DataCatalog_LookupEntry_FullMethodName                     = "/google.cloud.datacatalog.v1.DataCatalog/LookupEntry"
	DataCatalog_ListEntries_FullMethodName                     = "/google.cloud.datacatalog.v1.DataCatalog/ListEntries"
	DataCatalog_ModifyEntryOverview_FullMethodName             = "/google.cloud.datacatalog.v1.DataCatalog/ModifyEntryOverview"
	DataCatalog_ModifyEntryContacts_FullMethodName             = "/google.cloud.datacatalog.v1.DataCatalog/ModifyEntryContacts"
	DataCatalog_CreateTagTemplate_FullMethodName               = "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplate"
	DataCatalog_GetTagTemplate_FullMethodName                  = "/google.cloud.datacatalog.v1.DataCatalog/GetTagTemplate"
	DataCatalog_UpdateTagTemplate_FullMethodName               = "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplate"
	DataCatalog_DeleteTagTemplate_FullMethodName               = "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplate"
	DataCatalog_CreateTagTemplateField_FullMethodName          = "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplateField"
	DataCatalog_UpdateTagTemplateField_FullMethodName          = "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplateField"
	DataCatalog_RenameTagTemplateField_FullMethodName          = "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateField"
	DataCatalog_RenameTagTemplateFieldEnumValue_FullMethodName = "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateFieldEnumValue"
	DataCatalog_DeleteTagTemplateField_FullMethodName          = "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplateField"
	DataCatalog_CreateTag_FullMethodName                       = "/google.cloud.datacatalog.v1.DataCatalog/CreateTag"
	DataCatalog_UpdateTag_FullMethodName                       = "/google.cloud.datacatalog.v1.DataCatalog/UpdateTag"
	DataCatalog_DeleteTag_FullMethodName                       = "/google.cloud.datacatalog.v1.DataCatalog/DeleteTag"
	DataCatalog_ListTags_FullMethodName                        = "/google.cloud.datacatalog.v1.DataCatalog/ListTags"
	DataCatalog_ReconcileTags_FullMethodName                   = "/google.cloud.datacatalog.v1.DataCatalog/ReconcileTags"
	DataCatalog_StarEntry_FullMethodName                       = "/google.cloud.datacatalog.v1.DataCatalog/StarEntry"
	DataCatalog_UnstarEntry_FullMethodName                     = "/google.cloud.datacatalog.v1.DataCatalog/UnstarEntry"
	DataCatalog_SetIamPolicy_FullMethodName                    = "/google.cloud.datacatalog.v1.DataCatalog/SetIamPolicy"
	DataCatalog_GetIamPolicy_FullMethodName                    = "/google.cloud.datacatalog.v1.DataCatalog/GetIamPolicy"
	DataCatalog_TestIamPermissions_FullMethodName              = "/google.cloud.datacatalog.v1.DataCatalog/TestIamPermissions"
	DataCatalog_ImportEntries_FullMethodName                   = "/google.cloud.datacatalog.v1.DataCatalog/ImportEntries"
	DataCatalog_SetConfig_FullMethodName                       = "/google.cloud.datacatalog.v1.DataCatalog/SetConfig"
	DataCatalog_RetrieveConfig_FullMethodName                  = "/google.cloud.datacatalog.v1.DataCatalog/RetrieveConfig"
	DataCatalog_RetrieveEffectiveConfig_FullMethodName         = "/google.cloud.datacatalog.v1.DataCatalog/RetrieveEffectiveConfig"
)

// DataCatalogClient is the client API for DataCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Deprecated: Do not use.
type DataCatalogClient interface {
	// Deprecated: Do not use.
	// Searches Data Catalog for multiple resources like entries and tags that
	// match a query.
	//
	// This is a [Custom Method]
	// (https://cloud.google.com/apis/design/custom_methods) that doesn't return
	// all information on a resource, only its ID and high level fields. To get
	// more information, you can subsequently call specific get methods.
	//
	// Note: Data Catalog search queries don't guarantee full recall. Results
	// that match your query might not be returned, even in subsequent
	// result pages. Additionally, returned (and not returned) results can vary
	// if you repeat search queries.
	//
	// For more information, see [Data Catalog search syntax]
	// (https://cloud.google.com/data-catalog/docs/how-to/search-reference).
	SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error)
	// Deprecated: Do not use.
	// Creates an entry group.
	//
	// An entry group contains logically related entries together with [Cloud
	// Identity and Access Management](/data-catalog/docs/concepts/iam) policies.
	// These policies specify users who can create, edit, and view entries
	// within entry groups.
	//
	// Data Catalog automatically creates entry groups with names that start with
	// the `@` symbol for the following resources:
	//
	// * BigQuery entries (`@bigquery`)
	// * Pub/Sub topics (`@pubsub`)
	// * Dataproc Metastore services (`@dataproc_metastore_{SERVICE_NAME_HASH}`)
	//
	// You can create your own entry groups for Cloud Storage fileset entries
	// and custom entries together with the corresponding IAM policies.
	// User-created entry groups can't contain the `@` symbol, it is reserved
	// for automatically created groups.
	//
	// Entry groups, like entries, can be searched.
	//
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Gets an entry group.
	GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Updates an entry group.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `entry_group.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Deletes an entry group.
	//
	// You must enable the Data Catalog API in the project
	// identified by the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Lists entry groups.
	ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error)
	// Deprecated: Do not use.
	// Creates an entry.
	//
	// You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM',
	// or custom types. Data Catalog automatically creates entries with other
	// types during metadata ingestion from integrated systems.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	//
	// An entry group can have a maximum of 100,000 entries.
	CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deprecated: Do not use.
	// Updates an existing entry.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `entry.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deprecated: Do not use.
	// Deletes an existing entry.
	//
	// You can delete only the entries created by the
	// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
	// method.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Gets an entry.
	GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deprecated: Do not use.
	// Gets an entry by its target resource name.
	//
	// The resource name comes from the source Google Cloud Platform service.
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deprecated: Do not use.
	// Lists entries.
	//
	// Note: Currently, this method can list only custom entries.
	// To get a list of both custom and automatically created entries, use
	// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
	ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error)
	// Deprecated: Do not use.
	// Modifies entry overview, part of the business context of an
	// [Entry][google.cloud.datacatalog.v1.Entry].
	//
	// To call this method, you must have the `datacatalog.entries.updateOverview`
	// IAM permission on the corresponding project.
	ModifyEntryOverview(ctx context.Context, in *ModifyEntryOverviewRequest, opts ...grpc.CallOption) (*EntryOverview, error)
	// Deprecated: Do not use.
	// Modifies contacts, part of the business context of an
	// [Entry][google.cloud.datacatalog.v1.Entry].
	//
	// To call this method, you must have the `datacatalog.entries.updateContacts`
	// IAM permission on the corresponding project.
	ModifyEntryContacts(ctx context.Context, in *ModifyEntryContactsRequest, opts ...grpc.CallOption) (*Contacts, error)
	// Deprecated: Do not use.
	// Creates a tag template.
	//
	// You must enable the Data Catalog API in the project identified by the
	// `parent` parameter.
	// For more information, see [Data Catalog resource project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Gets a tag template.
	GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Updates a tag template.
	//
	// You can't update template fields with this method. These fields are
	// separate resources with their own create, update, and delete methods.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Deletes a tag template and all tags that use it.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Creates a field in a tag template.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Updates a field in a tag template.
	//
	// You can't update the field type with this method.
	//
	// You must enable the Data Catalog API in the project
	// identified by the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Renames a field in a tag template.
	//
	// You must enable the Data Catalog API in the project identified by the
	// `name` parameter. For more information, see [Data Catalog resource project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Renames an enum value in a tag template.
	//
	// Within a single enum field, enum values must be unique.
	RenameTagTemplateFieldEnumValue(ctx context.Context, in *RenameTagTemplateFieldEnumValueRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Deletes a field in a tag template and all uses of this field from the tags
	// based on this template.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Creates a tag and assigns it to:
	//
	//   - An [Entry][google.cloud.datacatalog.v1.Entry] if the method name is
	//     `projects.locations.entryGroups.entries.tags.create`.
	//   - Or [EntryGroup][google.cloud.datacatalog.v1.EntryGroup]if the method
	//     name is `projects.locations.entryGroups.tags.create`.
	//
	// Note: The project identified by the `parent` parameter for the [tag]
	// (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the [tag template]
	// (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be in the same organization.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deprecated: Do not use.
	// Updates an existing tag.
	UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deprecated: Do not use.
	// Deletes a tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Lists tags assigned to an [Entry][google.cloud.datacatalog.v1.Entry].
	// The [columns][google.cloud.datacatalog.v1.Tag.column] in the response are
	// lowercased.
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Deprecated: Do not use.
	// `ReconcileTags` creates or updates a list of tags on the entry.
	// If the
	// [ReconcileTagsRequest.force_delete_missing][google.cloud.datacatalog.v1.ReconcileTagsRequest.force_delete_missing]
	// parameter is set, the operation deletes tags not included in the input tag
	// list.
	//
	// `ReconcileTags` returns a [long-running operation]
	// [google.longrunning.Operation] resource that can be queried with
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation]
	// to return [ReconcileTagsMetadata]
	// [google.cloud.datacatalog.v1.ReconcileTagsMetadata] and
	// a [ReconcileTagsResponse]
	// [google.cloud.datacatalog.v1.ReconcileTagsResponse] message.
	ReconcileTags(ctx context.Context, in *ReconcileTagsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Marks an [Entry][google.cloud.datacatalog.v1.Entry] as starred by
	// the current user. Starring information is private to each user.
	StarEntry(ctx context.Context, in *StarEntryRequest, opts ...grpc.CallOption) (*StarEntryResponse, error)
	// Deprecated: Do not use.
	// Marks an [Entry][google.cloud.datacatalog.v1.Entry] as NOT starred by
	// the current user. Starring information is private to each user.
	UnstarEntry(ctx context.Context, in *UnstarEntryRequest, opts ...grpc.CallOption) (*UnstarEntryResponse, error)
	// Deprecated: Do not use.
	// Sets an access control policy for a resource. Replaces any existing
	// policy.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method sets policies only within Data Catalog and can't be
	// used to manage policies in BigQuery, Pub/Sub, Dataproc Metastore, and any
	// external Google Cloud Platform resources synced with the Data Catalog.
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Deprecated: Do not use.
	// Gets the access control policy for a resource.
	//
	// May return:
	//
	//   - A`NOT_FOUND` error if the resource doesn't exist or you don't have the
	//     permission to view it.
	//   - An empty policy if the resource exists but doesn't have a set policy.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method doesn't get policies from Google Cloud Platform
	// resources ingested into Data Catalog.
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Deprecated: Do not use.
	// Gets your permissions on a resource.
	//
	// Returns an empty set of permissions if the resource doesn't exist.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method gets policies only within Data Catalog and can't be
	// used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any
	// external Google Cloud Platform resources ingested into Data Catalog.
	//
	// No Google IAM permissions are required to call this method.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Deprecated: Do not use.
	// Imports entries from a source, such as data previously dumped into a
	// Cloud Storage bucket, into Data Catalog. Import of entries
	// is a sync operation that reconciles the state of the third-party system
	// with the Data Catalog.
	//
	// `ImportEntries` accepts source data snapshots of a third-party system.
	// Snapshot should be delivered as a .wire or base65-encoded .txt file
	// containing a sequence of Protocol Buffer messages of
	// [DumpItem][google.cloud.datacatalog.v1.DumpItem] type.
	//
	// `ImportEntries` returns a [long-running operation]
	// [google.longrunning.Operation] resource that can be queried with
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation]
	// to return
	// [ImportEntriesMetadata][google.cloud.datacatalog.v1.ImportEntriesMetadata]
	// and an
	// [ImportEntriesResponse][google.cloud.datacatalog.v1.ImportEntriesResponse]
	// message.
	ImportEntries(ctx context.Context, in *ImportEntriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Sets the configuration related to the migration to Dataplex for an
	// organization or project.
	SetConfig(ctx context.Context, in *SetConfigRequest, opts ...grpc.CallOption) (*MigrationConfig, error)
	// Deprecated: Do not use.
	// Retrieves the configuration related to the migration from Data Catalog to
	// Dataplex for a specific organization, including all the projects under it
	// which have a separate configuration set.
	RetrieveConfig(ctx context.Context, in *RetrieveConfigRequest, opts ...grpc.CallOption) (*OrganizationConfig, error)
	// Deprecated: Do not use.
	// Retrieves the effective configuration related to the migration from Data
	// Catalog to Dataplex for a specific organization or project. If there is no
	// specific configuration set for the resource, the setting is checked
	// hierarchicahlly through the ancestors of the resource, starting from the
	// resource itself.
	RetrieveEffectiveConfig(ctx context.Context, in *RetrieveEffectiveConfigRequest, opts ...grpc.CallOption) (*MigrationConfig, error)
}

type dataCatalogClient struct {
	cc grpc.ClientConnInterface
}

// Deprecated: Do not use.
func NewDataCatalogClient(cc grpc.ClientConnInterface) DataCatalogClient {
	return &dataCatalogClient{cc}
}

// Deprecated: Do not use.
func (c *dataCatalogClient) SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error) {
	out := new(SearchCatalogResponse)
	err := c.cc.Invoke(ctx, DataCatalog_SearchCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, DataCatalog_CreateEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, DataCatalog_GetEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteEntryGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error) {
	out := new(ListEntryGroupsResponse)
	err := c.cc.Invoke(ctx, DataCatalog_ListEntryGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, DataCatalog_CreateEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, DataCatalog_GetEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, DataCatalog_LookupEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error) {
	out := new(ListEntriesResponse)
	err := c.cc.Invoke(ctx, DataCatalog_ListEntries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ModifyEntryOverview(ctx context.Context, in *ModifyEntryOverviewRequest, opts ...grpc.CallOption) (*EntryOverview, error) {
	out := new(EntryOverview)
	err := c.cc.Invoke(ctx, DataCatalog_ModifyEntryOverview_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ModifyEntryContacts(ctx context.Context, in *ModifyEntryContactsRequest, opts ...grpc.CallOption) (*Contacts, error) {
	out := new(Contacts)
	err := c.cc.Invoke(ctx, DataCatalog_ModifyEntryContacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, DataCatalog_CreateTagTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, DataCatalog_GetTagTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateTagTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteTagTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, DataCatalog_CreateTagTemplateField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateTagTemplateField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, DataCatalog_RenameTagTemplateField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) RenameTagTemplateFieldEnumValue(ctx context.Context, in *RenameTagTemplateFieldEnumValueRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, DataCatalog_RenameTagTemplateFieldEnumValue_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteTagTemplateField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, DataCatalog_CreateTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataCatalog_DeleteTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, DataCatalog_ListTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ReconcileTags(ctx context.Context, in *ReconcileTagsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataCatalog_ReconcileTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) StarEntry(ctx context.Context, in *StarEntryRequest, opts ...grpc.CallOption) (*StarEntryResponse, error) {
	out := new(StarEntryResponse)
	err := c.cc.Invoke(ctx, DataCatalog_StarEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) UnstarEntry(ctx context.Context, in *UnstarEntryRequest, opts ...grpc.CallOption) (*UnstarEntryResponse, error) {
	out := new(UnstarEntryResponse)
	err := c.cc.Invoke(ctx, DataCatalog_UnstarEntry_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DataCatalog_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DataCatalog_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, DataCatalog_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) ImportEntries(ctx context.Context, in *ImportEntriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataCatalog_ImportEntries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) SetConfig(ctx context.Context, in *SetConfigRequest, opts ...grpc.CallOption) (*MigrationConfig, error) {
	out := new(MigrationConfig)
	err := c.cc.Invoke(ctx, DataCatalog_SetConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) RetrieveConfig(ctx context.Context, in *RetrieveConfigRequest, opts ...grpc.CallOption) (*OrganizationConfig, error) {
	out := new(OrganizationConfig)
	err := c.cc.Invoke(ctx, DataCatalog_RetrieveConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataCatalogClient) RetrieveEffectiveConfig(ctx context.Context, in *RetrieveEffectiveConfigRequest, opts ...grpc.CallOption) (*MigrationConfig, error) {
	out := new(MigrationConfig)
	err := c.cc.Invoke(ctx, DataCatalog_RetrieveEffectiveConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataCatalogServer is the server API for DataCatalog service.
// All implementations should embed UnimplementedDataCatalogServer
// for forward compatibility
//
// Deprecated: Do not use.
type DataCatalogServer interface {
	// Deprecated: Do not use.
	// Searches Data Catalog for multiple resources like entries and tags that
	// match a query.
	//
	// This is a [Custom Method]
	// (https://cloud.google.com/apis/design/custom_methods) that doesn't return
	// all information on a resource, only its ID and high level fields. To get
	// more information, you can subsequently call specific get methods.
	//
	// Note: Data Catalog search queries don't guarantee full recall. Results
	// that match your query might not be returned, even in subsequent
	// result pages. Additionally, returned (and not returned) results can vary
	// if you repeat search queries.
	//
	// For more information, see [Data Catalog search syntax]
	// (https://cloud.google.com/data-catalog/docs/how-to/search-reference).
	SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error)
	// Deprecated: Do not use.
	// Creates an entry group.
	//
	// An entry group contains logically related entries together with [Cloud
	// Identity and Access Management](/data-catalog/docs/concepts/iam) policies.
	// These policies specify users who can create, edit, and view entries
	// within entry groups.
	//
	// Data Catalog automatically creates entry groups with names that start with
	// the `@` symbol for the following resources:
	//
	// * BigQuery entries (`@bigquery`)
	// * Pub/Sub topics (`@pubsub`)
	// * Dataproc Metastore services (`@dataproc_metastore_{SERVICE_NAME_HASH}`)
	//
	// You can create your own entry groups for Cloud Storage fileset entries
	// and custom entries together with the corresponding IAM policies.
	// User-created entry groups can't contain the `@` symbol, it is reserved
	// for automatically created groups.
	//
	// Entry groups, like entries, can be searched.
	//
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Gets an entry group.
	GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Updates an entry group.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `entry_group.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*EntryGroup, error)
	// Deprecated: Do not use.
	// Deletes an entry group.
	//
	// You must enable the Data Catalog API in the project
	// identified by the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Lists entry groups.
	ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error)
	// Deprecated: Do not use.
	// Creates an entry.
	//
	// You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM',
	// or custom types. Data Catalog automatically creates entries with other
	// types during metadata ingestion from integrated systems.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	//
	// An entry group can have a maximum of 100,000 entries.
	CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error)
	// Deprecated: Do not use.
	// Updates an existing entry.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `entry.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error)
	// Deprecated: Do not use.
	// Deletes an existing entry.
	//
	// You can delete only the entries created by the
	// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
	// method.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteEntry(context.Context, *DeleteEntryRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Gets an entry.
	GetEntry(context.Context, *GetEntryRequest) (*Entry, error)
	// Deprecated: Do not use.
	// Gets an entry by its target resource name.
	//
	// The resource name comes from the source Google Cloud Platform service.
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
	// Deprecated: Do not use.
	// Lists entries.
	//
	// Note: Currently, this method can list only custom entries.
	// To get a list of both custom and automatically created entries, use
	// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
	ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error)
	// Deprecated: Do not use.
	// Modifies entry overview, part of the business context of an
	// [Entry][google.cloud.datacatalog.v1.Entry].
	//
	// To call this method, you must have the `datacatalog.entries.updateOverview`
	// IAM permission on the corresponding project.
	ModifyEntryOverview(context.Context, *ModifyEntryOverviewRequest) (*EntryOverview, error)
	// Deprecated: Do not use.
	// Modifies contacts, part of the business context of an
	// [Entry][google.cloud.datacatalog.v1.Entry].
	//
	// To call this method, you must have the `datacatalog.entries.updateContacts`
	// IAM permission on the corresponding project.
	ModifyEntryContacts(context.Context, *ModifyEntryContactsRequest) (*Contacts, error)
	// Deprecated: Do not use.
	// Creates a tag template.
	//
	// You must enable the Data Catalog API in the project identified by the
	// `parent` parameter.
	// For more information, see [Data Catalog resource project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Gets a tag template.
	GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Updates a tag template.
	//
	// You can't update template fields with this method. These fields are
	// separate resources with their own create, update, and delete methods.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error)
	// Deprecated: Do not use.
	// Deletes a tag template and all tags that use it.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Creates a field in a tag template.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Updates a field in a tag template.
	//
	// You can't update the field type with this method.
	//
	// You must enable the Data Catalog API in the project
	// identified by the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Renames a field in a tag template.
	//
	// You must enable the Data Catalog API in the project identified by the
	// `name` parameter. For more information, see [Data Catalog resource project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Renames an enum value in a tag template.
	//
	// Within a single enum field, enum values must be unique.
	RenameTagTemplateFieldEnumValue(context.Context, *RenameTagTemplateFieldEnumValueRequest) (*TagTemplateField, error)
	// Deprecated: Do not use.
	// Deletes a field in a tag template and all uses of this field from the tags
	// based on this template.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Creates a tag and assigns it to:
	//
	//   - An [Entry][google.cloud.datacatalog.v1.Entry] if the method name is
	//     `projects.locations.entryGroups.entries.tags.create`.
	//   - Or [EntryGroup][google.cloud.datacatalog.v1.EntryGroup]if the method
	//     name is `projects.locations.entryGroups.tags.create`.
	//
	// Note: The project identified by the `parent` parameter for the [tag]
	// (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the [tag template]
	// (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be in the same organization.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Deprecated: Do not use.
	// Updates an existing tag.
	UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error)
	// Deprecated: Do not use.
	// Deletes a tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Lists tags assigned to an [Entry][google.cloud.datacatalog.v1.Entry].
	// The [columns][google.cloud.datacatalog.v1.Tag.column] in the response are
	// lowercased.
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Deprecated: Do not use.
	// `ReconcileTags` creates or updates a list of tags on the entry.
	// If the
	// [ReconcileTagsRequest.force_delete_missing][google.cloud.datacatalog.v1.ReconcileTagsRequest.force_delete_missing]
	// parameter is set, the operation deletes tags not included in the input tag
	// list.
	//
	// `ReconcileTags` returns a [long-running operation]
	// [google.longrunning.Operation] resource that can be queried with
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation]
	// to return [ReconcileTagsMetadata]
	// [google.cloud.datacatalog.v1.ReconcileTagsMetadata] and
	// a [ReconcileTagsResponse]
	// [google.cloud.datacatalog.v1.ReconcileTagsResponse] message.
	ReconcileTags(context.Context, *ReconcileTagsRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Marks an [Entry][google.cloud.datacatalog.v1.Entry] as starred by
	// the current user. Starring information is private to each user.
	StarEntry(context.Context, *StarEntryRequest) (*StarEntryResponse, error)
	// Deprecated: Do not use.
	// Marks an [Entry][google.cloud.datacatalog.v1.Entry] as NOT starred by
	// the current user. Starring information is private to each user.
	UnstarEntry(context.Context, *UnstarEntryRequest) (*UnstarEntryResponse, error)
	// Deprecated: Do not use.
	// Sets an access control policy for a resource. Replaces any existing
	// policy.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method sets policies only within Data Catalog and can't be
	// used to manage policies in BigQuery, Pub/Sub, Dataproc Metastore, and any
	// external Google Cloud Platform resources synced with the Data Catalog.
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Deprecated: Do not use.
	// Gets the access control policy for a resource.
	//
	// May return:
	//
	//   - A`NOT_FOUND` error if the resource doesn't exist or you don't have the
	//     permission to view it.
	//   - An empty policy if the resource exists but doesn't have a set policy.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method doesn't get policies from Google Cloud Platform
	// resources ingested into Data Catalog.
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Deprecated: Do not use.
	// Gets your permissions on a resource.
	//
	// Returns an empty set of permissions if the resource doesn't exist.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method gets policies only within Data Catalog and can't be
	// used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any
	// external Google Cloud Platform resources ingested into Data Catalog.
	//
	// No Google IAM permissions are required to call this method.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Deprecated: Do not use.
	// Imports entries from a source, such as data previously dumped into a
	// Cloud Storage bucket, into Data Catalog. Import of entries
	// is a sync operation that reconciles the state of the third-party system
	// with the Data Catalog.
	//
	// `ImportEntries` accepts source data snapshots of a third-party system.
	// Snapshot should be delivered as a .wire or base65-encoded .txt file
	// containing a sequence of Protocol Buffer messages of
	// [DumpItem][google.cloud.datacatalog.v1.DumpItem] type.
	//
	// `ImportEntries` returns a [long-running operation]
	// [google.longrunning.Operation] resource that can be queried with
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation]
	// to return
	// [ImportEntriesMetadata][google.cloud.datacatalog.v1.ImportEntriesMetadata]
	// and an
	// [ImportEntriesResponse][google.cloud.datacatalog.v1.ImportEntriesResponse]
	// message.
	ImportEntries(context.Context, *ImportEntriesRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Sets the configuration related to the migration to Dataplex for an
	// organization or project.
	SetConfig(context.Context, *SetConfigRequest) (*MigrationConfig, error)
	// Deprecated: Do not use.
	// Retrieves the configuration related to the migration from Data Catalog to
	// Dataplex for a specific organization, including all the projects under it
	// which have a separate configuration set.
	RetrieveConfig(context.Context, *RetrieveConfigRequest) (*OrganizationConfig, error)
	// Deprecated: Do not use.
	// Retrieves the effective configuration related to the migration from Data
	// Catalog to Dataplex for a specific organization or project. If there is no
	// specific configuration set for the resource, the setting is checked
	// hierarchicahlly through the ancestors of the resource, starting from the
	// resource itself.
	RetrieveEffectiveConfig(context.Context, *RetrieveEffectiveConfigRequest) (*MigrationConfig, error)
}

// UnimplementedDataCatalogServer should be embedded to have forward compatible implementations.
type UnimplementedDataCatalogServer struct {
}

func (UnimplementedDataCatalogServer) SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCatalog not implemented")
}
func (UnimplementedDataCatalogServer) CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryGroup not implemented")
}
func (UnimplementedDataCatalogServer) GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryGroup not implemented")
}
func (UnimplementedDataCatalogServer) UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntryGroup not implemented")
}
func (UnimplementedDataCatalogServer) DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryGroup not implemented")
}
func (UnimplementedDataCatalogServer) ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntryGroups not implemented")
}
func (UnimplementedDataCatalogServer) CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntry not implemented")
}
func (UnimplementedDataCatalogServer) UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntry not implemented")
}
func (UnimplementedDataCatalogServer) DeleteEntry(context.Context, *DeleteEntryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntry not implemented")
}
func (UnimplementedDataCatalogServer) GetEntry(context.Context, *GetEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntry not implemented")
}
func (UnimplementedDataCatalogServer) LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEntry not implemented")
}
func (UnimplementedDataCatalogServer) ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntries not implemented")
}
func (UnimplementedDataCatalogServer) ModifyEntryOverview(context.Context, *ModifyEntryOverviewRequest) (*EntryOverview, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyEntryOverview not implemented")
}
func (UnimplementedDataCatalogServer) ModifyEntryContacts(context.Context, *ModifyEntryContactsRequest) (*Contacts, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyEntryContacts not implemented")
}
func (UnimplementedDataCatalogServer) CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplate not implemented")
}
func (UnimplementedDataCatalogServer) GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTagTemplate not implemented")
}
func (UnimplementedDataCatalogServer) UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplate not implemented")
}
func (UnimplementedDataCatalogServer) DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplate not implemented")
}
func (UnimplementedDataCatalogServer) CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplateField not implemented")
}
func (UnimplementedDataCatalogServer) UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplateField not implemented")
}
func (UnimplementedDataCatalogServer) RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTagTemplateField not implemented")
}
func (UnimplementedDataCatalogServer) RenameTagTemplateFieldEnumValue(context.Context, *RenameTagTemplateFieldEnumValueRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTagTemplateFieldEnumValue not implemented")
}
func (UnimplementedDataCatalogServer) DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplateField not implemented")
}
func (UnimplementedDataCatalogServer) CreateTag(context.Context, *CreateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTag not implemented")
}
func (UnimplementedDataCatalogServer) UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTag not implemented")
}
func (UnimplementedDataCatalogServer) DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTag not implemented")
}
func (UnimplementedDataCatalogServer) ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTags not implemented")
}
func (UnimplementedDataCatalogServer) ReconcileTags(context.Context, *ReconcileTagsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReconcileTags not implemented")
}
func (UnimplementedDataCatalogServer) StarEntry(context.Context, *StarEntryRequest) (*StarEntryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StarEntry not implemented")
}
func (UnimplementedDataCatalogServer) UnstarEntry(context.Context, *UnstarEntryRequest) (*UnstarEntryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnstarEntry not implemented")
}
func (UnimplementedDataCatalogServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedDataCatalogServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedDataCatalogServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedDataCatalogServer) ImportEntries(context.Context, *ImportEntriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportEntries not implemented")
}
func (UnimplementedDataCatalogServer) SetConfig(context.Context, *SetConfigRequest) (*MigrationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConfig not implemented")
}
func (UnimplementedDataCatalogServer) RetrieveConfig(context.Context, *RetrieveConfigRequest) (*OrganizationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveConfig not implemented")
}
func (UnimplementedDataCatalogServer) RetrieveEffectiveConfig(context.Context, *RetrieveEffectiveConfigRequest) (*MigrationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveEffectiveConfig not implemented")
}

// UnsafeDataCatalogServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataCatalogServer will
// result in compilation errors.
type UnsafeDataCatalogServer interface {
	mustEmbedUnimplementedDataCatalogServer()
}

// Deprecated: Do not use.
func RegisterDataCatalogServer(s grpc.ServiceRegistrar, srv DataCatalogServer) {
	s.RegisterService(&DataCatalog_ServiceDesc, srv)
}

func _DataCatalog_SearchCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SearchCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_SearchCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SearchCatalog(ctx, req.(*SearchCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, req.(*CreateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, req.(*GetEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, req.(*UpdateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteEntryGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, req.(*DeleteEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntryGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntryGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ListEntryGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, req.(*ListEntryGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntry(ctx, req.(*CreateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntry(ctx, req.(*UpdateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntry(ctx, req.(*DeleteEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntry(ctx, req.(*GetEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_LookupEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ListEntries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntries(ctx, req.(*ListEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ModifyEntryOverview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyEntryOverviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ModifyEntryOverview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ModifyEntryOverview_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ModifyEntryOverview(ctx, req.(*ModifyEntryOverviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ModifyEntryContacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyEntryContactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ModifyEntryContacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ModifyEntryContacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ModifyEntryContacts(ctx, req.(*ModifyEntryContactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateTagTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, req.(*CreateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetTagTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, req.(*GetTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateTagTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, req.(*UpdateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteTagTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, req.(*DeleteTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateTagTemplateField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, req.(*CreateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateTagTemplateField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, req.(*UpdateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_RenameTagTemplateField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, req.(*RenameTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateFieldEnumValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldEnumValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateFieldEnumValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_RenameTagTemplateFieldEnumValue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateFieldEnumValue(ctx, req.(*RenameTagTemplateFieldEnumValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteTagTemplateField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, req.(*DeleteTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTag(ctx, req.(*UpdateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_DeleteTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ListTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ReconcileTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReconcileTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ReconcileTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ReconcileTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ReconcileTags(ctx, req.(*ReconcileTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_StarEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StarEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).StarEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_StarEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).StarEntry(ctx, req.(*StarEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UnstarEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnstarEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UnstarEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UnstarEntry_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UnstarEntry(ctx, req.(*UnstarEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ImportEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ImportEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ImportEntries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ImportEntries(ctx, req.(*ImportEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_SetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_SetConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SetConfig(ctx, req.(*SetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RetrieveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RetrieveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_RetrieveConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RetrieveConfig(ctx, req.(*RetrieveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RetrieveEffectiveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveEffectiveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RetrieveEffectiveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_RetrieveEffectiveConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RetrieveEffectiveConfig(ctx, req.(*RetrieveEffectiveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataCatalog_ServiceDesc is the grpc.ServiceDesc for DataCatalog service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataCatalog_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1.DataCatalog",
	HandlerType: (*DataCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchCatalog",
			Handler:    _DataCatalog_SearchCatalog_Handler,
		},
		{
			MethodName: "CreateEntryGroup",
			Handler:    _DataCatalog_CreateEntryGroup_Handler,
		},
		{
			MethodName: "GetEntryGroup",
			Handler:    _DataCatalog_GetEntryGroup_Handler,
		},
		{
			MethodName: "UpdateEntryGroup",
			Handler:    _DataCatalog_UpdateEntryGroup_Handler,
		},
		{
			MethodName: "DeleteEntryGroup",
			Handler:    _DataCatalog_DeleteEntryGroup_Handler,
		},
		{
			MethodName: "ListEntryGroups",
			Handler:    _DataCatalog_ListEntryGroups_Handler,
		},
		{
			MethodName: "CreateEntry",
			Handler:    _DataCatalog_CreateEntry_Handler,
		},
		{
			MethodName: "UpdateEntry",
			Handler:    _DataCatalog_UpdateEntry_Handler,
		},
		{
			MethodName: "DeleteEntry",
			Handler:    _DataCatalog_DeleteEntry_Handler,
		},
		{
			MethodName: "GetEntry",
			Handler:    _DataCatalog_GetEntry_Handler,
		},
		{
			MethodName: "LookupEntry",
			Handler:    _DataCatalog_LookupEntry_Handler,
		},
		{
			MethodName: "ListEntries",
			Handler:    _DataCatalog_ListEntries_Handler,
		},
		{
			MethodName: "ModifyEntryOverview",
			Handler:    _DataCatalog_ModifyEntryOverview_Handler,
		},
		{
			MethodName: "ModifyEntryContacts",
			Handler:    _DataCatalog_ModifyEntryContacts_Handler,
		},
		{
			MethodName: "CreateTagTemplate",
			Handler:    _DataCatalog_CreateTagTemplate_Handler,
		},
		{
			MethodName: "GetTagTemplate",
			Handler:    _DataCatalog_GetTagTemplate_Handler,
		},
		{
			MethodName: "UpdateTagTemplate",
			Handler:    _DataCatalog_UpdateTagTemplate_Handler,
		},
		{
			MethodName: "DeleteTagTemplate",
			Handler:    _DataCatalog_DeleteTagTemplate_Handler,
		},
		{
			MethodName: "CreateTagTemplateField",
			Handler:    _DataCatalog_CreateTagTemplateField_Handler,
		},
		{
			MethodName: "UpdateTagTemplateField",
			Handler:    _DataCatalog_UpdateTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateField",
			Handler:    _DataCatalog_RenameTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateFieldEnumValue",
			Handler:    _DataCatalog_RenameTagTemplateFieldEnumValue_Handler,
		},
		{
			MethodName: "DeleteTagTemplateField",
			Handler:    _DataCatalog_DeleteTagTemplateField_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _DataCatalog_CreateTag_Handler,
		},
		{
			MethodName: "UpdateTag",
			Handler:    _DataCatalog_UpdateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _DataCatalog_DeleteTag_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _DataCatalog_ListTags_Handler,
		},
		{
			MethodName: "ReconcileTags",
			Handler:    _DataCatalog_ReconcileTags_Handler,
		},
		{
			MethodName: "StarEntry",
			Handler:    _DataCatalog_StarEntry_Handler,
		},
		{
			MethodName: "UnstarEntry",
			Handler:    _DataCatalog_UnstarEntry_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataCatalog_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataCatalog_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataCatalog_TestIamPermissions_Handler,
		},
		{
			MethodName: "ImportEntries",
			Handler:    _DataCatalog_ImportEntries_Handler,
		},
		{
			MethodName: "SetConfig",
			Handler:    _DataCatalog_SetConfig_Handler,
		},
		{
			MethodName: "RetrieveConfig",
			Handler:    _DataCatalog_RetrieveConfig_Handler,
		},
		{
			MethodName: "RetrieveEffectiveConfig",
			Handler:    _DataCatalog_RetrieveEffectiveConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1/datacatalog.proto",
}
