/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.authorization.domain;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import javax.security.auth.Subject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.rundeck.app.auth.types.AuthorizingProject;
import org.rundeck.app.authorization.domain.AppAuthorizer;
import org.rundeck.app.authorization.domain.appType.AppResourceTypeAuthorizingProvider;
import org.rundeck.app.authorization.domain.execution.AppExecutionResourceAuthorizingProvider;
import org.rundeck.app.authorization.domain.execution.AuthorizingExecution;
import org.rundeck.app.authorization.domain.job.AppJobResourceAuthorizingProvider;
import org.rundeck.app.authorization.domain.job.AuthorizingJob;
import org.rundeck.app.authorization.domain.project.AppProjectAdhocResourceAuthorizingProvider;
import org.rundeck.app.authorization.domain.project.AppProjectResourceAuthorizingProvider;
import org.rundeck.app.authorization.domain.projectAcl.AppProjectAclAuthorizingProvider;
import org.rundeck.app.authorization.domain.projectType.AppProjectTypeAuthorizingProvider;
import org.rundeck.app.authorization.domain.system.AppSystemAuthorizingProvider;
import org.rundeck.core.auth.access.AuthorizingAccess;
import org.rundeck.core.auth.access.MissingParameter;
import org.rundeck.core.auth.access.NotFound;
import org.rundeck.core.auth.access.ResIdResolver;
import org.rundeck.core.auth.access.UnauthorizedAccess;
import org.rundeck.core.auth.app.NamedAuthRequest;
import org.rundeck.core.auth.app.RundeckAccess;
import org.rundeck.core.auth.app.TypedNamedAuthRequest;
import org.rundeck.core.auth.app.type.AuthorizingAppType;
import org.rundeck.core.auth.app.type.AuthorizingProjectAcl;
import org.rundeck.core.auth.app.type.AuthorizingProjectAdhoc;
import org.rundeck.core.auth.app.type.AuthorizingProjectType;
import org.rundeck.core.auth.app.type.AuthorizingSystem;
import org.springframework.beans.factory.annotation.Autowired;

public class RundeckAppAuthorizer
implements AppAuthorizer,
GroovyObject {
    @Autowired
    private AppJobResourceAuthorizingProvider rundeckJobAuthorizer;
    @Autowired
    private AppExecutionResourceAuthorizingProvider rundeckExecutionAuthorizer;
    @Autowired
    private AppProjectResourceAuthorizingProvider rundeckProjectAuthorizer;
    @Autowired
    private AppSystemAuthorizingProvider rundeckSystemAuthorizer;
    @Autowired
    private AppProjectAdhocResourceAuthorizingProvider rundeckProjectAdhocAuthorizer;
    @Autowired
    private AppResourceTypeAuthorizingProvider rundeckAppResourceTypeAuthorizer;
    @Autowired
    private AppProjectTypeAuthorizingProvider rundeckProjectTypeAuthorizer;
    @Autowired
    private AppProjectAclAuthorizingProvider rundeckProjectAclAuthorizer;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public RundeckAppAuthorizer() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public boolean isAuthorized(Subject subject, ResIdResolver resolver, TypedNamedAuthRequest request) throws MissingParameter {
        AuthorizingAccess access = this.getAuthorizingAccess(subject, resolver, request.getType());
        return access.isAuthorized((NamedAuthRequest)request);
    }

    public void authorize(Subject subject, ResIdResolver resolver, TypedNamedAuthRequest request) throws UnauthorizedAccess, NotFound, MissingParameter {
        AuthorizingAccess access = this.getAuthorizingAccess(subject, resolver, request.getType());
        access.authorizeNamed((NamedAuthRequest)request);
    }

    public AuthorizingAccess getAuthorizingAccess(Subject subject, ResIdResolver resolver, String type) throws MissingParameter {
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)RundeckAccess.System.TYPE)) {
            return this.system(subject);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)RundeckAccess.Project.TYPE)) {
            return this.project(subject, resolver);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)RundeckAccess.Adhoc.TYPE)) {
            return this.adhoc(subject, resolver);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)RundeckAccess.Execution.TYPE)) {
            return this.execution(subject, resolver);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)RundeckAccess.Job.TYPE)) {
            return this.job(subject, resolver);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)RundeckAccess.ProjectAcl.TYPE)) {
            return this.projectAcl(subject, resolver);
        }
        if (type.startsWith(RundeckAccess.ApplicationType.TYPE)) {
            return this.applicationType(subject, this.resourceTypeResolver(RundeckAccess.ApplicationType.TYPE, RundeckAccess.ApplicationType.kindForTypeId((String)type)));
        }
        if (type.startsWith(RundeckAccess.ProjectType.TYPE)) {
            return this.projectType(subject, this.resourceTypeResolver(resolver, RundeckAccess.ProjectType.TYPE, RundeckAccess.ProjectType.kindForTypeId((String)type)));
        }
        throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"unknown type for authorizing access: ", (CharSequence)type));
    }

    private ResIdResolver resourceTypeResolver(String typeId, String kind) {
        return this.resourceTypeResolver(null, typeId, kind);
    }

    /*
     * WARNING - void declaration
     */
    private ResIdResolver resourceTypeResolver(ResIdResolver base, String typeName, String value) {
        void var3_3;
        void var2_2;
        Reference base2 = new Reference((Object)base);
        Reference typeName2 = new Reference((Object)var2_2);
        Reference value2 = new Reference((Object)var3_3);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public AuthorizingAppType applicationType(Subject subject, ResIdResolver resolver) {
        return this.rundeckAppResourceTypeAuthorizer.getAuthorizingResource(subject, resolver);
    }

    public AuthorizingAppType applicationType(Subject subject, String type) {
        return this.rundeckAppResourceTypeAuthorizer.getAuthorizingResource(subject, type);
    }

    public AuthorizingProjectType projectType(Subject subject, ResIdResolver resolver) {
        return this.rundeckProjectTypeAuthorizer.getAuthorizingResource(subject, resolver);
    }

    public AuthorizingProjectType projectType(Subject subject, String project, String type) {
        return this.rundeckProjectTypeAuthorizer.getAuthorizingResource(subject, project, type);
    }

    public AuthorizingExecution execution(Subject subject, ResIdResolver resolver) {
        return this.rundeckExecutionAuthorizer.getAuthorizingResource(subject, resolver);
    }

    public AuthorizingExecution execution(Subject subject, String project, String id) {
        return this.rundeckExecutionAuthorizer.getAuthorizingResource(subject, project, id);
    }

    public AuthorizingJob job(Subject subject, ResIdResolver resolver) {
        return this.rundeckJobAuthorizer.getAuthorizingResource(subject, resolver);
    }

    public AuthorizingJob job(Subject subject, String project, String id) {
        return this.rundeckJobAuthorizer.getAuthorizingResource(subject, project, id);
    }

    public AuthorizingProject project(Subject subject, ResIdResolver resolver) {
        return this.rundeckProjectAuthorizer.getAuthorizingResource(subject, resolver);
    }

    public AuthorizingProject project(Subject subject, String project) {
        return this.rundeckProjectAuthorizer.getAuthorizingResource(subject, project);
    }

    public AuthorizingProjectAdhoc adhoc(Subject subject, ResIdResolver resolver) {
        return this.rundeckProjectAdhocAuthorizer.getAuthorizingResource(subject, resolver);
    }

    public AuthorizingProjectAdhoc adhoc(Subject subject, String project) {
        return this.rundeckProjectAdhocAuthorizer.getAuthorizingResource(subject, project);
    }

    public AuthorizingProjectAcl projectAcl(Subject subject, ResIdResolver resolver) {
        return this.rundeckProjectAclAuthorizer.getAuthorizingResource(subject, resolver);
    }

    public AuthorizingProjectAcl projectAcl(Subject subject, String project) {
        return this.rundeckProjectAclAuthorizer.getAuthorizingResource(subject, project);
    }

    public AuthorizingSystem system(Subject subject) {
        return this.rundeckSystemAuthorizer.getAuthorizingResource(subject, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RundeckAppAuthorizer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RundeckAppAuthorizer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RundeckAppAuthorizer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RundeckAppAuthorizer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RundeckAppAuthorizer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(RundeckAppAuthorizer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public AppJobResourceAuthorizingProvider getRundeckJobAuthorizer() {
        return this.rundeckJobAuthorizer;
    }

    @Generated
    public void setRundeckJobAuthorizer(AppJobResourceAuthorizingProvider appJobResourceAuthorizingProvider) {
        this.rundeckJobAuthorizer = appJobResourceAuthorizingProvider;
    }

    @Generated
    public AppExecutionResourceAuthorizingProvider getRundeckExecutionAuthorizer() {
        return this.rundeckExecutionAuthorizer;
    }

    @Generated
    public void setRundeckExecutionAuthorizer(AppExecutionResourceAuthorizingProvider appExecutionResourceAuthorizingProvider) {
        this.rundeckExecutionAuthorizer = appExecutionResourceAuthorizingProvider;
    }

    @Generated
    public AppProjectResourceAuthorizingProvider getRundeckProjectAuthorizer() {
        return this.rundeckProjectAuthorizer;
    }

    @Generated
    public void setRundeckProjectAuthorizer(AppProjectResourceAuthorizingProvider appProjectResourceAuthorizingProvider) {
        this.rundeckProjectAuthorizer = appProjectResourceAuthorizingProvider;
    }

    @Generated
    public AppSystemAuthorizingProvider getRundeckSystemAuthorizer() {
        return this.rundeckSystemAuthorizer;
    }

    @Generated
    public void setRundeckSystemAuthorizer(AppSystemAuthorizingProvider appSystemAuthorizingProvider) {
        this.rundeckSystemAuthorizer = appSystemAuthorizingProvider;
    }

    @Generated
    public AppProjectAdhocResourceAuthorizingProvider getRundeckProjectAdhocAuthorizer() {
        return this.rundeckProjectAdhocAuthorizer;
    }

    @Generated
    public void setRundeckProjectAdhocAuthorizer(AppProjectAdhocResourceAuthorizingProvider appProjectAdhocResourceAuthorizingProvider) {
        this.rundeckProjectAdhocAuthorizer = appProjectAdhocResourceAuthorizingProvider;
    }

    @Generated
    public AppResourceTypeAuthorizingProvider getRundeckAppResourceTypeAuthorizer() {
        return this.rundeckAppResourceTypeAuthorizer;
    }

    @Generated
    public void setRundeckAppResourceTypeAuthorizer(AppResourceTypeAuthorizingProvider appResourceTypeAuthorizingProvider) {
        this.rundeckAppResourceTypeAuthorizer = appResourceTypeAuthorizingProvider;
    }

    @Generated
    public AppProjectTypeAuthorizingProvider getRundeckProjectTypeAuthorizer() {
        return this.rundeckProjectTypeAuthorizer;
    }

    @Generated
    public void setRundeckProjectTypeAuthorizer(AppProjectTypeAuthorizingProvider appProjectTypeAuthorizingProvider) {
        this.rundeckProjectTypeAuthorizer = appProjectTypeAuthorizingProvider;
    }

    @Generated
    public AppProjectAclAuthorizingProvider getRundeckProjectAclAuthorizer() {
        return this.rundeckProjectAclAuthorizer;
    }

    @Generated
    public void setRundeckProjectAclAuthorizer(AppProjectAclAuthorizingProvider appProjectAclAuthorizingProvider) {
        this.rundeckProjectAclAuthorizer = appProjectAclAuthorizingProvider;
    }
}

