/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.web;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.rundeck.app.web.WebExceptionHandler;
import org.rundeck.app.web.WebUtilService;
import org.rundeck.core.auth.access.MissingParameter;
import org.rundeck.core.auth.access.NotFound;
import org.rundeck.core.auth.access.UnauthorizedAccess;
import org.springframework.beans.factory.annotation.Autowired;
import rundeck.error_handling.InvalidParameterException;

public class ExceptionHandler
implements WebExceptionHandler,
GroovyObject {
    @Autowired
    private WebUtilService rundeckWebUtil;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ExceptionHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public boolean handleException(HttpServletRequest request, HttpServletResponse response, Throwable thrown) {
        if (thrown instanceof UnauthorizedAccess) {
            this.handleUnauthorized(request, response, (UnauthorizedAccess)((Object)ScriptBytecodeAdapter.castToType((Object)thrown, UnauthorizedAccess.class)));
        } else if (thrown instanceof NotFound) {
            this.handleNotFound(request, response, (NotFound)((Object)ScriptBytecodeAdapter.castToType((Object)thrown, NotFound.class)));
        } else if (thrown instanceof MissingParameter) {
            this.handleMissingParameter(request, response, (MissingParameter)ScriptBytecodeAdapter.castToType((Object)thrown, MissingParameter.class));
        } else if (thrown instanceof InvalidParameterException) {
            this.handleInvalidParameter(request, response, (InvalidParameterException)ScriptBytecodeAdapter.castToType((Object)thrown, InvalidParameterException.class));
        } else {
            return false;
        }
        return true;
    }

    public void handleUnauthorized(HttpServletRequest request, HttpServletResponse response, UnauthorizedAccess access) {
        request.setAttribute("titleCode", (Object)"request.error.unauthorized.title");
        this.rundeckWebUtil.respondError(request, response, "api.error.item.unauthorized", HttpServletResponse.SC_FORBIDDEN, ScriptBytecodeAdapter.createList((Object[])new Object[]{access.getAction(), access.getType(), access.getName()}));
    }

    public void handleNotFound(HttpServletRequest request, HttpServletResponse response, NotFound notFound) {
        request.setAttribute("titleCode", (Object)"request.error.notfound.title");
        this.rundeckWebUtil.respondError(request, response, "api.error.item.doesnotexist", HttpServletResponse.SC_NOT_FOUND, ScriptBytecodeAdapter.createList((Object[])new Object[]{notFound.getType(), notFound.getName()}));
    }

    public void handleMissingParameter(HttpServletRequest request, HttpServletResponse response, MissingParameter missingParameter) {
        request.setAttribute("titleCode", (Object)"request.error.title");
        this.rundeckWebUtil.respondError(request, response, "api.error.parameter.required", HttpServletResponse.SC_BAD_REQUEST, ScriptBytecodeAdapter.createList((Object[])new Object[]{DefaultGroovyMethods.join((Iterable)missingParameter.getParameters(), (String)",")}));
    }

    public void handleInvalidParameter(HttpServletRequest request, HttpServletResponse response, InvalidParameterException invalidParameter) {
        request.setAttribute("titleCode", (Object)"request.error.title");
        this.rundeckWebUtil.respondError(request, response, "api.error.parameter.invalid", HttpServletResponse.SC_BAD_REQUEST, ScriptBytecodeAdapter.createList((Object[])new Object[]{invalidParameter.getSuppliedValue(), invalidParameter.getParamName(), invalidParameter.getErrorDescription()}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExceptionHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public WebUtilService getRundeckWebUtil() {
        return this.rundeckWebUtil;
    }

    @Generated
    public void setRundeckWebUtil(WebUtilService webUtilService) {
        this.rundeckWebUtil = webUtilService;
    }
}

