// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/run/v2/execution.proto

package runpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Executions_GetExecution_FullMethodName    = "/google.cloud.run.v2.Executions/GetExecution"
	Executions_ListExecutions_FullMethodName  = "/google.cloud.run.v2.Executions/ListExecutions"
	Executions_DeleteExecution_FullMethodName = "/google.cloud.run.v2.Executions/DeleteExecution"
	Executions_CancelExecution_FullMethodName = "/google.cloud.run.v2.Executions/CancelExecution"
)

// ExecutionsClient is the client API for Executions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ExecutionsClient interface {
	// Gets information about an Execution.
	GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Lists Executions from a Job. Results are sorted by creation time,
	// descending.
	ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error)
	// Deletes an Execution.
	DeleteExecution(ctx context.Context, in *DeleteExecutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels an Execution.
	CancelExecution(ctx context.Context, in *CancelExecutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type executionsClient struct {
	cc grpc.ClientConnInterface
}

func NewExecutionsClient(cc grpc.ClientConnInterface) ExecutionsClient {
	return &executionsClient{cc}
}

func (c *executionsClient) GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, Executions_GetExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *executionsClient) ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error) {
	out := new(ListExecutionsResponse)
	err := c.cc.Invoke(ctx, Executions_ListExecutions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *executionsClient) DeleteExecution(ctx context.Context, in *DeleteExecutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Executions_DeleteExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *executionsClient) CancelExecution(ctx context.Context, in *CancelExecutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Executions_CancelExecution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExecutionsServer is the server API for Executions service.
// All implementations should embed UnimplementedExecutionsServer
// for forward compatibility
type ExecutionsServer interface {
	// Gets information about an Execution.
	GetExecution(context.Context, *GetExecutionRequest) (*Execution, error)
	// Lists Executions from a Job. Results are sorted by creation time,
	// descending.
	ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error)
	// Deletes an Execution.
	DeleteExecution(context.Context, *DeleteExecutionRequest) (*longrunningpb.Operation, error)
	// Cancels an Execution.
	CancelExecution(context.Context, *CancelExecutionRequest) (*longrunningpb.Operation, error)
}

// UnimplementedExecutionsServer should be embedded to have forward compatible implementations.
type UnimplementedExecutionsServer struct {
}

func (UnimplementedExecutionsServer) GetExecution(context.Context, *GetExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExecution not implemented")
}
func (UnimplementedExecutionsServer) ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExecutions not implemented")
}
func (UnimplementedExecutionsServer) DeleteExecution(context.Context, *DeleteExecutionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExecution not implemented")
}
func (UnimplementedExecutionsServer) CancelExecution(context.Context, *CancelExecutionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelExecution not implemented")
}

// UnsafeExecutionsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ExecutionsServer will
// result in compilation errors.
type UnsafeExecutionsServer interface {
	mustEmbedUnimplementedExecutionsServer()
}

func RegisterExecutionsServer(s grpc.ServiceRegistrar, srv ExecutionsServer) {
	s.RegisterService(&Executions_ServiceDesc, srv)
}

func _Executions_GetExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).GetExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Executions_GetExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).GetExecution(ctx, req.(*GetExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Executions_ListExecutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExecutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).ListExecutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Executions_ListExecutions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).ListExecutions(ctx, req.(*ListExecutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Executions_DeleteExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).DeleteExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Executions_DeleteExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).DeleteExecution(ctx, req.(*DeleteExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Executions_CancelExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionsServer).CancelExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Executions_CancelExecution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionsServer).CancelExecution(ctx, req.(*CancelExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Executions_ServiceDesc is the grpc.ServiceDesc for Executions service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Executions_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.run.v2.Executions",
	HandlerType: (*ExecutionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetExecution",
			Handler:    _Executions_GetExecution_Handler,
		},
		{
			MethodName: "ListExecutions",
			Handler:    _Executions_ListExecutions_Handler,
		},
		{
			MethodName: "DeleteExecution",
			Handler:    _Executions_DeleteExecution_Handler,
		},
		{
			MethodName: "CancelExecution",
			Handler:    _Executions_CancelExecution_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/run/v2/execution.proto",
}
