// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/billing/usage_records/v1/metadata_service.proto

package usageRecords

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	MetadataService_GetUsage_FullMethodName       = "/yandex.cloud.billing.usage_records.v1.MetadataService/GetUsage"
	MetadataService_GetLabel_FullMethodName       = "/yandex.cloud.billing.usage_records.v1.MetadataService/GetLabel"
	MetadataService_GetCloud_FullMethodName       = "/yandex.cloud.billing.usage_records.v1.MetadataService/GetCloud"
	MetadataService_GetResourceIDs_FullMethodName = "/yandex.cloud.billing.usage_records.v1.MetadataService/GetResourceIDs"
)

// MetadataServiceClient is the client API for MetadataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// # MetadataService service for retrieving metadata related to usage records
//
// The MetadataService provides a set of methods for retrieving metadata and reference information
// about billing usage records within a specific billing account and date range. This metadata
// includes information about clouds, services, SKUs, labels, and resources
// to understand the available entity structure before building detailed usage reports.
//
// Required permissions:
// All methods in this service require one of the following permissions on the specified billing account:
// - `billing.accounts.getReport`
type MetadataServiceClient interface {
	// GetUsage returns usage metadata including available clouds, services, SKUs, label keys, and date ranges
	// for a specific billing account and date range.
	//
	// This method provides a view of all available entities
	// that can be used for usage reporting within the specified date range
	// for the billing account and all its sub-accounts including:
	// - List of available clouds in provided data range
	// - Available label keys that can be used for filtering or grouping
	// - Available services
	// - Available SKUs
	// - Available billing accounts (user billing account and his sub-accounts)
	//
	// Implementation details:
	// - Empty cloud_id values are translated to a "Usage is out of scope of the Cloud" designation
	// - All data is filtered to only include items that had usage during the specified date range
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetUsage(ctx context.Context, in *GetUsageRequest, opts ...grpc.CallOption) (*GetUsageResponse, error)
	// GetLabel returns available label keys and values for a specific billing account
	// with pagination support.
	//
	// This method retrieves all available label values for a specified label key
	// within the given date range. It supports filtering by label value substring
	// and provides pagination for handling large result sets.
	//
	// The method can be used in several ways:
	//   - With label_key only: Returns all values for that key with pagination
	//   - With label_key and label_value: Returns array of matching labelValues with pagination
	//   - With label_key and label_value_filter: Returns all values for that key with pagination
	//     and a separate array of labelValues from the labelValueFilters parameter
	//   - With label_key, label_value and label_value_filter: returns only an array of matching labelValues
	//     with pagination and ignores labelValueFilters (i.e., labelValueFilters won't be returned)
	//
	// Implementation details:
	// - Case-insensitive label value matching when label_value is provided
	// - When label_value is specified, label_value_filter is ignored
	// - Label values are sorted alphabetically
	// - Pagination occurs when results exceed page_size
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetLabel(ctx context.Context, in *GetLabelRequest, opts ...grpc.CallOption) (*GetLabelResponse, error)
	// GetCloud returns available folders for specified clouds within a billing account
	// with optional filtering by cloud IDs, folder IDs and pagination support.
	//
	// This method returns a hierarchical view of clouds and their folders that the user
	// has access to within the specified date range. Results can be filtered by
	// specific cloud IDs and/or folder IDs, and pagination is supported for handling
	// large result sets.
	//
	// Implementation details:
	// - The method result does not contain empty cloud id information
	// - Filtering is done using case-insensitive substring matching
	// - Only clouds with at least one folder are included in the response
	// - Folder pagination is based on folder IDs, ordered alphabetically
	// - NextPageToken is only returned when there are more results available
	// - Base64-encoded page tokens are used for pagination state
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetCloud(ctx context.Context, in *GetCloudRequest, opts ...grpc.CallOption) (*GetCloudResponse, error)
	// GetResourceIDs returns all resource IDs for a specific billing account and date range
	// with pagination support.
	//
	// This method retrieves a list of all resource IDs that have usage records
	// within the specified date range and billing account. The results can be
	// filtered by a case-insensitive substring search on the resource ID.
	//
	// Implementation details:
	// - Filtering is done using case-insensitive substring matching
	// - Only resource IDs with actual usage in the period are returned
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetResourceIDs(ctx context.Context, in *GetResourceIDsRequest, opts ...grpc.CallOption) (*GetResourceIDsResponse, error)
}

type metadataServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetadataServiceClient(cc grpc.ClientConnInterface) MetadataServiceClient {
	return &metadataServiceClient{cc}
}

func (c *metadataServiceClient) GetUsage(ctx context.Context, in *GetUsageRequest, opts ...grpc.CallOption) (*GetUsageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetUsageResponse)
	err := c.cc.Invoke(ctx, MetadataService_GetUsage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetLabel(ctx context.Context, in *GetLabelRequest, opts ...grpc.CallOption) (*GetLabelResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetLabelResponse)
	err := c.cc.Invoke(ctx, MetadataService_GetLabel_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetCloud(ctx context.Context, in *GetCloudRequest, opts ...grpc.CallOption) (*GetCloudResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetCloudResponse)
	err := c.cc.Invoke(ctx, MetadataService_GetCloud_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetResourceIDs(ctx context.Context, in *GetResourceIDsRequest, opts ...grpc.CallOption) (*GetResourceIDsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetResourceIDsResponse)
	err := c.cc.Invoke(ctx, MetadataService_GetResourceIDs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetadataServiceServer is the server API for MetadataService service.
// All implementations should embed UnimplementedMetadataServiceServer
// for forward compatibility.
//
// # MetadataService service for retrieving metadata related to usage records
//
// The MetadataService provides a set of methods for retrieving metadata and reference information
// about billing usage records within a specific billing account and date range. This metadata
// includes information about clouds, services, SKUs, labels, and resources
// to understand the available entity structure before building detailed usage reports.
//
// Required permissions:
// All methods in this service require one of the following permissions on the specified billing account:
// - `billing.accounts.getReport`
type MetadataServiceServer interface {
	// GetUsage returns usage metadata including available clouds, services, SKUs, label keys, and date ranges
	// for a specific billing account and date range.
	//
	// This method provides a view of all available entities
	// that can be used for usage reporting within the specified date range
	// for the billing account and all its sub-accounts including:
	// - List of available clouds in provided data range
	// - Available label keys that can be used for filtering or grouping
	// - Available services
	// - Available SKUs
	// - Available billing accounts (user billing account and his sub-accounts)
	//
	// Implementation details:
	// - Empty cloud_id values are translated to a "Usage is out of scope of the Cloud" designation
	// - All data is filtered to only include items that had usage during the specified date range
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetUsage(context.Context, *GetUsageRequest) (*GetUsageResponse, error)
	// GetLabel returns available label keys and values for a specific billing account
	// with pagination support.
	//
	// This method retrieves all available label values for a specified label key
	// within the given date range. It supports filtering by label value substring
	// and provides pagination for handling large result sets.
	//
	// The method can be used in several ways:
	//   - With label_key only: Returns all values for that key with pagination
	//   - With label_key and label_value: Returns array of matching labelValues with pagination
	//   - With label_key and label_value_filter: Returns all values for that key with pagination
	//     and a separate array of labelValues from the labelValueFilters parameter
	//   - With label_key, label_value and label_value_filter: returns only an array of matching labelValues
	//     with pagination and ignores labelValueFilters (i.e., labelValueFilters won't be returned)
	//
	// Implementation details:
	// - Case-insensitive label value matching when label_value is provided
	// - When label_value is specified, label_value_filter is ignored
	// - Label values are sorted alphabetically
	// - Pagination occurs when results exceed page_size
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetLabel(context.Context, *GetLabelRequest) (*GetLabelResponse, error)
	// GetCloud returns available folders for specified clouds within a billing account
	// with optional filtering by cloud IDs, folder IDs and pagination support.
	//
	// This method returns a hierarchical view of clouds and their folders that the user
	// has access to within the specified date range. Results can be filtered by
	// specific cloud IDs and/or folder IDs, and pagination is supported for handling
	// large result sets.
	//
	// Implementation details:
	// - The method result does not contain empty cloud id information
	// - Filtering is done using case-insensitive substring matching
	// - Only clouds with at least one folder are included in the response
	// - Folder pagination is based on folder IDs, ordered alphabetically
	// - NextPageToken is only returned when there are more results available
	// - Base64-encoded page tokens are used for pagination state
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetCloud(context.Context, *GetCloudRequest) (*GetCloudResponse, error)
	// GetResourceIDs returns all resource IDs for a specific billing account and date range
	// with pagination support.
	//
	// This method retrieves a list of all resource IDs that have usage records
	// within the specified date range and billing account. The results can be
	// filtered by a case-insensitive substring search on the resource ID.
	//
	// Implementation details:
	// - Filtering is done using case-insensitive substring matching
	// - Only resource IDs with actual usage in the period are returned
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetResourceIDs(context.Context, *GetResourceIDsRequest) (*GetResourceIDsResponse, error)
}

// UnimplementedMetadataServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedMetadataServiceServer struct{}

func (UnimplementedMetadataServiceServer) GetUsage(context.Context, *GetUsageRequest) (*GetUsageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUsage not implemented")
}
func (UnimplementedMetadataServiceServer) GetLabel(context.Context, *GetLabelRequest) (*GetLabelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLabel not implemented")
}
func (UnimplementedMetadataServiceServer) GetCloud(context.Context, *GetCloudRequest) (*GetCloudResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCloud not implemented")
}
func (UnimplementedMetadataServiceServer) GetResourceIDs(context.Context, *GetResourceIDsRequest) (*GetResourceIDsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetResourceIDs not implemented")
}
func (UnimplementedMetadataServiceServer) testEmbeddedByValue() {}

// UnsafeMetadataServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MetadataServiceServer will
// result in compilation errors.
type UnsafeMetadataServiceServer interface {
	mustEmbedUnimplementedMetadataServiceServer()
}

func RegisterMetadataServiceServer(s grpc.ServiceRegistrar, srv MetadataServiceServer) {
	// If the following call pancis, it indicates UnimplementedMetadataServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&MetadataService_ServiceDesc, srv)
}

func _MetadataService_GetUsage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUsageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetUsage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetUsage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetUsage(ctx, req.(*GetUsageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetLabel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetLabel(ctx, req.(*GetLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetCloud_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetCloud(ctx, req.(*GetCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetResourceIDs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetResourceIDsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetResourceIDs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetadataService_GetResourceIDs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetResourceIDs(ctx, req.(*GetResourceIDsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MetadataService_ServiceDesc is the grpc.ServiceDesc for MetadataService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MetadataService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.billing.usage_records.v1.MetadataService",
	HandlerType: (*MetadataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetUsage",
			Handler:    _MetadataService_GetUsage_Handler,
		},
		{
			MethodName: "GetLabel",
			Handler:    _MetadataService_GetLabel_Handler,
		},
		{
			MethodName: "GetCloud",
			Handler:    _MetadataService_GetCloud_Handler,
		},
		{
			MethodName: "GetResourceIDs",
			Handler:    _MetadataService_GetResourceIDs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/billing/usage_records/v1/metadata_service.proto",
}
