# Go API client for v0038

API to access Slurm. Only GET requests are implemented.

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 0.0.38
- Package version: 1.0.0
- Generator version: 7.7.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen
For more information, please visit [https://www.schedmd.com/](https://www.schedmd.com/)

## Installation

Install the following dependencies:

```sh
go get github.com/stretchr/testify/assert
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```go
import v0038 "github.com/pcolladosoto/goslurm/v0038"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```go
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `v0038.ContextServerIndex` of type `int`.

```go
ctx := context.WithValue(context.Background(), v0038.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `v0038.ContextServerVariables` of type `map[string]string`.

```go
ctx := context.WithValue(context.Background(), v0038.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `v0038.ContextOperationServerIndices` and `v0038.ContextOperationServerVariables` context maps.

```go
ctx := context.WithValue(context.Background(), v0038.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), v0038.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OpenapiAPI* | [**OpenapiGet**](docs/OpenapiAPI.md#openapiget) | **Get** /openapi | Retrieve OpenAPI Specification
*OpenapiAPI* | [**OpenapiJsonGet**](docs/OpenapiAPI.md#openapijsonget) | **Get** /openapi.json | Retrieve OpenAPI Specification
*OpenapiAPI* | [**OpenapiV3Get**](docs/OpenapiAPI.md#openapiv3get) | **Get** /openapi/v3 | Retrieve OpenAPI Specification
*OpenapiAPI* | [**OpenapiYamlGet**](docs/OpenapiAPI.md#openapiyamlget) | **Get** /openapi.yaml | Retrieve OpenAPI Specification
*SlurmAPI* | [**SlurmV0038Diag**](docs/SlurmAPI.md#slurmv0038diag) | **Get** /slurm/v0.0.38/diag | get diagnostics
*SlurmAPI* | [**SlurmV0038GetJob**](docs/SlurmAPI.md#slurmv0038getjob) | **Get** /slurm/v0.0.38/job/{job_id} | get job info
*SlurmAPI* | [**SlurmV0038GetJobs**](docs/SlurmAPI.md#slurmv0038getjobs) | **Get** /slurm/v0.0.38/jobs | get list of jobs
*SlurmAPI* | [**SlurmV0038GetNode**](docs/SlurmAPI.md#slurmv0038getnode) | **Get** /slurm/v0.0.38/node/{node_name} | get node info
*SlurmAPI* | [**SlurmV0038GetNodes**](docs/SlurmAPI.md#slurmv0038getnodes) | **Get** /slurm/v0.0.38/nodes | get all node info
*SlurmAPI* | [**SlurmV0038GetPartition**](docs/SlurmAPI.md#slurmv0038getpartition) | **Get** /slurm/v0.0.38/partition/{partition_name} | get partition info
*SlurmAPI* | [**SlurmV0038GetPartitions**](docs/SlurmAPI.md#slurmv0038getpartitions) | **Get** /slurm/v0.0.38/partitions | get all partition info
*SlurmAPI* | [**SlurmV0038GetReservation**](docs/SlurmAPI.md#slurmv0038getreservation) | **Get** /slurm/v0.0.38/reservation/{reservation_name} | get reservation info
*SlurmAPI* | [**SlurmV0038GetReservations**](docs/SlurmAPI.md#slurmv0038getreservations) | **Get** /slurm/v0.0.38/reservations | get all reservation info
*SlurmAPI* | [**SlurmV0038Ping**](docs/SlurmAPI.md#slurmv0038ping) | **Get** /slurm/v0.0.38/ping | ping test
*SlurmAPI* | [**SlurmV0038SlurmctldGetLicenses**](docs/SlurmAPI.md#slurmv0038slurmctldgetlicenses) | **Get** /slurm/v0.0.38/licenses | get all Slurm tracked license info


## Documentation For Models

 - [V0038Diag](docs/V0038Diag.md)
 - [V0038DiagRpcm](docs/V0038DiagRpcm.md)
 - [V0038DiagRpcu](docs/V0038DiagRpcu.md)
 - [V0038DiagStatistics](docs/V0038DiagStatistics.md)
 - [V0038Error](docs/V0038Error.md)
 - [V0038Errors](docs/V0038Errors.md)
 - [V0038JobProperties](docs/V0038JobProperties.md)
 - [V0038JobResources](docs/V0038JobResources.md)
 - [V0038JobResponseProperties](docs/V0038JobResponseProperties.md)
 - [V0038JobsResponse](docs/V0038JobsResponse.md)
 - [V0038License](docs/V0038License.md)
 - [V0038Licenses](docs/V0038Licenses.md)
 - [V0038Meta](docs/V0038Meta.md)
 - [V0038MetaPlugin](docs/V0038MetaPlugin.md)
 - [V0038MetaSlurm](docs/V0038MetaSlurm.md)
 - [V0038MetaSlurmVersion](docs/V0038MetaSlurmVersion.md)
 - [V0038Node](docs/V0038Node.md)
 - [V0038NodeAllocation](docs/V0038NodeAllocation.md)
 - [V0038NodeAllocationSockets](docs/V0038NodeAllocationSockets.md)
 - [V0038NodesResponse](docs/V0038NodesResponse.md)
 - [V0038Partition](docs/V0038Partition.md)
 - [V0038PartitionsResponse](docs/V0038PartitionsResponse.md)
 - [V0038Ping](docs/V0038Ping.md)
 - [V0038Pings](docs/V0038Pings.md)
 - [V0038Reservation](docs/V0038Reservation.md)
 - [V0038ReservationPurgeCompleted](docs/V0038ReservationPurgeCompleted.md)
 - [V0038ReservationsResponse](docs/V0038ReservationsResponse.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### user

- **Type**: API key
- **API key parameter name**: X-SLURM-USER-NAME
- **Location**: HTTP header

Note, each API key must be added to a map of `map[string]APIKey` where the key is: X-SLURM-USER-NAME and passed in as the auth context for each request.

Example

```go
auth := context.WithValue(
		context.Background(),
		v0038.ContextAPIKeys,
		map[string]v0038.APIKey{
			"X-SLURM-USER-NAME": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```

### token

- **Type**: API key
- **API key parameter name**: X-SLURM-USER-TOKEN
- **Location**: HTTP header

Note, each API key must be added to a map of `map[string]APIKey` where the key is: X-SLURM-USER-TOKEN and passed in as the auth context for each request.

Example

```go
auth := context.WithValue(
		context.Background(),
		v0038.ContextAPIKeys,
		map[string]v0038.APIKey{
			"X-SLURM-USER-TOKEN": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author

sales@schedmd.com

