# How to contribute

First of all, thanks for your interest in contributing to this project!

#### Guidelines

Here are some guidelines to keep in mind when contributing:

- Please try to limit each pull request to one change, as this makes it much easier to manage; small pull requests are fine :)
- Please make sure that the tests pass, including EPUBCheck (see [README.md](README.md#epubcheck) for more information on EPUBCheck)
- If you're adding new features, please add new tests to cover them
- Please try to avoid making breaking changes to the API; it would be preferable to add a new method for a new feature rather than modify an existing one
- Please document any newly-added public methods

#### Optional

These are nice as well, although they won't prevent a pull request from getting merged:

- This project uses `go fmt` for formatting
- This project uses [Conventional Commits](https://www.conventionalcommits.org)
- This project uses [examples](https://pkg.go.dev/testing#hdr-Examples) where useful to make the documentation more clear

Cheers!
