// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2/conversation_dataset.proto

package dialogflowpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents metadata of a conversation.
type ConversationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The language code of the conversation data within this dataset.
	// See https://cloud.google.com/apis/design/standard_fields for more
	// information. Supports all UTF-8 languages.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ConversationInfo) Reset() {
	*x = ConversationInfo{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationInfo) ProtoMessage() {}

func (x *ConversationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationInfo.ProtoReflect.Descriptor instead.
func (*ConversationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{0}
}

func (x *ConversationInfo) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Represents the configuration of importing a set of conversation files in
// Google Cloud Storage.
type InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Where the data is from.
	//
	// Types that are assignable to Source:
	//
	//	*InputConfig_GcsSource
	Source isInputConfig_Source `protobuf_oneof:"source"`
}

func (x *InputConfig) Reset() {
	*x = InputConfig{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputConfig) ProtoMessage() {}

func (x *InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputConfig.ProtoReflect.Descriptor instead.
func (*InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{1}
}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *InputConfig) GetGcsSource() *GcsSources {
	if x, ok := x.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	// The Cloud Storage URI has the form gs://<Google Cloud Storage bucket
	// name>//agent*.json. Wildcards are allowed and will be expanded into all
	// matched JSON files, which will be read as one conversation per file.
	GcsSource *GcsSources `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

// Represents a conversation dataset that a user imports raw data into.
// The data inside ConversationDataset can not be changed after
// ImportConversationData finishes (and calling ImportConversationData on a
// dataset that already has data is not allowed).
type ConversationDataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. ConversationDataset resource name. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationDatasets/<Conversation Dataset ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the dataset. Maximum of 64 bytes.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the dataset. Maximum of 10000 bytes.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Creation time of this dataset.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Input configurations set during conversation data import.
	InputConfig *InputConfig `protobuf:"bytes,5,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Output only. Metadata set during conversation data import.
	ConversationInfo *ConversationInfo `protobuf:"bytes,6,opt,name=conversation_info,json=conversationInfo,proto3" json:"conversation_info,omitempty"`
	// Output only. The number of conversations this conversation dataset
	// contains.
	ConversationCount int64 `protobuf:"varint,7,opt,name=conversation_count,json=conversationCount,proto3" json:"conversation_count,omitempty"`
	// Output only. A read only boolean field reflecting Zone Isolation status of
	// the dataset.
	SatisfiesPzi *bool `protobuf:"varint,8,opt,name=satisfies_pzi,json=satisfiesPzi,proto3,oneof" json:"satisfies_pzi,omitempty"`
	// Output only. A read only boolean field reflecting Zone Separation status of
	// the dataset.
	SatisfiesPzs *bool `protobuf:"varint,9,opt,name=satisfies_pzs,json=satisfiesPzs,proto3,oneof" json:"satisfies_pzs,omitempty"`
}

func (x *ConversationDataset) Reset() {
	*x = ConversationDataset{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationDataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationDataset) ProtoMessage() {}

func (x *ConversationDataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationDataset.ProtoReflect.Descriptor instead.
func (*ConversationDataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{2}
}

func (x *ConversationDataset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConversationDataset) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ConversationDataset) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ConversationDataset) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConversationDataset) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *ConversationDataset) GetConversationInfo() *ConversationInfo {
	if x != nil {
		return x.ConversationInfo
	}
	return nil
}

func (x *ConversationDataset) GetConversationCount() int64 {
	if x != nil {
		return x.ConversationCount
	}
	return 0
}

func (x *ConversationDataset) GetSatisfiesPzi() bool {
	if x != nil && x.SatisfiesPzi != nil {
		return *x.SatisfiesPzi
	}
	return false
}

func (x *ConversationDataset) GetSatisfiesPzs() bool {
	if x != nil && x.SatisfiesPzs != nil {
		return *x.SatisfiesPzs
	}
	return false
}

// The request message for
// [ConversationDatasets.CreateConversationDataset][google.cloud.dialogflow.v2.ConversationDatasets.CreateConversationDataset].
type CreateConversationDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to create conversation dataset for. Format:
	// `projects/<Project ID>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The conversation dataset to create.
	ConversationDataset *ConversationDataset `protobuf:"bytes,2,opt,name=conversation_dataset,json=conversationDataset,proto3" json:"conversation_dataset,omitempty"`
}

func (x *CreateConversationDatasetRequest) Reset() {
	*x = CreateConversationDatasetRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateConversationDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationDatasetRequest) ProtoMessage() {}

func (x *CreateConversationDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationDatasetRequest.ProtoReflect.Descriptor instead.
func (*CreateConversationDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{3}
}

func (x *CreateConversationDatasetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConversationDatasetRequest) GetConversationDataset() *ConversationDataset {
	if x != nil {
		return x.ConversationDataset
	}
	return nil
}

// The request message for
// [ConversationDatasets.GetConversationDataset][google.cloud.dialogflow.v2.ConversationDatasets.GetConversationDataset].
type GetConversationDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation dataset to retrieve. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationDatasets/<Conversation Dataset ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversationDatasetRequest) Reset() {
	*x = GetConversationDatasetRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConversationDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationDatasetRequest) ProtoMessage() {}

func (x *GetConversationDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationDatasetRequest.ProtoReflect.Descriptor instead.
func (*GetConversationDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{4}
}

func (x *GetConversationDatasetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [ConversationDatasets.ListConversationDatasets][google.cloud.dialogflow.v2.ConversationDatasets.ListConversationDatasets].
type ListConversationDatasetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location name to list all conversation datasets
	// for. Format: `projects/<Project ID>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of conversation datasets to return in a single
	// page. By default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConversationDatasetsRequest) Reset() {
	*x = ListConversationDatasetsRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConversationDatasetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationDatasetsRequest) ProtoMessage() {}

func (x *ListConversationDatasetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationDatasetsRequest.ProtoReflect.Descriptor instead.
func (*ListConversationDatasetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{5}
}

func (x *ListConversationDatasetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversationDatasetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversationDatasetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [ConversationDatasets.ListConversationDatasets][google.cloud.dialogflow.v2.ConversationDatasets.ListConversationDatasets].
type ListConversationDatasetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of datasets to return.
	ConversationDatasets []*ConversationDataset `protobuf:"bytes,1,rep,name=conversation_datasets,json=conversationDatasets,proto3" json:"conversation_datasets,omitempty"`
	// The token to use to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversationDatasetsResponse) Reset() {
	*x = ListConversationDatasetsResponse{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConversationDatasetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationDatasetsResponse) ProtoMessage() {}

func (x *ListConversationDatasetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationDatasetsResponse.ProtoReflect.Descriptor instead.
func (*ListConversationDatasetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{6}
}

func (x *ListConversationDatasetsResponse) GetConversationDatasets() []*ConversationDataset {
	if x != nil {
		return x.ConversationDatasets
	}
	return nil
}

func (x *ListConversationDatasetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [ConversationDatasets.DeleteConversationDataset][google.cloud.dialogflow.v2.ConversationDatasets.DeleteConversationDataset].
type DeleteConversationDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation dataset to delete. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationDatasets/<Conversation Dataset ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConversationDatasetRequest) Reset() {
	*x = DeleteConversationDatasetRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteConversationDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversationDatasetRequest) ProtoMessage() {}

func (x *DeleteConversationDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversationDatasetRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversationDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteConversationDatasetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [ConversationDatasets.ImportConversationData][google.cloud.dialogflow.v2.ConversationDatasets.ImportConversationData].
type ImportConversationDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Dataset resource name. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationDatasets/<Conversation Dataset ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Configuration describing where to import data from.
	InputConfig *InputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
}

func (x *ImportConversationDataRequest) Reset() {
	*x = ImportConversationDataRequest{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportConversationDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportConversationDataRequest) ProtoMessage() {}

func (x *ImportConversationDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportConversationDataRequest.ProtoReflect.Descriptor instead.
func (*ImportConversationDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{8}
}

func (x *ImportConversationDataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImportConversationDataRequest) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

// Metadata for a
// [ConversationDatasets.ImportConversationData][google.cloud.dialogflow.v2.ConversationDatasets.ImportConversationData]
// operation.
type ImportConversationDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the imported conversation dataset. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationDatasets/<Conversation Dataset Id>`
	ConversationDataset string `protobuf:"bytes,1,opt,name=conversation_dataset,json=conversationDataset,proto3" json:"conversation_dataset,omitempty"`
	// Partial failures are failures that don't fail the whole long running
	// operation, e.g. single files that couldn't be read.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Timestamp when import conversation data request was created. The time is
	// measured on server side.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *ImportConversationDataOperationMetadata) Reset() {
	*x = ImportConversationDataOperationMetadata{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportConversationDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportConversationDataOperationMetadata) ProtoMessage() {}

func (x *ImportConversationDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportConversationDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*ImportConversationDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{9}
}

func (x *ImportConversationDataOperationMetadata) GetConversationDataset() string {
	if x != nil {
		return x.ConversationDataset
	}
	return ""
}

func (x *ImportConversationDataOperationMetadata) GetPartialFailures() []*status.Status {
	if x != nil {
		return x.PartialFailures
	}
	return nil
}

func (x *ImportConversationDataOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Response used for
// [ConversationDatasets.ImportConversationData][google.cloud.dialogflow.v2.ConversationDatasets.ImportConversationData]
// long running operation.
type ImportConversationDataOperationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the imported conversation dataset. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationDatasets/<Conversation Dataset Id>`
	ConversationDataset string `protobuf:"bytes,1,opt,name=conversation_dataset,json=conversationDataset,proto3" json:"conversation_dataset,omitempty"`
	// Number of conversations imported successfully.
	ImportCount int32 `protobuf:"varint,3,opt,name=import_count,json=importCount,proto3" json:"import_count,omitempty"`
}

func (x *ImportConversationDataOperationResponse) Reset() {
	*x = ImportConversationDataOperationResponse{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportConversationDataOperationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportConversationDataOperationResponse) ProtoMessage() {}

func (x *ImportConversationDataOperationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportConversationDataOperationResponse.ProtoReflect.Descriptor instead.
func (*ImportConversationDataOperationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{10}
}

func (x *ImportConversationDataOperationResponse) GetConversationDataset() string {
	if x != nil {
		return x.ConversationDataset
	}
	return ""
}

func (x *ImportConversationDataOperationResponse) GetImportCount() int32 {
	if x != nil {
		return x.ImportCount
	}
	return 0
}

// Metadata for [CreateConversationDataset][].
type CreateConversationDatasetOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the conversation dataset that will be created. Format:
	// `projects/<Project ID>/locations/<Location
	// ID>/conversationDatasets/<Conversation Dataset Id>`
	ConversationDataset string `protobuf:"bytes,1,opt,name=conversation_dataset,json=conversationDataset,proto3" json:"conversation_dataset,omitempty"`
}

func (x *CreateConversationDatasetOperationMetadata) Reset() {
	*x = CreateConversationDatasetOperationMetadata{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateConversationDatasetOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversationDatasetOperationMetadata) ProtoMessage() {}

func (x *CreateConversationDatasetOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversationDatasetOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateConversationDatasetOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{11}
}

func (x *CreateConversationDatasetOperationMetadata) GetConversationDataset() string {
	if x != nil {
		return x.ConversationDataset
	}
	return ""
}

// Metadata for [DeleteConversationDataset][].
type DeleteConversationDatasetOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteConversationDatasetOperationMetadata) Reset() {
	*x = DeleteConversationDatasetOperationMetadata{}
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteConversationDatasetOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversationDatasetOperationMetadata) ProtoMessage() {}

func (x *DeleteConversationDatasetOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversationDatasetOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteConversationDatasetOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP(), []int{12}
}

var File_google_cloud_dialogflow_v2_conversation_dataset_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x76, 0x32, 0x2f, 0x67, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3c, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x60, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xb1, 0x05, 0x0a, 0x13, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a, 0x11, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32, 0x0a, 0x12, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x2d, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x73,
	0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x88, 0x01, 0x01, 0x12, 0x2d,
	0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0c, 0x73, 0x61,
	0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x88, 0x01, 0x01, 0x3a, 0x88, 0x01,
	0xea, 0x41, 0x84, 0x01, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x74,
	0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73,
	0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x22, 0xa8, 0x01, 0x0a,
	0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x67,
	0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x6a, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12,
	0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb0, 0x01, 0x0a,
	0x20, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x64, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x6d, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbb,
	0x01, 0x0a, 0x1d, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8c, 0x02, 0x0a,
	0x27, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x65, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12,
	0x3d, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb3, 0x01, 0x0a, 0x27,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x21,
	0x0a, 0x0c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0x93, 0x01, 0x0a, 0x2a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x65, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x2c, 0x0a, 0x2a, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0xd6, 0x0c, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0xb3,
	0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb8, 0x01, 0xca, 0x41, 0x41, 0x0a,
	0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x12, 0x2a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x50, 0x3a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x38, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x73, 0x12, 0xfd, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22, 0x77, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x5a, 0x3a, 0x12, 0x38, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x90, 0x02, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x79, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x5a, 0x3a, 0x12,
	0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x88, 0x02, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x8d, 0x01, 0xca, 0x41, 0x43, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x2a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xef, 0x02, 0x0a, 0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xfa, 0x01, 0xca, 0x41, 0x52, 0x0a, 0x27, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x9e, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x54, 0x3a, 0x01, 0x2a, 0x22, 0x4f,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x22,
	0x43, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x61, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x9e,
	0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x42, 0x18, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x32, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62,
	0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xa2, 0x02, 0x02,
	0x44, 0x46, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescData = file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDesc
)

func file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDescData
}

var file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_dialogflow_v2_conversation_dataset_proto_goTypes = []any{
	(*ConversationInfo)(nil),                           // 0: google.cloud.dialogflow.v2.ConversationInfo
	(*InputConfig)(nil),                                // 1: google.cloud.dialogflow.v2.InputConfig
	(*ConversationDataset)(nil),                        // 2: google.cloud.dialogflow.v2.ConversationDataset
	(*CreateConversationDatasetRequest)(nil),           // 3: google.cloud.dialogflow.v2.CreateConversationDatasetRequest
	(*GetConversationDatasetRequest)(nil),              // 4: google.cloud.dialogflow.v2.GetConversationDatasetRequest
	(*ListConversationDatasetsRequest)(nil),            // 5: google.cloud.dialogflow.v2.ListConversationDatasetsRequest
	(*ListConversationDatasetsResponse)(nil),           // 6: google.cloud.dialogflow.v2.ListConversationDatasetsResponse
	(*DeleteConversationDatasetRequest)(nil),           // 7: google.cloud.dialogflow.v2.DeleteConversationDatasetRequest
	(*ImportConversationDataRequest)(nil),              // 8: google.cloud.dialogflow.v2.ImportConversationDataRequest
	(*ImportConversationDataOperationMetadata)(nil),    // 9: google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata
	(*ImportConversationDataOperationResponse)(nil),    // 10: google.cloud.dialogflow.v2.ImportConversationDataOperationResponse
	(*CreateConversationDatasetOperationMetadata)(nil), // 11: google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata
	(*DeleteConversationDatasetOperationMetadata)(nil), // 12: google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata
	(*GcsSources)(nil),                                 // 13: google.cloud.dialogflow.v2.GcsSources
	(*timestamppb.Timestamp)(nil),                      // 14: google.protobuf.Timestamp
	(*status.Status)(nil),                              // 15: google.rpc.Status
	(*longrunningpb.Operation)(nil),                    // 16: google.longrunning.Operation
}
var file_google_cloud_dialogflow_v2_conversation_dataset_proto_depIdxs = []int32{
	13, // 0: google.cloud.dialogflow.v2.InputConfig.gcs_source:type_name -> google.cloud.dialogflow.v2.GcsSources
	14, // 1: google.cloud.dialogflow.v2.ConversationDataset.create_time:type_name -> google.protobuf.Timestamp
	1,  // 2: google.cloud.dialogflow.v2.ConversationDataset.input_config:type_name -> google.cloud.dialogflow.v2.InputConfig
	0,  // 3: google.cloud.dialogflow.v2.ConversationDataset.conversation_info:type_name -> google.cloud.dialogflow.v2.ConversationInfo
	2,  // 4: google.cloud.dialogflow.v2.CreateConversationDatasetRequest.conversation_dataset:type_name -> google.cloud.dialogflow.v2.ConversationDataset
	2,  // 5: google.cloud.dialogflow.v2.ListConversationDatasetsResponse.conversation_datasets:type_name -> google.cloud.dialogflow.v2.ConversationDataset
	1,  // 6: google.cloud.dialogflow.v2.ImportConversationDataRequest.input_config:type_name -> google.cloud.dialogflow.v2.InputConfig
	15, // 7: google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata.partial_failures:type_name -> google.rpc.Status
	14, // 8: google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	3,  // 9: google.cloud.dialogflow.v2.ConversationDatasets.CreateConversationDataset:input_type -> google.cloud.dialogflow.v2.CreateConversationDatasetRequest
	4,  // 10: google.cloud.dialogflow.v2.ConversationDatasets.GetConversationDataset:input_type -> google.cloud.dialogflow.v2.GetConversationDatasetRequest
	5,  // 11: google.cloud.dialogflow.v2.ConversationDatasets.ListConversationDatasets:input_type -> google.cloud.dialogflow.v2.ListConversationDatasetsRequest
	7,  // 12: google.cloud.dialogflow.v2.ConversationDatasets.DeleteConversationDataset:input_type -> google.cloud.dialogflow.v2.DeleteConversationDatasetRequest
	8,  // 13: google.cloud.dialogflow.v2.ConversationDatasets.ImportConversationData:input_type -> google.cloud.dialogflow.v2.ImportConversationDataRequest
	16, // 14: google.cloud.dialogflow.v2.ConversationDatasets.CreateConversationDataset:output_type -> google.longrunning.Operation
	2,  // 15: google.cloud.dialogflow.v2.ConversationDatasets.GetConversationDataset:output_type -> google.cloud.dialogflow.v2.ConversationDataset
	6,  // 16: google.cloud.dialogflow.v2.ConversationDatasets.ListConversationDatasets:output_type -> google.cloud.dialogflow.v2.ListConversationDatasetsResponse
	16, // 17: google.cloud.dialogflow.v2.ConversationDatasets.DeleteConversationDataset:output_type -> google.longrunning.Operation
	16, // 18: google.cloud.dialogflow.v2.ConversationDatasets.ImportConversationData:output_type -> google.longrunning.Operation
	14, // [14:19] is the sub-list for method output_type
	9,  // [9:14] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2_conversation_dataset_proto_init() }
func file_google_cloud_dialogflow_v2_conversation_dataset_proto_init() {
	if File_google_cloud_dialogflow_v2_conversation_dataset_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2_gcs_proto_init()
	file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[1].OneofWrappers = []any{
		(*InputConfig_GcsSource)(nil),
	}
	file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes[2].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2_conversation_dataset_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2_conversation_dataset_proto_depIdxs,
		MessageInfos:      file_google_cloud_dialogflow_v2_conversation_dataset_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2_conversation_dataset_proto = out.File
	file_google_cloud_dialogflow_v2_conversation_dataset_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2_conversation_dataset_proto_goTypes = nil
	file_google_cloud_dialogflow_v2_conversation_dataset_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConversationDatasetsClient is the client API for ConversationDatasets service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConversationDatasetsClient interface {
	// Creates a new conversation dataset.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [CreateConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata]
	// - `response`:
	// [ConversationDataset][google.cloud.dialogflow.v2.ConversationDataset]
	CreateConversationDataset(ctx context.Context, in *CreateConversationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves the specified conversation dataset.
	GetConversationDataset(ctx context.Context, in *GetConversationDatasetRequest, opts ...grpc.CallOption) (*ConversationDataset, error)
	// Returns the list of all conversation datasets in the specified
	// project and location.
	ListConversationDatasets(ctx context.Context, in *ListConversationDatasetsRequest, opts ...grpc.CallOption) (*ListConversationDatasetsResponse, error)
	// Deletes the specified conversation dataset.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeleteConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteConversationDataset(ctx context.Context, in *DeleteConversationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Import data into the specified conversation dataset. Note that it
	// is not allowed to import data to a conversation dataset that
	// already has data in it.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportConversationDataOperationMetadata][google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata]
	// - `response`:
	// [ImportConversationDataOperationResponse][google.cloud.dialogflow.v2.ImportConversationDataOperationResponse]
	ImportConversationData(ctx context.Context, in *ImportConversationDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type conversationDatasetsClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationDatasetsClient(cc grpc.ClientConnInterface) ConversationDatasetsClient {
	return &conversationDatasetsClient{cc}
}

func (c *conversationDatasetsClient) CreateConversationDataset(ctx context.Context, in *CreateConversationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationDatasets/CreateConversationDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationDatasetsClient) GetConversationDataset(ctx context.Context, in *GetConversationDatasetRequest, opts ...grpc.CallOption) (*ConversationDataset, error) {
	out := new(ConversationDataset)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationDatasets/GetConversationDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationDatasetsClient) ListConversationDatasets(ctx context.Context, in *ListConversationDatasetsRequest, opts ...grpc.CallOption) (*ListConversationDatasetsResponse, error) {
	out := new(ListConversationDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationDatasets/ListConversationDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationDatasetsClient) DeleteConversationDataset(ctx context.Context, in *DeleteConversationDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationDatasets/DeleteConversationDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationDatasetsClient) ImportConversationData(ctx context.Context, in *ImportConversationDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.ConversationDatasets/ImportConversationData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationDatasetsServer is the server API for ConversationDatasets service.
type ConversationDatasetsServer interface {
	// Creates a new conversation dataset.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [CreateConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata]
	// - `response`:
	// [ConversationDataset][google.cloud.dialogflow.v2.ConversationDataset]
	CreateConversationDataset(context.Context, *CreateConversationDatasetRequest) (*longrunningpb.Operation, error)
	// Retrieves the specified conversation dataset.
	GetConversationDataset(context.Context, *GetConversationDatasetRequest) (*ConversationDataset, error)
	// Returns the list of all conversation datasets in the specified
	// project and location.
	ListConversationDatasets(context.Context, *ListConversationDatasetsRequest) (*ListConversationDatasetsResponse, error)
	// Deletes the specified conversation dataset.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeleteConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteConversationDataset(context.Context, *DeleteConversationDatasetRequest) (*longrunningpb.Operation, error)
	// Import data into the specified conversation dataset. Note that it
	// is not allowed to import data to a conversation dataset that
	// already has data in it.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportConversationDataOperationMetadata][google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata]
	// - `response`:
	// [ImportConversationDataOperationResponse][google.cloud.dialogflow.v2.ImportConversationDataOperationResponse]
	ImportConversationData(context.Context, *ImportConversationDataRequest) (*longrunningpb.Operation, error)
}

// UnimplementedConversationDatasetsServer can be embedded to have forward compatible implementations.
type UnimplementedConversationDatasetsServer struct {
}

func (*UnimplementedConversationDatasetsServer) CreateConversationDataset(context.Context, *CreateConversationDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateConversationDataset not implemented")
}
func (*UnimplementedConversationDatasetsServer) GetConversationDataset(context.Context, *GetConversationDatasetRequest) (*ConversationDataset, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetConversationDataset not implemented")
}
func (*UnimplementedConversationDatasetsServer) ListConversationDatasets(context.Context, *ListConversationDatasetsRequest) (*ListConversationDatasetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListConversationDatasets not implemented")
}
func (*UnimplementedConversationDatasetsServer) DeleteConversationDataset(context.Context, *DeleteConversationDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteConversationDataset not implemented")
}
func (*UnimplementedConversationDatasetsServer) ImportConversationData(context.Context, *ImportConversationDataRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ImportConversationData not implemented")
}

func RegisterConversationDatasetsServer(s *grpc.Server, srv ConversationDatasetsServer) {
	s.RegisterService(&_ConversationDatasets_serviceDesc, srv)
}

func _ConversationDatasets_CreateConversationDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).CreateConversationDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationDatasets/CreateConversationDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).CreateConversationDataset(ctx, req.(*CreateConversationDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationDatasets_GetConversationDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).GetConversationDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationDatasets/GetConversationDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).GetConversationDataset(ctx, req.(*GetConversationDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationDatasets_ListConversationDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).ListConversationDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationDatasets/ListConversationDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).ListConversationDatasets(ctx, req.(*ListConversationDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationDatasets_DeleteConversationDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).DeleteConversationDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationDatasets/DeleteConversationDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).DeleteConversationDataset(ctx, req.(*DeleteConversationDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationDatasets_ImportConversationData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportConversationDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationDatasetsServer).ImportConversationData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.ConversationDatasets/ImportConversationData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationDatasetsServer).ImportConversationData(ctx, req.(*ImportConversationDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConversationDatasets_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.ConversationDatasets",
	HandlerType: (*ConversationDatasetsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversationDataset",
			Handler:    _ConversationDatasets_CreateConversationDataset_Handler,
		},
		{
			MethodName: "GetConversationDataset",
			Handler:    _ConversationDatasets_GetConversationDataset_Handler,
		},
		{
			MethodName: "ListConversationDatasets",
			Handler:    _ConversationDatasets_ListConversationDatasets_Handler,
		},
		{
			MethodName: "DeleteConversationDataset",
			Handler:    _ConversationDatasets_DeleteConversationDataset_Handler,
		},
		{
			MethodName: "ImportConversationData",
			Handler:    _ConversationDatasets_ImportConversationData_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/conversation_dataset.proto",
}
