// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package pcaconnectorscepiface provides an interface to enable mocking the Private CA Connector for SCEP service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package pcaconnectorscepiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/pcaconnectorscep"
)

// PcaConnectorScepAPI provides an interface to enable mocking the
// pcaconnectorscep.PcaConnectorScep service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Private CA Connector for SCEP.
//	func myFunc(svc pcaconnectorscepiface.PcaConnectorScepAPI) bool {
//	    // Make svc.CreateChallenge request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := pcaconnectorscep.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockPcaConnectorScepClient struct {
//	    pcaconnectorscepiface.PcaConnectorScepAPI
//	}
//	func (m *mockPcaConnectorScepClient) CreateChallenge(input *pcaconnectorscep.CreateChallengeInput) (*pcaconnectorscep.CreateChallengeOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockPcaConnectorScepClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type PcaConnectorScepAPI interface {
	CreateChallenge(*pcaconnectorscep.CreateChallengeInput) (*pcaconnectorscep.CreateChallengeOutput, error)
	CreateChallengeWithContext(aws.Context, *pcaconnectorscep.CreateChallengeInput, ...request.Option) (*pcaconnectorscep.CreateChallengeOutput, error)
	CreateChallengeRequest(*pcaconnectorscep.CreateChallengeInput) (*request.Request, *pcaconnectorscep.CreateChallengeOutput)

	CreateConnector(*pcaconnectorscep.CreateConnectorInput) (*pcaconnectorscep.CreateConnectorOutput, error)
	CreateConnectorWithContext(aws.Context, *pcaconnectorscep.CreateConnectorInput, ...request.Option) (*pcaconnectorscep.CreateConnectorOutput, error)
	CreateConnectorRequest(*pcaconnectorscep.CreateConnectorInput) (*request.Request, *pcaconnectorscep.CreateConnectorOutput)

	DeleteChallenge(*pcaconnectorscep.DeleteChallengeInput) (*pcaconnectorscep.DeleteChallengeOutput, error)
	DeleteChallengeWithContext(aws.Context, *pcaconnectorscep.DeleteChallengeInput, ...request.Option) (*pcaconnectorscep.DeleteChallengeOutput, error)
	DeleteChallengeRequest(*pcaconnectorscep.DeleteChallengeInput) (*request.Request, *pcaconnectorscep.DeleteChallengeOutput)

	DeleteConnector(*pcaconnectorscep.DeleteConnectorInput) (*pcaconnectorscep.DeleteConnectorOutput, error)
	DeleteConnectorWithContext(aws.Context, *pcaconnectorscep.DeleteConnectorInput, ...request.Option) (*pcaconnectorscep.DeleteConnectorOutput, error)
	DeleteConnectorRequest(*pcaconnectorscep.DeleteConnectorInput) (*request.Request, *pcaconnectorscep.DeleteConnectorOutput)

	GetChallengeMetadata(*pcaconnectorscep.GetChallengeMetadataInput) (*pcaconnectorscep.GetChallengeMetadataOutput, error)
	GetChallengeMetadataWithContext(aws.Context, *pcaconnectorscep.GetChallengeMetadataInput, ...request.Option) (*pcaconnectorscep.GetChallengeMetadataOutput, error)
	GetChallengeMetadataRequest(*pcaconnectorscep.GetChallengeMetadataInput) (*request.Request, *pcaconnectorscep.GetChallengeMetadataOutput)

	GetChallengePassword(*pcaconnectorscep.GetChallengePasswordInput) (*pcaconnectorscep.GetChallengePasswordOutput, error)
	GetChallengePasswordWithContext(aws.Context, *pcaconnectorscep.GetChallengePasswordInput, ...request.Option) (*pcaconnectorscep.GetChallengePasswordOutput, error)
	GetChallengePasswordRequest(*pcaconnectorscep.GetChallengePasswordInput) (*request.Request, *pcaconnectorscep.GetChallengePasswordOutput)

	GetConnector(*pcaconnectorscep.GetConnectorInput) (*pcaconnectorscep.GetConnectorOutput, error)
	GetConnectorWithContext(aws.Context, *pcaconnectorscep.GetConnectorInput, ...request.Option) (*pcaconnectorscep.GetConnectorOutput, error)
	GetConnectorRequest(*pcaconnectorscep.GetConnectorInput) (*request.Request, *pcaconnectorscep.GetConnectorOutput)

	ListChallengeMetadata(*pcaconnectorscep.ListChallengeMetadataInput) (*pcaconnectorscep.ListChallengeMetadataOutput, error)
	ListChallengeMetadataWithContext(aws.Context, *pcaconnectorscep.ListChallengeMetadataInput, ...request.Option) (*pcaconnectorscep.ListChallengeMetadataOutput, error)
	ListChallengeMetadataRequest(*pcaconnectorscep.ListChallengeMetadataInput) (*request.Request, *pcaconnectorscep.ListChallengeMetadataOutput)

	ListChallengeMetadataPages(*pcaconnectorscep.ListChallengeMetadataInput, func(*pcaconnectorscep.ListChallengeMetadataOutput, bool) bool) error
	ListChallengeMetadataPagesWithContext(aws.Context, *pcaconnectorscep.ListChallengeMetadataInput, func(*pcaconnectorscep.ListChallengeMetadataOutput, bool) bool, ...request.Option) error

	ListConnectors(*pcaconnectorscep.ListConnectorsInput) (*pcaconnectorscep.ListConnectorsOutput, error)
	ListConnectorsWithContext(aws.Context, *pcaconnectorscep.ListConnectorsInput, ...request.Option) (*pcaconnectorscep.ListConnectorsOutput, error)
	ListConnectorsRequest(*pcaconnectorscep.ListConnectorsInput) (*request.Request, *pcaconnectorscep.ListConnectorsOutput)

	ListConnectorsPages(*pcaconnectorscep.ListConnectorsInput, func(*pcaconnectorscep.ListConnectorsOutput, bool) bool) error
	ListConnectorsPagesWithContext(aws.Context, *pcaconnectorscep.ListConnectorsInput, func(*pcaconnectorscep.ListConnectorsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*pcaconnectorscep.ListTagsForResourceInput) (*pcaconnectorscep.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *pcaconnectorscep.ListTagsForResourceInput, ...request.Option) (*pcaconnectorscep.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*pcaconnectorscep.ListTagsForResourceInput) (*request.Request, *pcaconnectorscep.ListTagsForResourceOutput)

	TagResource(*pcaconnectorscep.TagResourceInput) (*pcaconnectorscep.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *pcaconnectorscep.TagResourceInput, ...request.Option) (*pcaconnectorscep.TagResourceOutput, error)
	TagResourceRequest(*pcaconnectorscep.TagResourceInput) (*request.Request, *pcaconnectorscep.TagResourceOutput)

	UntagResource(*pcaconnectorscep.UntagResourceInput) (*pcaconnectorscep.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *pcaconnectorscep.UntagResourceInput, ...request.Option) (*pcaconnectorscep.UntagResourceOutput, error)
	UntagResourceRequest(*pcaconnectorscep.UntagResourceInput) (*request.Request, *pcaconnectorscep.UntagResourceOutput)
}

var _ PcaConnectorScepAPI = (*pcaconnectorscep.PcaConnectorScep)(nil)
