// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/apps/drive/labels/v2/label.proto

package labels

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of this label.
type Label_LabelType int32

const (
	// Unknown label type.
	Label_LABEL_TYPE_UNSPECIFIED Label_LabelType = 0
	// Shared labels may be shared with users to apply to Drive items.
	Label_SHARED Label_LabelType = 1
	// Admin-owned label. Only creatable and editable by admins. Supports some
	// additional admin-only features.
	Label_ADMIN Label_LabelType = 2
	// A label owned by an internal Google application rather than a customer.
	// These labels are read-only.
	Label_GOOGLE_APP Label_LabelType = 3
)

// Enum value maps for Label_LabelType.
var (
	Label_LabelType_name = map[int32]string{
		0: "LABEL_TYPE_UNSPECIFIED",
		1: "SHARED",
		2: "ADMIN",
		3: "GOOGLE_APP",
	}
	Label_LabelType_value = map[string]int32{
		"LABEL_TYPE_UNSPECIFIED": 0,
		"SHARED":                 1,
		"ADMIN":                  2,
		"GOOGLE_APP":             3,
	}
)

func (x Label_LabelType) Enum() *Label_LabelType {
	p := new(Label_LabelType)
	*p = x
	return p
}

func (x Label_LabelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Label_LabelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_labels_v2_label_proto_enumTypes[0].Descriptor()
}

func (Label_LabelType) Type() protoreflect.EnumType {
	return &file_google_apps_drive_labels_v2_label_proto_enumTypes[0]
}

func (x Label_LabelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Label_LabelType.Descriptor instead.
func (Label_LabelType) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_proto_rawDescGZIP(), []int{0, 0}
}

// Indicates how the applied label and field values should be copied when
// a Drive item is copied.
type Label_AppliedLabelPolicy_CopyMode int32

const (
	// Copy mode unspecified.
	Label_AppliedLabelPolicy_COPY_MODE_UNSPECIFIED Label_AppliedLabelPolicy_CopyMode = 0
	// The applied label and field values are not copied by default when
	// the Drive item it's applied to is copied.
	Label_AppliedLabelPolicy_DO_NOT_COPY Label_AppliedLabelPolicy_CopyMode = 1
	// The applied label and field values are always copied when the
	// Drive item it's applied to is copied.
	// Only admins can use this mode.
	Label_AppliedLabelPolicy_ALWAYS_COPY Label_AppliedLabelPolicy_CopyMode = 2
	// The applied label and field values are copied if the
	// label is appliable by the user making the copy.
	Label_AppliedLabelPolicy_COPY_APPLIABLE Label_AppliedLabelPolicy_CopyMode = 3
)

// Enum value maps for Label_AppliedLabelPolicy_CopyMode.
var (
	Label_AppliedLabelPolicy_CopyMode_name = map[int32]string{
		0: "COPY_MODE_UNSPECIFIED",
		1: "DO_NOT_COPY",
		2: "ALWAYS_COPY",
		3: "COPY_APPLIABLE",
	}
	Label_AppliedLabelPolicy_CopyMode_value = map[string]int32{
		"COPY_MODE_UNSPECIFIED": 0,
		"DO_NOT_COPY":           1,
		"ALWAYS_COPY":           2,
		"COPY_APPLIABLE":        3,
	}
)

func (x Label_AppliedLabelPolicy_CopyMode) Enum() *Label_AppliedLabelPolicy_CopyMode {
	p := new(Label_AppliedLabelPolicy_CopyMode)
	*p = x
	return p
}

func (x Label_AppliedLabelPolicy_CopyMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Label_AppliedLabelPolicy_CopyMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_labels_v2_label_proto_enumTypes[1].Descriptor()
}

func (Label_AppliedLabelPolicy_CopyMode) Type() protoreflect.EnumType {
	return &file_google_apps_drive_labels_v2_label_proto_enumTypes[1]
}

func (x Label_AppliedLabelPolicy_CopyMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Label_AppliedLabelPolicy_CopyMode.Descriptor instead.
func (Label_AppliedLabelPolicy_CopyMode) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_proto_rawDescGZIP(), []int{0, 4, 0}
}

// A label defines a taxonomy that can be applied to Drive items in order to
// organize and search across items. Labels can be simple strings, or can
// contain fields that describe additional metadata that can be further used to
// organize and search Drive items.
type Label struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the label. Will be in the form of either:
	// `labels/{id}` or `labels/{id}@{revision_id}` depending on the request.
	// See `id` and `revision_id` below.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Globally unique identifier of this label. ID makes up part of
	// the label `name`, but unlike `name`, ID is consistent between revisions.
	// Matches the regex: `([a-zA-Z0-9])+`
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. Revision ID of the label. Revision ID might be part of the
	// label `name` depending on the request issued. A new revision is created
	// whenever revisioned properties of a label are changed. Matches the regex:
	// `([a-zA-Z0-9])+`
	RevisionId string `protobuf:"bytes,3,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// Required. The type of label.
	LabelType Label_LabelType `protobuf:"varint,4,opt,name=label_type,json=labelType,proto3,enum=google.apps.drive.labels.v2.Label_LabelType" json:"label_type,omitempty"`
	// Output only. The user who created this label.
	Creator *UserInfo `protobuf:"bytes,5,opt,name=creator,proto3" json:"creator,omitempty"`
	// Output only. The time this label was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The user who created this label revision.
	RevisionCreator *UserInfo `protobuf:"bytes,7,opt,name=revision_creator,json=revisionCreator,proto3" json:"revision_creator,omitempty"`
	// Output only. The time this label revision was created.
	RevisionCreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=revision_create_time,json=revisionCreateTime,proto3" json:"revision_create_time,omitempty"`
	// Output only. The user who published this label.  This value has no meaning
	// when the label is not published.
	Publisher *UserInfo `protobuf:"bytes,9,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// Output only. The time this label was published. This value has no meaning
	// when the label is not published.
	PublishTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=publish_time,json=publishTime,proto3" json:"publish_time,omitempty"`
	// Output only. The user who disabled this label. This value has no meaning
	// when the label is not disabled.
	Disabler *UserInfo `protobuf:"bytes,11,opt,name=disabler,proto3" json:"disabler,omitempty"`
	// Output only. The time this label was disabled. This value has no meaning
	// when the label is not disabled.
	DisableTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=disable_time,json=disableTime,proto3" json:"disable_time,omitempty"`
	// Output only. The customer this label belongs to.
	// For example: "customers/123abc789."
	Customer string `protobuf:"bytes,13,opt,name=customer,proto3" json:"customer,omitempty"`
	// Required. The basic properties of the label.
	Properties *Label_Properties `protobuf:"bytes,14,opt,name=properties,proto3" json:"properties,omitempty"`
	// Output only. The lifecycle state of the label including whether it's
	// published, deprecated, and has draft changes.
	Lifecycle *Lifecycle `protobuf:"bytes,15,opt,name=lifecycle,proto3" json:"lifecycle,omitempty"`
	// Output only. UI display hints for rendering the label.
	DisplayHints *Label_DisplayHints `protobuf:"bytes,16,opt,name=display_hints,json=displayHints,proto3" json:"display_hints,omitempty"`
	// Output only. The capabilities related to this label on applied metadata.
	AppliedCapabilities *Label_AppliedCapabilities `protobuf:"bytes,17,opt,name=applied_capabilities,json=appliedCapabilities,proto3" json:"applied_capabilities,omitempty"`
	// Output only. The capabilities the user has on this label.
	SchemaCapabilities *Label_SchemaCapabilities `protobuf:"bytes,18,opt,name=schema_capabilities,json=schemaCapabilities,proto3" json:"schema_capabilities,omitempty"`
	// Output only. Behavior of this label when it's applied to Drive items.
	AppliedLabelPolicy *Label_AppliedLabelPolicy `protobuf:"bytes,19,opt,name=applied_label_policy,json=appliedLabelPolicy,proto3" json:"applied_label_policy,omitempty"`
	// List of fields in descending priority order.
	Fields []*Field `protobuf:"bytes,20,rep,name=fields,proto3" json:"fields,omitempty"`
	// Custom URL to present to users to allow them to learn more about this label
	// and how it should be used.
	LearnMoreUri string `protobuf:"bytes,21,opt,name=learn_more_uri,json=learnMoreUri,proto3" json:"learn_more_uri,omitempty"`
	// Output only. The LockStatus of this label.
	LockStatus *LockStatus `protobuf:"bytes,22,opt,name=lock_status,json=lockStatus,proto3" json:"lock_status,omitempty"`
}

func (x *Label) Reset() {
	*x = Label{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Label) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label) ProtoMessage() {}

func (x *Label) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Label.ProtoReflect.Descriptor instead.
func (*Label) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_proto_rawDescGZIP(), []int{0}
}

func (x *Label) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Label) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Label) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *Label) GetLabelType() Label_LabelType {
	if x != nil {
		return x.LabelType
	}
	return Label_LABEL_TYPE_UNSPECIFIED
}

func (x *Label) GetCreator() *UserInfo {
	if x != nil {
		return x.Creator
	}
	return nil
}

func (x *Label) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Label) GetRevisionCreator() *UserInfo {
	if x != nil {
		return x.RevisionCreator
	}
	return nil
}

func (x *Label) GetRevisionCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RevisionCreateTime
	}
	return nil
}

func (x *Label) GetPublisher() *UserInfo {
	if x != nil {
		return x.Publisher
	}
	return nil
}

func (x *Label) GetPublishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishTime
	}
	return nil
}

func (x *Label) GetDisabler() *UserInfo {
	if x != nil {
		return x.Disabler
	}
	return nil
}

func (x *Label) GetDisableTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DisableTime
	}
	return nil
}

func (x *Label) GetCustomer() string {
	if x != nil {
		return x.Customer
	}
	return ""
}

func (x *Label) GetProperties() *Label_Properties {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Label) GetLifecycle() *Lifecycle {
	if x != nil {
		return x.Lifecycle
	}
	return nil
}

func (x *Label) GetDisplayHints() *Label_DisplayHints {
	if x != nil {
		return x.DisplayHints
	}
	return nil
}

func (x *Label) GetAppliedCapabilities() *Label_AppliedCapabilities {
	if x != nil {
		return x.AppliedCapabilities
	}
	return nil
}

func (x *Label) GetSchemaCapabilities() *Label_SchemaCapabilities {
	if x != nil {
		return x.SchemaCapabilities
	}
	return nil
}

func (x *Label) GetAppliedLabelPolicy() *Label_AppliedLabelPolicy {
	if x != nil {
		return x.AppliedLabelPolicy
	}
	return nil
}

func (x *Label) GetFields() []*Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *Label) GetLearnMoreUri() string {
	if x != nil {
		return x.LearnMoreUri
	}
	return ""
}

func (x *Label) GetLockStatus() *LockStatus {
	if x != nil {
		return x.LockStatus
	}
	return nil
}

// Basic properties of the label.
type Label_Properties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Title of the label.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// The description of the label.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Label_Properties) Reset() {
	*x = Label_Properties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Label_Properties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label_Properties) ProtoMessage() {}

func (x *Label_Properties) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Label_Properties.ProtoReflect.Descriptor instead.
func (*Label_Properties) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Label_Properties) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Label_Properties) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// UI display hints for rendering the label.
type Label_DisplayHints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the label should be shown in the UI as disabled.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// This label should be hidden in the search menu when searching for Drive
	// items.
	HiddenInSearch bool `protobuf:"varint,2,opt,name=hidden_in_search,json=hiddenInSearch,proto3" json:"hidden_in_search,omitempty"`
	// This label should be shown in the apply menu when applying values to a
	// Drive item.
	ShownInApply bool `protobuf:"varint,3,opt,name=shown_in_apply,json=shownInApply,proto3" json:"shown_in_apply,omitempty"`
	// Order to display label in a list.
	Priority int64 `protobuf:"varint,4,opt,name=priority,proto3" json:"priority,omitempty"`
}

func (x *Label_DisplayHints) Reset() {
	*x = Label_DisplayHints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Label_DisplayHints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label_DisplayHints) ProtoMessage() {}

func (x *Label_DisplayHints) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Label_DisplayHints.ProtoReflect.Descriptor instead.
func (*Label_DisplayHints) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Label_DisplayHints) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *Label_DisplayHints) GetHiddenInSearch() bool {
	if x != nil {
		return x.HiddenInSearch
	}
	return false
}

func (x *Label_DisplayHints) GetShownInApply() bool {
	if x != nil {
		return x.ShownInApply
	}
	return false
}

func (x *Label_DisplayHints) GetPriority() int64 {
	if x != nil {
		return x.Priority
	}
	return 0
}

// The capabilities a user has on this label's applied metadata.
type Label_AppliedCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the user can read applied metadata related to this label.
	CanRead bool `protobuf:"varint,1,opt,name=can_read,json=canRead,proto3" json:"can_read,omitempty"`
	// Whether the user can apply this label to items.
	CanApply bool `protobuf:"varint,2,opt,name=can_apply,json=canApply,proto3" json:"can_apply,omitempty"`
	// Whether the user can remove this label from items.
	CanRemove bool `protobuf:"varint,3,opt,name=can_remove,json=canRemove,proto3" json:"can_remove,omitempty"`
}

func (x *Label_AppliedCapabilities) Reset() {
	*x = Label_AppliedCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Label_AppliedCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label_AppliedCapabilities) ProtoMessage() {}

func (x *Label_AppliedCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Label_AppliedCapabilities.ProtoReflect.Descriptor instead.
func (*Label_AppliedCapabilities) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Label_AppliedCapabilities) GetCanRead() bool {
	if x != nil {
		return x.CanRead
	}
	return false
}

func (x *Label_AppliedCapabilities) GetCanApply() bool {
	if x != nil {
		return x.CanApply
	}
	return false
}

func (x *Label_AppliedCapabilities) GetCanRemove() bool {
	if x != nil {
		return x.CanRemove
	}
	return false
}

// The capabilities related to this label when editing the label.
type Label_SchemaCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the user can change this label.
	CanUpdate bool `protobuf:"varint,1,opt,name=can_update,json=canUpdate,proto3" json:"can_update,omitempty"`
	// Whether the user can delete this label.
	// The user must have permission and the label must be disabled.
	CanDelete bool `protobuf:"varint,2,opt,name=can_delete,json=canDelete,proto3" json:"can_delete,omitempty"`
	// Whether the user can disable this label.
	// The user must have permission and this label must not already be
	// disabled.
	CanDisable bool `protobuf:"varint,3,opt,name=can_disable,json=canDisable,proto3" json:"can_disable,omitempty"`
	// Whether the user can enable this label.
	// The user must have permission and this label must be disabled.
	CanEnable bool `protobuf:"varint,4,opt,name=can_enable,json=canEnable,proto3" json:"can_enable,omitempty"`
}

func (x *Label_SchemaCapabilities) Reset() {
	*x = Label_SchemaCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Label_SchemaCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label_SchemaCapabilities) ProtoMessage() {}

func (x *Label_SchemaCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Label_SchemaCapabilities.ProtoReflect.Descriptor instead.
func (*Label_SchemaCapabilities) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Label_SchemaCapabilities) GetCanUpdate() bool {
	if x != nil {
		return x.CanUpdate
	}
	return false
}

func (x *Label_SchemaCapabilities) GetCanDelete() bool {
	if x != nil {
		return x.CanDelete
	}
	return false
}

func (x *Label_SchemaCapabilities) GetCanDisable() bool {
	if x != nil {
		return x.CanDisable
	}
	return false
}

func (x *Label_SchemaCapabilities) GetCanEnable() bool {
	if x != nil {
		return x.CanEnable
	}
	return false
}

// Behavior of this label when it's applied to Drive items.
type Label_AppliedLabelPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates how the applied label and field values should be copied when
	// a Drive item is copied.
	CopyMode Label_AppliedLabelPolicy_CopyMode `protobuf:"varint,1,opt,name=copy_mode,json=copyMode,proto3,enum=google.apps.drive.labels.v2.Label_AppliedLabelPolicy_CopyMode" json:"copy_mode,omitempty"`
}

func (x *Label_AppliedLabelPolicy) Reset() {
	*x = Label_AppliedLabelPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Label_AppliedLabelPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label_AppliedLabelPolicy) ProtoMessage() {}

func (x *Label_AppliedLabelPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_label_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Label_AppliedLabelPolicy.ProtoReflect.Descriptor instead.
func (*Label_AppliedLabelPolicy) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Label_AppliedLabelPolicy) GetCopyMode() Label_AppliedLabelPolicy_CopyMode {
	if x != nil {
		return x.CopyMode
	}
	return Label_AppliedLabelPolicy_COPY_MODE_UNSPECIFIED
}

var File_google_apps_drive_labels_v2_label_proto protoreflect.FileDescriptor

var file_google_apps_drive_labels_v2_label_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf6, 0x12, 0x0a, 0x05, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x24,
	0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55,
	0x0a, 0x10, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x51, 0x0a, 0x14, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x12, 0x42, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x72, 0x12, 0x42,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x52, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x49, 0x0a, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x59, 0x0a, 0x0d,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x48,
	0x69, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x6e, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x65, 0x64, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65,
	0x64, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x6b, 0x0a, 0x13, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x12, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x6c, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x3a, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x14, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x24,
	0x0a, 0x0e, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f, 0x6d, 0x6f, 0x72, 0x65, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x4d, 0x6f, 0x72,
	0x65, 0x55, 0x72, 0x69, 0x12, 0x4d, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x1a, 0x49, 0x0a, 0x0a, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x96,
	0x01, 0x0a, 0x0c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12,
	0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x68,
	0x69, 0x64, 0x64, 0x65, 0x6e, 0x5f, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x49, 0x6e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x68, 0x6f, 0x77, 0x6e, 0x5f, 0x69,
	0x6e, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x73,
	0x68, 0x6f, 0x77, 0x6e, 0x49, 0x6e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x1a, 0x6c, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x65, 0x64, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x19,
	0x0a, 0x08, 0x63, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x61, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x61, 0x6e,
	0x5f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x61,
	0x6e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x5f, 0x72, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x61, 0x6e, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x1a, 0x92, 0x01, 0x0a, 0x12, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x63, 0x61, 0x6e, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x63, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63,
	0x61, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x63, 0x61, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x61,
	0x6e, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0a, 0x63, 0x61, 0x6e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63,
	0x61, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x63, 0x61, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0xce, 0x01, 0x0a, 0x12, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x5b, 0x0a, 0x09, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x43, 0x6f, 0x70, 0x79,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x63, 0x6f, 0x70, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x5b,
	0x0a, 0x08, 0x43, 0x6f, 0x70, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f,
	0x50, 0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x4f, 0x5f, 0x4e, 0x4f, 0x54, 0x5f,
	0x43, 0x4f, 0x50, 0x59, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53,
	0x5f, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4f, 0x50, 0x59, 0x5f,
	0x41, 0x50, 0x50, 0x4c, 0x49, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x22, 0x4e, 0x0a, 0x09, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4c, 0x41, 0x42, 0x45,
	0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x41, 0x44, 0x4d, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x47,
	0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x10, 0x03, 0x3a, 0x32, 0xea, 0x41, 0x2f,
	0x0a, 0x20, 0x64, 0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x12, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x69, 0x64, 0x7d, 0x42,
	0xb9, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x76, 0x32, 0x42, 0x0a, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x3b, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0xa2, 0x02, 0x04, 0x44, 0x4c, 0x42, 0x4c, 0xea, 0x41, 0x3d, 0x0a, 0x25,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x12, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_apps_drive_labels_v2_label_proto_rawDescOnce sync.Once
	file_google_apps_drive_labels_v2_label_proto_rawDescData = file_google_apps_drive_labels_v2_label_proto_rawDesc
)

func file_google_apps_drive_labels_v2_label_proto_rawDescGZIP() []byte {
	file_google_apps_drive_labels_v2_label_proto_rawDescOnce.Do(func() {
		file_google_apps_drive_labels_v2_label_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_drive_labels_v2_label_proto_rawDescData)
	})
	return file_google_apps_drive_labels_v2_label_proto_rawDescData
}

var file_google_apps_drive_labels_v2_label_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_apps_drive_labels_v2_label_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_apps_drive_labels_v2_label_proto_goTypes = []interface{}{
	(Label_LabelType)(0),                   // 0: google.apps.drive.labels.v2.Label.LabelType
	(Label_AppliedLabelPolicy_CopyMode)(0), // 1: google.apps.drive.labels.v2.Label.AppliedLabelPolicy.CopyMode
	(*Label)(nil),                          // 2: google.apps.drive.labels.v2.Label
	(*Label_Properties)(nil),               // 3: google.apps.drive.labels.v2.Label.Properties
	(*Label_DisplayHints)(nil),             // 4: google.apps.drive.labels.v2.Label.DisplayHints
	(*Label_AppliedCapabilities)(nil),      // 5: google.apps.drive.labels.v2.Label.AppliedCapabilities
	(*Label_SchemaCapabilities)(nil),       // 6: google.apps.drive.labels.v2.Label.SchemaCapabilities
	(*Label_AppliedLabelPolicy)(nil),       // 7: google.apps.drive.labels.v2.Label.AppliedLabelPolicy
	(*UserInfo)(nil),                       // 8: google.apps.drive.labels.v2.UserInfo
	(*timestamppb.Timestamp)(nil),          // 9: google.protobuf.Timestamp
	(*Lifecycle)(nil),                      // 10: google.apps.drive.labels.v2.Lifecycle
	(*Field)(nil),                          // 11: google.apps.drive.labels.v2.Field
	(*LockStatus)(nil),                     // 12: google.apps.drive.labels.v2.LockStatus
}
var file_google_apps_drive_labels_v2_label_proto_depIdxs = []int32{
	0,  // 0: google.apps.drive.labels.v2.Label.label_type:type_name -> google.apps.drive.labels.v2.Label.LabelType
	8,  // 1: google.apps.drive.labels.v2.Label.creator:type_name -> google.apps.drive.labels.v2.UserInfo
	9,  // 2: google.apps.drive.labels.v2.Label.create_time:type_name -> google.protobuf.Timestamp
	8,  // 3: google.apps.drive.labels.v2.Label.revision_creator:type_name -> google.apps.drive.labels.v2.UserInfo
	9,  // 4: google.apps.drive.labels.v2.Label.revision_create_time:type_name -> google.protobuf.Timestamp
	8,  // 5: google.apps.drive.labels.v2.Label.publisher:type_name -> google.apps.drive.labels.v2.UserInfo
	9,  // 6: google.apps.drive.labels.v2.Label.publish_time:type_name -> google.protobuf.Timestamp
	8,  // 7: google.apps.drive.labels.v2.Label.disabler:type_name -> google.apps.drive.labels.v2.UserInfo
	9,  // 8: google.apps.drive.labels.v2.Label.disable_time:type_name -> google.protobuf.Timestamp
	3,  // 9: google.apps.drive.labels.v2.Label.properties:type_name -> google.apps.drive.labels.v2.Label.Properties
	10, // 10: google.apps.drive.labels.v2.Label.lifecycle:type_name -> google.apps.drive.labels.v2.Lifecycle
	4,  // 11: google.apps.drive.labels.v2.Label.display_hints:type_name -> google.apps.drive.labels.v2.Label.DisplayHints
	5,  // 12: google.apps.drive.labels.v2.Label.applied_capabilities:type_name -> google.apps.drive.labels.v2.Label.AppliedCapabilities
	6,  // 13: google.apps.drive.labels.v2.Label.schema_capabilities:type_name -> google.apps.drive.labels.v2.Label.SchemaCapabilities
	7,  // 14: google.apps.drive.labels.v2.Label.applied_label_policy:type_name -> google.apps.drive.labels.v2.Label.AppliedLabelPolicy
	11, // 15: google.apps.drive.labels.v2.Label.fields:type_name -> google.apps.drive.labels.v2.Field
	12, // 16: google.apps.drive.labels.v2.Label.lock_status:type_name -> google.apps.drive.labels.v2.LockStatus
	1,  // 17: google.apps.drive.labels.v2.Label.AppliedLabelPolicy.copy_mode:type_name -> google.apps.drive.labels.v2.Label.AppliedLabelPolicy.CopyMode
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_apps_drive_labels_v2_label_proto_init() }
func file_google_apps_drive_labels_v2_label_proto_init() {
	if File_google_apps_drive_labels_v2_label_proto != nil {
		return
	}
	file_google_apps_drive_labels_v2_common_proto_init()
	file_google_apps_drive_labels_v2_field_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_apps_drive_labels_v2_label_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Label); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2_label_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Label_Properties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2_label_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Label_DisplayHints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2_label_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Label_AppliedCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2_label_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Label_SchemaCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2_label_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Label_AppliedLabelPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_drive_labels_v2_label_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_drive_labels_v2_label_proto_goTypes,
		DependencyIndexes: file_google_apps_drive_labels_v2_label_proto_depIdxs,
		EnumInfos:         file_google_apps_drive_labels_v2_label_proto_enumTypes,
		MessageInfos:      file_google_apps_drive_labels_v2_label_proto_msgTypes,
	}.Build()
	File_google_apps_drive_labels_v2_label_proto = out.File
	file_google_apps_drive_labels_v2_label_proto_rawDesc = nil
	file_google_apps_drive_labels_v2_label_proto_goTypes = nil
	file_google_apps_drive_labels_v2_label_proto_depIdxs = nil
}
