// automatically generated by stateify.

package fuse

import (
	"context"

	"gvisor.dev/gvisor/pkg/state"
)

func (conn *connection) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.connection"
}

func (conn *connection) StateFields() []string {
	return []string{
		"fd",
		"attributeVersion",
		"initialized",
		"initializedChan",
		"connected",
		"connInitError",
		"connInitSuccess",
		"aborted",
		"numWaiting",
		"asyncNum",
		"asyncCongestionThreshold",
		"asyncNumMax",
		"maxRead",
		"maxWrite",
		"maxPages",
		"maxActiveRequests",
		"minor",
		"atomicOTrunc",
		"asyncRead",
		"writebackCache",
		"bigWrites",
		"dontMask",
		"noOpen",
	}
}

func (conn *connection) beforeSave() {}

// +checklocksignore
func (conn *connection) StateSave(stateSinkObject state.Sink) {
	conn.beforeSave()
	var initializedChanValue bool
	initializedChanValue = conn.saveInitializedChan()
	stateSinkObject.SaveValue(3, initializedChanValue)
	stateSinkObject.Save(0, &conn.fd)
	stateSinkObject.Save(1, &conn.attributeVersion)
	stateSinkObject.Save(2, &conn.initialized)
	stateSinkObject.Save(4, &conn.connected)
	stateSinkObject.Save(5, &conn.connInitError)
	stateSinkObject.Save(6, &conn.connInitSuccess)
	stateSinkObject.Save(7, &conn.aborted)
	stateSinkObject.Save(8, &conn.numWaiting)
	stateSinkObject.Save(9, &conn.asyncNum)
	stateSinkObject.Save(10, &conn.asyncCongestionThreshold)
	stateSinkObject.Save(11, &conn.asyncNumMax)
	stateSinkObject.Save(12, &conn.maxRead)
	stateSinkObject.Save(13, &conn.maxWrite)
	stateSinkObject.Save(14, &conn.maxPages)
	stateSinkObject.Save(15, &conn.maxActiveRequests)
	stateSinkObject.Save(16, &conn.minor)
	stateSinkObject.Save(17, &conn.atomicOTrunc)
	stateSinkObject.Save(18, &conn.asyncRead)
	stateSinkObject.Save(19, &conn.writebackCache)
	stateSinkObject.Save(20, &conn.bigWrites)
	stateSinkObject.Save(21, &conn.dontMask)
	stateSinkObject.Save(22, &conn.noOpen)
}

func (conn *connection) afterLoad(context.Context) {}

// +checklocksignore
func (conn *connection) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &conn.fd)
	stateSourceObject.Load(1, &conn.attributeVersion)
	stateSourceObject.Load(2, &conn.initialized)
	stateSourceObject.Load(4, &conn.connected)
	stateSourceObject.Load(5, &conn.connInitError)
	stateSourceObject.Load(6, &conn.connInitSuccess)
	stateSourceObject.Load(7, &conn.aborted)
	stateSourceObject.Load(8, &conn.numWaiting)
	stateSourceObject.Load(9, &conn.asyncNum)
	stateSourceObject.Load(10, &conn.asyncCongestionThreshold)
	stateSourceObject.Load(11, &conn.asyncNumMax)
	stateSourceObject.Load(12, &conn.maxRead)
	stateSourceObject.Load(13, &conn.maxWrite)
	stateSourceObject.Load(14, &conn.maxPages)
	stateSourceObject.Load(15, &conn.maxActiveRequests)
	stateSourceObject.Load(16, &conn.minor)
	stateSourceObject.Load(17, &conn.atomicOTrunc)
	stateSourceObject.Load(18, &conn.asyncRead)
	stateSourceObject.Load(19, &conn.writebackCache)
	stateSourceObject.Load(20, &conn.bigWrites)
	stateSourceObject.Load(21, &conn.dontMask)
	stateSourceObject.Load(22, &conn.noOpen)
	stateSourceObject.LoadValue(3, new(bool), func(y any) { conn.loadInitializedChan(ctx, y.(bool)) })
}

func (f *fuseDevice) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.fuseDevice"
}

func (f *fuseDevice) StateFields() []string {
	return []string{}
}

func (f *fuseDevice) beforeSave() {}

// +checklocksignore
func (f *fuseDevice) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
}

func (f *fuseDevice) afterLoad(context.Context) {}

// +checklocksignore
func (f *fuseDevice) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (fd *DeviceFD) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.DeviceFD"
}

func (fd *DeviceFD) StateFields() []string {
	return []string{
		"vfsfd",
		"FileDescriptionDefaultImpl",
		"DentryMetadataFileDescriptionImpl",
		"NoLockFD",
		"waitQueue",
		"fullQueueCh",
		"nextOpID",
		"queue",
		"numActiveRequests",
		"completions",
		"writeBuf",
		"conn",
	}
}

func (fd *DeviceFD) beforeSave() {}

// +checklocksignore
func (fd *DeviceFD) StateSave(stateSinkObject state.Sink) {
	fd.beforeSave()
	var fullQueueChValue int
	fullQueueChValue = fd.saveFullQueueCh()
	stateSinkObject.SaveValue(5, fullQueueChValue)
	stateSinkObject.Save(0, &fd.vfsfd)
	stateSinkObject.Save(1, &fd.FileDescriptionDefaultImpl)
	stateSinkObject.Save(2, &fd.DentryMetadataFileDescriptionImpl)
	stateSinkObject.Save(3, &fd.NoLockFD)
	stateSinkObject.Save(4, &fd.waitQueue)
	stateSinkObject.Save(6, &fd.nextOpID)
	stateSinkObject.Save(7, &fd.queue)
	stateSinkObject.Save(8, &fd.numActiveRequests)
	stateSinkObject.Save(9, &fd.completions)
	stateSinkObject.Save(10, &fd.writeBuf)
	stateSinkObject.Save(11, &fd.conn)
}

func (fd *DeviceFD) afterLoad(context.Context) {}

// +checklocksignore
func (fd *DeviceFD) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fd.vfsfd)
	stateSourceObject.Load(1, &fd.FileDescriptionDefaultImpl)
	stateSourceObject.Load(2, &fd.DentryMetadataFileDescriptionImpl)
	stateSourceObject.Load(3, &fd.NoLockFD)
	stateSourceObject.Load(4, &fd.waitQueue)
	stateSourceObject.Load(6, &fd.nextOpID)
	stateSourceObject.Load(7, &fd.queue)
	stateSourceObject.Load(8, &fd.numActiveRequests)
	stateSourceObject.Load(9, &fd.completions)
	stateSourceObject.Load(10, &fd.writeBuf)
	stateSourceObject.Load(11, &fd.conn)
	stateSourceObject.LoadValue(5, new(int), func(y any) { fd.loadFullQueueCh(ctx, y.(int)) })
}

func (dir *directoryFD) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.directoryFD"
}

func (dir *directoryFD) StateFields() []string {
	return []string{
		"fileDescription",
	}
}

func (dir *directoryFD) beforeSave() {}

// +checklocksignore
func (dir *directoryFD) StateSave(stateSinkObject state.Sink) {
	dir.beforeSave()
	stateSinkObject.Save(0, &dir.fileDescription)
}

func (dir *directoryFD) afterLoad(context.Context) {}

// +checklocksignore
func (dir *directoryFD) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &dir.fileDescription)
}

func (fd *fileDescription) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.fileDescription"
}

func (fd *fileDescription) StateFields() []string {
	return []string{
		"vfsfd",
		"FileDescriptionDefaultImpl",
		"DentryMetadataFileDescriptionImpl",
		"LockFD",
		"Fh",
		"Nonseekable",
		"DirectIO",
		"OpenFlag",
		"off",
	}
}

func (fd *fileDescription) beforeSave() {}

// +checklocksignore
func (fd *fileDescription) StateSave(stateSinkObject state.Sink) {
	fd.beforeSave()
	stateSinkObject.Save(0, &fd.vfsfd)
	stateSinkObject.Save(1, &fd.FileDescriptionDefaultImpl)
	stateSinkObject.Save(2, &fd.DentryMetadataFileDescriptionImpl)
	stateSinkObject.Save(3, &fd.LockFD)
	stateSinkObject.Save(4, &fd.Fh)
	stateSinkObject.Save(5, &fd.Nonseekable)
	stateSinkObject.Save(6, &fd.DirectIO)
	stateSinkObject.Save(7, &fd.OpenFlag)
	stateSinkObject.Save(8, &fd.off)
}

func (fd *fileDescription) afterLoad(context.Context) {}

// +checklocksignore
func (fd *fileDescription) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fd.vfsfd)
	stateSourceObject.Load(1, &fd.FileDescriptionDefaultImpl)
	stateSourceObject.Load(2, &fd.DentryMetadataFileDescriptionImpl)
	stateSourceObject.Load(3, &fd.LockFD)
	stateSourceObject.Load(4, &fd.Fh)
	stateSourceObject.Load(5, &fd.Nonseekable)
	stateSourceObject.Load(6, &fd.DirectIO)
	stateSourceObject.Load(7, &fd.OpenFlag)
	stateSourceObject.Load(8, &fd.off)
}

func (fsType *FilesystemType) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.FilesystemType"
}

func (fsType *FilesystemType) StateFields() []string {
	return []string{}
}

func (fsType *FilesystemType) beforeSave() {}

// +checklocksignore
func (fsType *FilesystemType) StateSave(stateSinkObject state.Sink) {
	fsType.beforeSave()
}

func (fsType *FilesystemType) afterLoad(context.Context) {}

// +checklocksignore
func (fsType *FilesystemType) StateLoad(ctx context.Context, stateSourceObject state.Source) {
}

func (f *filesystemOptions) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.filesystemOptions"
}

func (f *filesystemOptions) StateFields() []string {
	return []string{
		"mopts",
		"uid",
		"gid",
		"rootMode",
		"maxActiveRequests",
		"maxRead",
		"defaultPermissions",
		"allowOther",
	}
}

func (f *filesystemOptions) beforeSave() {}

// +checklocksignore
func (f *filesystemOptions) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	stateSinkObject.Save(0, &f.mopts)
	stateSinkObject.Save(1, &f.uid)
	stateSinkObject.Save(2, &f.gid)
	stateSinkObject.Save(3, &f.rootMode)
	stateSinkObject.Save(4, &f.maxActiveRequests)
	stateSinkObject.Save(5, &f.maxRead)
	stateSinkObject.Save(6, &f.defaultPermissions)
	stateSinkObject.Save(7, &f.allowOther)
}

func (f *filesystemOptions) afterLoad(context.Context) {}

// +checklocksignore
func (f *filesystemOptions) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.mopts)
	stateSourceObject.Load(1, &f.uid)
	stateSourceObject.Load(2, &f.gid)
	stateSourceObject.Load(3, &f.rootMode)
	stateSourceObject.Load(4, &f.maxActiveRequests)
	stateSourceObject.Load(5, &f.maxRead)
	stateSourceObject.Load(6, &f.defaultPermissions)
	stateSourceObject.Load(7, &f.allowOther)
}

func (fs *filesystem) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.filesystem"
}

func (fs *filesystem) StateFields() []string {
	return []string{
		"Filesystem",
		"devMinor",
		"conn",
		"opts",
		"clock",
	}
}

func (fs *filesystem) beforeSave() {}

// +checklocksignore
func (fs *filesystem) StateSave(stateSinkObject state.Sink) {
	fs.beforeSave()
	stateSinkObject.Save(0, &fs.Filesystem)
	stateSinkObject.Save(1, &fs.devMinor)
	stateSinkObject.Save(2, &fs.conn)
	stateSinkObject.Save(3, &fs.opts)
	stateSinkObject.Save(4, &fs.clock)
}

func (fs *filesystem) afterLoad(context.Context) {}

// +checklocksignore
func (fs *filesystem) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fs.Filesystem)
	stateSourceObject.Load(1, &fs.devMinor)
	stateSourceObject.Load(2, &fs.conn)
	stateSourceObject.Load(3, &fs.opts)
	stateSourceObject.Load(4, &fs.clock)
}

func (f *fileHandle) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.fileHandle"
}

func (f *fileHandle) StateFields() []string {
	return []string{
		"new",
		"handle",
		"flags",
	}
}

func (f *fileHandle) beforeSave() {}

// +checklocksignore
func (f *fileHandle) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	stateSinkObject.Save(0, &f.new)
	stateSinkObject.Save(1, &f.handle)
	stateSinkObject.Save(2, &f.flags)
}

func (f *fileHandle) afterLoad(context.Context) {}

// +checklocksignore
func (f *fileHandle) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.new)
	stateSourceObject.Load(1, &f.handle)
	stateSourceObject.Load(2, &f.flags)
}

func (i *inode) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.inode"
}

func (i *inode) StateFields() []string {
	return []string{
		"inodeRefs",
		"InodeNotAnonymous",
		"InodeNotSymlink",
		"InodeWatches",
		"OrderedChildren",
		"CachedMappable",
		"fs",
		"nodeID",
		"entryTime",
		"attrVersion",
		"attrTime",
		"link",
		"fh",
		"locks",
		"watches",
		"ino",
		"uid",
		"gid",
		"mode",
		"atime",
		"mtime",
		"ctime",
		"size",
		"nlink",
		"blockSize",
	}
}

func (i *inode) beforeSave() {}

// +checklocksignore
func (i *inode) StateSave(stateSinkObject state.Sink) {
	i.beforeSave()
	stateSinkObject.Save(0, &i.inodeRefs)
	stateSinkObject.Save(1, &i.InodeNotAnonymous)
	stateSinkObject.Save(2, &i.InodeNotSymlink)
	stateSinkObject.Save(3, &i.InodeWatches)
	stateSinkObject.Save(4, &i.OrderedChildren)
	stateSinkObject.Save(5, &i.CachedMappable)
	stateSinkObject.Save(6, &i.fs)
	stateSinkObject.Save(7, &i.nodeID)
	stateSinkObject.Save(8, &i.entryTime)
	stateSinkObject.Save(9, &i.attrVersion)
	stateSinkObject.Save(10, &i.attrTime)
	stateSinkObject.Save(11, &i.link)
	stateSinkObject.Save(12, &i.fh)
	stateSinkObject.Save(13, &i.locks)
	stateSinkObject.Save(14, &i.watches)
	stateSinkObject.Save(15, &i.ino)
	stateSinkObject.Save(16, &i.uid)
	stateSinkObject.Save(17, &i.gid)
	stateSinkObject.Save(18, &i.mode)
	stateSinkObject.Save(19, &i.atime)
	stateSinkObject.Save(20, &i.mtime)
	stateSinkObject.Save(21, &i.ctime)
	stateSinkObject.Save(22, &i.size)
	stateSinkObject.Save(23, &i.nlink)
	stateSinkObject.Save(24, &i.blockSize)
}

func (i *inode) afterLoad(context.Context) {}

// +checklocksignore
func (i *inode) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &i.inodeRefs)
	stateSourceObject.Load(1, &i.InodeNotAnonymous)
	stateSourceObject.Load(2, &i.InodeNotSymlink)
	stateSourceObject.Load(3, &i.InodeWatches)
	stateSourceObject.Load(4, &i.OrderedChildren)
	stateSourceObject.Load(5, &i.CachedMappable)
	stateSourceObject.Load(6, &i.fs)
	stateSourceObject.Load(7, &i.nodeID)
	stateSourceObject.Load(8, &i.entryTime)
	stateSourceObject.Load(9, &i.attrVersion)
	stateSourceObject.Load(10, &i.attrTime)
	stateSourceObject.Load(11, &i.link)
	stateSourceObject.Load(12, &i.fh)
	stateSourceObject.Load(13, &i.locks)
	stateSourceObject.Load(14, &i.watches)
	stateSourceObject.Load(15, &i.ino)
	stateSourceObject.Load(16, &i.uid)
	stateSourceObject.Load(17, &i.gid)
	stateSourceObject.Load(18, &i.mode)
	stateSourceObject.Load(19, &i.atime)
	stateSourceObject.Load(20, &i.mtime)
	stateSourceObject.Load(21, &i.ctime)
	stateSourceObject.Load(22, &i.size)
	stateSourceObject.Load(23, &i.nlink)
	stateSourceObject.Load(24, &i.blockSize)
}

func (r *inodeRefs) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.inodeRefs"
}

func (r *inodeRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *inodeRefs) beforeSave() {}

// +checklocksignore
func (r *inodeRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *inodeRefs) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(func() { r.afterLoad(ctx) })
}

func (fd *regularFileFD) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.regularFileFD"
}

func (fd *regularFileFD) StateFields() []string {
	return []string{
		"fileDescription",
		"off",
		"mappings",
		"data",
	}
}

func (fd *regularFileFD) beforeSave() {}

// +checklocksignore
func (fd *regularFileFD) StateSave(stateSinkObject state.Sink) {
	fd.beforeSave()
	stateSinkObject.Save(0, &fd.fileDescription)
	stateSinkObject.Save(1, &fd.off)
	stateSinkObject.Save(2, &fd.mappings)
	stateSinkObject.Save(3, &fd.data)
}

func (fd *regularFileFD) afterLoad(context.Context) {}

// +checklocksignore
func (fd *regularFileFD) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fd.fileDescription)
	stateSourceObject.Load(1, &fd.off)
	stateSourceObject.Load(2, &fd.mappings)
	stateSourceObject.Load(3, &fd.data)
}

func (l *requestList) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.requestList"
}

func (l *requestList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *requestList) beforeSave() {}

// +checklocksignore
func (l *requestList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *requestList) afterLoad(context.Context) {}

// +checklocksignore
func (l *requestList) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *requestEntry) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.requestEntry"
}

func (e *requestEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *requestEntry) beforeSave() {}

// +checklocksignore
func (e *requestEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *requestEntry) afterLoad(context.Context) {}

// +checklocksignore
func (e *requestEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (r *Request) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.Request"
}

func (r *Request) StateFields() []string {
	return []string{
		"requestEntry",
		"id",
		"hdr",
		"data",
		"async",
		"noReply",
	}
}

func (r *Request) beforeSave() {}

// +checklocksignore
func (r *Request) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.requestEntry)
	stateSinkObject.Save(1, &r.id)
	stateSinkObject.Save(2, &r.hdr)
	stateSinkObject.Save(3, &r.data)
	stateSinkObject.Save(4, &r.async)
	stateSinkObject.Save(5, &r.noReply)
}

func (r *Request) afterLoad(context.Context) {}

// +checklocksignore
func (r *Request) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.requestEntry)
	stateSourceObject.Load(1, &r.id)
	stateSourceObject.Load(2, &r.hdr)
	stateSourceObject.Load(3, &r.data)
	stateSourceObject.Load(4, &r.async)
	stateSourceObject.Load(5, &r.noReply)
}

func (fRes *futureResponse) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.futureResponse"
}

func (fRes *futureResponse) StateFields() []string {
	return []string{
		"opcode",
		"hdr",
		"data",
		"async",
	}
}

func (fRes *futureResponse) beforeSave() {}

// +checklocksignore
func (fRes *futureResponse) StateSave(stateSinkObject state.Sink) {
	fRes.beforeSave()
	stateSinkObject.Save(0, &fRes.opcode)
	stateSinkObject.Save(1, &fRes.hdr)
	stateSinkObject.Save(2, &fRes.data)
	stateSinkObject.Save(3, &fRes.async)
}

// +checklocksignore
func (fRes *futureResponse) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fRes.opcode)
	stateSourceObject.Load(1, &fRes.hdr)
	stateSourceObject.Load(2, &fRes.data)
	stateSourceObject.Load(3, &fRes.async)
	stateSourceObject.AfterLoad(func() { fRes.afterLoad(ctx) })
}

func (r *Response) StateTypeName() string {
	return "pkg/sentry/fsimpl/fuse.Response"
}

func (r *Response) StateFields() []string {
	return []string{
		"opcode",
		"hdr",
		"data",
	}
}

func (r *Response) beforeSave() {}

// +checklocksignore
func (r *Response) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.opcode)
	stateSinkObject.Save(1, &r.hdr)
	stateSinkObject.Save(2, &r.data)
}

func (r *Response) afterLoad(context.Context) {}

// +checklocksignore
func (r *Response) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.opcode)
	stateSourceObject.Load(1, &r.hdr)
	stateSourceObject.Load(2, &r.data)
}

func init() {
	state.Register((*connection)(nil))
	state.Register((*fuseDevice)(nil))
	state.Register((*DeviceFD)(nil))
	state.Register((*directoryFD)(nil))
	state.Register((*fileDescription)(nil))
	state.Register((*FilesystemType)(nil))
	state.Register((*filesystemOptions)(nil))
	state.Register((*filesystem)(nil))
	state.Register((*fileHandle)(nil))
	state.Register((*inode)(nil))
	state.Register((*inodeRefs)(nil))
	state.Register((*regularFileFD)(nil))
	state.Register((*requestList)(nil))
	state.Register((*requestEntry)(nil))
	state.Register((*Request)(nil))
	state.Register((*futureResponse)(nil))
	state.Register((*Response)(nil))
}
