/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.core;

import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.amazonaws.services.iot.client.AWSIotTimeoutException;
import com.amazonaws.services.iot.client.core.AbstractAwsIotClient;
import java.util.concurrent.Future;

public class AwsIotCompletion
extends AWSIotMessage {
    protected final AWSIotMessage request;
    protected final long timeout;
    protected final boolean isAsync;
    protected Future<?> timeoutTask;
    protected boolean hasSuccess;
    protected boolean hasFailure;
    protected boolean hasTimeout;

    public AwsIotCompletion(String topic, AWSIotQos qos, long timeout) {
        super(topic, qos);
        this.timeout = timeout;
        this.request = null;
        this.isAsync = false;
    }

    public AwsIotCompletion(String topic, AWSIotQos qos, String payload, long timeout) {
        super(topic, qos, payload);
        this.timeout = timeout;
        this.request = null;
        this.isAsync = false;
    }

    public AwsIotCompletion(String topic, AWSIotQos qos, byte[] payload, long timeout) {
        super(topic, qos, payload);
        this.timeout = timeout;
        this.request = null;
        this.isAsync = false;
    }

    public AwsIotCompletion(long timeout, boolean isAsync) {
        super(null, null);
        this.request = null;
        this.timeout = timeout;
        this.isAsync = isAsync;
    }

    public AwsIotCompletion(AWSIotMessage req, long timeout, boolean isAsync) {
        super(req.getTopic(), req.getQos(), req.getPayload());
        this.request = req;
        this.timeout = timeout;
        this.isAsync = isAsync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(AbstractAwsIotClient client) throws AWSIotException, AWSIotTimeoutException {
        AwsIotCompletion awsIotCompletion = this;
        synchronized (awsIotCompletion) {
            if (this.hasSuccess || this.hasFailure || this.hasTimeout) {
                if (!this.isAsync) {
                    if (this.hasFailure) {
                        throw new AWSIotException("Error happened when processing command " + this.topic);
                    }
                    if (this.hasTimeout) {
                        throw new AWSIotTimeoutException("Request timed out when processing command " + this.topic);
                    }
                }
                return;
            }
            if (this.timeout > 0L) {
                this.timeoutTask = client.scheduleTimeoutTask(new Runnable(){

                    @Override
                    public void run() {
                        AwsIotCompletion.this.onTimeout();
                    }
                }, this.timeout);
            }
            if (this.isAsync) {
                return;
            }
            while (!(this.hasSuccess || this.hasFailure || this.hasTimeout)) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.cancelTimeoutTask();
                    throw new AWSIotException(e);
                }
            }
            this.cancelTimeoutTask();
            if (this.hasFailure) {
                throw new AWSIotException(this.errorCode, this.errorMessage);
            }
            if (this.hasTimeout) {
                throw new AWSIotTimeoutException("Request timed out when processing request " + this.topic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess() {
        AwsIotCompletion awsIotCompletion = this;
        synchronized (awsIotCompletion) {
            if (this.hasSuccess || this.hasFailure || this.hasTimeout) {
                return;
            }
            this.hasSuccess = true;
            this.cancelTimeoutTask();
            if (!this.isAsync) {
                this.notify();
                return;
            }
        }
        if (this.request != null) {
            this.request.onSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure() {
        AwsIotCompletion awsIotCompletion = this;
        synchronized (awsIotCompletion) {
            if (this.hasSuccess || this.hasFailure || this.hasTimeout) {
                return;
            }
            this.hasFailure = true;
            this.cancelTimeoutTask();
            if (!this.isAsync) {
                this.notify();
                return;
            }
        }
        if (this.request != null) {
            this.request.setErrorCode(this.errorCode);
            this.request.setErrorMessage(this.errorMessage);
            this.request.onFailure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimeout() {
        AwsIotCompletion awsIotCompletion = this;
        synchronized (awsIotCompletion) {
            if (this.hasSuccess || this.hasFailure || this.hasTimeout) {
                return;
            }
            this.hasTimeout = true;
            this.cancelTimeoutTask();
            if (!this.isAsync) {
                this.notify();
                return;
            }
        }
        if (this.request != null) {
            this.request.onTimeout();
        }
    }

    private void cancelTimeoutTask() {
        if (this.timeoutTask != null && !this.timeoutTask.isCancelled()) {
            this.timeoutTask.cancel(false);
        }
    }
}

