/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.shadow;

import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotTimeoutException;
import com.amazonaws.services.iot.client.core.AwsIotCompletion;
import com.amazonaws.services.iot.client.shadow.AbstractAwsIotDevice;
import com.amazonaws.services.iot.client.shadow.AwsIotDeviceCommandManager;
import java.util.logging.Logger;

public class AwsIotDeviceCommand
extends AwsIotCompletion {
    private static final Logger LOGGER = Logger.getLogger(AwsIotDeviceCommand.class.getName());
    private final AwsIotDeviceCommandManager commandManager;
    private final AwsIotDeviceCommandManager.Command command;
    private final String commandId;
    private AWSIotMessage response;
    private Boolean requestSent;

    public AwsIotDeviceCommand(AwsIotDeviceCommandManager commandManager, AwsIotDeviceCommandManager.Command command, String commandId, AWSIotMessage request, long commandTimeout, boolean isAsync) {
        super(request, commandTimeout, isAsync);
        this.commandManager = commandManager;
        this.command = command;
        this.commandId = commandId;
        this.requestSent = false;
    }

    public void put(AbstractAwsIotDevice device) throws AWSIotException {
        if (device.isCommandReady(this.command)) {
            this._put(device);
        } else {
            LOGGER.info("Request is pending: " + this.command.name() + "/" + this.commandId);
        }
    }

    public String get(AbstractAwsIotDevice device) throws AWSIotException, AWSIotTimeoutException {
        super.get(device.getClient());
        return this.response != null ? this.response.getStringPayload() : null;
    }

    public boolean onReady(AbstractAwsIotDevice device) {
        try {
            LOGGER.info("Request is resumed: " + this.command.name() + "/" + this.commandId);
            this._put(device);
            return true;
        }
        catch (AWSIotException e) {
            return false;
        }
    }

    @Override
    public void onSuccess() {
        if (this.response == null) {
            return;
        }
        this.request.setPayload(this.response.getPayload());
        super.onSuccess();
    }

    @Override
    public void onFailure() {
        super.onFailure();
    }

    @Override
    public void onTimeout() {
        this.commandManager.onCommandTimeout(this);
        super.onTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _put(AbstractAwsIotDevice device) throws AWSIotException {
        AwsIotDeviceCommand awsIotDeviceCommand = this;
        synchronized (awsIotDeviceCommand) {
            if (this.requestSent.booleanValue()) {
                LOGGER.warning("Request was already sent: " + this.command.name() + "/" + this.commandId);
                return;
            }
            this.requestSent = true;
        }
        device.getClient().publish(this, this.timeout);
    }

    public AwsIotDeviceCommandManager getCommandManager() {
        return this.commandManager;
    }

    public AwsIotDeviceCommandManager.Command getCommand() {
        return this.command;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public AWSIotMessage getResponse() {
        return this.response;
    }

    public Boolean getRequestSent() {
        return this.requestSent;
    }

    public void setResponse(AWSIotMessage response) {
        this.response = response;
    }
}

