/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.ProbabilitySelector;
import io.jenetics.internal.math.base;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.Seq;
import java.util.Arrays;

public final class BoltzmannSelector<G extends Gene<?, G>, N extends Number>
extends ProbabilitySelector<G, N> {
    private final double _b;

    public BoltzmannSelector(double b) {
        this._b = b;
    }

    public BoltzmannSelector() {
        this(4.0);
    }

    @Override
    protected double[] probabilities(Seq<Phenotype<G, N>> population, int count) {
        assert (population != null) : "Population must not be null. ";
        assert (!population.isEmpty()) : "Population is empty.";
        assert (count > 0) : "Population to select must be greater than zero. ";
        double[] fitness = new double[population.size()];
        fitness[0] = ((Number)population.get(0).getFitness()).doubleValue();
        double min = fitness[0];
        double max = fitness[0];
        for (int i = 1; i < fitness.length; ++i) {
            fitness[i] = ((Number)population.get(i).getFitness()).doubleValue();
            if (fitness[i] < min) {
                min = fitness[i];
                continue;
            }
            if (!(fitness[i] > max)) continue;
            max = fitness[i];
        }
        double diff = max - min;
        if (BoltzmannSelector.eq(diff, 0.0)) {
            Arrays.fill(fitness, 1.0 / (double)fitness.length);
        } else {
            int i = fitness.length;
            while (--i >= 0) {
                fitness[i] = (fitness[i] - min) / diff;
            }
            i = fitness.length;
            while (--i >= 0) {
                fitness[i] = Math.exp(this._b * fitness[i]);
            }
        }
        return base.normalize(fitness);
    }

    public int hashCode() {
        return Hash.of(this.getClass()).and(this._b).value();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BoltzmannSelector && Double.compare(((BoltzmannSelector)obj)._b, this._b) == 0;
    }

    public String toString() {
        return String.format("BoltzmannSelector[b=%f]", this._b);
    }
}

