/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import io.jenetics.util.Seq;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

final class SeqSpliterator<T>
implements Spliterator<T> {
    private final Seq<T> _seq;
    private final int _fence;
    private int _index;

    SeqSpliterator(Seq<T> seq, int origin, int fence) {
        this._seq = Objects.requireNonNull(seq);
        this._index = origin;
        this._fence = fence;
    }

    SeqSpliterator(Seq<T> seq) {
        this(seq, 0, seq.length());
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        int i;
        Objects.requireNonNull(action);
        Seq<T> seq = this._seq;
        int hi = this._fence;
        if (seq.length() >= hi && (i = this._index) >= 0 && i < (this._index = hi)) {
            do {
                action.accept(seq.get(i));
            } while (++i < hi);
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this._index >= 0 && this._index < this._fence) {
            action.accept(this._seq.get(this._index++));
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        SeqSpliterator<T> seqSpliterator;
        int lo = this._index;
        int mid = lo + this._fence >>> 1;
        if (lo >= mid) {
            seqSpliterator = null;
        } else {
            this._index = mid;
            SeqSpliterator<T> seqSpliterator2 = new SeqSpliterator<T>(this._seq, lo, this._index);
            seqSpliterator = seqSpliterator2;
        }
        return seqSpliterator;
    }

    @Override
    public long estimateSize() {
        return this._fence - this._index;
    }

    @Override
    public int characteristics() {
        return 16704;
    }
}

