/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.io.svg;

import com.jgraph.io.svg.SVGGraphConstants;
import com.jgraph.io.svg.SVGGraphWriter;
import com.jgraph.io.svg.SVGUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGVertexWriter {
    public static String HEXCOLOR_SHADOW = SVGUtils.getHexEncoding(Color.DARK_GRAY);
    public static double SHADOW_OPACITY = 0.5;
    public static int SHADOW_DISTANCE = 3;

    public Node createNode(SVGGraphWriter sVGGraphWriter, Document document, GraphLayoutCache graphLayoutCache, CellView cellView, double d, double d2) {
        Rectangle2D rectangle2D = cellView.getBounds();
        AttributeMap attributeMap = cellView.getAllAttributes();
        Element element = document.createElement("a");
        String string = GraphConstants.getLink(attributeMap);
        if (string != null) {
            element.setAttribute("xlink:href", string);
        }
        int n = SVGGraphConstants.getShape(attributeMap);
        Color color = GraphConstants.getBackground(attributeMap);
        String string2 = null;
        if (color != null) {
            string2 = SVGUtils.getHexEncoding(color);
        }
        Color color2 = GraphConstants.getGradientColor(attributeMap);
        String string3 = null;
        if (color2 != null) {
            string2 = SVGUtils.getHexEncoding(color2);
        }
        Color color3 = GraphConstants.getBorderColor(attributeMap);
        String string4 = null;
        if (color3 != null) {
            string4 = SVGUtils.getHexEncoding(color3);
        }
        float f = GraphConstants.getLineWidth(attributeMap);
        boolean bl = SVGGraphConstants.isShadow(attributeMap);
        if (bl) {
            int n2 = SHADOW_DISTANCE;
            element.appendChild(sVGGraphWriter.createShapeNode(document, n, rectangle2D, d - (double)n2, d2 - (double)n2, HEXCOLOR_SHADOW, null, "none", f, SHADOW_OPACITY, false));
        }
        element.appendChild(sVGGraphWriter.createShapeNode(document, n, rectangle2D, d, d2, string2, string3, string4, f, 1.0, false));
        Object[] objectArray = sVGGraphWriter.getLabels(cellView);
        int n3 = (int)(rectangle2D.getX() - d + rectangle2D.getWidth() / 2.0);
        Font font = GraphConstants.getFont(attributeMap);
        int n4 = font != null ? font.getSize() : 11;
        int n5 = (n4 + SVGUtils.LINESPACING) * objectArray.length;
        int n6 = (int)((rectangle2D.getHeight() - (double)n5) / 2.0) + n4;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Color color4 = GraphConstants.getForeground(attributeMap);
            String string5 = null;
            if (color4 != null) {
                string5 = SVGUtils.getHexEncoding(color4);
            }
            if (objectArray[i] instanceof Node) {
                object = document.importNode((Node)objectArray[i], true);
                Node node = sVGGraphWriter.createTextNode(document, "", "middle", font, string5, n3, (int)(rectangle2D.getY() + (double)n6 - d2));
                element.appendChild(node);
                node.appendChild((Node)object);
            } else {
                object = String.valueOf(objectArray[i]);
                element.appendChild(sVGGraphWriter.createTextNode(document, (String)object, "middle", font, string5, n3, (int)(rectangle2D.getY() + (double)n6 - d2)));
            }
            n6 += n4 + SVGUtils.LINESPACING;
        }
        return element;
    }
}

