//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorage_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/220ad9c6554fc7d6d10a89bdb441c1e3b36e3285/specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountGetBlobInventoryPolicy.json
func ExampleBlobInventoryPoliciesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBlobInventoryPoliciesClient().Get(ctx, "res7687", "sto9699", armstorage.BlobInventoryPolicyNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BlobInventoryPolicy = armstorage.BlobInventoryPolicy{
	// 	Name: to.Ptr("DefaultInventoryPolicy"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/inventoryPolicies"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res7687/providers/Microsoft.Storage/storageAccounts/sto9699/inventoryPolicies/default"),
	// 	Properties: &armstorage.BlobInventoryPolicyProperties{
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-05T02:53:39.093Z"); return t}()),
	// 		Policy: &armstorage.BlobInventoryPolicySchema{
	// 			Type: to.Ptr(armstorage.InventoryRuleTypeInventory),
	// 			Enabled: to.Ptr(true),
	// 			Rules: []*armstorage.BlobInventoryPolicyRule{
	// 				{
	// 					Name: to.Ptr("inventoryPolicyRule1"),
	// 					Definition: &armstorage.BlobInventoryPolicyDefinition{
	// 						Format: to.Ptr(armstorage.FormatCSV),
	// 						Filters: &armstorage.BlobInventoryPolicyFilter{
	// 							BlobTypes: []*string{
	// 								to.Ptr("blockBlob"),
	// 								to.Ptr("appendBlob"),
	// 								to.Ptr("pageBlob")},
	// 								IncludeBlobVersions: to.Ptr(true),
	// 								IncludeSnapshots: to.Ptr(true),
	// 								PrefixMatch: []*string{
	// 									to.Ptr("inventoryprefix1"),
	// 									to.Ptr("inventoryprefix2")},
	// 								},
	// 								ObjectType: to.Ptr(armstorage.ObjectTypeBlob),
	// 								Schedule: to.Ptr(armstorage.ScheduleDaily),
	// 								SchemaFields: []*string{
	// 									to.Ptr("Name"),
	// 									to.Ptr("Creation-Time"),
	// 									to.Ptr("Last-Modified"),
	// 									to.Ptr("Content-Length"),
	// 									to.Ptr("Content-MD5"),
	// 									to.Ptr("BlobType"),
	// 									to.Ptr("AccessTier"),
	// 									to.Ptr("AccessTierChangeTime"),
	// 									to.Ptr("Snapshot"),
	// 									to.Ptr("VersionId"),
	// 									to.Ptr("IsCurrentVersion"),
	// 									to.Ptr("Metadata")},
	// 								},
	// 								Destination: to.Ptr("container1"),
	// 								Enabled: to.Ptr(true),
	// 						}},
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/220ad9c6554fc7d6d10a89bdb441c1e3b36e3285/specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountSetBlobInventoryPolicy.json
func ExampleBlobInventoryPoliciesClient_CreateOrUpdate_storageAccountSetBlobInventoryPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBlobInventoryPoliciesClient().CreateOrUpdate(ctx, "res7687", "sto9699", armstorage.BlobInventoryPolicyNameDefault, armstorage.BlobInventoryPolicy{
		Properties: &armstorage.BlobInventoryPolicyProperties{
			Policy: &armstorage.BlobInventoryPolicySchema{
				Type:    to.Ptr(armstorage.InventoryRuleTypeInventory),
				Enabled: to.Ptr(true),
				Rules: []*armstorage.BlobInventoryPolicyRule{
					{
						Name: to.Ptr("inventoryPolicyRule1"),
						Definition: &armstorage.BlobInventoryPolicyDefinition{
							Format: to.Ptr(armstorage.FormatCSV),
							Filters: &armstorage.BlobInventoryPolicyFilter{
								BlobTypes: []*string{
									to.Ptr("blockBlob"),
									to.Ptr("appendBlob"),
									to.Ptr("pageBlob")},
								CreationTime: &armstorage.BlobInventoryCreationTime{
									LastNDays: to.Ptr[int32](1000),
								},
								IncludeBlobVersions: to.Ptr(true),
								IncludeSnapshots:    to.Ptr(true),
								PrefixMatch: []*string{
									to.Ptr("inventoryprefix1"),
									to.Ptr("inventoryprefix2")},
							},
							ObjectType: to.Ptr(armstorage.ObjectTypeBlob),
							Schedule:   to.Ptr(armstorage.ScheduleDaily),
							SchemaFields: []*string{
								to.Ptr("Name"),
								to.Ptr("Creation-Time"),
								to.Ptr("Last-Modified"),
								to.Ptr("Content-Length"),
								to.Ptr("Content-MD5"),
								to.Ptr("BlobType"),
								to.Ptr("AccessTier"),
								to.Ptr("AccessTierChangeTime"),
								to.Ptr("Snapshot"),
								to.Ptr("VersionId"),
								to.Ptr("IsCurrentVersion"),
								to.Ptr("Metadata")},
						},
						Destination: to.Ptr("container1"),
						Enabled:     to.Ptr(true),
					},
					{
						Name: to.Ptr("inventoryPolicyRule2"),
						Definition: &armstorage.BlobInventoryPolicyDefinition{
							Format:     to.Ptr(armstorage.FormatParquet),
							ObjectType: to.Ptr(armstorage.ObjectTypeContainer),
							Schedule:   to.Ptr(armstorage.ScheduleWeekly),
							SchemaFields: []*string{
								to.Ptr("Name"),
								to.Ptr("Last-Modified"),
								to.Ptr("Metadata"),
								to.Ptr("LeaseStatus"),
								to.Ptr("LeaseState"),
								to.Ptr("LeaseDuration"),
								to.Ptr("PublicAccess"),
								to.Ptr("HasImmutabilityPolicy"),
								to.Ptr("HasLegalHold")},
						},
						Destination: to.Ptr("container2"),
						Enabled:     to.Ptr(true),
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BlobInventoryPolicy = armstorage.BlobInventoryPolicy{
	// 	Name: to.Ptr("DefaultInventoryPolicy"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/inventoryPolicies"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res7687/providers/Microsoft.Storage/storageAccounts/sto9699/inventoryPolicies/default"),
	// 	Properties: &armstorage.BlobInventoryPolicyProperties{
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-05T02:53:39.093Z"); return t}()),
	// 		Policy: &armstorage.BlobInventoryPolicySchema{
	// 			Type: to.Ptr(armstorage.InventoryRuleTypeInventory),
	// 			Enabled: to.Ptr(true),
	// 			Rules: []*armstorage.BlobInventoryPolicyRule{
	// 				{
	// 					Name: to.Ptr("inventoryPolicyRule1"),
	// 					Definition: &armstorage.BlobInventoryPolicyDefinition{
	// 						Format: to.Ptr(armstorage.FormatCSV),
	// 						Filters: &armstorage.BlobInventoryPolicyFilter{
	// 							BlobTypes: []*string{
	// 								to.Ptr("blockBlob"),
	// 								to.Ptr("appendBlob"),
	// 								to.Ptr("pageBlob")},
	// 								CreationTime: &armstorage.BlobInventoryCreationTime{
	// 									LastNDays: to.Ptr[int32](1000),
	// 								},
	// 								IncludeBlobVersions: to.Ptr(true),
	// 								IncludeSnapshots: to.Ptr(true),
	// 								PrefixMatch: []*string{
	// 									to.Ptr("inventoryprefix1"),
	// 									to.Ptr("inventoryprefix2")},
	// 								},
	// 								ObjectType: to.Ptr(armstorage.ObjectTypeBlob),
	// 								Schedule: to.Ptr(armstorage.ScheduleDaily),
	// 								SchemaFields: []*string{
	// 									to.Ptr("Name"),
	// 									to.Ptr("Creation-Time"),
	// 									to.Ptr("Last-Modified"),
	// 									to.Ptr("Content-Length"),
	// 									to.Ptr("Content-MD5"),
	// 									to.Ptr("BlobType"),
	// 									to.Ptr("AccessTier"),
	// 									to.Ptr("AccessTierChangeTime"),
	// 									to.Ptr("Snapshot"),
	// 									to.Ptr("VersionId"),
	// 									to.Ptr("IsCurrentVersion"),
	// 									to.Ptr("Metadata")},
	// 								},
	// 								Destination: to.Ptr("container1"),
	// 								Enabled: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("inventoryPolicyRule2"),
	// 								Definition: &armstorage.BlobInventoryPolicyDefinition{
	// 									Format: to.Ptr(armstorage.FormatParquet),
	// 									ObjectType: to.Ptr(armstorage.ObjectTypeContainer),
	// 									Schedule: to.Ptr(armstorage.ScheduleWeekly),
	// 									SchemaFields: []*string{
	// 										to.Ptr("Name"),
	// 										to.Ptr("Last-Modified"),
	// 										to.Ptr("Metadata"),
	// 										to.Ptr("LeaseStatus"),
	// 										to.Ptr("LeaseState"),
	// 										to.Ptr("LeaseDuration"),
	// 										to.Ptr("PublicAccess"),
	// 										to.Ptr("HasImmutabilityPolicy"),
	// 										to.Ptr("HasLegalHold")},
	// 									},
	// 									Destination: to.Ptr("container2"),
	// 									Enabled: to.Ptr(true),
	// 							}},
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/220ad9c6554fc7d6d10a89bdb441c1e3b36e3285/specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountSetBlobInventoryPolicyIncludeDeleteAndNewSchemaForHnsAccount.json
func ExampleBlobInventoryPoliciesClient_CreateOrUpdate_storageAccountSetBlobInventoryPolicyIncludeDeleteAndNewSchemaForHnsAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBlobInventoryPoliciesClient().CreateOrUpdate(ctx, "res7687", "sto9699", armstorage.BlobInventoryPolicyNameDefault, armstorage.BlobInventoryPolicy{
		Properties: &armstorage.BlobInventoryPolicyProperties{
			Policy: &armstorage.BlobInventoryPolicySchema{
				Type:    to.Ptr(armstorage.InventoryRuleTypeInventory),
				Enabled: to.Ptr(true),
				Rules: []*armstorage.BlobInventoryPolicyRule{
					{
						Name: to.Ptr("inventoryPolicyRule1"),
						Definition: &armstorage.BlobInventoryPolicyDefinition{
							Format: to.Ptr(armstorage.FormatCSV),
							Filters: &armstorage.BlobInventoryPolicyFilter{
								BlobTypes: []*string{
									to.Ptr("blockBlob"),
									to.Ptr("appendBlob"),
									to.Ptr("pageBlob")},
								ExcludePrefix: []*string{
									to.Ptr("excludeprefix1"),
									to.Ptr("excludeprefix2")},
								IncludeBlobVersions: to.Ptr(true),
								IncludeDeleted:      to.Ptr(true),
								IncludeSnapshots:    to.Ptr(true),
								PrefixMatch: []*string{
									to.Ptr("inventoryprefix1"),
									to.Ptr("inventoryprefix2")},
							},
							ObjectType: to.Ptr(armstorage.ObjectTypeBlob),
							Schedule:   to.Ptr(armstorage.ScheduleDaily),
							SchemaFields: []*string{
								to.Ptr("Name"),
								to.Ptr("Creation-Time"),
								to.Ptr("Last-Modified"),
								to.Ptr("Content-Length"),
								to.Ptr("Content-MD5"),
								to.Ptr("BlobType"),
								to.Ptr("AccessTier"),
								to.Ptr("AccessTierChangeTime"),
								to.Ptr("Snapshot"),
								to.Ptr("VersionId"),
								to.Ptr("IsCurrentVersion"),
								to.Ptr("ContentType"),
								to.Ptr("ContentEncoding"),
								to.Ptr("ContentLanguage"),
								to.Ptr("ContentCRC64"),
								to.Ptr("CacheControl"),
								to.Ptr("Metadata"),
								to.Ptr("DeletionId"),
								to.Ptr("Deleted"),
								to.Ptr("DeletedTime"),
								to.Ptr("RemainingRetentionDays")},
						},
						Destination: to.Ptr("container1"),
						Enabled:     to.Ptr(true),
					},
					{
						Name: to.Ptr("inventoryPolicyRule2"),
						Definition: &armstorage.BlobInventoryPolicyDefinition{
							Format:     to.Ptr(armstorage.FormatParquet),
							ObjectType: to.Ptr(armstorage.ObjectTypeContainer),
							Schedule:   to.Ptr(armstorage.ScheduleWeekly),
							SchemaFields: []*string{
								to.Ptr("Name"),
								to.Ptr("Last-Modified"),
								to.Ptr("Metadata"),
								to.Ptr("LeaseStatus"),
								to.Ptr("LeaseState"),
								to.Ptr("LeaseDuration"),
								to.Ptr("PublicAccess"),
								to.Ptr("HasImmutabilityPolicy"),
								to.Ptr("HasLegalHold"),
								to.Ptr("Etag"),
								to.Ptr("DefaultEncryptionScope"),
								to.Ptr("DenyEncryptionScopeOverride"),
								to.Ptr("ImmutableStorageWithVersioningEnabled"),
								to.Ptr("Deleted"),
								to.Ptr("Version"),
								to.Ptr("DeletedTime"),
								to.Ptr("RemainingRetentionDays")},
						},
						Destination: to.Ptr("container2"),
						Enabled:     to.Ptr(true),
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BlobInventoryPolicy = armstorage.BlobInventoryPolicy{
	// 	Name: to.Ptr("DefaultInventoryPolicy"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/inventoryPolicies"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res7687/providers/Microsoft.Storage/storageAccounts/sto9699/inventoryPolicies/default"),
	// 	Properties: &armstorage.BlobInventoryPolicyProperties{
	// 		Policy: &armstorage.BlobInventoryPolicySchema{
	// 			Type: to.Ptr(armstorage.InventoryRuleTypeInventory),
	// 			Enabled: to.Ptr(true),
	// 			Rules: []*armstorage.BlobInventoryPolicyRule{
	// 				{
	// 					Name: to.Ptr("inventoryPolicyRule1"),
	// 					Definition: &armstorage.BlobInventoryPolicyDefinition{
	// 						Format: to.Ptr(armstorage.FormatCSV),
	// 						Filters: &armstorage.BlobInventoryPolicyFilter{
	// 							BlobTypes: []*string{
	// 								to.Ptr("blockBlob"),
	// 								to.Ptr("appendBlob"),
	// 								to.Ptr("pageBlob")},
	// 								ExcludePrefix: []*string{
	// 									to.Ptr("excludeprefix1"),
	// 									to.Ptr("excludeprefix2")},
	// 									IncludeBlobVersions: to.Ptr(true),
	// 									IncludeDeleted: to.Ptr(true),
	// 									IncludeSnapshots: to.Ptr(true),
	// 									PrefixMatch: []*string{
	// 										to.Ptr("inventoryprefix1"),
	// 										to.Ptr("inventoryprefix2")},
	// 									},
	// 									ObjectType: to.Ptr(armstorage.ObjectTypeBlob),
	// 									Schedule: to.Ptr(armstorage.ScheduleDaily),
	// 									SchemaFields: []*string{
	// 										to.Ptr("Name"),
	// 										to.Ptr("Creation-Time"),
	// 										to.Ptr("Last-Modified"),
	// 										to.Ptr("Content-Length"),
	// 										to.Ptr("Content-MD5"),
	// 										to.Ptr("BlobType"),
	// 										to.Ptr("AccessTier"),
	// 										to.Ptr("AccessTierChangeTime"),
	// 										to.Ptr("Snapshot"),
	// 										to.Ptr("VersionId"),
	// 										to.Ptr("IsCurrentVersion"),
	// 										to.Ptr("ContentType"),
	// 										to.Ptr("ContentEncoding"),
	// 										to.Ptr("ContentLanguage"),
	// 										to.Ptr("ContentCRC64"),
	// 										to.Ptr("CacheControl"),
	// 										to.Ptr("Metadata"),
	// 										to.Ptr("DeletionId"),
	// 										to.Ptr("Deleted"),
	// 										to.Ptr("DeletedTime"),
	// 										to.Ptr("RemainingRetentionDays")},
	// 									},
	// 									Destination: to.Ptr("container1"),
	// 									Enabled: to.Ptr(true),
	// 								},
	// 								{
	// 									Name: to.Ptr("inventoryPolicyRule2"),
	// 									Definition: &armstorage.BlobInventoryPolicyDefinition{
	// 										Format: to.Ptr(armstorage.FormatParquet),
	// 										ObjectType: to.Ptr(armstorage.ObjectTypeContainer),
	// 										Schedule: to.Ptr(armstorage.ScheduleWeekly),
	// 										SchemaFields: []*string{
	// 											to.Ptr("Name"),
	// 											to.Ptr("Last-Modified"),
	// 											to.Ptr("Metadata"),
	// 											to.Ptr("LeaseStatus"),
	// 											to.Ptr("LeaseState"),
	// 											to.Ptr("LeaseDuration"),
	// 											to.Ptr("PublicAccess"),
	// 											to.Ptr("HasImmutabilityPolicy"),
	// 											to.Ptr("HasLegalHold"),
	// 											to.Ptr("Etag"),
	// 											to.Ptr("DefaultEncryptionScope"),
	// 											to.Ptr("DenyEncryptionScopeOverride"),
	// 											to.Ptr("ImmutableStorageWithVersioningEnabled"),
	// 											to.Ptr("Deleted"),
	// 											to.Ptr("Version"),
	// 											to.Ptr("DeletedTime"),
	// 											to.Ptr("RemainingRetentionDays")},
	// 										},
	// 										Destination: to.Ptr("container2"),
	// 										Enabled: to.Ptr(true),
	// 								}},
	// 							},
	// 						},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/220ad9c6554fc7d6d10a89bdb441c1e3b36e3285/specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountSetBlobInventoryPolicyIncludeDeleteAndNewSchemaForNonHnsAccount.json
func ExampleBlobInventoryPoliciesClient_CreateOrUpdate_storageAccountSetBlobInventoryPolicyIncludeDeleteAndNewSchemaForNonHnsAccount() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBlobInventoryPoliciesClient().CreateOrUpdate(ctx, "res7687", "sto9699", armstorage.BlobInventoryPolicyNameDefault, armstorage.BlobInventoryPolicy{
		Properties: &armstorage.BlobInventoryPolicyProperties{
			Policy: &armstorage.BlobInventoryPolicySchema{
				Type:    to.Ptr(armstorage.InventoryRuleTypeInventory),
				Enabled: to.Ptr(true),
				Rules: []*armstorage.BlobInventoryPolicyRule{
					{
						Name: to.Ptr("inventoryPolicyRule1"),
						Definition: &armstorage.BlobInventoryPolicyDefinition{
							Format: to.Ptr(armstorage.FormatCSV),
							Filters: &armstorage.BlobInventoryPolicyFilter{
								BlobTypes: []*string{
									to.Ptr("blockBlob"),
									to.Ptr("appendBlob"),
									to.Ptr("pageBlob")},
								ExcludePrefix: []*string{
									to.Ptr("excludeprefix1"),
									to.Ptr("excludeprefix2")},
								IncludeBlobVersions: to.Ptr(true),
								IncludeDeleted:      to.Ptr(true),
								IncludeSnapshots:    to.Ptr(true),
								PrefixMatch: []*string{
									to.Ptr("inventoryprefix1"),
									to.Ptr("inventoryprefix2")},
							},
							ObjectType: to.Ptr(armstorage.ObjectTypeBlob),
							Schedule:   to.Ptr(armstorage.ScheduleDaily),
							SchemaFields: []*string{
								to.Ptr("Name"),
								to.Ptr("Creation-Time"),
								to.Ptr("Last-Modified"),
								to.Ptr("Content-Length"),
								to.Ptr("Content-MD5"),
								to.Ptr("BlobType"),
								to.Ptr("AccessTier"),
								to.Ptr("AccessTierChangeTime"),
								to.Ptr("Snapshot"),
								to.Ptr("VersionId"),
								to.Ptr("IsCurrentVersion"),
								to.Ptr("Tags"),
								to.Ptr("ContentType"),
								to.Ptr("ContentEncoding"),
								to.Ptr("ContentLanguage"),
								to.Ptr("ContentCRC64"),
								to.Ptr("CacheControl"),
								to.Ptr("Metadata"),
								to.Ptr("Deleted"),
								to.Ptr("RemainingRetentionDays")},
						},
						Destination: to.Ptr("container1"),
						Enabled:     to.Ptr(true),
					},
					{
						Name: to.Ptr("inventoryPolicyRule2"),
						Definition: &armstorage.BlobInventoryPolicyDefinition{
							Format:     to.Ptr(armstorage.FormatParquet),
							ObjectType: to.Ptr(armstorage.ObjectTypeContainer),
							Schedule:   to.Ptr(armstorage.ScheduleWeekly),
							SchemaFields: []*string{
								to.Ptr("Name"),
								to.Ptr("Last-Modified"),
								to.Ptr("Metadata"),
								to.Ptr("LeaseStatus"),
								to.Ptr("LeaseState"),
								to.Ptr("LeaseDuration"),
								to.Ptr("PublicAccess"),
								to.Ptr("HasImmutabilityPolicy"),
								to.Ptr("HasLegalHold"),
								to.Ptr("Etag"),
								to.Ptr("DefaultEncryptionScope"),
								to.Ptr("DenyEncryptionScopeOverride"),
								to.Ptr("ImmutableStorageWithVersioningEnabled"),
								to.Ptr("Deleted"),
								to.Ptr("Version"),
								to.Ptr("DeletedTime"),
								to.Ptr("RemainingRetentionDays")},
						},
						Destination: to.Ptr("container2"),
						Enabled:     to.Ptr(true),
					}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BlobInventoryPolicy = armstorage.BlobInventoryPolicy{
	// 	Name: to.Ptr("DefaultInventoryPolicy"),
	// 	Type: to.Ptr("Microsoft.Storage/storageAccounts/inventoryPolicies"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res7687/providers/Microsoft.Storage/storageAccounts/sto9699/inventoryPolicies/default"),
	// 	Properties: &armstorage.BlobInventoryPolicyProperties{
	// 		Policy: &armstorage.BlobInventoryPolicySchema{
	// 			Type: to.Ptr(armstorage.InventoryRuleTypeInventory),
	// 			Enabled: to.Ptr(true),
	// 			Rules: []*armstorage.BlobInventoryPolicyRule{
	// 				{
	// 					Name: to.Ptr("inventoryPolicyRule1"),
	// 					Definition: &armstorage.BlobInventoryPolicyDefinition{
	// 						Format: to.Ptr(armstorage.FormatCSV),
	// 						Filters: &armstorage.BlobInventoryPolicyFilter{
	// 							BlobTypes: []*string{
	// 								to.Ptr("blockBlob"),
	// 								to.Ptr("appendBlob"),
	// 								to.Ptr("pageBlob")},
	// 								ExcludePrefix: []*string{
	// 									to.Ptr("excludeprefix1"),
	// 									to.Ptr("excludeprefix2")},
	// 									IncludeBlobVersions: to.Ptr(true),
	// 									IncludeDeleted: to.Ptr(true),
	// 									IncludeSnapshots: to.Ptr(true),
	// 									PrefixMatch: []*string{
	// 										to.Ptr("inventoryprefix1"),
	// 										to.Ptr("inventoryprefix2")},
	// 									},
	// 									ObjectType: to.Ptr(armstorage.ObjectTypeBlob),
	// 									Schedule: to.Ptr(armstorage.ScheduleDaily),
	// 									SchemaFields: []*string{
	// 										to.Ptr("Name"),
	// 										to.Ptr("Creation-Time"),
	// 										to.Ptr("Last-Modified"),
	// 										to.Ptr("Content-Length"),
	// 										to.Ptr("Content-MD5"),
	// 										to.Ptr("BlobType"),
	// 										to.Ptr("AccessTier"),
	// 										to.Ptr("AccessTierChangeTime"),
	// 										to.Ptr("Snapshot"),
	// 										to.Ptr("VersionId"),
	// 										to.Ptr("IsCurrentVersion"),
	// 										to.Ptr("Tags"),
	// 										to.Ptr("ContentType"),
	// 										to.Ptr("ContentEncoding"),
	// 										to.Ptr("ContentLanguage"),
	// 										to.Ptr("ContentCRC64"),
	// 										to.Ptr("CacheControl"),
	// 										to.Ptr("Metadata"),
	// 										to.Ptr("Deleted"),
	// 										to.Ptr("RemainingRetentionDays")},
	// 									},
	// 									Destination: to.Ptr("container1"),
	// 									Enabled: to.Ptr(true),
	// 								},
	// 								{
	// 									Name: to.Ptr("inventoryPolicyRule2"),
	// 									Definition: &armstorage.BlobInventoryPolicyDefinition{
	// 										Format: to.Ptr(armstorage.FormatParquet),
	// 										ObjectType: to.Ptr(armstorage.ObjectTypeContainer),
	// 										Schedule: to.Ptr(armstorage.ScheduleWeekly),
	// 										SchemaFields: []*string{
	// 											to.Ptr("Name"),
	// 											to.Ptr("Last-Modified"),
	// 											to.Ptr("Metadata"),
	// 											to.Ptr("LeaseStatus"),
	// 											to.Ptr("LeaseState"),
	// 											to.Ptr("LeaseDuration"),
	// 											to.Ptr("PublicAccess"),
	// 											to.Ptr("HasImmutabilityPolicy"),
	// 											to.Ptr("HasLegalHold"),
	// 											to.Ptr("Etag"),
	// 											to.Ptr("DefaultEncryptionScope"),
	// 											to.Ptr("DenyEncryptionScopeOverride"),
	// 											to.Ptr("ImmutableStorageWithVersioningEnabled"),
	// 											to.Ptr("Deleted"),
	// 											to.Ptr("Version"),
	// 											to.Ptr("DeletedTime"),
	// 											to.Ptr("RemainingRetentionDays")},
	// 										},
	// 										Destination: to.Ptr("container2"),
	// 										Enabled: to.Ptr(true),
	// 								}},
	// 							},
	// 						},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/220ad9c6554fc7d6d10a89bdb441c1e3b36e3285/specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountDeleteBlobInventoryPolicy.json
func ExampleBlobInventoryPoliciesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewBlobInventoryPoliciesClient().Delete(ctx, "res6977", "sto2527", armstorage.BlobInventoryPolicyNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/220ad9c6554fc7d6d10a89bdb441c1e3b36e3285/specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountListBlobInventoryPolicy.json
func ExampleBlobInventoryPoliciesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorage.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewBlobInventoryPoliciesClient().NewListPager("res7687", "sto9699", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListBlobInventoryPolicy = armstorage.ListBlobInventoryPolicy{
		// 	Value: []*armstorage.BlobInventoryPolicy{
		// 		{
		// 			Name: to.Ptr("DefaultInventoryPolicy"),
		// 			Type: to.Ptr("Microsoft.Storage/storageAccounts/inventoryPolicies"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/res7687/providers/Microsoft.Storage/storageAccounts/sto9699/inventoryPolicies/default"),
		// 			Properties: &armstorage.BlobInventoryPolicyProperties{
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-05T02:53:39.093Z"); return t}()),
		// 				Policy: &armstorage.BlobInventoryPolicySchema{
		// 					Type: to.Ptr(armstorage.InventoryRuleTypeInventory),
		// 					Enabled: to.Ptr(true),
		// 					Rules: []*armstorage.BlobInventoryPolicyRule{
		// 						{
		// 							Name: to.Ptr("inventoryPolicyRule1"),
		// 							Definition: &armstorage.BlobInventoryPolicyDefinition{
		// 								Format: to.Ptr(armstorage.FormatCSV),
		// 								Filters: &armstorage.BlobInventoryPolicyFilter{
		// 									BlobTypes: []*string{
		// 										to.Ptr("blockBlob"),
		// 										to.Ptr("appendBlob"),
		// 										to.Ptr("pageBlob")},
		// 										IncludeBlobVersions: to.Ptr(true),
		// 										IncludeSnapshots: to.Ptr(true),
		// 										PrefixMatch: []*string{
		// 											to.Ptr("inventoryprefix1"),
		// 											to.Ptr("inventoryprefix2")},
		// 										},
		// 										ObjectType: to.Ptr(armstorage.ObjectTypeBlob),
		// 										Schedule: to.Ptr(armstorage.ScheduleDaily),
		// 										SchemaFields: []*string{
		// 											to.Ptr("Name"),
		// 											to.Ptr("Creation-Time"),
		// 											to.Ptr("Last-Modified"),
		// 											to.Ptr("Content-Length"),
		// 											to.Ptr("Content-MD5"),
		// 											to.Ptr("BlobType"),
		// 											to.Ptr("AccessTier"),
		// 											to.Ptr("AccessTierChangeTime"),
		// 											to.Ptr("Snapshot"),
		// 											to.Ptr("VersionId"),
		// 											to.Ptr("IsCurrentVersion"),
		// 											to.Ptr("Metadata")},
		// 										},
		// 										Destination: to.Ptr("container1"),
		// 										Enabled: to.Ptr(true),
		// 								}},
		// 							},
		// 						},
		// 				}},
		// 			}
	}
}
