// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/channel/v1/service.proto

package channelpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudChannelService_ListCustomers_FullMethodName                       = "/google.cloud.channel.v1.CloudChannelService/ListCustomers"
	CloudChannelService_GetCustomer_FullMethodName                         = "/google.cloud.channel.v1.CloudChannelService/GetCustomer"
	CloudChannelService_CheckCloudIdentityAccountsExist_FullMethodName     = "/google.cloud.channel.v1.CloudChannelService/CheckCloudIdentityAccountsExist"
	CloudChannelService_CreateCustomer_FullMethodName                      = "/google.cloud.channel.v1.CloudChannelService/CreateCustomer"
	CloudChannelService_UpdateCustomer_FullMethodName                      = "/google.cloud.channel.v1.CloudChannelService/UpdateCustomer"
	CloudChannelService_DeleteCustomer_FullMethodName                      = "/google.cloud.channel.v1.CloudChannelService/DeleteCustomer"
	CloudChannelService_ImportCustomer_FullMethodName                      = "/google.cloud.channel.v1.CloudChannelService/ImportCustomer"
	CloudChannelService_ProvisionCloudIdentity_FullMethodName              = "/google.cloud.channel.v1.CloudChannelService/ProvisionCloudIdentity"
	CloudChannelService_ListEntitlements_FullMethodName                    = "/google.cloud.channel.v1.CloudChannelService/ListEntitlements"
	CloudChannelService_ListTransferableSkus_FullMethodName                = "/google.cloud.channel.v1.CloudChannelService/ListTransferableSkus"
	CloudChannelService_ListTransferableOffers_FullMethodName              = "/google.cloud.channel.v1.CloudChannelService/ListTransferableOffers"
	CloudChannelService_GetEntitlement_FullMethodName                      = "/google.cloud.channel.v1.CloudChannelService/GetEntitlement"
	CloudChannelService_CreateEntitlement_FullMethodName                   = "/google.cloud.channel.v1.CloudChannelService/CreateEntitlement"
	CloudChannelService_ChangeParameters_FullMethodName                    = "/google.cloud.channel.v1.CloudChannelService/ChangeParameters"
	CloudChannelService_ChangeRenewalSettings_FullMethodName               = "/google.cloud.channel.v1.CloudChannelService/ChangeRenewalSettings"
	CloudChannelService_ChangeOffer_FullMethodName                         = "/google.cloud.channel.v1.CloudChannelService/ChangeOffer"
	CloudChannelService_StartPaidService_FullMethodName                    = "/google.cloud.channel.v1.CloudChannelService/StartPaidService"
	CloudChannelService_SuspendEntitlement_FullMethodName                  = "/google.cloud.channel.v1.CloudChannelService/SuspendEntitlement"
	CloudChannelService_CancelEntitlement_FullMethodName                   = "/google.cloud.channel.v1.CloudChannelService/CancelEntitlement"
	CloudChannelService_ActivateEntitlement_FullMethodName                 = "/google.cloud.channel.v1.CloudChannelService/ActivateEntitlement"
	CloudChannelService_TransferEntitlements_FullMethodName                = "/google.cloud.channel.v1.CloudChannelService/TransferEntitlements"
	CloudChannelService_TransferEntitlementsToGoogle_FullMethodName        = "/google.cloud.channel.v1.CloudChannelService/TransferEntitlementsToGoogle"
	CloudChannelService_ListChannelPartnerLinks_FullMethodName             = "/google.cloud.channel.v1.CloudChannelService/ListChannelPartnerLinks"
	CloudChannelService_GetChannelPartnerLink_FullMethodName               = "/google.cloud.channel.v1.CloudChannelService/GetChannelPartnerLink"
	CloudChannelService_CreateChannelPartnerLink_FullMethodName            = "/google.cloud.channel.v1.CloudChannelService/CreateChannelPartnerLink"
	CloudChannelService_UpdateChannelPartnerLink_FullMethodName            = "/google.cloud.channel.v1.CloudChannelService/UpdateChannelPartnerLink"
	CloudChannelService_GetCustomerRepricingConfig_FullMethodName          = "/google.cloud.channel.v1.CloudChannelService/GetCustomerRepricingConfig"
	CloudChannelService_ListCustomerRepricingConfigs_FullMethodName        = "/google.cloud.channel.v1.CloudChannelService/ListCustomerRepricingConfigs"
	CloudChannelService_CreateCustomerRepricingConfig_FullMethodName       = "/google.cloud.channel.v1.CloudChannelService/CreateCustomerRepricingConfig"
	CloudChannelService_UpdateCustomerRepricingConfig_FullMethodName       = "/google.cloud.channel.v1.CloudChannelService/UpdateCustomerRepricingConfig"
	CloudChannelService_DeleteCustomerRepricingConfig_FullMethodName       = "/google.cloud.channel.v1.CloudChannelService/DeleteCustomerRepricingConfig"
	CloudChannelService_GetChannelPartnerRepricingConfig_FullMethodName    = "/google.cloud.channel.v1.CloudChannelService/GetChannelPartnerRepricingConfig"
	CloudChannelService_ListChannelPartnerRepricingConfigs_FullMethodName  = "/google.cloud.channel.v1.CloudChannelService/ListChannelPartnerRepricingConfigs"
	CloudChannelService_CreateChannelPartnerRepricingConfig_FullMethodName = "/google.cloud.channel.v1.CloudChannelService/CreateChannelPartnerRepricingConfig"
	CloudChannelService_UpdateChannelPartnerRepricingConfig_FullMethodName = "/google.cloud.channel.v1.CloudChannelService/UpdateChannelPartnerRepricingConfig"
	CloudChannelService_DeleteChannelPartnerRepricingConfig_FullMethodName = "/google.cloud.channel.v1.CloudChannelService/DeleteChannelPartnerRepricingConfig"
	CloudChannelService_ListSkuGroups_FullMethodName                       = "/google.cloud.channel.v1.CloudChannelService/ListSkuGroups"
	CloudChannelService_ListSkuGroupBillableSkus_FullMethodName            = "/google.cloud.channel.v1.CloudChannelService/ListSkuGroupBillableSkus"
	CloudChannelService_LookupOffer_FullMethodName                         = "/google.cloud.channel.v1.CloudChannelService/LookupOffer"
	CloudChannelService_ListProducts_FullMethodName                        = "/google.cloud.channel.v1.CloudChannelService/ListProducts"
	CloudChannelService_ListSkus_FullMethodName                            = "/google.cloud.channel.v1.CloudChannelService/ListSkus"
	CloudChannelService_ListOffers_FullMethodName                          = "/google.cloud.channel.v1.CloudChannelService/ListOffers"
	CloudChannelService_ListPurchasableSkus_FullMethodName                 = "/google.cloud.channel.v1.CloudChannelService/ListPurchasableSkus"
	CloudChannelService_ListPurchasableOffers_FullMethodName               = "/google.cloud.channel.v1.CloudChannelService/ListPurchasableOffers"
	CloudChannelService_QueryEligibleBillingAccounts_FullMethodName        = "/google.cloud.channel.v1.CloudChannelService/QueryEligibleBillingAccounts"
	CloudChannelService_RegisterSubscriber_FullMethodName                  = "/google.cloud.channel.v1.CloudChannelService/RegisterSubscriber"
	CloudChannelService_UnregisterSubscriber_FullMethodName                = "/google.cloud.channel.v1.CloudChannelService/UnregisterSubscriber"
	CloudChannelService_ListSubscribers_FullMethodName                     = "/google.cloud.channel.v1.CloudChannelService/ListSubscribers"
	CloudChannelService_ListEntitlementChanges_FullMethodName              = "/google.cloud.channel.v1.CloudChannelService/ListEntitlementChanges"
)

// CloudChannelServiceClient is the client API for CloudChannelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudChannelServiceClient interface {
	// List [Customer][google.cloud.channel.v1.Customer]s.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// List of [Customer][google.cloud.channel.v1.Customer]s, or an empty list if
	// there are no customers.
	ListCustomers(ctx context.Context, in *ListCustomersRequest, opts ...grpc.CallOption) (*ListCustomersResponse, error)
	// Returns the requested [Customer][google.cloud.channel.v1.Customer]
	// resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
	// invalid name parameter.
	//
	// Return value:
	// The [Customer][google.cloud.channel.v1.Customer] resource.
	GetCustomer(ctx context.Context, in *GetCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Confirms the existence of Cloud Identity accounts based on the domain and
	// if the Cloud Identity accounts are owned by the reseller.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * INVALID_VALUE: Invalid domain value in the request.
	//
	// Return value:
	// A list of
	// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
	// resources for the domain (may be empty)
	//
	// Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
	// no
	// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
	// resources match the domain.
	CheckCloudIdentityAccountsExist(ctx context.Context, in *CheckCloudIdentityAccountsExistRequest, opts ...grpc.CallOption) (*CheckCloudIdentityAccountsExistResponse, error)
	// Creates a new [Customer][google.cloud.channel.v1.Customer] resource under
	// the reseller or distributor account.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The reseller account making the request is different from the
	//     reseller account in the API request.
	//   - You are not authorized to create a customer. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - Domain field value doesn't match the primary email domain.
	//
	// Return value:
	// The newly created [Customer][google.cloud.channel.v1.Customer] resource.
	CreateCustomer(ctx context.Context, in *CreateCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Updates an existing [Customer][google.cloud.channel.v1.Customer] resource
	// for the reseller or distributor.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
	// for the name in the request.
	//
	// Return value:
	// The updated [Customer][google.cloud.channel.v1.Customer] resource.
	UpdateCustomer(ctx context.Context, in *UpdateCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The customer has existing entitlements.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
	// for the name in the request.
	DeleteCustomer(ctx context.Context, in *DeleteCustomerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Imports a [Customer][google.cloud.channel.v1.Customer] from the Cloud
	// Identity associated with the provided Cloud Identity ID or domain before a
	// TransferEntitlements call. If a linked Customer already exists and
	// overwrite_if_exists is true, it will update that Customer's data.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The reseller account making the request is different from the
	//     reseller account in the API request.
	//   - You are not authorized to import the customer. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
	// * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
	// expired or invalid.
	// * ALREADY_EXISTS: A customer already exists and has conflicting critical
	// fields. Requires an overwrite.
	//
	// Return value:
	// The [Customer][google.cloud.channel.v1.Customer].
	ImportCustomer(ctx context.Context, in *ImportCustomerRequest, opts ...grpc.CallOption) (*Customer, error)
	// Creates a Cloud Identity for the given customer using the customer's
	// information, or the information provided here.
	//
	// Possible error codes:
	//
	// *  PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - You are not authorized to provision cloud identity id. See
	//     https://support.google.com/channelservices/answer/9759265
	//   - INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//   - NOT_FOUND: The customer was not found.
	//   - ALREADY_EXISTS: The customer's primary email already exists. Retry
	//     after changing the customer's primary contact email.
	//   - INTERNAL: Any non-user error related to a technical issue in the
	//
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata contains an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ProvisionCloudIdentity(ctx context.Context, in *ProvisionCloudIdentityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a
	// customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// A list of the customer's
	// [Entitlement][google.cloud.channel.v1.Entitlement]s.
	ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error)
	// List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a
	// customer based on the Cloud Identity ID or Customer Name in the request.
	//
	// Use this method to list the entitlements information of an
	// unowned customer. You should provide the customer's
	// Cloud Identity ID or Customer Name.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller and has no auth token.
	//   - The supplied auth token is invalid.
	//   - The reseller account making the request is different
	//     from the reseller account in the query.
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// A list of the customer's
	// [TransferableSku][google.cloud.channel.v1.TransferableSku].
	ListTransferableSkus(ctx context.Context, in *ListTransferableSkusRequest, opts ...grpc.CallOption) (*ListTransferableSkusResponse, error)
	// List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a
	// customer based on Cloud Identity ID or Customer Name in the request.
	//
	// Use this method when a reseller gets the entitlement information of an
	// unowned customer. The reseller should provide the customer's
	// Cloud Identity ID or Customer Name.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller and has no auth token.
	//   - The customer provided incorrect reseller information when generating
	//     auth token.
	//   - The reseller account making the request is different
	//     from the reseller account in the query.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for
	// the given customer and SKU.
	ListTransferableOffers(ctx context.Context, in *ListTransferableOffersRequest, opts ...grpc.CallOption) (*ListTransferableOffersResponse, error)
	// Returns the requested [Entitlement][google.cloud.channel.v1.Entitlement]
	// resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer entitlement was not found.
	//
	// Return value:
	// The requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
	GetEntitlement(ctx context.Context, in *GetEntitlementRequest, opts ...grpc.CallOption) (*Entitlement, error)
	// Creates an entitlement for a customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - There is already a customer entitlement for a SKU from the same
	//     product family.
	//
	// * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
	// Google Channel support for further troubleshooting.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS:
	//   - The SKU was already purchased for the customer.
	//   - The customer's primary email already exists. Retry
	//     after changing the customer's primary contact email.
	//
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The domain required for purchasing a SKU has not been verified.
	//   - A pre-requisite SKU required to purchase an Add-On SKU is missing.
	//     For example, Google Workspace Business Starter is required to purchase
	//     Vault or Drive.
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CreateEntitlement(ctx context.Context, in *CreateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Change parameters of the entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// For example, the number of seats being changed is greater than the allowed
	// number of max seats, or decreasing seats for a commitment based plan.
	// * NOT_FOUND: Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeParameters(ctx context.Context, in *ChangeParametersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the renewal settings for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
	// commitment plan. Can't enable or disable renewals for non-commitment plans.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	//   - UNKNOWN: Any non-user error related to a technical issue in the backend.
	//     Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeRenewalSettings(ctx context.Context, in *ChangeRenewalSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the Offer for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Offer or Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeOffer(ctx context.Context, in *ChangeOfferRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts paid service for a trial entitlement.
	//
	// Starts paid service for a trial entitlement immediately. This method is
	// only applicable if a plan is set up for a trial entitlement but has some
	// trial days remaining.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
	// entitlement on trial plans.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	StartPaidService(ctx context.Context, in *StartPaidServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Suspends a previously fulfilled entitlement.
	//
	// An entitlement suspension is a long-running operation.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_ACTIVE: Entitlement is not active.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	SuspendEntitlement(ctx context.Context, in *SuspendEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a previously fulfilled entitlement.
	//
	// An entitlement cancellation is a long-running operation.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * FAILED_PRECONDITION: There are Google Cloud projects linked to the
	// Google Cloud entitlement's Cloud Billing subaccount.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
	// add-ons, or entitlements for Google Cloud's development platform.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CancelEntitlement(ctx context.Context, in *CancelEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Activates a previously suspended entitlement. Entitlements suspended for
	// pending ToS acceptance can't be activated using this method.
	//
	// An entitlement activation is a long-running operation and it updates
	// the state of the customer entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
	// suspensions and entitlements that have accepted the TOS.
	// * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
	// state.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ActivateEntitlement(ctx context.Context, in *ActivateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Transfers customer entitlements to new reseller.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS: The SKU was already transferred for the customer.
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The SKU requires domain verification to transfer, but the domain is
	//     not verified.
	//   - An Add-On SKU (example, Vault or Drive) is missing the
	//     pre-requisite SKU (example, G Suite Basic).
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//   - Specify all transferring entitlements.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlements(ctx context.Context, in *TransferEntitlementsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Transfers customer entitlements from their current reseller to Google.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS: The SKU was already transferred for the customer.
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The SKU requires domain verification to transfer, but the domain is
	//     not verified.
	//   - An Add-On SKU (example, Vault or Drive) is missing the
	//     pre-requisite SKU (example, G Suite Basic).
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlementsToGoogle(ctx context.Context, in *TransferEntitlementsToGoogleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s
	// belonging to a distributor. You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// The list of the distributor account's
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources.
	ListChannelPartnerLinks(ctx context.Context, in *ListChannelPartnerLinksRequest, opts ...grpc.CallOption) (*ListChannelPartnerLinksResponse, error)
	// Returns the requested
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: ChannelPartnerLink resource not found because of an
	// invalid channel partner link name.
	//
	// Return value:
	// The [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
	// resource.
	GetChannelPartnerLink(ctx context.Context, in *GetChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error)
	// Initiates a channel partner link between a distributor and a reseller, or
	// between resellers in an n-tier reseller channel.
	// Invited partners need to follow the invite_link_uri provided in the
	// response to accept. After accepting the invitation, a link is set up
	// between the two parties.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
	// exists.
	// * NOT_FOUND: No Cloud Identity customer exists for provided domain.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The new [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
	// resource.
	CreateChannelPartnerLink(ctx context.Context, in *CreateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error)
	// Updates a channel partner link. Distributors call this method to change a
	// link's status. For example, to suspend a partner link.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - Link state cannot change from invited to active or suspended.
	//   - Cannot send reseller_cloud_identity_id, invite_url, or name in update
	//     mask.
	//
	// * NOT_FOUND: ChannelPartnerLink resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The updated
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	UpdateChannelPartnerLink(ctx context.Context, in *UpdateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error)
	// Gets information about how a Reseller modifies their bill before sending
	// it to a Customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// was not found.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	GetCustomerRepricingConfig(ctx context.Context, in *GetCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error)
	// Lists information about how a Reseller modifies their bill before sending
	// it to a Customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * Customer ID
	// * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
	// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// * [CustomerRepricingConfig.update_time][google.cloud.channel.v1.CustomerRepricingConfig.update_time]
	//
	// If unsuccessful, returns an error.
	ListCustomerRepricingConfigs(ctx context.Context, in *ListCustomerRepricingConfigsRequest, opts ...grpc.CallOption) (*ListCustomerRepricingConfigsResponse, error)
	// Creates a CustomerRepricingConfig. Call this method to set modifications
	// for a specific customer's bill. You can only create configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. If needed, you can create a config for the current
	// month, with some restrictions.
	//
	// When creating a config for a future month, make sure there are no existing
	// configs for that
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// The following restrictions are for creating configs in the current month.
	//
	// * This functionality is reserved for recovering from an erroneous config,
	// and should not be used for regular business cases.
	// * The new config will not modify exports used with other configs.
	// Changes to the config may be immediate, but may take up to 24 hours.
	// * There is a limit of ten configs for any
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
	// for any
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	// * The contained
	// [CustomerRepricingConfig.repricing_config][google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]
	// value must be different from the value used in the current config for a
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	CreateCustomerRepricingConfig(ctx context.Context, in *CreateCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error)
	// Updates a CustomerRepricingConfig. Call this method to set modifications
	// for a specific customer's bill. This method overwrites the existing
	// CustomerRepricingConfig.
	//
	// You can only update configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. To make changes to configs for the current month, use
	// [CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig],
	// taking note of its restrictions. You cannot update the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// When updating a config in the future:
	//
	// * This config must already exist.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	UpdateCustomerRepricingConfig(ctx context.Context, in *UpdateCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error)
	// Deletes the given
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// permanently. You can only delete configs if their
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is set to a date after the current month.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// is active or in the past.
	// * NOT_FOUND: No
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// found for the name in the request.
	DeleteCustomerRepricingConfig(ctx context.Context, in *DeleteCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets information about how a Distributor modifies their bill before sending
	// it to a ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// was not found.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	GetChannelPartnerRepricingConfig(ctx context.Context, in *GetChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error)
	// Lists information about how a Reseller modifies their bill before sending
	// it to a ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * Channel Partner ID
	// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// * [ChannelPartnerRepricingConfig.update_time][google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]
	//
	// If unsuccessful, returns an error.
	ListChannelPartnerRepricingConfigs(ctx context.Context, in *ListChannelPartnerRepricingConfigsRequest, opts ...grpc.CallOption) (*ListChannelPartnerRepricingConfigsResponse, error)
	// Creates a ChannelPartnerRepricingConfig. Call this method to set
	// modifications for a specific ChannelPartner's bill. You can only create
	// configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. If needed, you can create a config for the current
	// month, with some restrictions.
	//
	// When creating a config for a future month, make sure there are no existing
	// configs for that
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// The following restrictions are for creating configs in the current month.
	//
	// * This functionality is reserved for recovering from an erroneous config,
	// and should not be used for regular business cases.
	// * The new config will not modify exports used with other configs.
	// Changes to the config may be immediate, but may take up to 24 hours.
	// * There is a limit of ten configs for any ChannelPartner or
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
	// for any
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	// * The contained
	// [ChannelPartnerRepricingConfig.repricing_config][google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]
	// value must be different from the value used in the current config for a
	// ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	CreateChannelPartnerRepricingConfig(ctx context.Context, in *CreateChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error)
	// Updates a ChannelPartnerRepricingConfig. Call this method to set
	// modifications for a specific ChannelPartner's bill. This method overwrites
	// the existing CustomerRepricingConfig.
	//
	// You can only update configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. To make changes to configs for the current month, use
	// [CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig],
	// taking note of its restrictions. You cannot update the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// When updating a config in the future:
	//
	// * This config must already exist.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	UpdateChannelPartnerRepricingConfig(ctx context.Context, in *UpdateChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error)
	// Deletes the given
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// permanently. You can only delete configs if their
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is set to a date after the current month.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// is active or in the past.
	// * NOT_FOUND: No
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// found for the name in the request.
	DeleteChannelPartnerRepricingConfig(ctx context.Context, in *DeleteChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the Rebilling supported SKU groups the account is authorized to
	// sell.
	// Reference: https://cloud.google.com/skus/sku-groups
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different, or the account doesn't exist.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the [SkuGroup][google.cloud.channel.v1.SkuGroup] resources.
	// The data for each resource is displayed in the alphabetical order of SKU
	// group display name.
	// The data for each resource is displayed in the ascending order of
	// [SkuGroup.display_name][google.cloud.channel.v1.SkuGroup.display_name]
	//
	// If unsuccessful, returns an error.
	ListSkuGroups(ctx context.Context, in *ListSkuGroupsRequest, opts ...grpc.CallOption) (*ListSkuGroupsResponse, error)
	// Lists the Billable SKUs in a given SKU group.
	//
	// Possible error codes:
	// PERMISSION_DENIED: If the account making the request and the account
	// being queried for are different, or the account doesn't exist.
	// INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// INTERNAL: Any non-user error related to technical issue in the
	// backend. In this case, contact cloud channel support.
	//
	// Return Value:
	// If successful, the [BillableSku][google.cloud.channel.v1.BillableSku]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * [BillableSku.service_display_name][google.cloud.channel.v1.BillableSku.service_display_name]
	// * [BillableSku.sku_display_name][google.cloud.channel.v1.BillableSku.sku_display_name]
	//
	// If unsuccessful, returns an error.
	ListSkuGroupBillableSkus(ctx context.Context, in *ListSkuGroupBillableSkusRequest, opts ...grpc.CallOption) (*ListSkuGroupBillableSkusResponse, error)
	// Returns the requested [Offer][google.cloud.channel.v1.Offer] resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement or offer was not found.
	//
	// Return value:
	// The [Offer][google.cloud.channel.v1.Offer] resource.
	LookupOffer(ctx context.Context, in *LookupOfferRequest, opts ...grpc.CallOption) (*Offer, error)
	// Lists the Products the reseller is authorized to sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error)
	// Lists the SKUs for a product the reseller is authorized to sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error)
	// Lists the Offers the reseller can sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListOffers(ctx context.Context, in *ListOffersRequest, opts ...grpc.CallOption) (*ListOffersResponse, error)
	// Lists the following:
	//
	// * SKUs that you can purchase for a customer
	// * SKUs that you can upgrade or downgrade for an entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListPurchasableSkus(ctx context.Context, in *ListPurchasableSkusRequest, opts ...grpc.CallOption) (*ListPurchasableSkusResponse, error)
	// Lists the following:
	//
	// * Offers that you can purchase for a customer.
	// * Offers that you can change for an entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListPurchasableOffers(ctx context.Context, in *ListPurchasableOffersRequest, opts ...grpc.CallOption) (*ListPurchasableOffersResponse, error)
	// Lists the billing accounts that are eligible to purchase particular SKUs
	// for a given customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// Based on the provided list of SKUs, returns a list of SKU groups that must
	// be purchased using the same billing account and the billing accounts
	// eligible to purchase each SKU group.
	QueryEligibleBillingAccounts(ctx context.Context, in *QueryEligibleBillingAccountsRequest, opts ...grpc.CallOption) (*QueryEligibleBillingAccountsResponse, error)
	// Registers a service account with subscriber privileges on the Cloud Pub/Sub
	// topic for this Channel Services account. After you create a
	// subscriber, you get the events through
	// [SubscriberEvent][google.cloud.channel.v1.SubscriberEvent]
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The topic name with the registered service email address.
	RegisterSubscriber(ctx context.Context, in *RegisterSubscriberRequest, opts ...grpc.CallOption) (*RegisterSubscriberResponse, error)
	// Unregisters a service account with subscriber privileges on the Cloud
	// Pub/Sub topic created for this Channel Services account. If there are no
	// service accounts left with subscriber privileges, this deletes the topic.
	// You can call ListSubscribers to check for these accounts.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The topic resource doesn't exist.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The topic name that unregistered the service email address.
	// Returns a success response if the service email address wasn't registered
	// with the topic.
	UnregisterSubscriber(ctx context.Context, in *UnregisterSubscriberRequest, opts ...grpc.CallOption) (*UnregisterSubscriberResponse, error)
	// Lists service accounts with subscriber privileges on the Cloud Pub/Sub
	// topic created for this Channel Services account.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The topic resource doesn't exist.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// A list of service email addresses.
	ListSubscribers(ctx context.Context, in *ListSubscribersRequest, opts ...grpc.CallOption) (*ListSubscribersResponse, error)
	// List entitlement history.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different.
	// * INVALID_ARGUMENT: Missing or invalid required fields in the request.
	// * NOT_FOUND: The parent resource doesn't exist. Usually the result of an
	// invalid name parameter.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact CloudChannel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return value:
	// List of [EntitlementChange][google.cloud.channel.v1.EntitlementChange]s.
	ListEntitlementChanges(ctx context.Context, in *ListEntitlementChangesRequest, opts ...grpc.CallOption) (*ListEntitlementChangesResponse, error)
}

type cloudChannelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudChannelServiceClient(cc grpc.ClientConnInterface) CloudChannelServiceClient {
	return &cloudChannelServiceClient{cc}
}

func (c *cloudChannelServiceClient) ListCustomers(ctx context.Context, in *ListCustomersRequest, opts ...grpc.CallOption) (*ListCustomersResponse, error) {
	out := new(ListCustomersResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListCustomers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetCustomer(ctx context.Context, in *GetCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, CloudChannelService_GetCustomer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CheckCloudIdentityAccountsExist(ctx context.Context, in *CheckCloudIdentityAccountsExistRequest, opts ...grpc.CallOption) (*CheckCloudIdentityAccountsExistResponse, error) {
	out := new(CheckCloudIdentityAccountsExistResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_CheckCloudIdentityAccountsExist_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateCustomer(ctx context.Context, in *CreateCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, CloudChannelService_CreateCustomer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateCustomer(ctx context.Context, in *UpdateCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, CloudChannelService_UpdateCustomer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) DeleteCustomer(ctx context.Context, in *DeleteCustomerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CloudChannelService_DeleteCustomer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ImportCustomer(ctx context.Context, in *ImportCustomerRequest, opts ...grpc.CallOption) (*Customer, error) {
	out := new(Customer)
	err := c.cc.Invoke(ctx, CloudChannelService_ImportCustomer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ProvisionCloudIdentity(ctx context.Context, in *ProvisionCloudIdentityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_ProvisionCloudIdentity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error) {
	out := new(ListEntitlementsResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListEntitlements_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListTransferableSkus(ctx context.Context, in *ListTransferableSkusRequest, opts ...grpc.CallOption) (*ListTransferableSkusResponse, error) {
	out := new(ListTransferableSkusResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListTransferableSkus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListTransferableOffers(ctx context.Context, in *ListTransferableOffersRequest, opts ...grpc.CallOption) (*ListTransferableOffersResponse, error) {
	out := new(ListTransferableOffersResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListTransferableOffers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetEntitlement(ctx context.Context, in *GetEntitlementRequest, opts ...grpc.CallOption) (*Entitlement, error) {
	out := new(Entitlement)
	err := c.cc.Invoke(ctx, CloudChannelService_GetEntitlement_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateEntitlement(ctx context.Context, in *CreateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_CreateEntitlement_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ChangeParameters(ctx context.Context, in *ChangeParametersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_ChangeParameters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ChangeRenewalSettings(ctx context.Context, in *ChangeRenewalSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_ChangeRenewalSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ChangeOffer(ctx context.Context, in *ChangeOfferRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_ChangeOffer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) StartPaidService(ctx context.Context, in *StartPaidServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_StartPaidService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) SuspendEntitlement(ctx context.Context, in *SuspendEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_SuspendEntitlement_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CancelEntitlement(ctx context.Context, in *CancelEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_CancelEntitlement_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ActivateEntitlement(ctx context.Context, in *ActivateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_ActivateEntitlement_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) TransferEntitlements(ctx context.Context, in *TransferEntitlementsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_TransferEntitlements_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) TransferEntitlementsToGoogle(ctx context.Context, in *TransferEntitlementsToGoogleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudChannelService_TransferEntitlementsToGoogle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListChannelPartnerLinks(ctx context.Context, in *ListChannelPartnerLinksRequest, opts ...grpc.CallOption) (*ListChannelPartnerLinksResponse, error) {
	out := new(ListChannelPartnerLinksResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListChannelPartnerLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetChannelPartnerLink(ctx context.Context, in *GetChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error) {
	out := new(ChannelPartnerLink)
	err := c.cc.Invoke(ctx, CloudChannelService_GetChannelPartnerLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateChannelPartnerLink(ctx context.Context, in *CreateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error) {
	out := new(ChannelPartnerLink)
	err := c.cc.Invoke(ctx, CloudChannelService_CreateChannelPartnerLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateChannelPartnerLink(ctx context.Context, in *UpdateChannelPartnerLinkRequest, opts ...grpc.CallOption) (*ChannelPartnerLink, error) {
	out := new(ChannelPartnerLink)
	err := c.cc.Invoke(ctx, CloudChannelService_UpdateChannelPartnerLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetCustomerRepricingConfig(ctx context.Context, in *GetCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error) {
	out := new(CustomerRepricingConfig)
	err := c.cc.Invoke(ctx, CloudChannelService_GetCustomerRepricingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListCustomerRepricingConfigs(ctx context.Context, in *ListCustomerRepricingConfigsRequest, opts ...grpc.CallOption) (*ListCustomerRepricingConfigsResponse, error) {
	out := new(ListCustomerRepricingConfigsResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListCustomerRepricingConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateCustomerRepricingConfig(ctx context.Context, in *CreateCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error) {
	out := new(CustomerRepricingConfig)
	err := c.cc.Invoke(ctx, CloudChannelService_CreateCustomerRepricingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateCustomerRepricingConfig(ctx context.Context, in *UpdateCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*CustomerRepricingConfig, error) {
	out := new(CustomerRepricingConfig)
	err := c.cc.Invoke(ctx, CloudChannelService_UpdateCustomerRepricingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) DeleteCustomerRepricingConfig(ctx context.Context, in *DeleteCustomerRepricingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CloudChannelService_DeleteCustomerRepricingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) GetChannelPartnerRepricingConfig(ctx context.Context, in *GetChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error) {
	out := new(ChannelPartnerRepricingConfig)
	err := c.cc.Invoke(ctx, CloudChannelService_GetChannelPartnerRepricingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListChannelPartnerRepricingConfigs(ctx context.Context, in *ListChannelPartnerRepricingConfigsRequest, opts ...grpc.CallOption) (*ListChannelPartnerRepricingConfigsResponse, error) {
	out := new(ListChannelPartnerRepricingConfigsResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListChannelPartnerRepricingConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) CreateChannelPartnerRepricingConfig(ctx context.Context, in *CreateChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error) {
	out := new(ChannelPartnerRepricingConfig)
	err := c.cc.Invoke(ctx, CloudChannelService_CreateChannelPartnerRepricingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UpdateChannelPartnerRepricingConfig(ctx context.Context, in *UpdateChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*ChannelPartnerRepricingConfig, error) {
	out := new(ChannelPartnerRepricingConfig)
	err := c.cc.Invoke(ctx, CloudChannelService_UpdateChannelPartnerRepricingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) DeleteChannelPartnerRepricingConfig(ctx context.Context, in *DeleteChannelPartnerRepricingConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CloudChannelService_DeleteChannelPartnerRepricingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListSkuGroups(ctx context.Context, in *ListSkuGroupsRequest, opts ...grpc.CallOption) (*ListSkuGroupsResponse, error) {
	out := new(ListSkuGroupsResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListSkuGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListSkuGroupBillableSkus(ctx context.Context, in *ListSkuGroupBillableSkusRequest, opts ...grpc.CallOption) (*ListSkuGroupBillableSkusResponse, error) {
	out := new(ListSkuGroupBillableSkusResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListSkuGroupBillableSkus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) LookupOffer(ctx context.Context, in *LookupOfferRequest, opts ...grpc.CallOption) (*Offer, error) {
	out := new(Offer)
	err := c.cc.Invoke(ctx, CloudChannelService_LookupOffer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListProducts(ctx context.Context, in *ListProductsRequest, opts ...grpc.CallOption) (*ListProductsResponse, error) {
	out := new(ListProductsResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListProducts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error) {
	out := new(ListSkusResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListSkus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListOffers(ctx context.Context, in *ListOffersRequest, opts ...grpc.CallOption) (*ListOffersResponse, error) {
	out := new(ListOffersResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListOffers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListPurchasableSkus(ctx context.Context, in *ListPurchasableSkusRequest, opts ...grpc.CallOption) (*ListPurchasableSkusResponse, error) {
	out := new(ListPurchasableSkusResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListPurchasableSkus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListPurchasableOffers(ctx context.Context, in *ListPurchasableOffersRequest, opts ...grpc.CallOption) (*ListPurchasableOffersResponse, error) {
	out := new(ListPurchasableOffersResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListPurchasableOffers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) QueryEligibleBillingAccounts(ctx context.Context, in *QueryEligibleBillingAccountsRequest, opts ...grpc.CallOption) (*QueryEligibleBillingAccountsResponse, error) {
	out := new(QueryEligibleBillingAccountsResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_QueryEligibleBillingAccounts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) RegisterSubscriber(ctx context.Context, in *RegisterSubscriberRequest, opts ...grpc.CallOption) (*RegisterSubscriberResponse, error) {
	out := new(RegisterSubscriberResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_RegisterSubscriber_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) UnregisterSubscriber(ctx context.Context, in *UnregisterSubscriberRequest, opts ...grpc.CallOption) (*UnregisterSubscriberResponse, error) {
	out := new(UnregisterSubscriberResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_UnregisterSubscriber_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListSubscribers(ctx context.Context, in *ListSubscribersRequest, opts ...grpc.CallOption) (*ListSubscribersResponse, error) {
	out := new(ListSubscribersResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListSubscribers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelServiceClient) ListEntitlementChanges(ctx context.Context, in *ListEntitlementChangesRequest, opts ...grpc.CallOption) (*ListEntitlementChangesResponse, error) {
	out := new(ListEntitlementChangesResponse)
	err := c.cc.Invoke(ctx, CloudChannelService_ListEntitlementChanges_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudChannelServiceServer is the server API for CloudChannelService service.
// All implementations should embed UnimplementedCloudChannelServiceServer
// for forward compatibility
type CloudChannelServiceServer interface {
	// List [Customer][google.cloud.channel.v1.Customer]s.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// List of [Customer][google.cloud.channel.v1.Customer]s, or an empty list if
	// there are no customers.
	ListCustomers(context.Context, *ListCustomersRequest) (*ListCustomersResponse, error)
	// Returns the requested [Customer][google.cloud.channel.v1.Customer]
	// resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
	// invalid name parameter.
	//
	// Return value:
	// The [Customer][google.cloud.channel.v1.Customer] resource.
	GetCustomer(context.Context, *GetCustomerRequest) (*Customer, error)
	// Confirms the existence of Cloud Identity accounts based on the domain and
	// if the Cloud Identity accounts are owned by the reseller.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * INVALID_VALUE: Invalid domain value in the request.
	//
	// Return value:
	// A list of
	// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
	// resources for the domain (may be empty)
	//
	// Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
	// no
	// [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
	// resources match the domain.
	CheckCloudIdentityAccountsExist(context.Context, *CheckCloudIdentityAccountsExistRequest) (*CheckCloudIdentityAccountsExistResponse, error)
	// Creates a new [Customer][google.cloud.channel.v1.Customer] resource under
	// the reseller or distributor account.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The reseller account making the request is different from the
	//     reseller account in the API request.
	//   - You are not authorized to create a customer. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - Domain field value doesn't match the primary email domain.
	//
	// Return value:
	// The newly created [Customer][google.cloud.channel.v1.Customer] resource.
	CreateCustomer(context.Context, *CreateCustomerRequest) (*Customer, error)
	// Updates an existing [Customer][google.cloud.channel.v1.Customer] resource
	// for the reseller or distributor.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
	// for the name in the request.
	//
	// Return value:
	// The updated [Customer][google.cloud.channel.v1.Customer] resource.
	UpdateCustomer(context.Context, *UpdateCustomerRequest) (*Customer, error)
	// Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The customer has existing entitlements.
	// * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
	// for the name in the request.
	DeleteCustomer(context.Context, *DeleteCustomerRequest) (*emptypb.Empty, error)
	// Imports a [Customer][google.cloud.channel.v1.Customer] from the Cloud
	// Identity associated with the provided Cloud Identity ID or domain before a
	// TransferEntitlements call. If a linked Customer already exists and
	// overwrite_if_exists is true, it will update that Customer's data.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The reseller account making the request is different from the
	//     reseller account in the API request.
	//   - You are not authorized to import the customer. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
	// * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
	// expired or invalid.
	// * ALREADY_EXISTS: A customer already exists and has conflicting critical
	// fields. Requires an overwrite.
	//
	// Return value:
	// The [Customer][google.cloud.channel.v1.Customer].
	ImportCustomer(context.Context, *ImportCustomerRequest) (*Customer, error)
	// Creates a Cloud Identity for the given customer using the customer's
	// information, or the information provided here.
	//
	// Possible error codes:
	//
	// *  PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - You are not authorized to provision cloud identity id. See
	//     https://support.google.com/channelservices/answer/9759265
	//   - INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//   - NOT_FOUND: The customer was not found.
	//   - ALREADY_EXISTS: The customer's primary email already exists. Retry
	//     after changing the customer's primary contact email.
	//   - INTERNAL: Any non-user error related to a technical issue in the
	//
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata contains an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ProvisionCloudIdentity(context.Context, *ProvisionCloudIdentityRequest) (*longrunningpb.Operation, error)
	// Lists [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a
	// customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// A list of the customer's
	// [Entitlement][google.cloud.channel.v1.Entitlement]s.
	ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error)
	// List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a
	// customer based on the Cloud Identity ID or Customer Name in the request.
	//
	// Use this method to list the entitlements information of an
	// unowned customer. You should provide the customer's
	// Cloud Identity ID or Customer Name.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller and has no auth token.
	//   - The supplied auth token is invalid.
	//   - The reseller account making the request is different
	//     from the reseller account in the query.
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// A list of the customer's
	// [TransferableSku][google.cloud.channel.v1.TransferableSku].
	ListTransferableSkus(context.Context, *ListTransferableSkusRequest) (*ListTransferableSkusResponse, error)
	// List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a
	// customer based on Cloud Identity ID or Customer Name in the request.
	//
	// Use this method when a reseller gets the entitlement information of an
	// unowned customer. The reseller should provide the customer's
	// Cloud Identity ID or Customer Name.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller and has no auth token.
	//   - The customer provided incorrect reseller information when generating
	//     auth token.
	//   - The reseller account making the request is different
	//     from the reseller account in the query.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for
	// the given customer and SKU.
	ListTransferableOffers(context.Context, *ListTransferableOffersRequest) (*ListTransferableOffersResponse, error)
	// Returns the requested [Entitlement][google.cloud.channel.v1.Entitlement]
	// resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer entitlement was not found.
	//
	// Return value:
	// The requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
	GetEntitlement(context.Context, *GetEntitlementRequest) (*Entitlement, error)
	// Creates an entitlement for a customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - There is already a customer entitlement for a SKU from the same
	//     product family.
	//
	// * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
	// Google Channel support for further troubleshooting.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS:
	//   - The SKU was already purchased for the customer.
	//   - The customer's primary email already exists. Retry
	//     after changing the customer's primary contact email.
	//
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The domain required for purchasing a SKU has not been verified.
	//   - A pre-requisite SKU required to purchase an Add-On SKU is missing.
	//     For example, Google Workspace Business Starter is required to purchase
	//     Vault or Drive.
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CreateEntitlement(context.Context, *CreateEntitlementRequest) (*longrunningpb.Operation, error)
	// Change parameters of the entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// For example, the number of seats being changed is greater than the allowed
	// number of max seats, or decreasing seats for a commitment based plan.
	// * NOT_FOUND: Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeParameters(context.Context, *ChangeParametersRequest) (*longrunningpb.Operation, error)
	// Updates the renewal settings for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
	// commitment plan. Can't enable or disable renewals for non-commitment plans.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	//   - UNKNOWN: Any non-user error related to a technical issue in the backend.
	//     Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeRenewalSettings(context.Context, *ChangeRenewalSettingsRequest) (*longrunningpb.Operation, error)
	// Updates the Offer for an existing customer entitlement.
	//
	// An entitlement update is a long-running operation and it updates the
	// entitlement as a result of fulfillment.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Offer or Entitlement resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ChangeOffer(context.Context, *ChangeOfferRequest) (*longrunningpb.Operation, error)
	// Starts paid service for a trial entitlement.
	//
	// Starts paid service for a trial entitlement immediately. This method is
	// only applicable if a plan is set up for a trial entitlement but has some
	// trial days remaining.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
	// entitlement on trial plans.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	StartPaidService(context.Context, *StartPaidServiceRequest) (*longrunningpb.Operation, error)
	// Suspends a previously fulfilled entitlement.
	//
	// An entitlement suspension is a long-running operation.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * NOT_ACTIVE: Entitlement is not active.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	SuspendEntitlement(context.Context, *SuspendEntitlementRequest) (*longrunningpb.Operation, error)
	// Cancels a previously fulfilled entitlement.
	//
	// An entitlement cancellation is a long-running operation.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * FAILED_PRECONDITION: There are Google Cloud projects linked to the
	// Google Cloud entitlement's Cloud Billing subaccount.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
	// add-ons, or entitlements for Google Cloud's development platform.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	CancelEntitlement(context.Context, *CancelEntitlementRequest) (*longrunningpb.Operation, error)
	// Activates a previously suspended entitlement. Entitlements suspended for
	// pending ToS acceptance can't be activated using this method.
	//
	// An entitlement activation is a long-running operation and it updates
	// the state of the customer entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement resource not found.
	// * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
	// suspensions and entitlements that have accepted the TOS.
	// * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
	// state.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	ActivateEntitlement(context.Context, *ActivateEntitlementRequest) (*longrunningpb.Operation, error)
	// Transfers customer entitlements to new reseller.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller.
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS: The SKU was already transferred for the customer.
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The SKU requires domain verification to transfer, but the domain is
	//     not verified.
	//   - An Add-On SKU (example, Vault or Drive) is missing the
	//     pre-requisite SKU (example, G Suite Basic).
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//   - Specify all transferring entitlements.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlements(context.Context, *TransferEntitlementsRequest) (*longrunningpb.Operation, error)
	// Transfers customer entitlements from their current reseller to Google.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The customer or offer resource was not found.
	// * ALREADY_EXISTS: The SKU was already transferred for the customer.
	// * CONDITION_NOT_MET or FAILED_PRECONDITION:
	//   - The SKU requires domain verification to transfer, but the domain is
	//     not verified.
	//   - An Add-On SKU (example, Vault or Drive) is missing the
	//     pre-requisite SKU (example, G Suite Basic).
	//   - (Developer accounts only) Reseller and resold domain must meet the
	//     following naming requirements:
	//   - Domain names must start with goog-test.
	//   - Domain names must include the reseller domain.
	//
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The response will contain
	// google.protobuf.Empty on success. The Operation metadata will contain an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	TransferEntitlementsToGoogle(context.Context, *TransferEntitlementsToGoogleRequest) (*longrunningpb.Operation, error)
	// List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s
	// belonging to a distributor. You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// The list of the distributor account's
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources.
	ListChannelPartnerLinks(context.Context, *ListChannelPartnerLinksRequest) (*ListChannelPartnerLinksResponse, error)
	// Returns the requested
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: ChannelPartnerLink resource not found because of an
	// invalid channel partner link name.
	//
	// Return value:
	// The [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
	// resource.
	GetChannelPartnerLink(context.Context, *GetChannelPartnerLinkRequest) (*ChannelPartnerLink, error)
	// Initiates a channel partner link between a distributor and a reseller, or
	// between resellers in an n-tier reseller channel.
	// Invited partners need to follow the invite_link_uri provided in the
	// response to accept. After accepting the invitation, a link is set up
	// between the two parties.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
	// exists.
	// * NOT_FOUND: No Cloud Identity customer exists for provided domain.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The new [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
	// resource.
	CreateChannelPartnerLink(context.Context, *CreateChannelPartnerLinkRequest) (*ChannelPartnerLink, error)
	// Updates a channel partner link. Distributors call this method to change a
	// link's status. For example, to suspend a partner link.
	// You must be a distributor to call this method.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request is different
	// from the reseller account in the API request.
	// * INVALID_ARGUMENT:
	//   - Required request parameters are missing or invalid.
	//   - Link state cannot change from invited to active or suspended.
	//   - Cannot send reseller_cloud_identity_id, invite_url, or name in update
	//     mask.
	//
	// * NOT_FOUND: ChannelPartnerLink resource not found.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The updated
	// [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
	UpdateChannelPartnerLink(context.Context, *UpdateChannelPartnerLinkRequest) (*ChannelPartnerLink, error)
	// Gets information about how a Reseller modifies their bill before sending
	// it to a Customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// was not found.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	GetCustomerRepricingConfig(context.Context, *GetCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error)
	// Lists information about how a Reseller modifies their bill before sending
	// it to a Customer.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * Customer ID
	// * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
	// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// * [CustomerRepricingConfig.update_time][google.cloud.channel.v1.CustomerRepricingConfig.update_time]
	//
	// If unsuccessful, returns an error.
	ListCustomerRepricingConfigs(context.Context, *ListCustomerRepricingConfigsRequest) (*ListCustomerRepricingConfigsResponse, error)
	// Creates a CustomerRepricingConfig. Call this method to set modifications
	// for a specific customer's bill. You can only create configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. If needed, you can create a config for the current
	// month, with some restrictions.
	//
	// When creating a config for a future month, make sure there are no existing
	// configs for that
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// The following restrictions are for creating configs in the current month.
	//
	// * This functionality is reserved for recovering from an erroneous config,
	// and should not be used for regular business cases.
	// * The new config will not modify exports used with other configs.
	// Changes to the config may be immediate, but may take up to 24 hours.
	// * There is a limit of ten configs for any
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
	// for any
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	// * The contained
	// [CustomerRepricingConfig.repricing_config][google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]
	// value must be different from the value used in the current config for a
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	CreateCustomerRepricingConfig(context.Context, *CreateCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error)
	// Updates a CustomerRepricingConfig. Call this method to set modifications
	// for a specific customer's bill. This method overwrites the existing
	// CustomerRepricingConfig.
	//
	// You can only update configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. To make changes to configs for the current month, use
	// [CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig],
	// taking note of its restrictions. You cannot update the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// When updating a config in the future:
	//
	// * This config must already exist.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// resource, otherwise returns an error.
	UpdateCustomerRepricingConfig(context.Context, *UpdateCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error)
	// Deletes the given
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// permanently. You can only delete configs if their
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is set to a date after the current month.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// is active or in the past.
	// * NOT_FOUND: No
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// found for the name in the request.
	DeleteCustomerRepricingConfig(context.Context, *DeleteCustomerRepricingConfigRequest) (*emptypb.Empty, error)
	// Gets information about how a Distributor modifies their bill before sending
	// it to a ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// was not found.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	GetChannelPartnerRepricingConfig(context.Context, *GetChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error)
	// Lists information about how a Reseller modifies their bill before sending
	// it to a ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * Channel Partner ID
	// * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// * [ChannelPartnerRepricingConfig.update_time][google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]
	//
	// If unsuccessful, returns an error.
	ListChannelPartnerRepricingConfigs(context.Context, *ListChannelPartnerRepricingConfigsRequest) (*ListChannelPartnerRepricingConfigsResponse, error)
	// Creates a ChannelPartnerRepricingConfig. Call this method to set
	// modifications for a specific ChannelPartner's bill. You can only create
	// configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. If needed, you can create a config for the current
	// month, with some restrictions.
	//
	// When creating a config for a future month, make sure there are no existing
	// configs for that
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// The following restrictions are for creating configs in the current month.
	//
	// * This functionality is reserved for recovering from an erroneous config,
	// and should not be used for regular business cases.
	// * The new config will not modify exports used with other configs.
	// Changes to the config may be immediate, but may take up to 24 hours.
	// * There is a limit of ten configs for any ChannelPartner or
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
	// for any
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	// * The contained
	// [ChannelPartnerRepricingConfig.repricing_config][google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]
	// value must be different from the value used in the current config for a
	// ChannelPartner.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	CreateChannelPartnerRepricingConfig(context.Context, *CreateChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error)
	// Updates a ChannelPartnerRepricingConfig. Call this method to set
	// modifications for a specific ChannelPartner's bill. This method overwrites
	// the existing CustomerRepricingConfig.
	//
	// You can only update configs if the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is a future month. To make changes to configs for the current month, use
	// [CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig],
	// taking note of its restrictions. You cannot update the
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
	//
	// When updating a config in the future:
	//
	// * This config must already exist.
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different.
	// * INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request. Also displays if the updated config is for the current month or
	// past months.
	// * NOT_FOUND: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// specified does not exist or is not associated with the given account.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the updated
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// resource, otherwise returns an error.
	UpdateChannelPartnerRepricingConfig(context.Context, *UpdateChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error)
	// Deletes the given
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// permanently. You can only delete configs if their
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// is set to a date after the current month.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The account making the request does not own
	// this customer.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * FAILED_PRECONDITION: The
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// is active or in the past.
	// * NOT_FOUND: No
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// found for the name in the request.
	DeleteChannelPartnerRepricingConfig(context.Context, *DeleteChannelPartnerRepricingConfigRequest) (*emptypb.Empty, error)
	// Lists the Rebilling supported SKU groups the account is authorized to
	// sell.
	// Reference: https://cloud.google.com/skus/sku-groups
	//
	// Possible Error Codes:
	//
	// * PERMISSION_DENIED: If the account making the request and the account
	// being queried are different, or the account doesn't exist.
	// * INTERNAL: Any non-user error related to technical issues in the
	// backend. In this case, contact Cloud Channel support.
	//
	// Return Value:
	// If successful, the [SkuGroup][google.cloud.channel.v1.SkuGroup] resources.
	// The data for each resource is displayed in the alphabetical order of SKU
	// group display name.
	// The data for each resource is displayed in the ascending order of
	// [SkuGroup.display_name][google.cloud.channel.v1.SkuGroup.display_name]
	//
	// If unsuccessful, returns an error.
	ListSkuGroups(context.Context, *ListSkuGroupsRequest) (*ListSkuGroupsResponse, error)
	// Lists the Billable SKUs in a given SKU group.
	//
	// Possible error codes:
	// PERMISSION_DENIED: If the account making the request and the account
	// being queried for are different, or the account doesn't exist.
	// INVALID_ARGUMENT: Missing or invalid required parameters in the
	// request.
	// INTERNAL: Any non-user error related to technical issue in the
	// backend. In this case, contact cloud channel support.
	//
	// Return Value:
	// If successful, the [BillableSku][google.cloud.channel.v1.BillableSku]
	// resources. The data for each resource is displayed in the ascending order
	// of:
	//
	// * [BillableSku.service_display_name][google.cloud.channel.v1.BillableSku.service_display_name]
	// * [BillableSku.sku_display_name][google.cloud.channel.v1.BillableSku.sku_display_name]
	//
	// If unsuccessful, returns an error.
	ListSkuGroupBillableSkus(context.Context, *ListSkuGroupBillableSkusRequest) (*ListSkuGroupBillableSkusResponse, error)
	// Returns the requested [Offer][google.cloud.channel.v1.Offer] resource.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: Entitlement or offer was not found.
	//
	// Return value:
	// The [Offer][google.cloud.channel.v1.Offer] resource.
	LookupOffer(context.Context, *LookupOfferRequest) (*Offer, error)
	// Lists the Products the reseller is authorized to sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error)
	// Lists the SKUs for a product the reseller is authorized to sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListSkus(context.Context, *ListSkusRequest) (*ListSkusResponse, error)
	// Lists the Offers the reseller can sell.
	//
	// Possible error codes:
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListOffers(context.Context, *ListOffersRequest) (*ListOffersResponse, error)
	// Lists the following:
	//
	// * SKUs that you can purchase for a customer
	// * SKUs that you can upgrade or downgrade for an entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListPurchasableSkus(context.Context, *ListPurchasableSkusRequest) (*ListPurchasableSkusResponse, error)
	// Lists the following:
	//
	// * Offers that you can purchase for a customer.
	// * Offers that you can change for an entitlement.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED:
	//   - The customer doesn't belong to the reseller
	//   - The reseller is not authorized to transact on this Product. See
	//     https://support.google.com/channelservices/answer/9759265
	//
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	ListPurchasableOffers(context.Context, *ListPurchasableOffersRequest) (*ListPurchasableOffersResponse, error)
	// Lists the billing accounts that are eligible to purchase particular SKUs
	// for a given customer.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The customer doesn't belong to the reseller.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	//
	// Return value:
	// Based on the provided list of SKUs, returns a list of SKU groups that must
	// be purchased using the same billing account and the billing accounts
	// eligible to purchase each SKU group.
	QueryEligibleBillingAccounts(context.Context, *QueryEligibleBillingAccountsRequest) (*QueryEligibleBillingAccountsResponse, error)
	// Registers a service account with subscriber privileges on the Cloud Pub/Sub
	// topic for this Channel Services account. After you create a
	// subscriber, you get the events through
	// [SubscriberEvent][google.cloud.channel.v1.SubscriberEvent]
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The topic name with the registered service email address.
	RegisterSubscriber(context.Context, *RegisterSubscriberRequest) (*RegisterSubscriberResponse, error)
	// Unregisters a service account with subscriber privileges on the Cloud
	// Pub/Sub topic created for this Channel Services account. If there are no
	// service accounts left with subscriber privileges, this deletes the topic.
	// You can call ListSubscribers to check for these accounts.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The topic resource doesn't exist.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// The topic name that unregistered the service email address.
	// Returns a success response if the service email address wasn't registered
	// with the topic.
	UnregisterSubscriber(context.Context, *UnregisterSubscriberRequest) (*UnregisterSubscriberResponse, error)
	// Lists service accounts with subscriber privileges on the Cloud Pub/Sub
	// topic created for this Channel Services account.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different, or the impersonated user
	// is not a super admin.
	// * INVALID_ARGUMENT: Required request parameters are missing or invalid.
	// * NOT_FOUND: The topic resource doesn't exist.
	// * INTERNAL: Any non-user error related to a technical issue in the
	// backend. Contact Cloud Channel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// Contact Cloud Channel support.
	//
	// Return value:
	// A list of service email addresses.
	ListSubscribers(context.Context, *ListSubscribersRequest) (*ListSubscribersResponse, error)
	// List entitlement history.
	//
	// Possible error codes:
	//
	// * PERMISSION_DENIED: The reseller account making the request and the
	// provided reseller account are different.
	// * INVALID_ARGUMENT: Missing or invalid required fields in the request.
	// * NOT_FOUND: The parent resource doesn't exist. Usually the result of an
	// invalid name parameter.
	// * INTERNAL: Any non-user error related to a technical issue in the backend.
	// In this case, contact CloudChannel support.
	// * UNKNOWN: Any non-user error related to a technical issue in the backend.
	// In this case, contact Cloud Channel support.
	//
	// Return value:
	// List of [EntitlementChange][google.cloud.channel.v1.EntitlementChange]s.
	ListEntitlementChanges(context.Context, *ListEntitlementChangesRequest) (*ListEntitlementChangesResponse, error)
}

// UnimplementedCloudChannelServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCloudChannelServiceServer struct {
}

func (UnimplementedCloudChannelServiceServer) ListCustomers(context.Context, *ListCustomersRequest) (*ListCustomersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomers not implemented")
}
func (UnimplementedCloudChannelServiceServer) GetCustomer(context.Context, *GetCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomer not implemented")
}
func (UnimplementedCloudChannelServiceServer) CheckCloudIdentityAccountsExist(context.Context, *CheckCloudIdentityAccountsExistRequest) (*CheckCloudIdentityAccountsExistResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckCloudIdentityAccountsExist not implemented")
}
func (UnimplementedCloudChannelServiceServer) CreateCustomer(context.Context, *CreateCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomer not implemented")
}
func (UnimplementedCloudChannelServiceServer) UpdateCustomer(context.Context, *UpdateCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomer not implemented")
}
func (UnimplementedCloudChannelServiceServer) DeleteCustomer(context.Context, *DeleteCustomerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomer not implemented")
}
func (UnimplementedCloudChannelServiceServer) ImportCustomer(context.Context, *ImportCustomerRequest) (*Customer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportCustomer not implemented")
}
func (UnimplementedCloudChannelServiceServer) ProvisionCloudIdentity(context.Context, *ProvisionCloudIdentityRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionCloudIdentity not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntitlements not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListTransferableSkus(context.Context, *ListTransferableSkusRequest) (*ListTransferableSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferableSkus not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListTransferableOffers(context.Context, *ListTransferableOffersRequest) (*ListTransferableOffersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferableOffers not implemented")
}
func (UnimplementedCloudChannelServiceServer) GetEntitlement(context.Context, *GetEntitlementRequest) (*Entitlement, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntitlement not implemented")
}
func (UnimplementedCloudChannelServiceServer) CreateEntitlement(context.Context, *CreateEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntitlement not implemented")
}
func (UnimplementedCloudChannelServiceServer) ChangeParameters(context.Context, *ChangeParametersRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeParameters not implemented")
}
func (UnimplementedCloudChannelServiceServer) ChangeRenewalSettings(context.Context, *ChangeRenewalSettingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeRenewalSettings not implemented")
}
func (UnimplementedCloudChannelServiceServer) ChangeOffer(context.Context, *ChangeOfferRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeOffer not implemented")
}
func (UnimplementedCloudChannelServiceServer) StartPaidService(context.Context, *StartPaidServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartPaidService not implemented")
}
func (UnimplementedCloudChannelServiceServer) SuspendEntitlement(context.Context, *SuspendEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuspendEntitlement not implemented")
}
func (UnimplementedCloudChannelServiceServer) CancelEntitlement(context.Context, *CancelEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelEntitlement not implemented")
}
func (UnimplementedCloudChannelServiceServer) ActivateEntitlement(context.Context, *ActivateEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateEntitlement not implemented")
}
func (UnimplementedCloudChannelServiceServer) TransferEntitlements(context.Context, *TransferEntitlementsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferEntitlements not implemented")
}
func (UnimplementedCloudChannelServiceServer) TransferEntitlementsToGoogle(context.Context, *TransferEntitlementsToGoogleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferEntitlementsToGoogle not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListChannelPartnerLinks(context.Context, *ListChannelPartnerLinksRequest) (*ListChannelPartnerLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannelPartnerLinks not implemented")
}
func (UnimplementedCloudChannelServiceServer) GetChannelPartnerLink(context.Context, *GetChannelPartnerLinkRequest) (*ChannelPartnerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChannelPartnerLink not implemented")
}
func (UnimplementedCloudChannelServiceServer) CreateChannelPartnerLink(context.Context, *CreateChannelPartnerLinkRequest) (*ChannelPartnerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChannelPartnerLink not implemented")
}
func (UnimplementedCloudChannelServiceServer) UpdateChannelPartnerLink(context.Context, *UpdateChannelPartnerLinkRequest) (*ChannelPartnerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChannelPartnerLink not implemented")
}
func (UnimplementedCloudChannelServiceServer) GetCustomerRepricingConfig(context.Context, *GetCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomerRepricingConfig not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListCustomerRepricingConfigs(context.Context, *ListCustomerRepricingConfigsRequest) (*ListCustomerRepricingConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomerRepricingConfigs not implemented")
}
func (UnimplementedCloudChannelServiceServer) CreateCustomerRepricingConfig(context.Context, *CreateCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomerRepricingConfig not implemented")
}
func (UnimplementedCloudChannelServiceServer) UpdateCustomerRepricingConfig(context.Context, *UpdateCustomerRepricingConfigRequest) (*CustomerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomerRepricingConfig not implemented")
}
func (UnimplementedCloudChannelServiceServer) DeleteCustomerRepricingConfig(context.Context, *DeleteCustomerRepricingConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomerRepricingConfig not implemented")
}
func (UnimplementedCloudChannelServiceServer) GetChannelPartnerRepricingConfig(context.Context, *GetChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChannelPartnerRepricingConfig not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListChannelPartnerRepricingConfigs(context.Context, *ListChannelPartnerRepricingConfigsRequest) (*ListChannelPartnerRepricingConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannelPartnerRepricingConfigs not implemented")
}
func (UnimplementedCloudChannelServiceServer) CreateChannelPartnerRepricingConfig(context.Context, *CreateChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChannelPartnerRepricingConfig not implemented")
}
func (UnimplementedCloudChannelServiceServer) UpdateChannelPartnerRepricingConfig(context.Context, *UpdateChannelPartnerRepricingConfigRequest) (*ChannelPartnerRepricingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChannelPartnerRepricingConfig not implemented")
}
func (UnimplementedCloudChannelServiceServer) DeleteChannelPartnerRepricingConfig(context.Context, *DeleteChannelPartnerRepricingConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteChannelPartnerRepricingConfig not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListSkuGroups(context.Context, *ListSkuGroupsRequest) (*ListSkuGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSkuGroups not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListSkuGroupBillableSkus(context.Context, *ListSkuGroupBillableSkusRequest) (*ListSkuGroupBillableSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSkuGroupBillableSkus not implemented")
}
func (UnimplementedCloudChannelServiceServer) LookupOffer(context.Context, *LookupOfferRequest) (*Offer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupOffer not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListProducts(context.Context, *ListProductsRequest) (*ListProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProducts not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListSkus(context.Context, *ListSkusRequest) (*ListSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSkus not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListOffers(context.Context, *ListOffersRequest) (*ListOffersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOffers not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListPurchasableSkus(context.Context, *ListPurchasableSkusRequest) (*ListPurchasableSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPurchasableSkus not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListPurchasableOffers(context.Context, *ListPurchasableOffersRequest) (*ListPurchasableOffersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPurchasableOffers not implemented")
}
func (UnimplementedCloudChannelServiceServer) QueryEligibleBillingAccounts(context.Context, *QueryEligibleBillingAccountsRequest) (*QueryEligibleBillingAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryEligibleBillingAccounts not implemented")
}
func (UnimplementedCloudChannelServiceServer) RegisterSubscriber(context.Context, *RegisterSubscriberRequest) (*RegisterSubscriberResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterSubscriber not implemented")
}
func (UnimplementedCloudChannelServiceServer) UnregisterSubscriber(context.Context, *UnregisterSubscriberRequest) (*UnregisterSubscriberResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnregisterSubscriber not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListSubscribers(context.Context, *ListSubscribersRequest) (*ListSubscribersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubscribers not implemented")
}
func (UnimplementedCloudChannelServiceServer) ListEntitlementChanges(context.Context, *ListEntitlementChangesRequest) (*ListEntitlementChangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntitlementChanges not implemented")
}

// UnsafeCloudChannelServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudChannelServiceServer will
// result in compilation errors.
type UnsafeCloudChannelServiceServer interface {
	mustEmbedUnimplementedCloudChannelServiceServer()
}

func RegisterCloudChannelServiceServer(s grpc.ServiceRegistrar, srv CloudChannelServiceServer) {
	s.RegisterService(&CloudChannelService_ServiceDesc, srv)
}

func _CloudChannelService_ListCustomers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListCustomers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListCustomers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListCustomers(ctx, req.(*ListCustomersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_GetCustomer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetCustomer(ctx, req.(*GetCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CheckCloudIdentityAccountsExist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckCloudIdentityAccountsExistRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CheckCloudIdentityAccountsExist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_CheckCloudIdentityAccountsExist_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CheckCloudIdentityAccountsExist(ctx, req.(*CheckCloudIdentityAccountsExistRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_CreateCustomer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateCustomer(ctx, req.(*CreateCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_UpdateCustomer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateCustomer(ctx, req.(*UpdateCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_DeleteCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).DeleteCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_DeleteCustomer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).DeleteCustomer(ctx, req.(*DeleteCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ImportCustomer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ImportCustomer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ImportCustomer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ImportCustomer(ctx, req.(*ImportCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ProvisionCloudIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvisionCloudIdentityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ProvisionCloudIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ProvisionCloudIdentity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ProvisionCloudIdentity(ctx, req.(*ProvisionCloudIdentityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListEntitlements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntitlementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListEntitlements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListEntitlements_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListEntitlements(ctx, req.(*ListEntitlementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListTransferableSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferableSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListTransferableSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListTransferableSkus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListTransferableSkus(ctx, req.(*ListTransferableSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListTransferableOffers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferableOffersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListTransferableOffers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListTransferableOffers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListTransferableOffers(ctx, req.(*ListTransferableOffersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_GetEntitlement_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetEntitlement(ctx, req.(*GetEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_CreateEntitlement_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateEntitlement(ctx, req.(*CreateEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ChangeParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ChangeParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ChangeParameters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ChangeParameters(ctx, req.(*ChangeParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ChangeRenewalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeRenewalSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ChangeRenewalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ChangeRenewalSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ChangeRenewalSettings(ctx, req.(*ChangeRenewalSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ChangeOffer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeOfferRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ChangeOffer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ChangeOffer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ChangeOffer(ctx, req.(*ChangeOfferRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_StartPaidService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartPaidServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).StartPaidService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_StartPaidService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).StartPaidService(ctx, req.(*StartPaidServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_SuspendEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuspendEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).SuspendEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_SuspendEntitlement_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).SuspendEntitlement(ctx, req.(*SuspendEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CancelEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CancelEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_CancelEntitlement_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CancelEntitlement(ctx, req.(*CancelEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ActivateEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ActivateEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ActivateEntitlement_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ActivateEntitlement(ctx, req.(*ActivateEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_TransferEntitlements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferEntitlementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).TransferEntitlements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_TransferEntitlements_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).TransferEntitlements(ctx, req.(*TransferEntitlementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_TransferEntitlementsToGoogle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferEntitlementsToGoogleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).TransferEntitlementsToGoogle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_TransferEntitlementsToGoogle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).TransferEntitlementsToGoogle(ctx, req.(*TransferEntitlementsToGoogleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListChannelPartnerLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelPartnerLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListChannelPartnerLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListChannelPartnerLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListChannelPartnerLinks(ctx, req.(*ListChannelPartnerLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetChannelPartnerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelPartnerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetChannelPartnerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_GetChannelPartnerLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetChannelPartnerLink(ctx, req.(*GetChannelPartnerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateChannelPartnerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChannelPartnerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_CreateChannelPartnerLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerLink(ctx, req.(*CreateChannelPartnerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateChannelPartnerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChannelPartnerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_UpdateChannelPartnerLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerLink(ctx, req.(*UpdateChannelPartnerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetCustomerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetCustomerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_GetCustomerRepricingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetCustomerRepricingConfig(ctx, req.(*GetCustomerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListCustomerRepricingConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomerRepricingConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListCustomerRepricingConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListCustomerRepricingConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListCustomerRepricingConfigs(ctx, req.(*ListCustomerRepricingConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateCustomerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateCustomerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_CreateCustomerRepricingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateCustomerRepricingConfig(ctx, req.(*CreateCustomerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateCustomerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateCustomerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_UpdateCustomerRepricingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateCustomerRepricingConfig(ctx, req.(*UpdateCustomerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_DeleteCustomerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).DeleteCustomerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_DeleteCustomerRepricingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).DeleteCustomerRepricingConfig(ctx, req.(*DeleteCustomerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_GetChannelPartnerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelPartnerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).GetChannelPartnerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_GetChannelPartnerRepricingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).GetChannelPartnerRepricingConfig(ctx, req.(*GetChannelPartnerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListChannelPartnerRepricingConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelPartnerRepricingConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListChannelPartnerRepricingConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListChannelPartnerRepricingConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListChannelPartnerRepricingConfigs(ctx, req.(*ListChannelPartnerRepricingConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_CreateChannelPartnerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChannelPartnerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_CreateChannelPartnerRepricingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).CreateChannelPartnerRepricingConfig(ctx, req.(*CreateChannelPartnerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UpdateChannelPartnerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChannelPartnerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_UpdateChannelPartnerRepricingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UpdateChannelPartnerRepricingConfig(ctx, req.(*UpdateChannelPartnerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_DeleteChannelPartnerRepricingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteChannelPartnerRepricingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).DeleteChannelPartnerRepricingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_DeleteChannelPartnerRepricingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).DeleteChannelPartnerRepricingConfig(ctx, req.(*DeleteChannelPartnerRepricingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListSkuGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSkuGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListSkuGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListSkuGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListSkuGroups(ctx, req.(*ListSkuGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListSkuGroupBillableSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSkuGroupBillableSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListSkuGroupBillableSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListSkuGroupBillableSkus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListSkuGroupBillableSkus(ctx, req.(*ListSkuGroupBillableSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_LookupOffer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupOfferRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).LookupOffer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_LookupOffer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).LookupOffer(ctx, req.(*LookupOfferRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListProducts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListProducts(ctx, req.(*ListProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListSkus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListSkus(ctx, req.(*ListSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListOffers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOffersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListOffers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListOffers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListOffers(ctx, req.(*ListOffersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListPurchasableSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPurchasableSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListPurchasableSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListPurchasableSkus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListPurchasableSkus(ctx, req.(*ListPurchasableSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListPurchasableOffers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPurchasableOffersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListPurchasableOffers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListPurchasableOffers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListPurchasableOffers(ctx, req.(*ListPurchasableOffersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_QueryEligibleBillingAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryEligibleBillingAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).QueryEligibleBillingAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_QueryEligibleBillingAccounts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).QueryEligibleBillingAccounts(ctx, req.(*QueryEligibleBillingAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_RegisterSubscriber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterSubscriberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).RegisterSubscriber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_RegisterSubscriber_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).RegisterSubscriber(ctx, req.(*RegisterSubscriberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_UnregisterSubscriber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnregisterSubscriberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).UnregisterSubscriber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_UnregisterSubscriber_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).UnregisterSubscriber(ctx, req.(*UnregisterSubscriberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListSubscribers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscribersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListSubscribers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListSubscribers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListSubscribers(ctx, req.(*ListSubscribersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelService_ListEntitlementChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntitlementChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelServiceServer).ListEntitlementChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudChannelService_ListEntitlementChanges_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelServiceServer).ListEntitlementChanges(ctx, req.(*ListEntitlementChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudChannelService_ServiceDesc is the grpc.ServiceDesc for CloudChannelService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudChannelService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.channel.v1.CloudChannelService",
	HandlerType: (*CloudChannelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCustomers",
			Handler:    _CloudChannelService_ListCustomers_Handler,
		},
		{
			MethodName: "GetCustomer",
			Handler:    _CloudChannelService_GetCustomer_Handler,
		},
		{
			MethodName: "CheckCloudIdentityAccountsExist",
			Handler:    _CloudChannelService_CheckCloudIdentityAccountsExist_Handler,
		},
		{
			MethodName: "CreateCustomer",
			Handler:    _CloudChannelService_CreateCustomer_Handler,
		},
		{
			MethodName: "UpdateCustomer",
			Handler:    _CloudChannelService_UpdateCustomer_Handler,
		},
		{
			MethodName: "DeleteCustomer",
			Handler:    _CloudChannelService_DeleteCustomer_Handler,
		},
		{
			MethodName: "ImportCustomer",
			Handler:    _CloudChannelService_ImportCustomer_Handler,
		},
		{
			MethodName: "ProvisionCloudIdentity",
			Handler:    _CloudChannelService_ProvisionCloudIdentity_Handler,
		},
		{
			MethodName: "ListEntitlements",
			Handler:    _CloudChannelService_ListEntitlements_Handler,
		},
		{
			MethodName: "ListTransferableSkus",
			Handler:    _CloudChannelService_ListTransferableSkus_Handler,
		},
		{
			MethodName: "ListTransferableOffers",
			Handler:    _CloudChannelService_ListTransferableOffers_Handler,
		},
		{
			MethodName: "GetEntitlement",
			Handler:    _CloudChannelService_GetEntitlement_Handler,
		},
		{
			MethodName: "CreateEntitlement",
			Handler:    _CloudChannelService_CreateEntitlement_Handler,
		},
		{
			MethodName: "ChangeParameters",
			Handler:    _CloudChannelService_ChangeParameters_Handler,
		},
		{
			MethodName: "ChangeRenewalSettings",
			Handler:    _CloudChannelService_ChangeRenewalSettings_Handler,
		},
		{
			MethodName: "ChangeOffer",
			Handler:    _CloudChannelService_ChangeOffer_Handler,
		},
		{
			MethodName: "StartPaidService",
			Handler:    _CloudChannelService_StartPaidService_Handler,
		},
		{
			MethodName: "SuspendEntitlement",
			Handler:    _CloudChannelService_SuspendEntitlement_Handler,
		},
		{
			MethodName: "CancelEntitlement",
			Handler:    _CloudChannelService_CancelEntitlement_Handler,
		},
		{
			MethodName: "ActivateEntitlement",
			Handler:    _CloudChannelService_ActivateEntitlement_Handler,
		},
		{
			MethodName: "TransferEntitlements",
			Handler:    _CloudChannelService_TransferEntitlements_Handler,
		},
		{
			MethodName: "TransferEntitlementsToGoogle",
			Handler:    _CloudChannelService_TransferEntitlementsToGoogle_Handler,
		},
		{
			MethodName: "ListChannelPartnerLinks",
			Handler:    _CloudChannelService_ListChannelPartnerLinks_Handler,
		},
		{
			MethodName: "GetChannelPartnerLink",
			Handler:    _CloudChannelService_GetChannelPartnerLink_Handler,
		},
		{
			MethodName: "CreateChannelPartnerLink",
			Handler:    _CloudChannelService_CreateChannelPartnerLink_Handler,
		},
		{
			MethodName: "UpdateChannelPartnerLink",
			Handler:    _CloudChannelService_UpdateChannelPartnerLink_Handler,
		},
		{
			MethodName: "GetCustomerRepricingConfig",
			Handler:    _CloudChannelService_GetCustomerRepricingConfig_Handler,
		},
		{
			MethodName: "ListCustomerRepricingConfigs",
			Handler:    _CloudChannelService_ListCustomerRepricingConfigs_Handler,
		},
		{
			MethodName: "CreateCustomerRepricingConfig",
			Handler:    _CloudChannelService_CreateCustomerRepricingConfig_Handler,
		},
		{
			MethodName: "UpdateCustomerRepricingConfig",
			Handler:    _CloudChannelService_UpdateCustomerRepricingConfig_Handler,
		},
		{
			MethodName: "DeleteCustomerRepricingConfig",
			Handler:    _CloudChannelService_DeleteCustomerRepricingConfig_Handler,
		},
		{
			MethodName: "GetChannelPartnerRepricingConfig",
			Handler:    _CloudChannelService_GetChannelPartnerRepricingConfig_Handler,
		},
		{
			MethodName: "ListChannelPartnerRepricingConfigs",
			Handler:    _CloudChannelService_ListChannelPartnerRepricingConfigs_Handler,
		},
		{
			MethodName: "CreateChannelPartnerRepricingConfig",
			Handler:    _CloudChannelService_CreateChannelPartnerRepricingConfig_Handler,
		},
		{
			MethodName: "UpdateChannelPartnerRepricingConfig",
			Handler:    _CloudChannelService_UpdateChannelPartnerRepricingConfig_Handler,
		},
		{
			MethodName: "DeleteChannelPartnerRepricingConfig",
			Handler:    _CloudChannelService_DeleteChannelPartnerRepricingConfig_Handler,
		},
		{
			MethodName: "ListSkuGroups",
			Handler:    _CloudChannelService_ListSkuGroups_Handler,
		},
		{
			MethodName: "ListSkuGroupBillableSkus",
			Handler:    _CloudChannelService_ListSkuGroupBillableSkus_Handler,
		},
		{
			MethodName: "LookupOffer",
			Handler:    _CloudChannelService_LookupOffer_Handler,
		},
		{
			MethodName: "ListProducts",
			Handler:    _CloudChannelService_ListProducts_Handler,
		},
		{
			MethodName: "ListSkus",
			Handler:    _CloudChannelService_ListSkus_Handler,
		},
		{
			MethodName: "ListOffers",
			Handler:    _CloudChannelService_ListOffers_Handler,
		},
		{
			MethodName: "ListPurchasableSkus",
			Handler:    _CloudChannelService_ListPurchasableSkus_Handler,
		},
		{
			MethodName: "ListPurchasableOffers",
			Handler:    _CloudChannelService_ListPurchasableOffers_Handler,
		},
		{
			MethodName: "QueryEligibleBillingAccounts",
			Handler:    _CloudChannelService_QueryEligibleBillingAccounts_Handler,
		},
		{
			MethodName: "RegisterSubscriber",
			Handler:    _CloudChannelService_RegisterSubscriber_Handler,
		},
		{
			MethodName: "UnregisterSubscriber",
			Handler:    _CloudChannelService_UnregisterSubscriber_Handler,
		},
		{
			MethodName: "ListSubscribers",
			Handler:    _CloudChannelService_ListSubscribers_Handler,
		},
		{
			MethodName: "ListEntitlementChanges",
			Handler:    _CloudChannelService_ListEntitlementChanges_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/channel/v1/service.proto",
}
