// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto

package appgatewayspb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AppGatewaysService_ListAppGateways_FullMethodName  = "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/ListAppGateways"
	AppGatewaysService_GetAppGateway_FullMethodName    = "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/GetAppGateway"
	AppGatewaysService_CreateAppGateway_FullMethodName = "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/CreateAppGateway"
	AppGatewaysService_DeleteAppGateway_FullMethodName = "/google.cloud.beyondcorp.appgateways.v1.AppGatewaysService/DeleteAppGateway"
)

// AppGatewaysServiceClient is the client API for AppGatewaysService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AppGatewaysServiceClient interface {
	// Lists AppGateways in a given project and location.
	ListAppGateways(ctx context.Context, in *ListAppGatewaysRequest, opts ...grpc.CallOption) (*ListAppGatewaysResponse, error)
	// Gets details of a single AppGateway.
	GetAppGateway(ctx context.Context, in *GetAppGatewayRequest, opts ...grpc.CallOption) (*AppGateway, error)
	// Creates a new AppGateway in a given project and location.
	CreateAppGateway(ctx context.Context, in *CreateAppGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single AppGateway.
	DeleteAppGateway(ctx context.Context, in *DeleteAppGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type appGatewaysServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAppGatewaysServiceClient(cc grpc.ClientConnInterface) AppGatewaysServiceClient {
	return &appGatewaysServiceClient{cc}
}

func (c *appGatewaysServiceClient) ListAppGateways(ctx context.Context, in *ListAppGatewaysRequest, opts ...grpc.CallOption) (*ListAppGatewaysResponse, error) {
	out := new(ListAppGatewaysResponse)
	err := c.cc.Invoke(ctx, AppGatewaysService_ListAppGateways_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appGatewaysServiceClient) GetAppGateway(ctx context.Context, in *GetAppGatewayRequest, opts ...grpc.CallOption) (*AppGateway, error) {
	out := new(AppGateway)
	err := c.cc.Invoke(ctx, AppGatewaysService_GetAppGateway_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appGatewaysServiceClient) CreateAppGateway(ctx context.Context, in *CreateAppGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AppGatewaysService_CreateAppGateway_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appGatewaysServiceClient) DeleteAppGateway(ctx context.Context, in *DeleteAppGatewayRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AppGatewaysService_DeleteAppGateway_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AppGatewaysServiceServer is the server API for AppGatewaysService service.
// All implementations should embed UnimplementedAppGatewaysServiceServer
// for forward compatibility
type AppGatewaysServiceServer interface {
	// Lists AppGateways in a given project and location.
	ListAppGateways(context.Context, *ListAppGatewaysRequest) (*ListAppGatewaysResponse, error)
	// Gets details of a single AppGateway.
	GetAppGateway(context.Context, *GetAppGatewayRequest) (*AppGateway, error)
	// Creates a new AppGateway in a given project and location.
	CreateAppGateway(context.Context, *CreateAppGatewayRequest) (*longrunningpb.Operation, error)
	// Deletes a single AppGateway.
	DeleteAppGateway(context.Context, *DeleteAppGatewayRequest) (*longrunningpb.Operation, error)
}

// UnimplementedAppGatewaysServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAppGatewaysServiceServer struct {
}

func (UnimplementedAppGatewaysServiceServer) ListAppGateways(context.Context, *ListAppGatewaysRequest) (*ListAppGatewaysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAppGateways not implemented")
}
func (UnimplementedAppGatewaysServiceServer) GetAppGateway(context.Context, *GetAppGatewayRequest) (*AppGateway, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppGateway not implemented")
}
func (UnimplementedAppGatewaysServiceServer) CreateAppGateway(context.Context, *CreateAppGatewayRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAppGateway not implemented")
}
func (UnimplementedAppGatewaysServiceServer) DeleteAppGateway(context.Context, *DeleteAppGatewayRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAppGateway not implemented")
}

// UnsafeAppGatewaysServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AppGatewaysServiceServer will
// result in compilation errors.
type UnsafeAppGatewaysServiceServer interface {
	mustEmbedUnimplementedAppGatewaysServiceServer()
}

func RegisterAppGatewaysServiceServer(s grpc.ServiceRegistrar, srv AppGatewaysServiceServer) {
	s.RegisterService(&AppGatewaysService_ServiceDesc, srv)
}

func _AppGatewaysService_ListAppGateways_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAppGatewaysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppGatewaysServiceServer).ListAppGateways(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppGatewaysService_ListAppGateways_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppGatewaysServiceServer).ListAppGateways(ctx, req.(*ListAppGatewaysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppGatewaysService_GetAppGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAppGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppGatewaysServiceServer).GetAppGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppGatewaysService_GetAppGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppGatewaysServiceServer).GetAppGateway(ctx, req.(*GetAppGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppGatewaysService_CreateAppGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAppGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppGatewaysServiceServer).CreateAppGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppGatewaysService_CreateAppGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppGatewaysServiceServer).CreateAppGateway(ctx, req.(*CreateAppGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppGatewaysService_DeleteAppGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAppGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppGatewaysServiceServer).DeleteAppGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppGatewaysService_DeleteAppGateway_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppGatewaysServiceServer).DeleteAppGateway(ctx, req.(*DeleteAppGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AppGatewaysService_ServiceDesc is the grpc.ServiceDesc for AppGatewaysService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AppGatewaysService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.beyondcorp.appgateways.v1.AppGatewaysService",
	HandlerType: (*AppGatewaysServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAppGateways",
			Handler:    _AppGatewaysService_ListAppGateways_Handler,
		},
		{
			MethodName: "GetAppGateway",
			Handler:    _AppGatewaysService_GetAppGateway_Handler,
		},
		{
			MethodName: "CreateAppGateway",
			Handler:    _AppGatewaysService_CreateAppGateway_Handler,
		},
		{
			MethodName: "DeleteAppGateway",
			Handler:    _AppGatewaysService_DeleteAppGateway_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto",
}
