// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2alpha/merchant_center_account_link_service.proto

package retailpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MerchantCenterAccountLinkService_ListMerchantCenterAccountLinks_FullMethodName  = "/google.cloud.retail.v2alpha.MerchantCenterAccountLinkService/ListMerchantCenterAccountLinks"
	MerchantCenterAccountLinkService_CreateMerchantCenterAccountLink_FullMethodName = "/google.cloud.retail.v2alpha.MerchantCenterAccountLinkService/CreateMerchantCenterAccountLink"
	MerchantCenterAccountLinkService_DeleteMerchantCenterAccountLink_FullMethodName = "/google.cloud.retail.v2alpha.MerchantCenterAccountLinkService/DeleteMerchantCenterAccountLink"
)

// MerchantCenterAccountLinkServiceClient is the client API for MerchantCenterAccountLinkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MerchantCenterAccountLinkServiceClient interface {
	// Lists all
	// [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]s
	// under the specified parent [Catalog][google.cloud.retail.v2alpha.Catalog].
	ListMerchantCenterAccountLinks(ctx context.Context, in *ListMerchantCenterAccountLinksRequest, opts ...grpc.CallOption) (*ListMerchantCenterAccountLinksResponse, error)
	// Creates a
	// [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink].
	CreateMerchantCenterAccountLink(ctx context.Context, in *CreateMerchantCenterAccountLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a
	// [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink].
	// If the
	// [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]
	// to delete does not exist, a NOT_FOUND error is returned.
	DeleteMerchantCenterAccountLink(ctx context.Context, in *DeleteMerchantCenterAccountLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type merchantCenterAccountLinkServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMerchantCenterAccountLinkServiceClient(cc grpc.ClientConnInterface) MerchantCenterAccountLinkServiceClient {
	return &merchantCenterAccountLinkServiceClient{cc}
}

func (c *merchantCenterAccountLinkServiceClient) ListMerchantCenterAccountLinks(ctx context.Context, in *ListMerchantCenterAccountLinksRequest, opts ...grpc.CallOption) (*ListMerchantCenterAccountLinksResponse, error) {
	out := new(ListMerchantCenterAccountLinksResponse)
	err := c.cc.Invoke(ctx, MerchantCenterAccountLinkService_ListMerchantCenterAccountLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merchantCenterAccountLinkServiceClient) CreateMerchantCenterAccountLink(ctx context.Context, in *CreateMerchantCenterAccountLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MerchantCenterAccountLinkService_CreateMerchantCenterAccountLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merchantCenterAccountLinkServiceClient) DeleteMerchantCenterAccountLink(ctx context.Context, in *DeleteMerchantCenterAccountLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, MerchantCenterAccountLinkService_DeleteMerchantCenterAccountLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MerchantCenterAccountLinkServiceServer is the server API for MerchantCenterAccountLinkService service.
// All implementations should embed UnimplementedMerchantCenterAccountLinkServiceServer
// for forward compatibility
type MerchantCenterAccountLinkServiceServer interface {
	// Lists all
	// [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]s
	// under the specified parent [Catalog][google.cloud.retail.v2alpha.Catalog].
	ListMerchantCenterAccountLinks(context.Context, *ListMerchantCenterAccountLinksRequest) (*ListMerchantCenterAccountLinksResponse, error)
	// Creates a
	// [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink].
	CreateMerchantCenterAccountLink(context.Context, *CreateMerchantCenterAccountLinkRequest) (*longrunningpb.Operation, error)
	// Deletes a
	// [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink].
	// If the
	// [MerchantCenterAccountLink][google.cloud.retail.v2alpha.MerchantCenterAccountLink]
	// to delete does not exist, a NOT_FOUND error is returned.
	DeleteMerchantCenterAccountLink(context.Context, *DeleteMerchantCenterAccountLinkRequest) (*emptypb.Empty, error)
}

// UnimplementedMerchantCenterAccountLinkServiceServer should be embedded to have forward compatible implementations.
type UnimplementedMerchantCenterAccountLinkServiceServer struct {
}

func (UnimplementedMerchantCenterAccountLinkServiceServer) ListMerchantCenterAccountLinks(context.Context, *ListMerchantCenterAccountLinksRequest) (*ListMerchantCenterAccountLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMerchantCenterAccountLinks not implemented")
}
func (UnimplementedMerchantCenterAccountLinkServiceServer) CreateMerchantCenterAccountLink(context.Context, *CreateMerchantCenterAccountLinkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMerchantCenterAccountLink not implemented")
}
func (UnimplementedMerchantCenterAccountLinkServiceServer) DeleteMerchantCenterAccountLink(context.Context, *DeleteMerchantCenterAccountLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMerchantCenterAccountLink not implemented")
}

// UnsafeMerchantCenterAccountLinkServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MerchantCenterAccountLinkServiceServer will
// result in compilation errors.
type UnsafeMerchantCenterAccountLinkServiceServer interface {
	mustEmbedUnimplementedMerchantCenterAccountLinkServiceServer()
}

func RegisterMerchantCenterAccountLinkServiceServer(s grpc.ServiceRegistrar, srv MerchantCenterAccountLinkServiceServer) {
	s.RegisterService(&MerchantCenterAccountLinkService_ServiceDesc, srv)
}

func _MerchantCenterAccountLinkService_ListMerchantCenterAccountLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMerchantCenterAccountLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantCenterAccountLinkServiceServer).ListMerchantCenterAccountLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MerchantCenterAccountLinkService_ListMerchantCenterAccountLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantCenterAccountLinkServiceServer).ListMerchantCenterAccountLinks(ctx, req.(*ListMerchantCenterAccountLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MerchantCenterAccountLinkService_CreateMerchantCenterAccountLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMerchantCenterAccountLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantCenterAccountLinkServiceServer).CreateMerchantCenterAccountLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MerchantCenterAccountLinkService_CreateMerchantCenterAccountLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantCenterAccountLinkServiceServer).CreateMerchantCenterAccountLink(ctx, req.(*CreateMerchantCenterAccountLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MerchantCenterAccountLinkService_DeleteMerchantCenterAccountLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMerchantCenterAccountLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantCenterAccountLinkServiceServer).DeleteMerchantCenterAccountLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MerchantCenterAccountLinkService_DeleteMerchantCenterAccountLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantCenterAccountLinkServiceServer).DeleteMerchantCenterAccountLink(ctx, req.(*DeleteMerchantCenterAccountLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MerchantCenterAccountLinkService_ServiceDesc is the grpc.ServiceDesc for MerchantCenterAccountLinkService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MerchantCenterAccountLinkService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2alpha.MerchantCenterAccountLinkService",
	HandlerType: (*MerchantCenterAccountLinkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMerchantCenterAccountLinks",
			Handler:    _MerchantCenterAccountLinkService_ListMerchantCenterAccountLinks_Handler,
		},
		{
			MethodName: "CreateMerchantCenterAccountLink",
			Handler:    _MerchantCenterAccountLinkService_CreateMerchantCenterAccountLink_Handler,
		},
		{
			MethodName: "DeleteMerchantCenterAccountLink",
			Handler:    _MerchantCenterAccountLinkService_DeleteMerchantCenterAccountLink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2alpha/merchant_center_account_link_service.proto",
}
