// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2beta/completion_service.proto

package retailpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CompletionService_CompleteQuery_FullMethodName        = "/google.cloud.retail.v2beta.CompletionService/CompleteQuery"
	CompletionService_ImportCompletionData_FullMethodName = "/google.cloud.retail.v2beta.CompletionService/ImportCompletionData"
)

// CompletionServiceClient is the client API for CompletionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CompletionServiceClient interface {
	// Completes the specified prefix with keyword suggestions.
	//
	// This feature is only available for users who have Retail Search enabled.
	// Enable Retail Search on Cloud Console before using this feature.
	CompleteQuery(ctx context.Context, in *CompleteQueryRequest, opts ...grpc.CallOption) (*CompleteQueryResponse, error)
	// Bulk import of processed completion dataset.
	//
	// Request processing is asynchronous. Partial updating is not supported.
	//
	// The operation is successfully finished only after the imported suggestions
	// are indexed successfully and ready for serving. The process takes hours.
	//
	// This feature is only available for users who have Retail Search enabled.
	// Enable Retail Search on Cloud Console before using this feature.
	ImportCompletionData(ctx context.Context, in *ImportCompletionDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type completionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCompletionServiceClient(cc grpc.ClientConnInterface) CompletionServiceClient {
	return &completionServiceClient{cc}
}

func (c *completionServiceClient) CompleteQuery(ctx context.Context, in *CompleteQueryRequest, opts ...grpc.CallOption) (*CompleteQueryResponse, error) {
	out := new(CompleteQueryResponse)
	err := c.cc.Invoke(ctx, CompletionService_CompleteQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *completionServiceClient) ImportCompletionData(ctx context.Context, in *ImportCompletionDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CompletionService_ImportCompletionData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CompletionServiceServer is the server API for CompletionService service.
// All implementations should embed UnimplementedCompletionServiceServer
// for forward compatibility
type CompletionServiceServer interface {
	// Completes the specified prefix with keyword suggestions.
	//
	// This feature is only available for users who have Retail Search enabled.
	// Enable Retail Search on Cloud Console before using this feature.
	CompleteQuery(context.Context, *CompleteQueryRequest) (*CompleteQueryResponse, error)
	// Bulk import of processed completion dataset.
	//
	// Request processing is asynchronous. Partial updating is not supported.
	//
	// The operation is successfully finished only after the imported suggestions
	// are indexed successfully and ready for serving. The process takes hours.
	//
	// This feature is only available for users who have Retail Search enabled.
	// Enable Retail Search on Cloud Console before using this feature.
	ImportCompletionData(context.Context, *ImportCompletionDataRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCompletionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCompletionServiceServer struct {
}

func (UnimplementedCompletionServiceServer) CompleteQuery(context.Context, *CompleteQueryRequest) (*CompleteQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteQuery not implemented")
}
func (UnimplementedCompletionServiceServer) ImportCompletionData(context.Context, *ImportCompletionDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportCompletionData not implemented")
}

// UnsafeCompletionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CompletionServiceServer will
// result in compilation errors.
type UnsafeCompletionServiceServer interface {
	mustEmbedUnimplementedCompletionServiceServer()
}

func RegisterCompletionServiceServer(s grpc.ServiceRegistrar, srv CompletionServiceServer) {
	s.RegisterService(&CompletionService_ServiceDesc, srv)
}

func _CompletionService_CompleteQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CompletionServiceServer).CompleteQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CompletionService_CompleteQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CompletionServiceServer).CompleteQuery(ctx, req.(*CompleteQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CompletionService_ImportCompletionData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportCompletionDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CompletionServiceServer).ImportCompletionData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CompletionService_ImportCompletionData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CompletionServiceServer).ImportCompletionData(ctx, req.(*ImportCompletionDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CompletionService_ServiceDesc is the grpc.ServiceDesc for CompletionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CompletionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2beta.CompletionService",
	HandlerType: (*CompletionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CompleteQuery",
			Handler:    _CompletionService_CompleteQuery_Handler,
		},
		{
			MethodName: "ImportCompletionData",
			Handler:    _CompletionService_ImportCompletionData_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2beta/completion_service.proto",
}
