// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/migration/v2alpha/translation_service.proto

package migrationpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SqlTranslationService_TranslateQuery_FullMethodName = "/google.cloud.bigquery.migration.v2alpha.SqlTranslationService/TranslateQuery"
)

// SqlTranslationServiceClient is the client API for SqlTranslationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SqlTranslationServiceClient interface {
	// Translates input queries from source dialects to GoogleSQL.
	TranslateQuery(ctx context.Context, in *TranslateQueryRequest, opts ...grpc.CallOption) (*TranslateQueryResponse, error)
}

type sqlTranslationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlTranslationServiceClient(cc grpc.ClientConnInterface) SqlTranslationServiceClient {
	return &sqlTranslationServiceClient{cc}
}

func (c *sqlTranslationServiceClient) TranslateQuery(ctx context.Context, in *TranslateQueryRequest, opts ...grpc.CallOption) (*TranslateQueryResponse, error) {
	out := new(TranslateQueryResponse)
	err := c.cc.Invoke(ctx, SqlTranslationService_TranslateQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlTranslationServiceServer is the server API for SqlTranslationService service.
// All implementations should embed UnimplementedSqlTranslationServiceServer
// for forward compatibility
type SqlTranslationServiceServer interface {
	// Translates input queries from source dialects to GoogleSQL.
	TranslateQuery(context.Context, *TranslateQueryRequest) (*TranslateQueryResponse, error)
}

// UnimplementedSqlTranslationServiceServer should be embedded to have forward compatible implementations.
type UnimplementedSqlTranslationServiceServer struct {
}

func (UnimplementedSqlTranslationServiceServer) TranslateQuery(context.Context, *TranslateQueryRequest) (*TranslateQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TranslateQuery not implemented")
}

// UnsafeSqlTranslationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SqlTranslationServiceServer will
// result in compilation errors.
type UnsafeSqlTranslationServiceServer interface {
	mustEmbedUnimplementedSqlTranslationServiceServer()
}

func RegisterSqlTranslationServiceServer(s grpc.ServiceRegistrar, srv SqlTranslationServiceServer) {
	s.RegisterService(&SqlTranslationService_ServiceDesc, srv)
}

func _SqlTranslationService_TranslateQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TranslateQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlTranslationServiceServer).TranslateQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SqlTranslationService_TranslateQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlTranslationServiceServer).TranslateQuery(ctx, req.(*TranslateQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SqlTranslationService_ServiceDesc is the grpc.ServiceDesc for SqlTranslationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SqlTranslationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.migration.v2alpha.SqlTranslationService",
	HandlerType: (*SqlTranslationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TranslateQuery",
			Handler:    _SqlTranslationService_TranslateQuery_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/migration/v2alpha/translation_service.proto",
}
