// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/datapolicies/v1/datapolicy.proto

package datapoliciespb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataPolicyService_CreateDataPolicy_FullMethodName   = "/google.cloud.bigquery.datapolicies.v1.DataPolicyService/CreateDataPolicy"
	DataPolicyService_UpdateDataPolicy_FullMethodName   = "/google.cloud.bigquery.datapolicies.v1.DataPolicyService/UpdateDataPolicy"
	DataPolicyService_RenameDataPolicy_FullMethodName   = "/google.cloud.bigquery.datapolicies.v1.DataPolicyService/RenameDataPolicy"
	DataPolicyService_DeleteDataPolicy_FullMethodName   = "/google.cloud.bigquery.datapolicies.v1.DataPolicyService/DeleteDataPolicy"
	DataPolicyService_GetDataPolicy_FullMethodName      = "/google.cloud.bigquery.datapolicies.v1.DataPolicyService/GetDataPolicy"
	DataPolicyService_ListDataPolicies_FullMethodName   = "/google.cloud.bigquery.datapolicies.v1.DataPolicyService/ListDataPolicies"
	DataPolicyService_GetIamPolicy_FullMethodName       = "/google.cloud.bigquery.datapolicies.v1.DataPolicyService/GetIamPolicy"
	DataPolicyService_SetIamPolicy_FullMethodName       = "/google.cloud.bigquery.datapolicies.v1.DataPolicyService/SetIamPolicy"
	DataPolicyService_TestIamPermissions_FullMethodName = "/google.cloud.bigquery.datapolicies.v1.DataPolicyService/TestIamPermissions"
)

// DataPolicyServiceClient is the client API for DataPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataPolicyServiceClient interface {
	// Creates a new data policy under a project with the given `dataPolicyId`
	// (used as the display name), policy tag, and data policy type.
	CreateDataPolicy(ctx context.Context, in *CreateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// Updates the metadata for an existing data policy. The target data policy
	// can be specified by the resource name.
	UpdateDataPolicy(ctx context.Context, in *UpdateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// Renames the id (display name) of the specified data policy.
	RenameDataPolicy(ctx context.Context, in *RenameDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// Deletes the data policy specified by its resource name.
	DeleteDataPolicy(ctx context.Context, in *DeleteDataPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the data policy specified by its resource name.
	GetDataPolicy(ctx context.Context, in *GetDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error)
	// List all of the data policies in the specified parent project.
	ListDataPolicies(ctx context.Context, in *ListDataPoliciesRequest, opts ...grpc.CallOption) (*ListDataPoliciesResponse, error)
	// Gets the IAM policy for the specified data policy.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the IAM policy for the specified data policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the caller's permission on the specified data policy resource.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type dataPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataPolicyServiceClient(cc grpc.ClientConnInterface) DataPolicyServiceClient {
	return &dataPolicyServiceClient{cc}
}

func (c *dataPolicyServiceClient) CreateDataPolicy(ctx context.Context, in *CreateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, DataPolicyService_CreateDataPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) UpdateDataPolicy(ctx context.Context, in *UpdateDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, DataPolicyService_UpdateDataPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) RenameDataPolicy(ctx context.Context, in *RenameDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, DataPolicyService_RenameDataPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) DeleteDataPolicy(ctx context.Context, in *DeleteDataPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataPolicyService_DeleteDataPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) GetDataPolicy(ctx context.Context, in *GetDataPolicyRequest, opts ...grpc.CallOption) (*DataPolicy, error) {
	out := new(DataPolicy)
	err := c.cc.Invoke(ctx, DataPolicyService_GetDataPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) ListDataPolicies(ctx context.Context, in *ListDataPoliciesRequest, opts ...grpc.CallOption) (*ListDataPoliciesResponse, error) {
	out := new(ListDataPoliciesResponse)
	err := c.cc.Invoke(ctx, DataPolicyService_ListDataPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DataPolicyService_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, DataPolicyService_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataPolicyServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, DataPolicyService_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataPolicyServiceServer is the server API for DataPolicyService service.
// All implementations should embed UnimplementedDataPolicyServiceServer
// for forward compatibility
type DataPolicyServiceServer interface {
	// Creates a new data policy under a project with the given `dataPolicyId`
	// (used as the display name), policy tag, and data policy type.
	CreateDataPolicy(context.Context, *CreateDataPolicyRequest) (*DataPolicy, error)
	// Updates the metadata for an existing data policy. The target data policy
	// can be specified by the resource name.
	UpdateDataPolicy(context.Context, *UpdateDataPolicyRequest) (*DataPolicy, error)
	// Renames the id (display name) of the specified data policy.
	RenameDataPolicy(context.Context, *RenameDataPolicyRequest) (*DataPolicy, error)
	// Deletes the data policy specified by its resource name.
	DeleteDataPolicy(context.Context, *DeleteDataPolicyRequest) (*emptypb.Empty, error)
	// Gets the data policy specified by its resource name.
	GetDataPolicy(context.Context, *GetDataPolicyRequest) (*DataPolicy, error)
	// List all of the data policies in the specified parent project.
	ListDataPolicies(context.Context, *ListDataPoliciesRequest) (*ListDataPoliciesResponse, error)
	// Gets the IAM policy for the specified data policy.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the IAM policy for the specified data policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the caller's permission on the specified data policy resource.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedDataPolicyServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDataPolicyServiceServer struct {
}

func (UnimplementedDataPolicyServiceServer) CreateDataPolicy(context.Context, *CreateDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataPolicy not implemented")
}
func (UnimplementedDataPolicyServiceServer) UpdateDataPolicy(context.Context, *UpdateDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataPolicy not implemented")
}
func (UnimplementedDataPolicyServiceServer) RenameDataPolicy(context.Context, *RenameDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameDataPolicy not implemented")
}
func (UnimplementedDataPolicyServiceServer) DeleteDataPolicy(context.Context, *DeleteDataPolicyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataPolicy not implemented")
}
func (UnimplementedDataPolicyServiceServer) GetDataPolicy(context.Context, *GetDataPolicyRequest) (*DataPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataPolicy not implemented")
}
func (UnimplementedDataPolicyServiceServer) ListDataPolicies(context.Context, *ListDataPoliciesRequest) (*ListDataPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataPolicies not implemented")
}
func (UnimplementedDataPolicyServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedDataPolicyServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedDataPolicyServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeDataPolicyServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataPolicyServiceServer will
// result in compilation errors.
type UnsafeDataPolicyServiceServer interface {
	mustEmbedUnimplementedDataPolicyServiceServer()
}

func RegisterDataPolicyServiceServer(s grpc.ServiceRegistrar, srv DataPolicyServiceServer) {
	s.RegisterService(&DataPolicyService_ServiceDesc, srv)
}

func _DataPolicyService_CreateDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).CreateDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataPolicyService_CreateDataPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).CreateDataPolicy(ctx, req.(*CreateDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_UpdateDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).UpdateDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataPolicyService_UpdateDataPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).UpdateDataPolicy(ctx, req.(*UpdateDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_RenameDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).RenameDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataPolicyService_RenameDataPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).RenameDataPolicy(ctx, req.(*RenameDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_DeleteDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).DeleteDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataPolicyService_DeleteDataPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).DeleteDataPolicy(ctx, req.(*DeleteDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_GetDataPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).GetDataPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataPolicyService_GetDataPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).GetDataPolicy(ctx, req.(*GetDataPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_ListDataPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).ListDataPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataPolicyService_ListDataPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).ListDataPolicies(ctx, req.(*ListDataPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataPolicyService_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataPolicyService_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataPolicyService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataPolicyServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataPolicyService_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataPolicyServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataPolicyService_ServiceDesc is the grpc.ServiceDesc for DataPolicyService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataPolicyService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.datapolicies.v1.DataPolicyService",
	HandlerType: (*DataPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataPolicy",
			Handler:    _DataPolicyService_CreateDataPolicy_Handler,
		},
		{
			MethodName: "UpdateDataPolicy",
			Handler:    _DataPolicyService_UpdateDataPolicy_Handler,
		},
		{
			MethodName: "RenameDataPolicy",
			Handler:    _DataPolicyService_RenameDataPolicy_Handler,
		},
		{
			MethodName: "DeleteDataPolicy",
			Handler:    _DataPolicyService_DeleteDataPolicy_Handler,
		},
		{
			MethodName: "GetDataPolicy",
			Handler:    _DataPolicyService_GetDataPolicy_Handler,
		},
		{
			MethodName: "ListDataPolicies",
			Handler:    _DataPolicyService_ListDataPolicies_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataPolicyService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataPolicyService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataPolicyService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/datapolicies/v1/datapolicy.proto",
}
