// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/assuredworkloads/v1beta1/assuredworkloads_service.proto

package assuredworkloadspb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AssuredWorkloadsService_CreateWorkload_FullMethodName           = "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/CreateWorkload"
	AssuredWorkloadsService_UpdateWorkload_FullMethodName           = "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/UpdateWorkload"
	AssuredWorkloadsService_RestrictAllowedResources_FullMethodName = "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/RestrictAllowedResources"
	AssuredWorkloadsService_DeleteWorkload_FullMethodName           = "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/DeleteWorkload"
	AssuredWorkloadsService_GetWorkload_FullMethodName              = "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/GetWorkload"
	AssuredWorkloadsService_AnalyzeWorkloadMove_FullMethodName      = "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/AnalyzeWorkloadMove"
	AssuredWorkloadsService_ListWorkloads_FullMethodName            = "/google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService/ListWorkloads"
)

// AssuredWorkloadsServiceClient is the client API for AssuredWorkloadsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AssuredWorkloadsServiceClient interface {
	// Creates Assured Workload.
	CreateWorkload(ctx context.Context, in *CreateWorkloadRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing workload.
	// Currently allows updating of workload display_name and labels.
	// For force updates don't set etag field in the Workload.
	// Only one update operation per workload can be in progress.
	UpdateWorkload(ctx context.Context, in *UpdateWorkloadRequest, opts ...grpc.CallOption) (*Workload, error)
	// Restrict the list of resources allowed in the Workload environment.
	// The current list of allowed products can be found at
	// https://cloud.google.com/assured-workloads/docs/supported-products
	// In addition to assuredworkloads.workload.update permission, the user should
	// also have orgpolicy.policy.set permission on the folder resource
	// to use this functionality.
	RestrictAllowedResources(ctx context.Context, in *RestrictAllowedResourcesRequest, opts ...grpc.CallOption) (*RestrictAllowedResourcesResponse, error)
	// Deletes the workload. Make sure that workload's direct children are already
	// in a deleted state, otherwise the request will fail with a
	// FAILED_PRECONDITION error.
	// In addition to assuredworkloads.workload.delete permission, the user should
	// also have orgpolicy.policy.set permission on the deleted folder to remove
	// Assured Workloads OrgPolicies.
	DeleteWorkload(ctx context.Context, in *DeleteWorkloadRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets Assured Workload associated with a CRM Node
	GetWorkload(ctx context.Context, in *GetWorkloadRequest, opts ...grpc.CallOption) (*Workload, error)
	// Analyze if the source Assured Workloads can be moved to the target Assured
	// Workload
	AnalyzeWorkloadMove(ctx context.Context, in *AnalyzeWorkloadMoveRequest, opts ...grpc.CallOption) (*AnalyzeWorkloadMoveResponse, error)
	// Lists Assured Workloads under a CRM Node.
	ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error)
}

type assuredWorkloadsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssuredWorkloadsServiceClient(cc grpc.ClientConnInterface) AssuredWorkloadsServiceClient {
	return &assuredWorkloadsServiceClient{cc}
}

func (c *assuredWorkloadsServiceClient) CreateWorkload(ctx context.Context, in *CreateWorkloadRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_CreateWorkload_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) UpdateWorkload(ctx context.Context, in *UpdateWorkloadRequest, opts ...grpc.CallOption) (*Workload, error) {
	out := new(Workload)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_UpdateWorkload_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) RestrictAllowedResources(ctx context.Context, in *RestrictAllowedResourcesRequest, opts ...grpc.CallOption) (*RestrictAllowedResourcesResponse, error) {
	out := new(RestrictAllowedResourcesResponse)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_RestrictAllowedResources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) DeleteWorkload(ctx context.Context, in *DeleteWorkloadRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_DeleteWorkload_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) GetWorkload(ctx context.Context, in *GetWorkloadRequest, opts ...grpc.CallOption) (*Workload, error) {
	out := new(Workload)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_GetWorkload_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) AnalyzeWorkloadMove(ctx context.Context, in *AnalyzeWorkloadMoveRequest, opts ...grpc.CallOption) (*AnalyzeWorkloadMoveResponse, error) {
	out := new(AnalyzeWorkloadMoveResponse)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_AnalyzeWorkloadMove_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error) {
	out := new(ListWorkloadsResponse)
	err := c.cc.Invoke(ctx, AssuredWorkloadsService_ListWorkloads_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssuredWorkloadsServiceServer is the server API for AssuredWorkloadsService service.
// All implementations should embed UnimplementedAssuredWorkloadsServiceServer
// for forward compatibility
type AssuredWorkloadsServiceServer interface {
	// Creates Assured Workload.
	CreateWorkload(context.Context, *CreateWorkloadRequest) (*longrunningpb.Operation, error)
	// Updates an existing workload.
	// Currently allows updating of workload display_name and labels.
	// For force updates don't set etag field in the Workload.
	// Only one update operation per workload can be in progress.
	UpdateWorkload(context.Context, *UpdateWorkloadRequest) (*Workload, error)
	// Restrict the list of resources allowed in the Workload environment.
	// The current list of allowed products can be found at
	// https://cloud.google.com/assured-workloads/docs/supported-products
	// In addition to assuredworkloads.workload.update permission, the user should
	// also have orgpolicy.policy.set permission on the folder resource
	// to use this functionality.
	RestrictAllowedResources(context.Context, *RestrictAllowedResourcesRequest) (*RestrictAllowedResourcesResponse, error)
	// Deletes the workload. Make sure that workload's direct children are already
	// in a deleted state, otherwise the request will fail with a
	// FAILED_PRECONDITION error.
	// In addition to assuredworkloads.workload.delete permission, the user should
	// also have orgpolicy.policy.set permission on the deleted folder to remove
	// Assured Workloads OrgPolicies.
	DeleteWorkload(context.Context, *DeleteWorkloadRequest) (*emptypb.Empty, error)
	// Gets Assured Workload associated with a CRM Node
	GetWorkload(context.Context, *GetWorkloadRequest) (*Workload, error)
	// Analyze if the source Assured Workloads can be moved to the target Assured
	// Workload
	AnalyzeWorkloadMove(context.Context, *AnalyzeWorkloadMoveRequest) (*AnalyzeWorkloadMoveResponse, error)
	// Lists Assured Workloads under a CRM Node.
	ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error)
}

// UnimplementedAssuredWorkloadsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAssuredWorkloadsServiceServer struct {
}

func (UnimplementedAssuredWorkloadsServiceServer) CreateWorkload(context.Context, *CreateWorkloadRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkload not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) UpdateWorkload(context.Context, *UpdateWorkloadRequest) (*Workload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkload not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) RestrictAllowedResources(context.Context, *RestrictAllowedResourcesRequest) (*RestrictAllowedResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestrictAllowedResources not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) DeleteWorkload(context.Context, *DeleteWorkloadRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkload not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) GetWorkload(context.Context, *GetWorkloadRequest) (*Workload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkload not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) AnalyzeWorkloadMove(context.Context, *AnalyzeWorkloadMoveRequest) (*AnalyzeWorkloadMoveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeWorkloadMove not implemented")
}
func (UnimplementedAssuredWorkloadsServiceServer) ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkloads not implemented")
}

// UnsafeAssuredWorkloadsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AssuredWorkloadsServiceServer will
// result in compilation errors.
type UnsafeAssuredWorkloadsServiceServer interface {
	mustEmbedUnimplementedAssuredWorkloadsServiceServer()
}

func RegisterAssuredWorkloadsServiceServer(s grpc.ServiceRegistrar, srv AssuredWorkloadsServiceServer) {
	s.RegisterService(&AssuredWorkloadsService_ServiceDesc, srv)
}

func _AssuredWorkloadsService_CreateWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).CreateWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_CreateWorkload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).CreateWorkload(ctx, req.(*CreateWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_UpdateWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).UpdateWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_UpdateWorkload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).UpdateWorkload(ctx, req.(*UpdateWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_RestrictAllowedResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestrictAllowedResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).RestrictAllowedResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_RestrictAllowedResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).RestrictAllowedResources(ctx, req.(*RestrictAllowedResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_DeleteWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).DeleteWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_DeleteWorkload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).DeleteWorkload(ctx, req.(*DeleteWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_GetWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).GetWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_GetWorkload_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).GetWorkload(ctx, req.(*GetWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_AnalyzeWorkloadMove_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeWorkloadMoveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).AnalyzeWorkloadMove(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_AnalyzeWorkloadMove_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).AnalyzeWorkloadMove(ctx, req.(*AnalyzeWorkloadMoveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_ListWorkloads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkloadsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).ListWorkloads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AssuredWorkloadsService_ListWorkloads_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).ListWorkloads(ctx, req.(*ListWorkloadsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AssuredWorkloadsService_ServiceDesc is the grpc.ServiceDesc for AssuredWorkloadsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AssuredWorkloadsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.assuredworkloads.v1beta1.AssuredWorkloadsService",
	HandlerType: (*AssuredWorkloadsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWorkload",
			Handler:    _AssuredWorkloadsService_CreateWorkload_Handler,
		},
		{
			MethodName: "UpdateWorkload",
			Handler:    _AssuredWorkloadsService_UpdateWorkload_Handler,
		},
		{
			MethodName: "RestrictAllowedResources",
			Handler:    _AssuredWorkloadsService_RestrictAllowedResources_Handler,
		},
		{
			MethodName: "DeleteWorkload",
			Handler:    _AssuredWorkloadsService_DeleteWorkload_Handler,
		},
		{
			MethodName: "GetWorkload",
			Handler:    _AssuredWorkloadsService_GetWorkload_Handler,
		},
		{
			MethodName: "AnalyzeWorkloadMove",
			Handler:    _AssuredWorkloadsService_AnalyzeWorkloadMove_Handler,
		},
		{
			MethodName: "ListWorkloads",
			Handler:    _AssuredWorkloadsService_ListWorkloads_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/assuredworkloads/v1beta1/assuredworkloads_service.proto",
}
