// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Cloud Guard and Security Zones API
//
// Use the Cloud Guard and Security Zones API to automate processes that you would otherwise perform through the Cloud Guard Console or the Security Zones Console. For more information on these services, see the Cloud Guard (https://docs.oracle.com/iaas/cloud-guard/home.htm) and Security Zones (https://docs.oracle.com/iaas/security-zone/home.htm) documentation.
// **Note:** For Cloud Guard, you can perform Create, Update, and Delete operations only from the reporting region of your Cloud Guard tenancy. You can perform Read operations from any region.
//

package cloudguard

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// DetectorConfiguration Configuration details for a detector.
type DetectorConfiguration struct {

	// Unique identifier of the configuration
	ConfigKey *string `mandatory:"true" json:"configKey"`

	// Configuration name
	Name *string `mandatory:"true" json:"name"`

	// Configuration value
	Value *string `mandatory:"false" json:"value"`

	// Configuration data type
	DataType *string `mandatory:"false" json:"dataType"`

	// List of configuration values
	Values []ConfigValue `mandatory:"false" json:"values"`

	// Map property Value data type
	AllowedValuesDataType *string `mandatory:"false" json:"allowedValuesDataType"`

	// Map of possible values for configuration
	AllowedValues []PropertyTuple `mandatory:"false" json:"allowedValues"`

	// Map of additional property values for configuration
	AdditionalProperties []AdditionalConfigPropertyDefinition `mandatory:"false" json:"additionalProperties"`
}

func (m DetectorConfiguration) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m DetectorConfiguration) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
