// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewAddTeamRoleParams creates a new AddTeamRoleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAddTeamRoleParams() *AddTeamRoleParams {
	return &AddTeamRoleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAddTeamRoleParamsWithTimeout creates a new AddTeamRoleParams object
// with the ability to set a timeout on a request.
func NewAddTeamRoleParamsWithTimeout(timeout time.Duration) *AddTeamRoleParams {
	return &AddTeamRoleParams{
		timeout: timeout,
	}
}

// NewAddTeamRoleParamsWithContext creates a new AddTeamRoleParams object
// with the ability to set a context for a request.
func NewAddTeamRoleParamsWithContext(ctx context.Context) *AddTeamRoleParams {
	return &AddTeamRoleParams{
		Context: ctx,
	}
}

// NewAddTeamRoleParamsWithHTTPClient creates a new AddTeamRoleParams object
// with the ability to set a custom HTTPClient for a request.
func NewAddTeamRoleParamsWithHTTPClient(client *http.Client) *AddTeamRoleParams {
	return &AddTeamRoleParams{
		HTTPClient: client,
	}
}

/*
AddTeamRoleParams contains all the parameters to send to the API endpoint

	for the add team role operation.

	Typically these are written to a http.Request.
*/
type AddTeamRoleParams struct {

	// Body.
	Body *models.AddTeamRoleCommand

	// TeamID.
	//
	// Format: int64
	TeamID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the add team role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddTeamRoleParams) WithDefaults() *AddTeamRoleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the add team role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddTeamRoleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the add team role params
func (o *AddTeamRoleParams) WithTimeout(timeout time.Duration) *AddTeamRoleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the add team role params
func (o *AddTeamRoleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the add team role params
func (o *AddTeamRoleParams) WithContext(ctx context.Context) *AddTeamRoleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the add team role params
func (o *AddTeamRoleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the add team role params
func (o *AddTeamRoleParams) WithHTTPClient(client *http.Client) *AddTeamRoleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the add team role params
func (o *AddTeamRoleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the add team role params
func (o *AddTeamRoleParams) WithBody(body *models.AddTeamRoleCommand) *AddTeamRoleParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the add team role params
func (o *AddTeamRoleParams) SetBody(body *models.AddTeamRoleCommand) {
	o.Body = body
}

// WithTeamID adds the teamID to the add team role params
func (o *AddTeamRoleParams) WithTeamID(teamID int64) *AddTeamRoleParams {
	o.SetTeamID(teamID)
	return o
}

// SetTeamID adds the teamId to the add team role params
func (o *AddTeamRoleParams) SetTeamID(teamID int64) {
	o.TeamID = teamID
}

// WriteToRequest writes these params to a swagger request
func (o *AddTeamRoleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param teamId
	if err := r.SetPathParam("teamId", swag.FormatInt64(o.TeamID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
