// Code generated by go-swagger; DO NOT EDIT.

package enterprise

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CleanDataSourceCacheReader is a Reader for the CleanDataSourceCache structure.
type CleanDataSourceCacheReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CleanDataSourceCacheReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCleanDataSourceCacheOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewCleanDataSourceCacheInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /datasources/{dataSourceUID}/cache/clean] cleanDataSourceCache", response, response.Code())
	}
}

// NewCleanDataSourceCacheOK creates a CleanDataSourceCacheOK with default headers values
func NewCleanDataSourceCacheOK() *CleanDataSourceCacheOK {
	return &CleanDataSourceCacheOK{}
}

/*
CleanDataSourceCacheOK describes a response with status code 200, with default header values.

CacheConfigResponse
*/
type CleanDataSourceCacheOK struct {
	Payload *models.CacheConfigResponse
}

// IsSuccess returns true when this clean data source cache Ok response has a 2xx status code
func (o *CleanDataSourceCacheOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this clean data source cache Ok response has a 3xx status code
func (o *CleanDataSourceCacheOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this clean data source cache Ok response has a 4xx status code
func (o *CleanDataSourceCacheOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this clean data source cache Ok response has a 5xx status code
func (o *CleanDataSourceCacheOK) IsServerError() bool {
	return false
}

// IsCode returns true when this clean data source cache Ok response a status code equal to that given
func (o *CleanDataSourceCacheOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the clean data source cache Ok response
func (o *CleanDataSourceCacheOK) Code() int {
	return 200
}

func (o *CleanDataSourceCacheOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/clean][%d] cleanDataSourceCacheOk %s", 200, payload)
}

func (o *CleanDataSourceCacheOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/clean][%d] cleanDataSourceCacheOk %s", 200, payload)
}

func (o *CleanDataSourceCacheOK) GetPayload() *models.CacheConfigResponse {
	return o.Payload
}

func (o *CleanDataSourceCacheOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CacheConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCleanDataSourceCacheInternalServerError creates a CleanDataSourceCacheInternalServerError with default headers values
func NewCleanDataSourceCacheInternalServerError() *CleanDataSourceCacheInternalServerError {
	return &CleanDataSourceCacheInternalServerError{}
}

/*
CleanDataSourceCacheInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CleanDataSourceCacheInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this clean data source cache internal server error response has a 2xx status code
func (o *CleanDataSourceCacheInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this clean data source cache internal server error response has a 3xx status code
func (o *CleanDataSourceCacheInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this clean data source cache internal server error response has a 4xx status code
func (o *CleanDataSourceCacheInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this clean data source cache internal server error response has a 5xx status code
func (o *CleanDataSourceCacheInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this clean data source cache internal server error response a status code equal to that given
func (o *CleanDataSourceCacheInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the clean data source cache internal server error response
func (o *CleanDataSourceCacheInternalServerError) Code() int {
	return 500
}

func (o *CleanDataSourceCacheInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/clean][%d] cleanDataSourceCacheInternalServerError %s", 500, payload)
}

func (o *CleanDataSourceCacheInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/clean][%d] cleanDataSourceCacheInternalServerError %s", 500, payload)
}

func (o *CleanDataSourceCacheInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CleanDataSourceCacheInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
