// Code generated by go-swagger; DO NOT EDIT.

package library_elements

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateLibraryElementReader is a Reader for the UpdateLibraryElement structure.
type UpdateLibraryElementReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateLibraryElementReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateLibraryElementOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateLibraryElementBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateLibraryElementUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateLibraryElementForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateLibraryElementNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 412:
		result := NewUpdateLibraryElementPreconditionFailed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateLibraryElementInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /library-elements/{library_element_uid}] updateLibraryElement", response, response.Code())
	}
}

// NewUpdateLibraryElementOK creates a UpdateLibraryElementOK with default headers values
func NewUpdateLibraryElementOK() *UpdateLibraryElementOK {
	return &UpdateLibraryElementOK{}
}

/*
UpdateLibraryElementOK describes a response with status code 200, with default header values.

(empty)
*/
type UpdateLibraryElementOK struct {
	Payload *models.LibraryElementResponse
}

// IsSuccess returns true when this update library element Ok response has a 2xx status code
func (o *UpdateLibraryElementOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update library element Ok response has a 3xx status code
func (o *UpdateLibraryElementOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update library element Ok response has a 4xx status code
func (o *UpdateLibraryElementOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update library element Ok response has a 5xx status code
func (o *UpdateLibraryElementOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update library element Ok response a status code equal to that given
func (o *UpdateLibraryElementOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update library element Ok response
func (o *UpdateLibraryElementOK) Code() int {
	return 200
}

func (o *UpdateLibraryElementOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementOk %s", 200, payload)
}

func (o *UpdateLibraryElementOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementOk %s", 200, payload)
}

func (o *UpdateLibraryElementOK) GetPayload() *models.LibraryElementResponse {
	return o.Payload
}

func (o *UpdateLibraryElementOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LibraryElementResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateLibraryElementBadRequest creates a UpdateLibraryElementBadRequest with default headers values
func NewUpdateLibraryElementBadRequest() *UpdateLibraryElementBadRequest {
	return &UpdateLibraryElementBadRequest{}
}

/*
UpdateLibraryElementBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UpdateLibraryElementBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update library element bad request response has a 2xx status code
func (o *UpdateLibraryElementBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update library element bad request response has a 3xx status code
func (o *UpdateLibraryElementBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update library element bad request response has a 4xx status code
func (o *UpdateLibraryElementBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update library element bad request response has a 5xx status code
func (o *UpdateLibraryElementBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update library element bad request response a status code equal to that given
func (o *UpdateLibraryElementBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update library element bad request response
func (o *UpdateLibraryElementBadRequest) Code() int {
	return 400
}

func (o *UpdateLibraryElementBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementBadRequest %s", 400, payload)
}

func (o *UpdateLibraryElementBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementBadRequest %s", 400, payload)
}

func (o *UpdateLibraryElementBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateLibraryElementBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateLibraryElementUnauthorized creates a UpdateLibraryElementUnauthorized with default headers values
func NewUpdateLibraryElementUnauthorized() *UpdateLibraryElementUnauthorized {
	return &UpdateLibraryElementUnauthorized{}
}

/*
UpdateLibraryElementUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateLibraryElementUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update library element unauthorized response has a 2xx status code
func (o *UpdateLibraryElementUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update library element unauthorized response has a 3xx status code
func (o *UpdateLibraryElementUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update library element unauthorized response has a 4xx status code
func (o *UpdateLibraryElementUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update library element unauthorized response has a 5xx status code
func (o *UpdateLibraryElementUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update library element unauthorized response a status code equal to that given
func (o *UpdateLibraryElementUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update library element unauthorized response
func (o *UpdateLibraryElementUnauthorized) Code() int {
	return 401
}

func (o *UpdateLibraryElementUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementUnauthorized %s", 401, payload)
}

func (o *UpdateLibraryElementUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementUnauthorized %s", 401, payload)
}

func (o *UpdateLibraryElementUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateLibraryElementUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateLibraryElementForbidden creates a UpdateLibraryElementForbidden with default headers values
func NewUpdateLibraryElementForbidden() *UpdateLibraryElementForbidden {
	return &UpdateLibraryElementForbidden{}
}

/*
UpdateLibraryElementForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateLibraryElementForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update library element forbidden response has a 2xx status code
func (o *UpdateLibraryElementForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update library element forbidden response has a 3xx status code
func (o *UpdateLibraryElementForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update library element forbidden response has a 4xx status code
func (o *UpdateLibraryElementForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update library element forbidden response has a 5xx status code
func (o *UpdateLibraryElementForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update library element forbidden response a status code equal to that given
func (o *UpdateLibraryElementForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update library element forbidden response
func (o *UpdateLibraryElementForbidden) Code() int {
	return 403
}

func (o *UpdateLibraryElementForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementForbidden %s", 403, payload)
}

func (o *UpdateLibraryElementForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementForbidden %s", 403, payload)
}

func (o *UpdateLibraryElementForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateLibraryElementForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateLibraryElementNotFound creates a UpdateLibraryElementNotFound with default headers values
func NewUpdateLibraryElementNotFound() *UpdateLibraryElementNotFound {
	return &UpdateLibraryElementNotFound{}
}

/*
UpdateLibraryElementNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type UpdateLibraryElementNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update library element not found response has a 2xx status code
func (o *UpdateLibraryElementNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update library element not found response has a 3xx status code
func (o *UpdateLibraryElementNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update library element not found response has a 4xx status code
func (o *UpdateLibraryElementNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update library element not found response has a 5xx status code
func (o *UpdateLibraryElementNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update library element not found response a status code equal to that given
func (o *UpdateLibraryElementNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update library element not found response
func (o *UpdateLibraryElementNotFound) Code() int {
	return 404
}

func (o *UpdateLibraryElementNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementNotFound %s", 404, payload)
}

func (o *UpdateLibraryElementNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementNotFound %s", 404, payload)
}

func (o *UpdateLibraryElementNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateLibraryElementNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateLibraryElementPreconditionFailed creates a UpdateLibraryElementPreconditionFailed with default headers values
func NewUpdateLibraryElementPreconditionFailed() *UpdateLibraryElementPreconditionFailed {
	return &UpdateLibraryElementPreconditionFailed{}
}

/*
UpdateLibraryElementPreconditionFailed describes a response with status code 412, with default header values.

PreconditionFailedError
*/
type UpdateLibraryElementPreconditionFailed struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update library element precondition failed response has a 2xx status code
func (o *UpdateLibraryElementPreconditionFailed) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update library element precondition failed response has a 3xx status code
func (o *UpdateLibraryElementPreconditionFailed) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update library element precondition failed response has a 4xx status code
func (o *UpdateLibraryElementPreconditionFailed) IsClientError() bool {
	return true
}

// IsServerError returns true when this update library element precondition failed response has a 5xx status code
func (o *UpdateLibraryElementPreconditionFailed) IsServerError() bool {
	return false
}

// IsCode returns true when this update library element precondition failed response a status code equal to that given
func (o *UpdateLibraryElementPreconditionFailed) IsCode(code int) bool {
	return code == 412
}

// Code gets the status code for the update library element precondition failed response
func (o *UpdateLibraryElementPreconditionFailed) Code() int {
	return 412
}

func (o *UpdateLibraryElementPreconditionFailed) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementPreconditionFailed %s", 412, payload)
}

func (o *UpdateLibraryElementPreconditionFailed) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementPreconditionFailed %s", 412, payload)
}

func (o *UpdateLibraryElementPreconditionFailed) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateLibraryElementPreconditionFailed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateLibraryElementInternalServerError creates a UpdateLibraryElementInternalServerError with default headers values
func NewUpdateLibraryElementInternalServerError() *UpdateLibraryElementInternalServerError {
	return &UpdateLibraryElementInternalServerError{}
}

/*
UpdateLibraryElementInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateLibraryElementInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update library element internal server error response has a 2xx status code
func (o *UpdateLibraryElementInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update library element internal server error response has a 3xx status code
func (o *UpdateLibraryElementInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update library element internal server error response has a 4xx status code
func (o *UpdateLibraryElementInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update library element internal server error response has a 5xx status code
func (o *UpdateLibraryElementInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update library element internal server error response a status code equal to that given
func (o *UpdateLibraryElementInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update library element internal server error response
func (o *UpdateLibraryElementInternalServerError) Code() int {
	return 500
}

func (o *UpdateLibraryElementInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementInternalServerError %s", 500, payload)
}

func (o *UpdateLibraryElementInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /library-elements/{library_element_uid}][%d] updateLibraryElementInternalServerError %s", 500, payload)
}

func (o *UpdateLibraryElementInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateLibraryElementInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
