// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// GetSnapshotResponseDTO get snapshot response DTO
//
// swagger:model GetSnapshotResponseDTO
type GetSnapshotResponseDTO struct {

	// created
	// Format: date-time
	Created strfmt.DateTime `json:"created,omitempty"`

	// finished
	// Format: date-time
	Finished strfmt.DateTime `json:"finished,omitempty"`

	// results
	Results []*MigrateDataResponseItemDTO `json:"results"`

	// session Uid
	SessionUID string `json:"sessionUid,omitempty"`

	// stats
	Stats *SnapshotResourceStats `json:"stats,omitempty"`

	// status
	// Enum: [INITIALIZING CREATING PENDING_UPLOAD UPLOADING PENDING_PROCESSING PROCESSING FINISHED CANCELED ERROR UNKNOWN]
	Status string `json:"status,omitempty"`

	// uid
	UID string `json:"uid,omitempty"`
}

// Validate validates this get snapshot response DTO
func (m *GetSnapshotResponseDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFinished(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResults(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStats(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GetSnapshotResponseDTO) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(m.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("created", "body", "date-time", m.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *GetSnapshotResponseDTO) validateFinished(formats strfmt.Registry) error {
	if swag.IsZero(m.Finished) { // not required
		return nil
	}

	if err := validate.FormatOf("finished", "body", "date-time", m.Finished.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *GetSnapshotResponseDTO) validateResults(formats strfmt.Registry) error {
	if swag.IsZero(m.Results) { // not required
		return nil
	}

	for i := 0; i < len(m.Results); i++ {
		if swag.IsZero(m.Results[i]) { // not required
			continue
		}

		if m.Results[i] != nil {
			if err := m.Results[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("results" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("results" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GetSnapshotResponseDTO) validateStats(formats strfmt.Registry) error {
	if swag.IsZero(m.Stats) { // not required
		return nil
	}

	if m.Stats != nil {
		if err := m.Stats.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stats")
			}
			return err
		}
	}

	return nil
}

var getSnapshotResponseDtoTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["INITIALIZING","CREATING","PENDING_UPLOAD","UPLOADING","PENDING_PROCESSING","PROCESSING","FINISHED","CANCELED","ERROR","UNKNOWN"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		getSnapshotResponseDtoTypeStatusPropEnum = append(getSnapshotResponseDtoTypeStatusPropEnum, v)
	}
}

const (

	// GetSnapshotResponseDTOStatusINITIALIZING captures enum value "INITIALIZING"
	GetSnapshotResponseDTOStatusINITIALIZING string = "INITIALIZING"

	// GetSnapshotResponseDTOStatusCREATING captures enum value "CREATING"
	GetSnapshotResponseDTOStatusCREATING string = "CREATING"

	// GetSnapshotResponseDTOStatusPENDINGUPLOAD captures enum value "PENDING_UPLOAD"
	GetSnapshotResponseDTOStatusPENDINGUPLOAD string = "PENDING_UPLOAD"

	// GetSnapshotResponseDTOStatusUPLOADING captures enum value "UPLOADING"
	GetSnapshotResponseDTOStatusUPLOADING string = "UPLOADING"

	// GetSnapshotResponseDTOStatusPENDINGPROCESSING captures enum value "PENDING_PROCESSING"
	GetSnapshotResponseDTOStatusPENDINGPROCESSING string = "PENDING_PROCESSING"

	// GetSnapshotResponseDTOStatusPROCESSING captures enum value "PROCESSING"
	GetSnapshotResponseDTOStatusPROCESSING string = "PROCESSING"

	// GetSnapshotResponseDTOStatusFINISHED captures enum value "FINISHED"
	GetSnapshotResponseDTOStatusFINISHED string = "FINISHED"

	// GetSnapshotResponseDTOStatusCANCELED captures enum value "CANCELED"
	GetSnapshotResponseDTOStatusCANCELED string = "CANCELED"

	// GetSnapshotResponseDTOStatusERROR captures enum value "ERROR"
	GetSnapshotResponseDTOStatusERROR string = "ERROR"

	// GetSnapshotResponseDTOStatusUNKNOWN captures enum value "UNKNOWN"
	GetSnapshotResponseDTOStatusUNKNOWN string = "UNKNOWN"
)

// prop value enum
func (m *GetSnapshotResponseDTO) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, getSnapshotResponseDtoTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GetSnapshotResponseDTO) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this get snapshot response DTO based on the context it is used
func (m *GetSnapshotResponseDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateResults(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStats(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GetSnapshotResponseDTO) contextValidateResults(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Results); i++ {

		if m.Results[i] != nil {

			if swag.IsZero(m.Results[i]) { // not required
				return nil
			}

			if err := m.Results[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("results" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("results" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GetSnapshotResponseDTO) contextValidateStats(ctx context.Context, formats strfmt.Registry) error {

	if m.Stats != nil {

		if swag.IsZero(m.Stats) { // not required
			return nil
		}

		if err := m.Stats.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stats")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stats")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GetSnapshotResponseDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GetSnapshotResponseDTO) UnmarshalBinary(b []byte) error {
	var res GetSnapshotResponseDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
