// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// JSONWebKey JSONWebKey represents a public or private key in JWK format. It can be
// marshaled into JSON and unmarshaled from JSON.
//
// swagger:model JSONWebKey
type JSONWebKey struct {

	// Key algorithm, parsed from `alg` header.
	Algorithm string `json:"Algorithm,omitempty"`

	// X.509 certificate thumbprint (SHA-1), parsed from `x5t` header.
	CertificateThumbprintSHA1 []uint8 `json:"CertificateThumbprintSHA1"`

	// X.509 certificate thumbprint (SHA-256), parsed from `x5t#S256` header.
	CertificateThumbprintSHA256 []uint8 `json:"CertificateThumbprintSHA256"`

	// X.509 certificate chain, parsed from `x5c` header.
	Certificates []*Certificate `json:"Certificates"`

	// certificates URL
	CertificatesURL *URL `json:"CertificatesURL,omitempty"`

	// Key is the Go in-memory representation of this key. It must have one
	// of these types:
	// ed25519.PublicKey
	// ed25519.PrivateKey
	// ecdsa.PublicKey
	// ecdsa.PrivateKey
	// rsa.PublicKey
	// rsa.PrivateKey
	// []byte (a symmetric key)
	//
	// When marshaling this JSONWebKey into JSON, the "kty" header parameter
	// will be automatically set based on the type of this field.
	Key interface{} `json:"Key,omitempty"`

	// Key identifier, parsed from `kid` header.
	KeyID string `json:"KeyID,omitempty"`

	// Key use, parsed from `use` header.
	Use string `json:"Use,omitempty"`
}

// Validate validates this JSON web key
func (m *JSONWebKey) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCertificates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificatesURL(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *JSONWebKey) validateCertificates(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificates) { // not required
		return nil
	}

	for i := 0; i < len(m.Certificates); i++ {
		if swag.IsZero(m.Certificates[i]) { // not required
			continue
		}

		if m.Certificates[i] != nil {
			if err := m.Certificates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Certificates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Certificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *JSONWebKey) validateCertificatesURL(formats strfmt.Registry) error {
	if swag.IsZero(m.CertificatesURL) { // not required
		return nil
	}

	if m.CertificatesURL != nil {
		if err := m.CertificatesURL.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("CertificatesURL")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("CertificatesURL")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this JSON web key based on the context it is used
func (m *JSONWebKey) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCertificates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificatesURL(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *JSONWebKey) contextValidateCertificates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Certificates); i++ {

		if m.Certificates[i] != nil {

			if swag.IsZero(m.Certificates[i]) { // not required
				return nil
			}

			if err := m.Certificates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Certificates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Certificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *JSONWebKey) contextValidateCertificatesURL(ctx context.Context, formats strfmt.Registry) error {

	if m.CertificatesURL != nil {

		if swag.IsZero(m.CertificatesURL) { // not required
			return nil
		}

		if err := m.CertificatesURL.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("CertificatesURL")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("CertificatesURL")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *JSONWebKey) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *JSONWebKey) UnmarshalBinary(b []byte) error {
	var res JSONWebKey
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
