// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SnapshotDTO Base snapshot without results
//
// swagger:model SnapshotDTO
type SnapshotDTO struct {

	// created
	// Format: date-time
	Created strfmt.DateTime `json:"created,omitempty"`

	// finished
	// Format: date-time
	Finished strfmt.DateTime `json:"finished,omitempty"`

	// session Uid
	SessionUID string `json:"sessionUid,omitempty"`

	// status
	// Enum: [INITIALIZING CREATING PENDING_UPLOAD UPLOADING PENDING_PROCESSING PROCESSING FINISHED CANCELED ERROR UNKNOWN]
	Status string `json:"status,omitempty"`

	// uid
	UID string `json:"uid,omitempty"`
}

// Validate validates this snapshot DTO
func (m *SnapshotDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFinished(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SnapshotDTO) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(m.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("created", "body", "date-time", m.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SnapshotDTO) validateFinished(formats strfmt.Registry) error {
	if swag.IsZero(m.Finished) { // not required
		return nil
	}

	if err := validate.FormatOf("finished", "body", "date-time", m.Finished.String(), formats); err != nil {
		return err
	}

	return nil
}

var snapshotDtoTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["INITIALIZING","CREATING","PENDING_UPLOAD","UPLOADING","PENDING_PROCESSING","PROCESSING","FINISHED","CANCELED","ERROR","UNKNOWN"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snapshotDtoTypeStatusPropEnum = append(snapshotDtoTypeStatusPropEnum, v)
	}
}

const (

	// SnapshotDTOStatusINITIALIZING captures enum value "INITIALIZING"
	SnapshotDTOStatusINITIALIZING string = "INITIALIZING"

	// SnapshotDTOStatusCREATING captures enum value "CREATING"
	SnapshotDTOStatusCREATING string = "CREATING"

	// SnapshotDTOStatusPENDINGUPLOAD captures enum value "PENDING_UPLOAD"
	SnapshotDTOStatusPENDINGUPLOAD string = "PENDING_UPLOAD"

	// SnapshotDTOStatusUPLOADING captures enum value "UPLOADING"
	SnapshotDTOStatusUPLOADING string = "UPLOADING"

	// SnapshotDTOStatusPENDINGPROCESSING captures enum value "PENDING_PROCESSING"
	SnapshotDTOStatusPENDINGPROCESSING string = "PENDING_PROCESSING"

	// SnapshotDTOStatusPROCESSING captures enum value "PROCESSING"
	SnapshotDTOStatusPROCESSING string = "PROCESSING"

	// SnapshotDTOStatusFINISHED captures enum value "FINISHED"
	SnapshotDTOStatusFINISHED string = "FINISHED"

	// SnapshotDTOStatusCANCELED captures enum value "CANCELED"
	SnapshotDTOStatusCANCELED string = "CANCELED"

	// SnapshotDTOStatusERROR captures enum value "ERROR"
	SnapshotDTOStatusERROR string = "ERROR"

	// SnapshotDTOStatusUNKNOWN captures enum value "UNKNOWN"
	SnapshotDTOStatusUNKNOWN string = "UNKNOWN"
)

// prop value enum
func (m *SnapshotDTO) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snapshotDtoTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SnapshotDTO) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this snapshot DTO based on context it is used
func (m *SnapshotDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SnapshotDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SnapshotDTO) UnmarshalBinary(b []byte) error {
	var res SnapshotDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
