// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ListTeamRolesReader is a Reader for the ListTeamRoles structure.
type ListTeamRolesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListTeamRolesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListTeamRolesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewListTeamRolesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListTeamRolesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListTeamRolesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /access-control/teams/{teamId}/roles] listTeamRoles", response, response.Code())
	}
}

// NewListTeamRolesOK creates a ListTeamRolesOK with default headers values
func NewListTeamRolesOK() *ListTeamRolesOK {
	return &ListTeamRolesOK{}
}

/*
ListTeamRolesOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type ListTeamRolesOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this list team roles Ok response has a 2xx status code
func (o *ListTeamRolesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list team roles Ok response has a 3xx status code
func (o *ListTeamRolesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list team roles Ok response has a 4xx status code
func (o *ListTeamRolesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list team roles Ok response has a 5xx status code
func (o *ListTeamRolesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list team roles Ok response a status code equal to that given
func (o *ListTeamRolesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list team roles Ok response
func (o *ListTeamRolesOK) Code() int {
	return 200
}

func (o *ListTeamRolesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/teams/{teamId}/roles][%d] listTeamRolesOk %s", 200, payload)
}

func (o *ListTeamRolesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/teams/{teamId}/roles][%d] listTeamRolesOk %s", 200, payload)
}

func (o *ListTeamRolesOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *ListTeamRolesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTeamRolesBadRequest creates a ListTeamRolesBadRequest with default headers values
func NewListTeamRolesBadRequest() *ListTeamRolesBadRequest {
	return &ListTeamRolesBadRequest{}
}

/*
ListTeamRolesBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type ListTeamRolesBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list team roles bad request response has a 2xx status code
func (o *ListTeamRolesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list team roles bad request response has a 3xx status code
func (o *ListTeamRolesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list team roles bad request response has a 4xx status code
func (o *ListTeamRolesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this list team roles bad request response has a 5xx status code
func (o *ListTeamRolesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this list team roles bad request response a status code equal to that given
func (o *ListTeamRolesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the list team roles bad request response
func (o *ListTeamRolesBadRequest) Code() int {
	return 400
}

func (o *ListTeamRolesBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/teams/{teamId}/roles][%d] listTeamRolesBadRequest %s", 400, payload)
}

func (o *ListTeamRolesBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/teams/{teamId}/roles][%d] listTeamRolesBadRequest %s", 400, payload)
}

func (o *ListTeamRolesBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTeamRolesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTeamRolesForbidden creates a ListTeamRolesForbidden with default headers values
func NewListTeamRolesForbidden() *ListTeamRolesForbidden {
	return &ListTeamRolesForbidden{}
}

/*
ListTeamRolesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type ListTeamRolesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list team roles forbidden response has a 2xx status code
func (o *ListTeamRolesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list team roles forbidden response has a 3xx status code
func (o *ListTeamRolesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list team roles forbidden response has a 4xx status code
func (o *ListTeamRolesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this list team roles forbidden response has a 5xx status code
func (o *ListTeamRolesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this list team roles forbidden response a status code equal to that given
func (o *ListTeamRolesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the list team roles forbidden response
func (o *ListTeamRolesForbidden) Code() int {
	return 403
}

func (o *ListTeamRolesForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/teams/{teamId}/roles][%d] listTeamRolesForbidden %s", 403, payload)
}

func (o *ListTeamRolesForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/teams/{teamId}/roles][%d] listTeamRolesForbidden %s", 403, payload)
}

func (o *ListTeamRolesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTeamRolesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTeamRolesInternalServerError creates a ListTeamRolesInternalServerError with default headers values
func NewListTeamRolesInternalServerError() *ListTeamRolesInternalServerError {
	return &ListTeamRolesInternalServerError{}
}

/*
ListTeamRolesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type ListTeamRolesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list team roles internal server error response has a 2xx status code
func (o *ListTeamRolesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list team roles internal server error response has a 3xx status code
func (o *ListTeamRolesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list team roles internal server error response has a 4xx status code
func (o *ListTeamRolesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this list team roles internal server error response has a 5xx status code
func (o *ListTeamRolesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this list team roles internal server error response a status code equal to that given
func (o *ListTeamRolesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the list team roles internal server error response
func (o *ListTeamRolesInternalServerError) Code() int {
	return 500
}

func (o *ListTeamRolesInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/teams/{teamId}/roles][%d] listTeamRolesInternalServerError %s", 500, payload)
}

func (o *ListTeamRolesInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/teams/{teamId}/roles][%d] listTeamRolesInternalServerError %s", 500, payload)
}

func (o *ListTeamRolesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListTeamRolesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
