// Code generated by go-swagger; DO NOT EDIT.

package admin_ldap

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new admin ldap API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for admin ldap API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetLDAPStatus(opts ...ClientOption) (*GetLDAPStatusOK, error)
	GetLDAPStatusWithParams(params *GetLDAPStatusParams, opts ...ClientOption) (*GetLDAPStatusOK, error)

	GetUserFromLDAP(userName string, opts ...ClientOption) (*GetUserFromLDAPOK, error)
	GetUserFromLDAPWithParams(params *GetUserFromLDAPParams, opts ...ClientOption) (*GetUserFromLDAPOK, error)

	PostSyncUserWithLDAP(userID int64, opts ...ClientOption) (*PostSyncUserWithLDAPOK, error)
	PostSyncUserWithLDAPWithParams(params *PostSyncUserWithLDAPParams, opts ...ClientOption) (*PostSyncUserWithLDAPOK, error)

	ReloadLDAPCfg(opts ...ClientOption) (*ReloadLDAPCfgOK, error)
	ReloadLDAPCfgWithParams(params *ReloadLDAPCfgParams, opts ...ClientOption) (*ReloadLDAPCfgOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetLDAPStatus attempts to connect to all the configured LDAP servers and returns information on whenever they re available or not

If you are running Grafana Enterprise and have Fine-grained access control enabled, you need to have a permission with action `ldap.status:read`.
*/
func (a *Client) GetLDAPStatus(opts ...ClientOption) (*GetLDAPStatusOK, error) {
	params := NewGetLDAPStatusParams()
	return a.GetLDAPStatusWithParams(params, opts...)
}

func (a *Client) GetLDAPStatusWithParams(params *GetLDAPStatusParams, opts ...ClientOption) (*GetLDAPStatusOK, error) {
	if params == nil {
		params = NewGetLDAPStatusParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getLDAPStatus",
		Method:             "GET",
		PathPattern:        "/admin/ldap/status",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetLDAPStatusReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetLDAPStatusOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getLDAPStatus: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetUserFromLDAP finds an user based on a username in LDAP this helps illustrate how would the particular user be mapped in grafana when synced

If you are running Grafana Enterprise and have Fine-grained access control enabled, you need to have a permission with action `ldap.user:read`.
*/
func (a *Client) GetUserFromLDAP(userName string, opts ...ClientOption) (*GetUserFromLDAPOK, error) {
	params := NewGetUserFromLDAPParams().WithUserName(userName)
	return a.GetUserFromLDAPWithParams(params, opts...)
}

func (a *Client) GetUserFromLDAPWithParams(params *GetUserFromLDAPParams, opts ...ClientOption) (*GetUserFromLDAPOK, error) {
	if params == nil {
		params = NewGetUserFromLDAPParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getUserFromLDAP",
		Method:             "GET",
		PathPattern:        "/admin/ldap/{user_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetUserFromLDAPReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUserFromLDAPOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getUserFromLDAP: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PostSyncUserWithLDAP enables a single grafana user to be synchronized against LDAP

If you are running Grafana Enterprise and have Fine-grained access control enabled, you need to have a permission with action `ldap.user:sync`.
*/
func (a *Client) PostSyncUserWithLDAP(userID int64, opts ...ClientOption) (*PostSyncUserWithLDAPOK, error) {
	params := NewPostSyncUserWithLDAPParams().WithUserID(userID)
	return a.PostSyncUserWithLDAPWithParams(params, opts...)
}

func (a *Client) PostSyncUserWithLDAPWithParams(params *PostSyncUserWithLDAPParams, opts ...ClientOption) (*PostSyncUserWithLDAPOK, error) {
	if params == nil {
		params = NewPostSyncUserWithLDAPParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "postSyncUserWithLDAP",
		Method:             "POST",
		PathPattern:        "/admin/ldap/sync/{user_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PostSyncUserWithLDAPReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PostSyncUserWithLDAPOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for postSyncUserWithLDAP: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ReloadLDAPCfg reloads the LDAP configuration

If you are running Grafana Enterprise and have Fine-grained access control enabled, you need to have a permission with action `ldap.config:reload`.
*/
func (a *Client) ReloadLDAPCfg(opts ...ClientOption) (*ReloadLDAPCfgOK, error) {
	params := NewReloadLDAPCfgParams()
	return a.ReloadLDAPCfgWithParams(params, opts...)
}

func (a *Client) ReloadLDAPCfgWithParams(params *ReloadLDAPCfgParams, opts ...ClientOption) (*ReloadLDAPCfgOK, error) {
	if params == nil {
		params = NewReloadLDAPCfgParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "reloadLDAPCfg",
		Method:             "POST",
		PathPattern:        "/admin/ldap/reload",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ReloadLDAPCfgReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ReloadLDAPCfgOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for reloadLDAPCfg: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
