// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewUpdateDataSourceByIDParams creates a new UpdateDataSourceByIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateDataSourceByIDParams() *UpdateDataSourceByIDParams {
	return &UpdateDataSourceByIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateDataSourceByIDParamsWithTimeout creates a new UpdateDataSourceByIDParams object
// with the ability to set a timeout on a request.
func NewUpdateDataSourceByIDParamsWithTimeout(timeout time.Duration) *UpdateDataSourceByIDParams {
	return &UpdateDataSourceByIDParams{
		timeout: timeout,
	}
}

// NewUpdateDataSourceByIDParamsWithContext creates a new UpdateDataSourceByIDParams object
// with the ability to set a context for a request.
func NewUpdateDataSourceByIDParamsWithContext(ctx context.Context) *UpdateDataSourceByIDParams {
	return &UpdateDataSourceByIDParams{
		Context: ctx,
	}
}

// NewUpdateDataSourceByIDParamsWithHTTPClient creates a new UpdateDataSourceByIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateDataSourceByIDParamsWithHTTPClient(client *http.Client) *UpdateDataSourceByIDParams {
	return &UpdateDataSourceByIDParams{
		HTTPClient: client,
	}
}

/*
UpdateDataSourceByIDParams contains all the parameters to send to the API endpoint

	for the update data source by ID operation.

	Typically these are written to a http.Request.
*/
type UpdateDataSourceByIDParams struct {

	// Body.
	Body *models.UpdateDataSourceCommand

	// ID.
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update data source by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateDataSourceByIDParams) WithDefaults() *UpdateDataSourceByIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update data source by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateDataSourceByIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update data source by ID params
func (o *UpdateDataSourceByIDParams) WithTimeout(timeout time.Duration) *UpdateDataSourceByIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update data source by ID params
func (o *UpdateDataSourceByIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update data source by ID params
func (o *UpdateDataSourceByIDParams) WithContext(ctx context.Context) *UpdateDataSourceByIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update data source by ID params
func (o *UpdateDataSourceByIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update data source by ID params
func (o *UpdateDataSourceByIDParams) WithHTTPClient(client *http.Client) *UpdateDataSourceByIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update data source by ID params
func (o *UpdateDataSourceByIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update data source by ID params
func (o *UpdateDataSourceByIDParams) WithBody(body *models.UpdateDataSourceCommand) *UpdateDataSourceByIDParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update data source by ID params
func (o *UpdateDataSourceByIDParams) SetBody(body *models.UpdateDataSourceCommand) {
	o.Body = body
}

// WithID adds the id to the update data source by ID params
func (o *UpdateDataSourceByIDParams) WithID(id string) *UpdateDataSourceByIDParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the update data source by ID params
func (o *UpdateDataSourceByIDParams) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateDataSourceByIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
