// Code generated by go-swagger; DO NOT EDIT.

package enterprise

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetDataSourceCacheConfigReader is a Reader for the GetDataSourceCacheConfig structure.
type GetDataSourceCacheConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDataSourceCacheConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDataSourceCacheConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewGetDataSourceCacheConfigInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /datasources/{dataSourceUID}/cache] getDataSourceCacheConfig", response, response.Code())
	}
}

// NewGetDataSourceCacheConfigOK creates a GetDataSourceCacheConfigOK with default headers values
func NewGetDataSourceCacheConfigOK() *GetDataSourceCacheConfigOK {
	return &GetDataSourceCacheConfigOK{}
}

/*
GetDataSourceCacheConfigOK describes a response with status code 200, with default header values.

CacheConfigResponse
*/
type GetDataSourceCacheConfigOK struct {
	Payload *models.CacheConfigResponse
}

// IsSuccess returns true when this get data source cache config Ok response has a 2xx status code
func (o *GetDataSourceCacheConfigOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get data source cache config Ok response has a 3xx status code
func (o *GetDataSourceCacheConfigOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source cache config Ok response has a 4xx status code
func (o *GetDataSourceCacheConfigOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get data source cache config Ok response has a 5xx status code
func (o *GetDataSourceCacheConfigOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source cache config Ok response a status code equal to that given
func (o *GetDataSourceCacheConfigOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get data source cache config Ok response
func (o *GetDataSourceCacheConfigOK) Code() int {
	return 200
}

func (o *GetDataSourceCacheConfigOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{dataSourceUID}/cache][%d] getDataSourceCacheConfigOk %s", 200, payload)
}

func (o *GetDataSourceCacheConfigOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{dataSourceUID}/cache][%d] getDataSourceCacheConfigOk %s", 200, payload)
}

func (o *GetDataSourceCacheConfigOK) GetPayload() *models.CacheConfigResponse {
	return o.Payload
}

func (o *GetDataSourceCacheConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CacheConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceCacheConfigInternalServerError creates a GetDataSourceCacheConfigInternalServerError with default headers values
func NewGetDataSourceCacheConfigInternalServerError() *GetDataSourceCacheConfigInternalServerError {
	return &GetDataSourceCacheConfigInternalServerError{}
}

/*
GetDataSourceCacheConfigInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetDataSourceCacheConfigInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source cache config internal server error response has a 2xx status code
func (o *GetDataSourceCacheConfigInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source cache config internal server error response has a 3xx status code
func (o *GetDataSourceCacheConfigInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source cache config internal server error response has a 4xx status code
func (o *GetDataSourceCacheConfigInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get data source cache config internal server error response has a 5xx status code
func (o *GetDataSourceCacheConfigInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get data source cache config internal server error response a status code equal to that given
func (o *GetDataSourceCacheConfigInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get data source cache config internal server error response
func (o *GetDataSourceCacheConfigInternalServerError) Code() int {
	return 500
}

func (o *GetDataSourceCacheConfigInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{dataSourceUID}/cache][%d] getDataSourceCacheConfigInternalServerError %s", 500, payload)
}

func (o *GetDataSourceCacheConfigInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{dataSourceUID}/cache][%d] getDataSourceCacheConfigInternalServerError %s", 500, payload)
}

func (o *GetDataSourceCacheConfigInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceCacheConfigInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
