// Code generated by go-swagger; DO NOT EDIT.

package library_elements

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateLibraryElementReader is a Reader for the CreateLibraryElement structure.
type CreateLibraryElementReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateLibraryElementReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateLibraryElementOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateLibraryElementBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewCreateLibraryElementUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateLibraryElementForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCreateLibraryElementNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateLibraryElementInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /library-elements] createLibraryElement", response, response.Code())
	}
}

// NewCreateLibraryElementOK creates a CreateLibraryElementOK with default headers values
func NewCreateLibraryElementOK() *CreateLibraryElementOK {
	return &CreateLibraryElementOK{}
}

/*
CreateLibraryElementOK describes a response with status code 200, with default header values.

(empty)
*/
type CreateLibraryElementOK struct {
	Payload *models.LibraryElementResponse
}

// IsSuccess returns true when this create library element Ok response has a 2xx status code
func (o *CreateLibraryElementOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create library element Ok response has a 3xx status code
func (o *CreateLibraryElementOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create library element Ok response has a 4xx status code
func (o *CreateLibraryElementOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create library element Ok response has a 5xx status code
func (o *CreateLibraryElementOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create library element Ok response a status code equal to that given
func (o *CreateLibraryElementOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create library element Ok response
func (o *CreateLibraryElementOK) Code() int {
	return 200
}

func (o *CreateLibraryElementOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementOk %s", 200, payload)
}

func (o *CreateLibraryElementOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementOk %s", 200, payload)
}

func (o *CreateLibraryElementOK) GetPayload() *models.LibraryElementResponse {
	return o.Payload
}

func (o *CreateLibraryElementOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LibraryElementResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateLibraryElementBadRequest creates a CreateLibraryElementBadRequest with default headers values
func NewCreateLibraryElementBadRequest() *CreateLibraryElementBadRequest {
	return &CreateLibraryElementBadRequest{}
}

/*
CreateLibraryElementBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type CreateLibraryElementBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create library element bad request response has a 2xx status code
func (o *CreateLibraryElementBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create library element bad request response has a 3xx status code
func (o *CreateLibraryElementBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create library element bad request response has a 4xx status code
func (o *CreateLibraryElementBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create library element bad request response has a 5xx status code
func (o *CreateLibraryElementBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create library element bad request response a status code equal to that given
func (o *CreateLibraryElementBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create library element bad request response
func (o *CreateLibraryElementBadRequest) Code() int {
	return 400
}

func (o *CreateLibraryElementBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementBadRequest %s", 400, payload)
}

func (o *CreateLibraryElementBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementBadRequest %s", 400, payload)
}

func (o *CreateLibraryElementBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateLibraryElementBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateLibraryElementUnauthorized creates a CreateLibraryElementUnauthorized with default headers values
func NewCreateLibraryElementUnauthorized() *CreateLibraryElementUnauthorized {
	return &CreateLibraryElementUnauthorized{}
}

/*
CreateLibraryElementUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateLibraryElementUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create library element unauthorized response has a 2xx status code
func (o *CreateLibraryElementUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create library element unauthorized response has a 3xx status code
func (o *CreateLibraryElementUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create library element unauthorized response has a 4xx status code
func (o *CreateLibraryElementUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create library element unauthorized response has a 5xx status code
func (o *CreateLibraryElementUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create library element unauthorized response a status code equal to that given
func (o *CreateLibraryElementUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create library element unauthorized response
func (o *CreateLibraryElementUnauthorized) Code() int {
	return 401
}

func (o *CreateLibraryElementUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementUnauthorized %s", 401, payload)
}

func (o *CreateLibraryElementUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementUnauthorized %s", 401, payload)
}

func (o *CreateLibraryElementUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateLibraryElementUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateLibraryElementForbidden creates a CreateLibraryElementForbidden with default headers values
func NewCreateLibraryElementForbidden() *CreateLibraryElementForbidden {
	return &CreateLibraryElementForbidden{}
}

/*
CreateLibraryElementForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateLibraryElementForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create library element forbidden response has a 2xx status code
func (o *CreateLibraryElementForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create library element forbidden response has a 3xx status code
func (o *CreateLibraryElementForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create library element forbidden response has a 4xx status code
func (o *CreateLibraryElementForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create library element forbidden response has a 5xx status code
func (o *CreateLibraryElementForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create library element forbidden response a status code equal to that given
func (o *CreateLibraryElementForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create library element forbidden response
func (o *CreateLibraryElementForbidden) Code() int {
	return 403
}

func (o *CreateLibraryElementForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementForbidden %s", 403, payload)
}

func (o *CreateLibraryElementForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementForbidden %s", 403, payload)
}

func (o *CreateLibraryElementForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateLibraryElementForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateLibraryElementNotFound creates a CreateLibraryElementNotFound with default headers values
func NewCreateLibraryElementNotFound() *CreateLibraryElementNotFound {
	return &CreateLibraryElementNotFound{}
}

/*
CreateLibraryElementNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type CreateLibraryElementNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create library element not found response has a 2xx status code
func (o *CreateLibraryElementNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create library element not found response has a 3xx status code
func (o *CreateLibraryElementNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create library element not found response has a 4xx status code
func (o *CreateLibraryElementNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this create library element not found response has a 5xx status code
func (o *CreateLibraryElementNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this create library element not found response a status code equal to that given
func (o *CreateLibraryElementNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the create library element not found response
func (o *CreateLibraryElementNotFound) Code() int {
	return 404
}

func (o *CreateLibraryElementNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementNotFound %s", 404, payload)
}

func (o *CreateLibraryElementNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementNotFound %s", 404, payload)
}

func (o *CreateLibraryElementNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateLibraryElementNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateLibraryElementInternalServerError creates a CreateLibraryElementInternalServerError with default headers values
func NewCreateLibraryElementInternalServerError() *CreateLibraryElementInternalServerError {
	return &CreateLibraryElementInternalServerError{}
}

/*
CreateLibraryElementInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateLibraryElementInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create library element internal server error response has a 2xx status code
func (o *CreateLibraryElementInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create library element internal server error response has a 3xx status code
func (o *CreateLibraryElementInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create library element internal server error response has a 4xx status code
func (o *CreateLibraryElementInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create library element internal server error response has a 5xx status code
func (o *CreateLibraryElementInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create library element internal server error response a status code equal to that given
func (o *CreateLibraryElementInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create library element internal server error response
func (o *CreateLibraryElementInternalServerError) Code() int {
	return 500
}

func (o *CreateLibraryElementInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementInternalServerError %s", 500, payload)
}

func (o *CreateLibraryElementInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /library-elements][%d] createLibraryElementInternalServerError %s", 500, payload)
}

func (o *CreateLibraryElementInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateLibraryElementInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
