// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetSnapshotReader is a Reader for the GetSnapshot structure.
type GetSnapshotReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSnapshotReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetSnapshotOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetSnapshotBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetSnapshotUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetSnapshotForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetSnapshotInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}] getSnapshot", response, response.Code())
	}
}

// NewGetSnapshotOK creates a GetSnapshotOK with default headers values
func NewGetSnapshotOK() *GetSnapshotOK {
	return &GetSnapshotOK{}
}

/*
GetSnapshotOK describes a response with status code 200, with default header values.

(empty)
*/
type GetSnapshotOK struct {
	Payload *models.GetSnapshotResponseDTO
}

// IsSuccess returns true when this get snapshot Ok response has a 2xx status code
func (o *GetSnapshotOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get snapshot Ok response has a 3xx status code
func (o *GetSnapshotOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get snapshot Ok response has a 4xx status code
func (o *GetSnapshotOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get snapshot Ok response has a 5xx status code
func (o *GetSnapshotOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get snapshot Ok response a status code equal to that given
func (o *GetSnapshotOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get snapshot Ok response
func (o *GetSnapshotOK) Code() int {
	return 200
}

func (o *GetSnapshotOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotOk %s", 200, payload)
}

func (o *GetSnapshotOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotOk %s", 200, payload)
}

func (o *GetSnapshotOK) GetPayload() *models.GetSnapshotResponseDTO {
	return o.Payload
}

func (o *GetSnapshotOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GetSnapshotResponseDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSnapshotBadRequest creates a GetSnapshotBadRequest with default headers values
func NewGetSnapshotBadRequest() *GetSnapshotBadRequest {
	return &GetSnapshotBadRequest{}
}

/*
GetSnapshotBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetSnapshotBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get snapshot bad request response has a 2xx status code
func (o *GetSnapshotBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get snapshot bad request response has a 3xx status code
func (o *GetSnapshotBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get snapshot bad request response has a 4xx status code
func (o *GetSnapshotBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get snapshot bad request response has a 5xx status code
func (o *GetSnapshotBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get snapshot bad request response a status code equal to that given
func (o *GetSnapshotBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get snapshot bad request response
func (o *GetSnapshotBadRequest) Code() int {
	return 400
}

func (o *GetSnapshotBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotBadRequest %s", 400, payload)
}

func (o *GetSnapshotBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotBadRequest %s", 400, payload)
}

func (o *GetSnapshotBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSnapshotBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSnapshotUnauthorized creates a GetSnapshotUnauthorized with default headers values
func NewGetSnapshotUnauthorized() *GetSnapshotUnauthorized {
	return &GetSnapshotUnauthorized{}
}

/*
GetSnapshotUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetSnapshotUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get snapshot unauthorized response has a 2xx status code
func (o *GetSnapshotUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get snapshot unauthorized response has a 3xx status code
func (o *GetSnapshotUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get snapshot unauthorized response has a 4xx status code
func (o *GetSnapshotUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get snapshot unauthorized response has a 5xx status code
func (o *GetSnapshotUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get snapshot unauthorized response a status code equal to that given
func (o *GetSnapshotUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get snapshot unauthorized response
func (o *GetSnapshotUnauthorized) Code() int {
	return 401
}

func (o *GetSnapshotUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotUnauthorized %s", 401, payload)
}

func (o *GetSnapshotUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotUnauthorized %s", 401, payload)
}

func (o *GetSnapshotUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSnapshotUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSnapshotForbidden creates a GetSnapshotForbidden with default headers values
func NewGetSnapshotForbidden() *GetSnapshotForbidden {
	return &GetSnapshotForbidden{}
}

/*
GetSnapshotForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetSnapshotForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get snapshot forbidden response has a 2xx status code
func (o *GetSnapshotForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get snapshot forbidden response has a 3xx status code
func (o *GetSnapshotForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get snapshot forbidden response has a 4xx status code
func (o *GetSnapshotForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get snapshot forbidden response has a 5xx status code
func (o *GetSnapshotForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get snapshot forbidden response a status code equal to that given
func (o *GetSnapshotForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get snapshot forbidden response
func (o *GetSnapshotForbidden) Code() int {
	return 403
}

func (o *GetSnapshotForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotForbidden %s", 403, payload)
}

func (o *GetSnapshotForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotForbidden %s", 403, payload)
}

func (o *GetSnapshotForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSnapshotForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSnapshotInternalServerError creates a GetSnapshotInternalServerError with default headers values
func NewGetSnapshotInternalServerError() *GetSnapshotInternalServerError {
	return &GetSnapshotInternalServerError{}
}

/*
GetSnapshotInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetSnapshotInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get snapshot internal server error response has a 2xx status code
func (o *GetSnapshotInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get snapshot internal server error response has a 3xx status code
func (o *GetSnapshotInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get snapshot internal server error response has a 4xx status code
func (o *GetSnapshotInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get snapshot internal server error response has a 5xx status code
func (o *GetSnapshotInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get snapshot internal server error response a status code equal to that given
func (o *GetSnapshotInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get snapshot internal server error response
func (o *GetSnapshotInternalServerError) Code() int {
	return 500
}

func (o *GetSnapshotInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotInternalServerError %s", 500, payload)
}

func (o *GetSnapshotInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshot/{snapshotUid}][%d] getSnapshotInternalServerError %s", 500, payload)
}

func (o *GetSnapshotInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSnapshotInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
