// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ExportMuteTimingReader is a Reader for the ExportMuteTiming structure.
type ExportMuteTimingReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ExportMuteTimingReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewExportMuteTimingOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewExportMuteTimingForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /v1/provisioning/mute-timings/{name}/export] ExportMuteTiming", response, response.Code())
	}
}

// NewExportMuteTimingOK creates a ExportMuteTimingOK with default headers values
func NewExportMuteTimingOK() *ExportMuteTimingOK {
	return &ExportMuteTimingOK{}
}

/*
ExportMuteTimingOK describes a response with status code 200, with default header values.

AlertingFileExport
*/
type ExportMuteTimingOK struct {
	Payload *models.AlertingFileExport
}

// IsSuccess returns true when this export mute timing Ok response has a 2xx status code
func (o *ExportMuteTimingOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this export mute timing Ok response has a 3xx status code
func (o *ExportMuteTimingOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this export mute timing Ok response has a 4xx status code
func (o *ExportMuteTimingOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this export mute timing Ok response has a 5xx status code
func (o *ExportMuteTimingOK) IsServerError() bool {
	return false
}

// IsCode returns true when this export mute timing Ok response a status code equal to that given
func (o *ExportMuteTimingOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the export mute timing Ok response
func (o *ExportMuteTimingOK) Code() int {
	return 200
}

func (o *ExportMuteTimingOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/provisioning/mute-timings/{name}/export][%d] exportMuteTimingOk %s", 200, payload)
}

func (o *ExportMuteTimingOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/provisioning/mute-timings/{name}/export][%d] exportMuteTimingOk %s", 200, payload)
}

func (o *ExportMuteTimingOK) GetPayload() *models.AlertingFileExport {
	return o.Payload
}

func (o *ExportMuteTimingOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AlertingFileExport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewExportMuteTimingForbidden creates a ExportMuteTimingForbidden with default headers values
func NewExportMuteTimingForbidden() *ExportMuteTimingForbidden {
	return &ExportMuteTimingForbidden{}
}

/*
ExportMuteTimingForbidden describes a response with status code 403, with default header values.

PermissionDenied
*/
type ExportMuteTimingForbidden struct {
	Payload models.PermissionDenied
}

// IsSuccess returns true when this export mute timing forbidden response has a 2xx status code
func (o *ExportMuteTimingForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this export mute timing forbidden response has a 3xx status code
func (o *ExportMuteTimingForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this export mute timing forbidden response has a 4xx status code
func (o *ExportMuteTimingForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this export mute timing forbidden response has a 5xx status code
func (o *ExportMuteTimingForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this export mute timing forbidden response a status code equal to that given
func (o *ExportMuteTimingForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the export mute timing forbidden response
func (o *ExportMuteTimingForbidden) Code() int {
	return 403
}

func (o *ExportMuteTimingForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/provisioning/mute-timings/{name}/export][%d] exportMuteTimingForbidden %s", 403, payload)
}

func (o *ExportMuteTimingForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/provisioning/mute-timings/{name}/export][%d] exportMuteTimingForbidden %s", 403, payload)
}

func (o *ExportMuteTimingForbidden) GetPayload() models.PermissionDenied {
	return o.Payload
}

func (o *ExportMuteTimingForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
