// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListLogPatternsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`

	// The name of the log pattern set.
	PatternSetName *string `min:"1" type:"string"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLogPatternsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLogPatternsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListLogPatternsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PatternSetName != nil && len(*s.PatternSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PatternSetName", 1))
	}

	if s.ResourceGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListLogPatternsOutput struct {
	_ struct{} `type:"structure"`

	// The list of log patterns.
	LogPatterns []LogPattern `type:"list"`

	// The token used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `type:"string"`

	// The name of the resource group.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListLogPatternsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLogPatterns = "ListLogPatterns"

// ListLogPatternsRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Lists the log patterns in the specific log LogPatternSet.
//
//    // Example sending a request using ListLogPatternsRequest.
//    req := client.ListLogPatternsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListLogPatterns
func (c *Client) ListLogPatternsRequest(input *ListLogPatternsInput) ListLogPatternsRequest {
	op := &aws.Operation{
		Name:       opListLogPatterns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLogPatternsInput{}
	}

	req := c.newRequest(op, input, &ListLogPatternsOutput{})
	return ListLogPatternsRequest{Request: req, Input: input, Copy: c.ListLogPatternsRequest}
}

// ListLogPatternsRequest is the request type for the
// ListLogPatterns API operation.
type ListLogPatternsRequest struct {
	*aws.Request
	Input *ListLogPatternsInput
	Copy  func(*ListLogPatternsInput) ListLogPatternsRequest
}

// Send marshals and sends the ListLogPatterns API request.
func (r ListLogPatternsRequest) Send(ctx context.Context) (*ListLogPatternsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLogPatternsResponse{
		ListLogPatternsOutput: r.Request.Data.(*ListLogPatternsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListLogPatternsRequestPaginator returns a paginator for ListLogPatterns.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListLogPatternsRequest(input)
//   p := applicationinsights.NewListLogPatternsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListLogPatternsPaginator(req ListLogPatternsRequest) ListLogPatternsPaginator {
	return ListLogPatternsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListLogPatternsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListLogPatternsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListLogPatternsPaginator struct {
	aws.Pager
}

func (p *ListLogPatternsPaginator) CurrentPage() *ListLogPatternsOutput {
	return p.Pager.CurrentPage().(*ListLogPatternsOutput)
}

// ListLogPatternsResponse is the response type for the
// ListLogPatterns API operation.
type ListLogPatternsResponse struct {
	*ListLogPatternsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLogPatterns request.
func (r *ListLogPatternsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
