// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package athenaiface provides an interface to enable mocking the Amazon Athena service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package athenaiface

import (
	"github.com/aws/aws-sdk-go-v2/service/athena"
)

// ClientAPI provides an interface to enable mocking the
// athena.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Athena.
//    func myFunc(svc athenaiface.ClientAPI) bool {
//        // Make svc.BatchGetNamedQuery request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := athena.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        athenaiface.ClientPI
//    }
//    func (m *mockClientClient) BatchGetNamedQuery(input *athena.BatchGetNamedQueryInput) (*athena.BatchGetNamedQueryOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	BatchGetNamedQueryRequest(*athena.BatchGetNamedQueryInput) athena.BatchGetNamedQueryRequest

	BatchGetQueryExecutionRequest(*athena.BatchGetQueryExecutionInput) athena.BatchGetQueryExecutionRequest

	CreateNamedQueryRequest(*athena.CreateNamedQueryInput) athena.CreateNamedQueryRequest

	CreateWorkGroupRequest(*athena.CreateWorkGroupInput) athena.CreateWorkGroupRequest

	DeleteNamedQueryRequest(*athena.DeleteNamedQueryInput) athena.DeleteNamedQueryRequest

	DeleteWorkGroupRequest(*athena.DeleteWorkGroupInput) athena.DeleteWorkGroupRequest

	GetNamedQueryRequest(*athena.GetNamedQueryInput) athena.GetNamedQueryRequest

	GetQueryExecutionRequest(*athena.GetQueryExecutionInput) athena.GetQueryExecutionRequest

	GetQueryResultsRequest(*athena.GetQueryResultsInput) athena.GetQueryResultsRequest

	GetWorkGroupRequest(*athena.GetWorkGroupInput) athena.GetWorkGroupRequest

	ListNamedQueriesRequest(*athena.ListNamedQueriesInput) athena.ListNamedQueriesRequest

	ListQueryExecutionsRequest(*athena.ListQueryExecutionsInput) athena.ListQueryExecutionsRequest

	ListTagsForResourceRequest(*athena.ListTagsForResourceInput) athena.ListTagsForResourceRequest

	ListWorkGroupsRequest(*athena.ListWorkGroupsInput) athena.ListWorkGroupsRequest

	StartQueryExecutionRequest(*athena.StartQueryExecutionInput) athena.StartQueryExecutionRequest

	StopQueryExecutionRequest(*athena.StopQueryExecutionInput) athena.StopQueryExecutionRequest

	TagResourceRequest(*athena.TagResourceInput) athena.TagResourceRequest

	UntagResourceRequest(*athena.UntagResourceInput) athena.UntagResourceRequest

	UpdateWorkGroupRequest(*athena.UpdateWorkGroupInput) athena.UpdateWorkGroupRequest
}

var _ ClientAPI = (*athena.Client)(nil)
