// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTypeRegistrationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The current status of the type registration request.
	RegistrationStatusFilter RegistrationStatus `type:"string" enum:"true"`

	// The kind of type.
	//
	// Currently the only valid value is RESOURCE.
	Type RegistryType `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the type.
	//
	// Conditional: You must specify TypeName or Arn.
	TypeArn *string `type:"string"`

	// The name of the type.
	//
	// Conditional: You must specify TypeName or Arn.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation
func (s ListTypeRegistrationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTypeRegistrationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTypeRegistrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTypeRegistrationsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call this action again
	// and assign that token to the request object's NextToken parameter. If the
	// request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of type registration tokens.
	//
	// Use DescribeTypeRegistration to return detailed information about a type
	// registration request.
	RegistrationTokenList []string `type:"list"`
}

// String returns the string representation
func (s ListTypeRegistrationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTypeRegistrations = "ListTypeRegistrations"

// ListTypeRegistrationsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns a list of registration tokens for the specified type.
//
//    // Example sending a request using ListTypeRegistrationsRequest.
//    req := client.ListTypeRegistrationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations
func (c *Client) ListTypeRegistrationsRequest(input *ListTypeRegistrationsInput) ListTypeRegistrationsRequest {
	op := &aws.Operation{
		Name:       opListTypeRegistrations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTypeRegistrationsInput{}
	}

	req := c.newRequest(op, input, &ListTypeRegistrationsOutput{})
	return ListTypeRegistrationsRequest{Request: req, Input: input, Copy: c.ListTypeRegistrationsRequest}
}

// ListTypeRegistrationsRequest is the request type for the
// ListTypeRegistrations API operation.
type ListTypeRegistrationsRequest struct {
	*aws.Request
	Input *ListTypeRegistrationsInput
	Copy  func(*ListTypeRegistrationsInput) ListTypeRegistrationsRequest
}

// Send marshals and sends the ListTypeRegistrations API request.
func (r ListTypeRegistrationsRequest) Send(ctx context.Context) (*ListTypeRegistrationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTypeRegistrationsResponse{
		ListTypeRegistrationsOutput: r.Request.Data.(*ListTypeRegistrationsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTypeRegistrationsRequestPaginator returns a paginator for ListTypeRegistrations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTypeRegistrationsRequest(input)
//   p := cloudformation.NewListTypeRegistrationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTypeRegistrationsPaginator(req ListTypeRegistrationsRequest) ListTypeRegistrationsPaginator {
	return ListTypeRegistrationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTypeRegistrationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTypeRegistrationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTypeRegistrationsPaginator struct {
	aws.Pager
}

func (p *ListTypeRegistrationsPaginator) CurrentPage() *ListTypeRegistrationsOutput {
	return p.Pager.CurrentPage().(*ListTypeRegistrationsOutput)
}

// ListTypeRegistrationsResponse is the response type for the
// ListTypeRegistrations API operation.
type ListTypeRegistrationsResponse struct {
	*ListTypeRegistrationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTypeRegistrations request.
func (r *ListTypeRegistrationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
