// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type CreateGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// List of fleets that can be used to fulfill game session placement requests
	// in the queue. Fleets are identified by either a fleet ARN or a fleet alias
	// ARN. Destinations are listed in default preference order.
	Destinations []GameSessionQueueDestination `type:"list"`

	// Descriptive label that is associated with game session queue. Queue names
	// must be unique within each region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Collection of latency policies to apply when processing game sessions placement
	// requests with player latency information. Multiple policies are evaluated
	// in order of the maximum latency value, starting with the lowest latency values.
	// With just one policy, it is enforced at the start of the game session placement
	// for the duration period. With multiple policies, each policy is enforced
	// consecutively for its duration period. For example, a queue might enforce
	// a 60-second policy followed by a 120-second policy, and then no policy for
	// the remainder of the placement. A player latency policy must set a value
	// for MaximumIndividualPlayerLatencyMilliseconds; if none is set, this API
	// requests will fail.
	PlayerLatencyPolicies []PlayerLatencyPolicy `type:"list"`

	// Maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGameSessionQueueInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGameSessionQueueInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
type CreateGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created game session queue.
	GameSessionQueue *GameSessionQueue `type:"structure"`
}

// String returns the string representation
func (s CreateGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateGameSessionQueue = "CreateGameSessionQueue"

// CreateGameSessionQueueRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Establishes a new queue for processing requests to place new game sessions.
// A queue identifies where new game sessions can be hosted -- by specifying
// a list of destinations (fleets or aliases) -- and how long requests can wait
// in the queue before timing out. You can set up a queue to try to place game
// sessions on fleets in multiple regions. To add placement requests to a queue,
// call StartGameSessionPlacement and reference the queue name.
//
// Destination order. When processing a request for a game session, Amazon GameLift
// tries each destination in order until it finds one with available resources
// to host the new game session. A queue's default order is determined by how
// destinations are listed. The default order is overridden when a game session
// placement request provides player latency information. Player latency information
// enables Amazon GameLift to prioritize destinations where players report the
// lowest average latency, as a result placing the new game session where the
// majority of players will have the best possible gameplay experience.
//
// Player latency policies. For placement requests containing player latency
// information, use player latency policies to protect individual players from
// very high latencies. With a latency cap, even when a destination can deliver
// a low latency for most players, the game is not placed where any individual
// player is reporting latency higher than a policy's maximum. A queue can have
// multiple latency policies, which are enforced consecutively starting with
// the policy with the lowest latency cap. Use multiple policies to gradually
// relax latency controls; for example, you might set a policy with a low latency
// cap for the first 60 seconds, a second policy with a higher cap for the next
// 60 seconds, etc.
//
// To create a new queue, provide a name, timeout value, a list of destinations
// and, if desired, a set of latency policies. If successful, a new queue object
// is returned.
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
//    // Example sending a request using CreateGameSessionQueueRequest.
//    req := client.CreateGameSessionQueueRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue
func (c *Client) CreateGameSessionQueueRequest(input *CreateGameSessionQueueInput) CreateGameSessionQueueRequest {
	op := &aws.Operation{
		Name:       opCreateGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGameSessionQueueInput{}
	}

	req := c.newRequest(op, input, &CreateGameSessionQueueOutput{})
	return CreateGameSessionQueueRequest{Request: req, Input: input, Copy: c.CreateGameSessionQueueRequest}
}

// CreateGameSessionQueueRequest is the request type for the
// CreateGameSessionQueue API operation.
type CreateGameSessionQueueRequest struct {
	*aws.Request
	Input *CreateGameSessionQueueInput
	Copy  func(*CreateGameSessionQueueInput) CreateGameSessionQueueRequest
}

// Send marshals and sends the CreateGameSessionQueue API request.
func (r CreateGameSessionQueueRequest) Send(ctx context.Context) (*CreateGameSessionQueueResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateGameSessionQueueResponse{
		CreateGameSessionQueueOutput: r.Request.Data.(*CreateGameSessionQueueOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateGameSessionQueueResponse is the response type for the
// CreateGameSessionQueue API operation.
type CreateGameSessionQueueResponse struct {
	*CreateGameSessionQueueOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateGameSessionQueue request.
func (r *CreateGameSessionQueueResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
