// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesis

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for ListTagsForStream.
type ListTagsForStreamInput struct {
	_ struct{} `type:"structure"`

	// The key to use as the starting point for the list of tags. If this parameter
	// is set, ListTagsForStream gets all tags that occur after ExclusiveStartTagKey.
	ExclusiveStartTagKey *string `min:"1" type:"string"`

	// The number of tags to return. If this number is less than the total number
	// of tags associated with the stream, HasMoreTags is set to true. To list additional
	// tags, set ExclusiveStartTagKey to the last key in the response.
	Limit *int64 `min:"1" type:"integer"`

	// The name of the stream.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTagsForStreamInput"}
	if s.ExclusiveStartTagKey != nil && len(*s.ExclusiveStartTagKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExclusiveStartTagKey", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}

	if s.StreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output for ListTagsForStream.
type ListTagsForStreamOutput struct {
	_ struct{} `type:"structure"`

	// If set to true, more tags are available. To request additional tags, set
	// ExclusiveStartTagKey to the key of the last tag returned.
	//
	// HasMoreTags is a required field
	HasMoreTags *bool `type:"boolean" required:"true"`

	// A list of tags associated with StreamName, starting with the first tag after
	// ExclusiveStartTagKey and up to the specified Limit.
	//
	// Tags is a required field
	Tags []Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForStreamOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTagsForStream = "ListTagsForStream"

// ListTagsForStreamRequest returns a request value for making API operation for
// Amazon Kinesis.
//
// Lists the tags for the specified Kinesis data stream. This operation has
// a limit of five transactions per second per account.
//
//    // Example sending a request using ListTagsForStreamRequest.
//    req := client.ListTagsForStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStream
func (c *Client) ListTagsForStreamRequest(input *ListTagsForStreamInput) ListTagsForStreamRequest {
	op := &aws.Operation{
		Name:       opListTagsForStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForStreamInput{}
	}

	req := c.newRequest(op, input, &ListTagsForStreamOutput{})
	return ListTagsForStreamRequest{Request: req, Input: input, Copy: c.ListTagsForStreamRequest}
}

// ListTagsForStreamRequest is the request type for the
// ListTagsForStream API operation.
type ListTagsForStreamRequest struct {
	*aws.Request
	Input *ListTagsForStreamInput
	Copy  func(*ListTagsForStreamInput) ListTagsForStreamRequest
}

// Send marshals and sends the ListTagsForStream API request.
func (r ListTagsForStreamRequest) Send(ctx context.Context) (*ListTagsForStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTagsForStreamResponse{
		ListTagsForStreamOutput: r.Request.Data.(*ListTagsForStreamOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListTagsForStreamResponse is the response type for the
// ListTagsForStream API operation.
type ListTagsForStreamResponse struct {
	*ListTagsForStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTagsForStream request.
func (r *ListTagsForStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
