// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes bandwidth information.
type Bandwidth struct {
	_ struct{} `type:"structure"`

	// Download speed in Mbps.
	DownloadSpeed *int64 `type:"integer"`

	// Upload speed in Mbps.
	UploadSpeed *int64 `type:"integer"`
}

// String returns the string representation
func (s Bandwidth) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Bandwidth) MarshalFields(e protocol.FieldEncoder) error {
	if s.DownloadSpeed != nil {
		v := *s.DownloadSpeed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DownloadSpeed", protocol.Int64Value(v), metadata)
	}
	if s.UploadSpeed != nil {
		v := *s.UploadSpeed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadSpeed", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Describes the association between a customer gateway, a device, and a link.
type CustomerGatewayAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the customer gateway.
	CustomerGatewayArn *string `type:"string"`

	// The ID of the device.
	DeviceId *string `type:"string"`

	// The ID of the global network.
	GlobalNetworkId *string `type:"string"`

	// The ID of the link.
	LinkId *string `type:"string"`

	// The association state.
	State CustomerGatewayAssociationState `type:"string" enum:"true"`
}

// String returns the string representation
func (s CustomerGatewayAssociation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomerGatewayAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomerGatewayArn != nil {
		v := *s.CustomerGatewayArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CustomerGatewayArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GlobalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkId != nil {
		v := *s.LinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes a device.
type Device struct {
	_ struct{} `type:"structure"`

	// The date and time that the site was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the device.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the device.
	DeviceArn *string `type:"string"`

	// The ID of the device.
	DeviceId *string `type:"string"`

	// The ID of the global network.
	GlobalNetworkId *string `type:"string"`

	// The site location.
	Location *Location `type:"structure"`

	// The device model.
	Model *string `type:"string"`

	// The device serial number.
	SerialNumber *string `type:"string"`

	// The site ID.
	SiteId *string `type:"string"`

	// The device state.
	State DeviceState `type:"string" enum:"true"`

	// The tags for the device.
	Tags []Tag `type:"list"`

	// The device type.
	Type *string `type:"string"`

	// The device vendor.
	Vendor *string `type:"string"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Device) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceArn != nil {
		v := *s.DeviceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GlobalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.Model != nil {
		v := *s.Model

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Model", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SerialNumber != nil {
		v := *s.SerialNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SerialNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Vendor != nil {
		v := *s.Vendor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Vendor", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a global network.
type GlobalNetwork struct {
	_ struct{} `type:"structure"`

	// The date and time that the global network was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the global network.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the global network.
	GlobalNetworkArn *string `type:"string"`

	// The ID of the global network.
	GlobalNetworkId *string `type:"string"`

	// The state of the global network.
	State GlobalNetworkState `type:"string" enum:"true"`

	// The tags for the global network.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s GlobalNetwork) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GlobalNetwork) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkArn != nil {
		v := *s.GlobalNetworkArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GlobalNetworkArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GlobalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Describes a link.
type Link struct {
	_ struct{} `type:"structure"`

	// The bandwidth for the link.
	Bandwidth *Bandwidth `type:"structure"`

	// The date and time that the link was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the link.
	Description *string `type:"string"`

	// The ID of the global network.
	GlobalNetworkId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the link.
	LinkArn *string `type:"string"`

	// The ID of the link.
	LinkId *string `type:"string"`

	// The provider of the link.
	Provider *string `type:"string"`

	// The ID of the site.
	SiteId *string `type:"string"`

	// The state of the link.
	State LinkState `type:"string" enum:"true"`

	// The tags for the link.
	Tags []Tag `type:"list"`

	// The type of the link.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Link) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Link) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bandwidth != nil {
		v := s.Bandwidth

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Bandwidth", v, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GlobalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkArn != nil {
		v := *s.LinkArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkId != nil {
		v := *s.LinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Provider != nil {
		v := *s.Provider

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Provider", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the association between a device and a link.
type LinkAssociation struct {
	_ struct{} `type:"structure"`

	// The device ID for the link association.
	DeviceId *string `type:"string"`

	// The ID of the global network.
	GlobalNetworkId *string `type:"string"`

	// The state of the association.
	LinkAssociationState LinkAssociationState `type:"string" enum:"true"`

	// The ID of the link.
	LinkId *string `type:"string"`
}

// String returns the string representation
func (s LinkAssociation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LinkAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GlobalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LinkAssociationState) > 0 {
		v := s.LinkAssociationState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkAssociationState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LinkId != nil {
		v := *s.LinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a location.
type Location struct {
	_ struct{} `type:"structure"`

	// The physical address.
	Address *string `type:"string"`

	// The latitude.
	Latitude *string `type:"string"`

	// The longitude.
	Longitude *string `type:"string"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Location) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Latitude != nil {
		v := *s.Latitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Latitude", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Longitude != nil {
		v := *s.Longitude

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Longitude", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a site.
type Site struct {
	_ struct{} `type:"structure"`

	// The date and time that the site was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the site.
	Description *string `type:"string"`

	// The ID of the global network.
	GlobalNetworkId *string `type:"string"`

	// The location of the site.
	Location *Location `type:"structure"`

	// The Amazon Resource Name (ARN) of the site.
	SiteArn *string `type:"string"`

	// The ID of the site.
	SiteId *string `type:"string"`

	// The state of the site.
	State SiteState `type:"string" enum:"true"`

	// The tags for the site.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s Site) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Site) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GlobalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.SiteArn != nil {
		v := *s.SiteArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Describes a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Length Constraints: Maximum length of 128 characters.
	Key *string `type:"string"`

	// The tag value.
	//
	// Length Constraints: Maximum length of 256 characters.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the registration of a transit gateway to a global network.
type TransitGatewayRegistration struct {
	_ struct{} `type:"structure"`

	// The ID of the global network.
	GlobalNetworkId *string `type:"string"`

	// The state of the transit gateway registration.
	State *TransitGatewayRegistrationStateReason `type:"structure"`

	// The Amazon Resource Name (ARN) of the transit gateway.
	TransitGatewayArn *string `type:"string"`
}

// String returns the string representation
func (s TransitGatewayRegistration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TransitGatewayRegistration) MarshalFields(e protocol.FieldEncoder) error {
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GlobalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "State", v, metadata)
	}
	if s.TransitGatewayArn != nil {
		v := *s.TransitGatewayArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TransitGatewayArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the status of a transit gateway registration.
type TransitGatewayRegistrationStateReason struct {
	_ struct{} `type:"structure"`

	// The code for the state reason.
	Code TransitGatewayRegistrationState `type:"string" enum:"true"`

	// The message for the state reason.
	Message *string `type:"string"`
}

// String returns the string representation
func (s TransitGatewayRegistrationStateReason) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TransitGatewayRegistrationStateReason) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Code) > 0 {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Code", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a validation exception for a field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message for the field.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The name of the field.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ValidationExceptionField) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
