// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAlgorithmInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm to describe.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `locationName:"algorithmArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAlgorithmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlgorithmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAlgorithmInput"}

	if s.AlgorithmArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlgorithmArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAlgorithmOutput struct {
	_ struct{} `type:"structure"`

	// A listing of the properties of the algorithm.
	Algorithm *Algorithm `locationName:"algorithm" type:"structure"`
}

// String returns the string representation
func (s DescribeAlgorithmOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAlgorithm = "DescribeAlgorithm"

// DescribeAlgorithmRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Describes the given algorithm.
//
//    // Example sending a request using DescribeAlgorithmRequest.
//    req := client.DescribeAlgorithmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeAlgorithm
func (c *Client) DescribeAlgorithmRequest(input *DescribeAlgorithmInput) DescribeAlgorithmRequest {
	op := &aws.Operation{
		Name:       opDescribeAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlgorithmInput{}
	}

	req := c.newRequest(op, input, &DescribeAlgorithmOutput{})
	return DescribeAlgorithmRequest{Request: req, Input: input, Copy: c.DescribeAlgorithmRequest}
}

// DescribeAlgorithmRequest is the request type for the
// DescribeAlgorithm API operation.
type DescribeAlgorithmRequest struct {
	*aws.Request
	Input *DescribeAlgorithmInput
	Copy  func(*DescribeAlgorithmInput) DescribeAlgorithmRequest
}

// Send marshals and sends the DescribeAlgorithm API request.
func (r DescribeAlgorithmRequest) Send(ctx context.Context) (*DescribeAlgorithmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAlgorithmResponse{
		DescribeAlgorithmOutput: r.Request.Data.(*DescribeAlgorithmOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAlgorithmResponse is the response type for the
// DescribeAlgorithm API operation.
type DescribeAlgorithmResponse struct {
	*DescribeAlgorithmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAlgorithm request.
func (r *DescribeAlgorithmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
