// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetApnsChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApnsChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) channel for an application.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApnsChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.APNSChannelResponse != nil {
		v := s.APNSChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "APNSChannelResponse", v, metadata)
	}
	return nil
}

const opGetApnsChannel = "GetApnsChannel"

// GetApnsChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about the status and settings of the APNs channel for
// an application.
//
//    // Example sending a request using GetApnsChannelRequest.
//    req := client.GetApnsChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel
func (c *Client) GetApnsChannelRequest(input *GetApnsChannelInput) GetApnsChannelRequest {
	op := &aws.Operation{
		Name:       opGetApnsChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &GetApnsChannelInput{}
	}

	req := c.newRequest(op, input, &GetApnsChannelOutput{})
	return GetApnsChannelRequest{Request: req, Input: input, Copy: c.GetApnsChannelRequest}
}

// GetApnsChannelRequest is the request type for the
// GetApnsChannel API operation.
type GetApnsChannelRequest struct {
	*aws.Request
	Input *GetApnsChannelInput
	Copy  func(*GetApnsChannelInput) GetApnsChannelRequest
}

// Send marshals and sends the GetApnsChannel API request.
func (r GetApnsChannelRequest) Send(ctx context.Context) (*GetApnsChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetApnsChannelResponse{
		GetApnsChannelOutput: r.Request.Data.(*GetApnsChannelOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetApnsChannelResponse is the response type for the
// GetApnsChannel API operation.
type GetApnsChannelResponse struct {
	*GetApnsChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetApnsChannel request.
func (r *GetApnsChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
