// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudtrail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetTrailInput struct {
	_ struct{} `type:"structure"`

	// The name or the Amazon Resource Name (ARN) of the trail for which you want
	// to retrieve settings information.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetTrailInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrailInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTrailInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetTrailOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a trail.
	Trail *Trail `type:"structure"`
}

// String returns the string representation
func (s GetTrailOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTrail = "GetTrail"

// GetTrailRequest returns a request value for making API operation for
// AWS CloudTrail.
//
// Returns settings information for a specified trail.
//
//    // Example sending a request using GetTrailRequest.
//    req := client.GetTrailRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrail
func (c *Client) GetTrailRequest(input *GetTrailInput) GetTrailRequest {
	op := &aws.Operation{
		Name:       opGetTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTrailInput{}
	}

	req := c.newRequest(op, input, &GetTrailOutput{})
	return GetTrailRequest{Request: req, Input: input, Copy: c.GetTrailRequest}
}

// GetTrailRequest is the request type for the
// GetTrail API operation.
type GetTrailRequest struct {
	*aws.Request
	Input *GetTrailInput
	Copy  func(*GetTrailInput) GetTrailRequest
}

// Send marshals and sends the GetTrail API request.
func (r GetTrailRequest) Send(ctx context.Context) (*GetTrailResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTrailResponse{
		GetTrailOutput: r.Request.Data.(*GetTrailOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetTrailResponse is the response type for the
// GetTrail API operation.
type GetTrailResponse struct {
	*GetTrailOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTrail request.
func (r *GetTrailResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
