// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTableReplicaAutoScalingInput struct {
	_ struct{} `type:"structure"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTableReplicaAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableReplicaAutoScalingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTableReplicaAutoScalingInput"}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTableReplicaAutoScalingOutput struct {
	_ struct{} `type:"structure"`

	// Represents the auto scaling properties of the table.
	TableAutoScalingDescription *TableAutoScalingDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeTableReplicaAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTableReplicaAutoScaling = "DescribeTableReplicaAutoScaling"

// DescribeTableReplicaAutoScalingRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Describes auto scaling settings across replicas of the global table at once.
//
// This method only applies to Version 2019.11.21 (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html)
// of global tables.
//
//    // Example sending a request using DescribeTableReplicaAutoScalingRequest.
//    req := client.DescribeTableReplicaAutoScalingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTableReplicaAutoScaling
func (c *Client) DescribeTableReplicaAutoScalingRequest(input *DescribeTableReplicaAutoScalingInput) DescribeTableReplicaAutoScalingRequest {
	op := &aws.Operation{
		Name:       opDescribeTableReplicaAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableReplicaAutoScalingInput{}
	}

	req := c.newRequest(op, input, &DescribeTableReplicaAutoScalingOutput{})
	return DescribeTableReplicaAutoScalingRequest{Request: req, Input: input, Copy: c.DescribeTableReplicaAutoScalingRequest}
}

// DescribeTableReplicaAutoScalingRequest is the request type for the
// DescribeTableReplicaAutoScaling API operation.
type DescribeTableReplicaAutoScalingRequest struct {
	*aws.Request
	Input *DescribeTableReplicaAutoScalingInput
	Copy  func(*DescribeTableReplicaAutoScalingInput) DescribeTableReplicaAutoScalingRequest
}

// Send marshals and sends the DescribeTableReplicaAutoScaling API request.
func (r DescribeTableReplicaAutoScalingRequest) Send(ctx context.Context) (*DescribeTableReplicaAutoScalingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTableReplicaAutoScalingResponse{
		DescribeTableReplicaAutoScalingOutput: r.Request.Data.(*DescribeTableReplicaAutoScalingOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTableReplicaAutoScalingResponse is the response type for the
// DescribeTableReplicaAutoScaling API operation.
type DescribeTableReplicaAutoScalingResponse struct {
	*DescribeTableReplicaAutoScalingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTableReplicaAutoScaling request.
func (r *DescribeTableReplicaAutoScalingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
